/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ex.AbstractDelegatingToRootTraversalPolicy;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentBasedComponent;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.TextComponent;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorTextField
extends NonOpaquePanel
implements DocumentListener,
TextComponent,
DataProvider,
DocumentBasedComponent,
FocusListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.EditorTextField");
    public static final Key<Boolean> SUPPLEMENTARY_KEY = Key.create((String)"Supplementary");
    private Document myDocument;
    private final Project myProject;
    private FileType myFileType;
    private EditorEx myEditor;
    private Component myNextFocusable;
    private boolean myWholeTextSelected;
    private final List<DocumentListener> myDocumentListeners;
    private final List<FocusListener> myFocusListeners;
    private boolean myIsListenerInstalled;
    private boolean myIsViewer;
    private boolean myIsSupplementary;
    private boolean myInheritSwingFont;
    private Color myEnforcedBgColor;
    private boolean myOneLineMode;
    private boolean myEnsureWillComputePreferredSize;
    private Dimension myPassivePreferredSize;
    private CharSequence myHintText;
    private boolean myIsRendererWithSelection;
    private Color myRendererBg;
    private Color myRendererFg;
    private int myPreferredWidth;
    private final List<EditorSettingsProvider> mySettingsProviders;

    public EditorTextField() {
        this("");
    }

    public EditorTextField(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/EditorTextField", "<init>"));
        }
        this(EditorFactory.getInstance().createDocument((CharSequence)text), null, (FileType)FileTypes.PLAIN_TEXT);
    }

    public EditorTextField(@NotNull String text, Project project, FileType fileType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/EditorTextField", "<init>"));
        }
        this(EditorFactory.getInstance().createDocument((CharSequence)text), project, fileType, false, true);
    }

    public EditorTextField(Document document, Project project, FileType fileType) {
        this(document, project, fileType, false, true);
    }

    public EditorTextField(Document document, Project project, FileType fileType, boolean isViewer) {
        this(document, project, fileType, isViewer, true);
    }

    public EditorTextField(Document document, Project project, FileType fileType, boolean isViewer, boolean oneLineMode) {
        this.myEditor = null;
        this.myNextFocusable = null;
        this.myWholeTextSelected = false;
        this.myDocumentListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myFocusListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myIsListenerInstalled = false;
        this.myInheritSwingFont = true;
        this.myEnforcedBgColor = null;
        this.myIsRendererWithSelection = false;
        this.myPreferredWidth = -1;
        this.mySettingsProviders = new ArrayList<EditorSettingsProvider>();
        this.myOneLineMode = oneLineMode;
        this.myIsViewer = isViewer;
        this.setDocument(document);
        this.myProject = project;
        this.myFileType = fileType;
        this.setLayout(new BorderLayout());
        this.enableEvents(8L);
        this.setFocusable(true);
        super.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                EditorTextField.this.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.setFocusTraversalPolicyProvider(true);
        DelegatingToRootTraversalPolicy policy = SystemInfo.isJavaVersionAtLeast((String)"1.7") ? new Jdk7DelegatingToRootTraversalPolicy() : new DelegatingToRootTraversalPolicy();
        this.setFocusTraversalPolicy(policy);
        this.setFont(UIManager.getFont("TextField.font"));
    }

    public void setSupplementary(boolean supplementary) {
        this.myIsSupplementary = supplementary;
        if (this.myEditor != null) {
            this.myEditor.putUserData(SUPPLEMENTARY_KEY, supplementary);
        }
    }

    public void setFontInheritedFromLAF(boolean b) {
        this.myInheritSwingFont = b;
        this.setDocument(this.myDocument);
    }

    public String getText() {
        return this.myDocument.getText();
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.myEnforcedBgColor = bg;
        if (this.myEditor != null) {
            this.myEditor.setBackgroundColor(bg);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void addDocumentListener(DocumentListener listener) {
        this.myDocumentListeners.add(listener);
        this.installDocumentListener();
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.myDocumentListeners.remove(listener);
        this.uninstallDocumentListener(false);
    }

    public void beforeDocumentChange(DocumentEvent event) {
        for (DocumentListener documentListener : this.myDocumentListeners) {
            documentListener.beforeDocumentChange(event);
        }
    }

    public void documentChanged(DocumentEvent event) {
        for (DocumentListener documentListener : this.myDocumentListeners) {
            documentListener.documentChanged(event);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public void setDocument(Document document) {
        if (this.myDocument != null) {
            this.uninstallDocumentListener(true);
        }
        this.myDocument = document;
        this.installDocumentListener();
        if (this.myEditor == null) {
            return;
        }
        boolean isFocused = this.isFocusOwner();
        EditorEx editor = this.myEditor;
        this.myEditor = this.createEditor();
        this.releaseEditor(editor);
        this.add(this.myEditor.getComponent(), "Center");
        this.validate();
        if (isFocused) {
            this.myEditor.getContentComponent().requestFocus();
        }
    }

    private void installDocumentListener() {
        if (this.myDocument != null && !this.myDocumentListeners.isEmpty() && !this.myIsListenerInstalled) {
            this.myIsListenerInstalled = true;
            this.myDocument.addDocumentListener((DocumentListener)this);
        }
    }

    private void uninstallDocumentListener(boolean force) {
        if (this.myDocument != null && this.myIsListenerInstalled && (force || this.myDocumentListeners.isEmpty())) {
            this.myIsListenerInstalled = false;
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }
    }

    public void setText(final @Nullable String text) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(EditorTextField.this.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        CaretModel caretModel;
                        EditorTextField.this.myDocument.replaceString(0, EditorTextField.this.myDocument.getTextLength(), (CharSequence)(text == null ? "" : text));
                        if (EditorTextField.this.myEditor != null && (caretModel = EditorTextField.this.myEditor.getCaretModel()).getOffset() >= EditorTextField.this.myDocument.getTextLength()) {
                            caretModel.moveToOffset(EditorTextField.this.myDocument.getTextLength());
                        }
                    }
                }, null, null, UndoConfirmationPolicy.DEFAULT, EditorTextField.this.getDocument());
            }
        });
    }

    public void setPlaceholder(@Nullable CharSequence text) {
        this.myHintText = text;
        if (this.myEditor != null) {
            this.myEditor.setPlaceholder(text);
        }
    }

    public void selectAll() {
        if (this.myEditor != null) {
            EditorTextField.doSelectAll(this.myEditor);
        } else {
            this.myWholeTextSelected = true;
        }
    }

    private static void doSelectAll(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/EditorTextField", "doSelectAll"));
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().getPrimaryCaret().setSelection(0, editor.getDocument().getTextLength(), false);
    }

    public void removeSelection() {
        if (this.myEditor != null) {
            this.myEditor.getSelectionModel().removeSelection();
        } else {
            this.myWholeTextSelected = false;
        }
    }

    public CaretModel getCaretModel() {
        return this.myEditor.getCaretModel();
    }

    public boolean isFocusOwner() {
        if (this.myEditor != null) {
            return IJSwingUtilities.hasFocus(this.myEditor.getContentComponent());
        }
        return super.isFocusOwner();
    }

    void releaseEditor(final @NotNull Editor editor) {
        PsiFile psiFile;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/EditorTextField", "releaseEditor"));
        }
        if (this.myProject != null && this.myIsViewer && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument())) != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).setHighlightingEnabled(psiFile, true);
        }
        this.remove(editor.getComponent());
        editor.getContentComponent().removeFocusListener(this);
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!editor.isDisposed()) {
                    EditorFactory.getInstance().releaseEditor(editor);
                }
            }
        };
        if (application.isUnitTestMode() || application.isDispatchThread()) {
            runnable.run();
        } else {
            application.invokeLater(runnable);
        }
    }

    public void addNotify() {
        this.releaseEditor();
        boolean isFocused = this.isFocusOwner();
        this.initEditor();
        super.addNotify();
        if (this.myNextFocusable != null) {
            this.myEditor.getContentComponent().setNextFocusableComponent(this.myNextFocusable);
            this.myNextFocusable = null;
        }
        this.revalidate();
        if (isFocused) {
            this.requestFocus();
        }
    }

    private void initEditor() {
        this.myEditor = this.createEditor();
        JComponent component = this.myEditor.getComponent();
        this.add(component, "Center");
    }

    public void removeNotify() {
        super.removeNotify();
        this.releaseEditor();
    }

    private void releaseEditor() {
        if (this.myEditor == null) {
            return;
        }
        final EditorEx editor = this.myEditor;
        this.myEditor = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorTextField.this.releaseEditor(editor);
            }
        });
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.myEditor != null) {
            this.setupEditorFont(this.myEditor);
        }
    }

    protected boolean isOneLineMode() {
        return this.myOneLineMode;
    }

    protected void initOneLineMode(EditorEx editor) {
        boolean isOneLineMode = this.isOneLineMode();
        editor.setOneLineMode(isOneLineMode);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme defaultScheme = UIUtil.isUnderDarcula() ? colorsManager.getGlobalScheme() : colorsManager.getScheme("Default");
        EditorColorsScheme customGlobalScheme = isOneLineMode ? defaultScheme : null;
        editor.setColorsScheme(editor.createBoundColorSchemeDelegate(customGlobalScheme));
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        colorsScheme.setColor(EditorColors.CARET_ROW_COLOR, null);
        editor.setColorsScheme(new DelegateColorScheme(colorsScheme){

            @Override
            public TextAttributes getAttributes(TextAttributesKey key) {
                TextAttributes attributes = super.getAttributes(key);
                if (!EditorTextField.this.isEnabled() && attributes != null) {
                    return new TextAttributes(UIUtil.getInactiveTextColor(), attributes.getBackgroundColor(), attributes.getEffectColor(), attributes.getEffectType(), attributes.getFontType());
                }
                return attributes;
            }
        });
        this.setupEditorFont(editor);
        this.updateBorder(editor);
        editor.setBackgroundColor(this.getBackgroundColor(this.isEnabled(), colorsScheme));
    }

    public void setOneLineMode(boolean oneLineMode) {
        this.myOneLineMode = oneLineMode;
    }

    protected EditorEx createEditor() {
        PsiFile psiFile;
        LOG.assertTrue(this.myDocument != null);
        EditorFactory factory = EditorFactory.getInstance();
        EditorEx editor = this.myIsViewer ? (this.myProject == null ? (EditorEx)factory.createViewer(this.myDocument) : (EditorEx)factory.createViewer(this.myDocument, this.myProject)) : (this.myProject == null ? (EditorEx)factory.createEditor(this.myDocument) : (EditorEx)factory.createEditor(this.myDocument, this.myProject));
        EditorSettings settings = editor.getSettings();
        settings.setAdditionalLinesCount(0);
        settings.setAdditionalColumnsCount(1);
        settings.setRightMarginShown(false);
        settings.setRightMargin(-1);
        settings.setFoldingOutlineShown(false);
        settings.setLineNumbersShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setVirtualSpace(false);
        settings.setWheelFontChangeEnabled(false);
        settings.setAdditionalPageAtBottom(false);
        editor.setHorizontalScrollbarVisible(false);
        editor.setVerticalScrollbarVisible(false);
        editor.setCaretEnabled(!this.myIsViewer);
        settings.setLineCursorWidth(1);
        if (this.myProject != null && this.myIsViewer && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)editor.getDocument())) != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).setHighlightingEnabled(psiFile, false);
        }
        if (this.myProject != null && this.myFileType != null) {
            editor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, this.myFileType));
        }
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        colorsScheme.setColor(EditorColors.CARET_ROW_COLOR, null);
        if (!this.isEnabled()) {
            editor.setColorsScheme(new DelegateColorScheme(colorsScheme){

                @Override
                @Nullable
                public Color getColor(ColorKey key) {
                    return super.getColor(key);
                }

                @Override
                public TextAttributes getAttributes(TextAttributesKey key) {
                    TextAttributes attributes = super.getAttributes(key);
                    if (!EditorTextField.this.isEnabled()) {
                        return new TextAttributes(UIUtil.getInactiveTextColor(), attributes.getBackgroundColor(), attributes.getEffectColor(), attributes.getEffectType(), attributes.getFontType());
                    }
                    return attributes;
                }
            });
        }
        editor.setOneLineMode(this.myOneLineMode);
        editor.getCaretModel().moveToOffset(this.myDocument.getTextLength());
        if (!this.shouldHaveBorder()) {
            editor.setBorder(null);
        }
        if (this.myIsViewer) {
            editor.getSelectionModel().removeSelection();
        } else if (this.myWholeTextSelected) {
            EditorTextField.doSelectAll(editor);
            this.myWholeTextSelected = false;
        }
        editor.putUserData(SUPPLEMENTARY_KEY, this.myIsSupplementary);
        editor.getContentComponent().setFocusCycleRoot(false);
        editor.getContentComponent().addFocusListener(this);
        editor.setPlaceholder(this.myHintText);
        this.initOneLineMode(editor);
        if (this.myIsRendererWithSelection) {
            ((EditorImpl)editor).setPaintSelection(true);
            editor.getColorsScheme().setColor(EditorColors.SELECTION_BACKGROUND_COLOR, this.myRendererBg);
            editor.getColorsScheme().setColor(EditorColors.SELECTION_FOREGROUND_COLOR, this.myRendererFg);
            editor.getSelectionModel().setSelection(0, this.myDocument.getTextLength());
            editor.setBackgroundColor(this.myRendererBg);
        }
        for (EditorSettingsProvider provider : this.mySettingsProviders) {
            provider.customizeSettings(editor);
        }
        return editor;
    }

    protected void updateBorder(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/EditorTextField", "updateBorder"));
        }
        if (editor.isOneLineMode() && !Boolean.TRUE.equals(this.getClientProperty("JComboBox.isTableCellEditor")) && (SwingUtilities.getAncestorOfClass(JTable.class, (Component)((Object)this)) == null || Boolean.TRUE.equals(this.getClientProperty("JBListTable.isTableCellEditor")))) {
            Container parent = this.getParent();
            if (parent instanceof JTable || parent instanceof CellRendererPane) {
                return;
            }
            if (UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
                editor.setBorder(UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF() ? new DarculaEditorTextFieldBorder() : new MacUIUtil.EditorTextFieldBorder((JComponent)((Object)this)));
                editor.addFocusListener(new FocusChangeListener(){

                    @Override
                    public void focusGained(Editor editor) {
                        EditorTextField.this.repaint();
                    }

                    @Override
                    public void focusLost(Editor editor) {
                        EditorTextField.this.repaint();
                    }
                });
            } else if (UIUtil.isUnderAlloyLookAndFeel() || UIUtil.isUnderJGoodiesLookAndFeel()) {
                editor.setBorder(BorderFactory.createCompoundBorder(UIUtil.getTextFieldBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            } else {
                editor.setBorder(BorderFactory.createCompoundBorder(UIUtil.getTextFieldBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            }
        }
    }

    private void setupEditorFont(EditorEx editor) {
        if (this.myInheritSwingFont) {
            editor.getColorsScheme().setEditorFontName(this.getFont().getFontName());
            editor.getColorsScheme().setEditorFontSize(this.getFont().getSize());
        }
    }

    protected boolean shouldHaveBorder() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            super.setEnabled(enabled);
            this.myIsViewer = !enabled;
            EditorEx editor = this.myEditor;
            if (editor == null) {
                return;
            }
            this.releaseEditor(editor);
            this.initEditor();
            this.revalidate();
        }
    }

    public Color getBackground() {
        Color color = this.getBackgroundColor(this.isEnabled(), EditorColorsUtil.getGlobalOrDefaultColorScheme());
        return color != null ? color : super.getBackground();
    }

    private Color getBackgroundColor(boolean enabled, EditorColorsScheme colorsScheme) {
        if (this.myEnforcedBgColor != null) {
            return this.myEnforcedBgColor;
        }
        if (UIUtil.getParentOfType(CellRendererPane.class, (Component)((Object)this)) != null && (UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF())) {
            return this.getParent().getBackground();
        }
        if (UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            return UIUtil.getTextFieldBackground();
        }
        return enabled ? colorsScheme.getDefaultBackground() : UIUtil.getInactiveTextFieldBackgroundColor();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.myEditor == null || comp != this.myEditor.getComponent()) assert (false) : "You are not allowed to add anything to EditorTextField";
        super.addImpl(comp, constraints, index);
    }

    public Dimension getPreferredSize() {
        if (super.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        boolean toReleaseEditor = false;
        if (this.myEditor == null && this.myEnsureWillComputePreferredSize) {
            this.myEnsureWillComputePreferredSize = false;
            this.initEditor();
            toReleaseEditor = true;
        }
        Dimension size = new Dimension(100, 20);
        if (this.myEditor != null) {
            Insets insets;
            Dimension preferredSize = new Dimension(this.myEditor.getComponent().getPreferredSize());
            if (this.myPreferredWidth != -1) {
                preferredSize.width = this.myPreferredWidth;
            }
            if ((insets = this.getInsets()) != null) {
                preferredSize.width += insets.left;
                preferredSize.width += insets.right;
                preferredSize.height += insets.top;
                preferredSize.height += insets.bottom;
            }
            size = preferredSize;
        } else if (this.myPassivePreferredSize != null) {
            size = this.myPassivePreferredSize;
        }
        if (toReleaseEditor) {
            this.releaseEditor();
            this.myPassivePreferredSize = size;
        }
        return size;
    }

    public Dimension getMinimumSize() {
        if (super.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension size = new Dimension(1, 20);
        if (this.myEditor != null) {
            size.height = this.myEditor.getLineHeight();
            size = UIUtil.addInsets((Dimension)size, (Insets)this.getInsets());
            size = UIUtil.addInsets((Dimension)size, (Insets)this.myEditor.getInsets());
        }
        return size;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.myPreferredWidth = preferredWidth;
    }

    public Component getNextFocusableComponent() {
        if (this.myEditor == null && this.myNextFocusable == null) {
            return super.getNextFocusableComponent();
        }
        if (this.myEditor == null) {
            return this.myNextFocusable;
        }
        return this.myEditor.getContentComponent().getNextFocusableComponent();
    }

    public void setNextFocusableComponent(Component aComponent) {
        if (this.myEditor != null) {
            this.myEditor.getContentComponent().setNextFocusableComponent(aComponent);
            return;
        }
        this.myNextFocusable = aComponent;
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.isConsumed() || this.myEditor != null && !this.myEditor.processKeyTyped(e)) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        return true;
    }

    public void requestFocus() {
        if (this.myEditor != null) {
            this.myEditor.getContentComponent().requestFocus();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        } else {
            super.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.myEditor != null) {
            boolean b = this.myEditor.getContentComponent().requestFocusInWindow();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return b;
        }
        return super.requestFocusInWindow();
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    public JComponent getFocusTarget() {
        return this.myEditor == null ? this : this.myEditor.getContentComponent();
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.myFocusListeners.add(l);
    }

    public synchronized void removeFocusListener(FocusListener l) {
        this.myFocusListeners.remove(l);
    }

    @Override
    public void focusGained(FocusEvent e) {
        for (FocusListener listener : this.myFocusListeners) {
            listener.focusGained(e);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        for (FocusListener listener : this.myFocusListeners) {
            listener.focusLost(e);
        }
    }

    public Object getData(String dataId) {
        if (this.myEditor != null && this.myEditor.isRendererMode()) {
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return this.myEditor.getCopyProvider();
            }
            return null;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    public void setFileType(FileType fileType) {
        this.setNewDocumentAndFileType(fileType, this.getDocument());
    }

    public void setNewDocumentAndFileType(FileType fileType, Document document) {
        this.myFileType = fileType;
        this.setDocument(document);
    }

    public void ensureWillComputePreferredSize() {
        this.myEnsureWillComputePreferredSize = true;
    }

    public void setAsRendererWithSelection(Color backgroundColor, Color foregroundColor) {
        this.myIsRendererWithSelection = true;
        this.myRendererBg = backgroundColor;
        this.myRendererFg = foregroundColor;
    }

    public void addSettingsProvider(EditorSettingsProvider provider) {
        this.mySettingsProviders.add(provider);
    }

    public boolean removeSettingsProvider(EditorSettingsProvider provider) {
        return this.mySettingsProviders.remove(provider);
    }

    private static class DelegatingToRootTraversalPolicy
    extends AbstractDelegatingToRootTraversalPolicy {
        private DelegatingToRootTraversalPolicy() {
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            Editor editor;
            Editor editor2 = editor = aContainer instanceof EditorTextField ? ((EditorTextField)((Object)aContainer)).getEditor() : null;
            if (editor != null) {
                return editor.getContentComponent();
            }
            return aContainer;
        }
    }

    private static class Jdk7DelegatingToRootTraversalPolicy
    extends DelegatingToRootTraversalPolicy {
        private boolean invokedFromBeforeOrAfter;

        private Jdk7DelegatingToRootTraversalPolicy() {
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return this.getDefaultComponent(aContainer);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return this.getDefaultComponent(aContainer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            Component after;
            this.invokedFromBeforeOrAfter = true;
            try {
                after = super.getComponentAfter(aContainer, aComponent);
            }
            finally {
                this.invokedFromBeforeOrAfter = false;
            }
            return after != aComponent ? after : null;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Component before = super.getComponentBefore(aContainer, aComponent);
            return before != aComponent ? before : null;
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            if (this.invokedFromBeforeOrAfter) {
                return null;
            }
            return super.getDefaultComponent(aContainer);
        }
    }
}

