/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.MaskProvider;
import com.intellij.openapi.ui.popup.MouseChecker;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.Gray;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.LightColors;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.MoveComponentListener;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.ResizeComponentListener;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.PopupComponent;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.Alarm;
import com.intellij.util.BooleanFunction;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.Processor;
import com.intellij.util.ui.ChildFocusWatcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractPopup
implements JBPopup {
    public static final String SHOW_HINTS = "ShowHints";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.AbstractPopup");
    private static final Object SUPPRESS_MAC_CORNER = new Object();
    private static final boolean X_WINDOW_FOCUS_BUG = SystemInfo.isXWindow;
    private PopupComponent myPopup;
    private MyContentPanel myContent;
    private JComponent myPreferredFocusedComponent;
    private boolean myRequestFocus;
    private boolean myFocusable;
    private boolean myForcedHeavyweight;
    private boolean myLocateWithinScreen;
    private boolean myResizable = false;
    private JPanel myHeaderPanel;
    private CaptionPanel myCaption = null;
    private JComponent myComponent;
    private String myDimensionServiceKey = null;
    private Computable<Boolean> myCallBack = null;
    private Project myProject;
    private boolean myCancelOnClickOutside;
    private Set<JBPopupListener> myListeners;
    private boolean myUseDimServiceForXYLocation;
    private MouseChecker myCancelOnMouseOutCallback;
    private Canceller myMouseOutCanceller;
    private boolean myCancelOnWindow;
    private boolean myCancelOnWindowDeactivation = true;
    private Dimension myForcedSize;
    private Point myForcedLocation;
    private boolean myCancelKeyEnabled;
    private boolean myLocateByContent;
    protected FocusTrackback myFocusTrackback;
    private Dimension myMinSize;
    private List<Object> myUserData;
    private boolean myShadowed;
    private float myAlpha = 0.0f;
    private float myLastAlpha = 0.0f;
    private MaskProvider myMaskProvider;
    private Window myWindow;
    private boolean myInStack;
    private MyWindowListener myWindowListener;
    private boolean myModalContext;
    private Component[] myFocusOwners;
    private PopupBorder myPopupBorder;
    private Dimension myRestoreWindowSize;
    protected Component myOwner;
    protected Component myRequestorComponent;
    private boolean myHeaderAlwaysFocusable;
    private boolean myMovable;
    private JComponent myHeaderComponent;
    protected InputEvent myDisposeEvent;
    private Runnable myFinalRunnable;
    @Nullable
    private BooleanFunction<KeyEvent> myKeyEventHandler;
    protected boolean myOk;
    protected final SpeedSearch mySpeedSearch = new SpeedSearch(){
        boolean searchFieldShown = false;

        public void update() {
            AbstractPopup.this.mySpeedSearchPatternField.setBackground(new JTextField().getBackground());
            AbstractPopup.this.onSpeedSearchPatternChanged();
            AbstractPopup.this.mySpeedSearchPatternField.setText(this.getFilter());
            if (this.isHoldingFilter() && !this.searchFieldShown) {
                AbstractPopup.this.setHeaderComponent(AbstractPopup.this.mySpeedSearchPatternField);
                this.searchFieldShown = true;
            } else if (!this.isHoldingFilter() && this.searchFieldShown) {
                AbstractPopup.this.setHeaderComponent(null);
                this.searchFieldShown = false;
            }
        }

        public void noHits() {
            AbstractPopup.this.mySpeedSearchPatternField.setBackground(LightColors.RED);
        }
    };
    private JTextField mySpeedSearchPatternField;
    private boolean myNativePopup;
    private boolean myMayBeParent;
    private SpeedSearchKeyListener mySearchKeyListener;
    private JLabel myAdComponent;
    private boolean myDisposed;
    private UiActivity myActivityKey;
    private Disposable myProjectDisposable;
    private volatile State myState = State.NEW;

    private void debugState(String message, State ... states) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.hashCode() + " - " + message);
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                LOG.debug("unexpected thread");
            }
            for (State state : states) {
                if (state != this.myState) continue;
                return;
            }
            LOG.debug((Throwable)new IllegalStateException("myState=" + (Object)((Object)this.myState)));
        }
    }

    AbstractPopup() {
    }

    AbstractPopup init(Project project, @NotNull JComponent component, @Nullable JComponent preferredFocusedComponent, boolean requestFocus, boolean focusable, boolean movable, String dimensionServiceKey, boolean resizable, @Nullable String caption, @Nullable Computable<Boolean> callback, boolean cancelOnClickOutside, @Nullable Set<JBPopupListener> listeners, boolean useDimServiceForXYLocation, ActiveComponent commandButton, @Nullable IconButton cancelButton, @Nullable MouseChecker cancelOnMouseOutCallback, boolean cancelOnWindow, @Nullable ActiveIcon titleIcon, boolean cancelKeyEnabled, boolean locateByContent, boolean placeWithinScreenBounds, @Nullable Dimension minSize, float alpha, @Nullable MaskProvider maskProvider, boolean inStack, boolean modalContext, @Nullable Component[] focusOwners, @Nullable String adText, int adTextAlignment, boolean headerAlwaysFocusable, @NotNull List<Pair<ActionListener, KeyStroke>> keyboardActions, Component settingsButtons, final @Nullable Processor<JBPopup> pinCallback, boolean mayBeParent, boolean showShadow, boolean showBorder, boolean cancelOnWindowDeactivation, @Nullable BooleanFunction<KeyEvent> keyEventHandler) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/popup/AbstractPopup", "init"));
        }
        if (keyboardActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyboardActions", "com/intellij/ui/popup/AbstractPopup", "init"));
        }
        if (requestFocus && !focusable) assert (false) : "Incorrect argument combination: requestFocus=true focusable=false";
        this.myActivityKey = new UiActivity.Focus(new String[]{"Popup:" + this});
        this.myProject = project;
        this.myComponent = component;
        this.myPopupBorder = showBorder ? PopupBorder.Factory.create((boolean)true, (boolean)showShadow) : PopupBorder.Factory.createEmpty();
        this.myShadowed = showShadow;
        this.myContent = this.createContentPanel(resizable, this.myPopupBorder, this.isToDrawMacCorner() && resizable);
        this.myMayBeParent = mayBeParent;
        this.myCancelOnWindowDeactivation = cancelOnWindowDeactivation;
        this.myContent.add((Component)component, "Center");
        if (adText != null) {
            this.setAdText(adText, adTextAlignment);
        }
        this.myCancelKeyEnabled = cancelKeyEnabled;
        this.myLocateByContent = locateByContent;
        this.myLocateWithinScreen = placeWithinScreenBounds;
        this.myAlpha = alpha;
        this.myMaskProvider = maskProvider;
        this.myInStack = inStack;
        this.myModalContext = modalContext;
        this.myFocusOwners = focusOwners;
        this.myHeaderAlwaysFocusable = headerAlwaysFocusable;
        this.myMovable = movable;
        ActiveIcon actualIcon = titleIcon == null ? new ActiveIcon(EmptyIcon.ICON_0) : titleIcon;
        this.myHeaderPanel = new JPanel(new BorderLayout());
        if (caption != null) {
            if (!caption.isEmpty()) {
                this.myCaption = new TitlePanel(actualIcon.getRegular(), actualIcon.getInactive());
                ((TitlePanel)this.myCaption).setText(caption);
            } else {
                this.myCaption = new CaptionPanel();
            }
            if (pinCallback != null) {
                this.myCaption.setButtonComponent((ActiveComponent)new InplaceButton(new IconButton("Pin", AllIcons.General.AutohideOff, AllIcons.General.AutohideOff, AllIcons.General.AutohideOffInactive), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        pinCallback.process((Object)AbstractPopup.this);
                    }
                }));
            } else if (cancelButton != null) {
                this.myCaption.setButtonComponent((ActiveComponent)new InplaceButton(cancelButton, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractPopup.this.cancel();
                    }
                }));
            } else if (commandButton != null) {
                this.myCaption.setButtonComponent(commandButton);
            }
        } else {
            this.myCaption = new CaptionPanel();
            this.myCaption.setBorder(null);
            this.myCaption.setPreferredSize((Dimension)JBUI.emptySize());
        }
        this.setWindowActive(this.myHeaderAlwaysFocusable);
        this.myHeaderPanel.add((Component)this.myCaption, "North");
        this.myContent.add((Component)this.myHeaderPanel, "North");
        this.myForcedHeavyweight = true;
        this.myResizable = resizable;
        this.myPreferredFocusedComponent = preferredFocusedComponent;
        this.myRequestFocus = requestFocus;
        this.myFocusable = focusable;
        this.myDimensionServiceKey = dimensionServiceKey;
        this.myCallBack = callback;
        this.myCancelOnClickOutside = cancelOnClickOutside;
        this.myCancelOnMouseOutCallback = cancelOnMouseOutCallback;
        this.myListeners = listeners == null ? new HashSet() : listeners;
        this.myUseDimServiceForXYLocation = useDimServiceForXYLocation;
        this.myCancelOnWindow = cancelOnWindow;
        this.myMinSize = minSize;
        for (Pair<ActionListener, KeyStroke> pair : keyboardActions) {
            this.myContent.registerKeyboardAction((ActionListener)pair.getFirst(), (KeyStroke)pair.getSecond(), 2);
        }
        if (settingsButtons != null) {
            this.myCaption.addSettingsComponent(settingsButtons);
        }
        this.myKeyEventHandler = keyEventHandler;
        this.debugState("popup initialized", State.NEW);
        this.myState = State.INIT;
        return this;
    }

    private void setWindowActive(boolean active) {
        boolean value;
        boolean bl = value = this.myHeaderAlwaysFocusable || active;
        if (this.myCaption != null) {
            this.myCaption.setActive(value);
        }
        this.myPopupBorder.setActive(value);
        this.myContent.repaint();
    }

    @NotNull
    protected MyContentPanel createContentPanel(boolean resizable, PopupBorder border, boolean isToDrawMacCorner) {
        MyContentPanel myContentPanel = new MyContentPanel(resizable, border, isToDrawMacCorner);
        if (myContentPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup", "createContentPanel"));
        }
        return myContentPanel;
    }

    public boolean isToDrawMacCorner() {
        Component component;
        if (!SystemInfo.isMac || this.myComponent.getComponentCount() <= 0) {
            return false;
        }
        return this.myComponent.getComponentCount() <= 0 || !((component = this.myComponent.getComponent(0)) instanceof JComponent) || !Boolean.TRUE.equals(((JComponent)component).getClientProperty(SUPPRESS_MAC_CORNER));
    }

    public void setShowHints(boolean show) {
        JRootPane rootPane;
        Window ancestor = AbstractPopup.getContentWindow(this.myComponent);
        if (ancestor instanceof RootPaneContainer && (rootPane = ((RootPaneContainer)((Object)ancestor)).getRootPane()) != null) {
            rootPane.putClientProperty(SHOW_HINTS, show);
        }
    }

    public static void suppressMacCornerFor(JComponent popupComponent) {
        popupComponent.putClientProperty(SUPPRESS_MAC_CORNER, Boolean.TRUE);
    }

    public String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    public void setDimensionServiceKey(@Nullable String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
    }

    public void showInCenterOf(@NotNull Component aContainer) {
        if (aContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aContainer", "com/intellij/ui/popup/AbstractPopup", "showInCenterOf"));
        }
        Point popupPoint = AbstractPopup.getCenterOf(aContainer, this.myContent);
        this.show(aContainer, popupPoint.x, popupPoint.y, false);
    }

    public void setAdText(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ui/popup/AbstractPopup", "setAdText"));
        }
        this.setAdText(s, 2);
    }

    public void setAdText(@NotNull String s, int alignment) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/ui/popup/AbstractPopup", "setAdText"));
        }
        if (this.myAdComponent == null) {
            this.myAdComponent = HintUtil.createAdComponent(s, (Border)JBUI.Borders.empty((int)1, (int)5), alignment);
            JPanel wrapper = new JPanel(new BorderLayout()){

                @Override
                protected void paintComponent(Graphics g) {
                    g.setColor((Color)Gray._135);
                    g.drawLine(0, 0, this.getWidth(), 0);
                    super.paintComponent(g);
                }
            };
            wrapper.setOpaque(false);
            wrapper.setBorder((Border)JBUI.Borders.emptyTop((int)1));
            wrapper.add((Component)this.myAdComponent, "Center");
            this.myContent.add((Component)wrapper, "South");
            this.pack(false, true);
        } else {
            this.myAdComponent.setText(s);
            this.myAdComponent.setHorizontalAlignment(alignment);
        }
    }

    public static Point getCenterOf(Component aContainer, JComponent content) {
        JComponent component = AbstractPopup.getTargetComponent(aContainer);
        Point containerScreenPoint = component.getVisibleRect().getLocation();
        SwingUtilities.convertPointToScreen(containerScreenPoint, aContainer);
        return UIUtil.getCenterPoint((Rectangle)new Rectangle(containerScreenPoint, component.getVisibleRect().getSize()), (Dimension)content.getPreferredSize());
    }

    public void showCenteredInCurrentWindow(@NotNull Project project) {
        Component parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/popup/AbstractPopup", "showCenteredInCurrentWindow"));
        }
        Window window = null;
        Component focusedComponent = AbstractPopup.getWndManager().getFocusedComponent(project);
        if (focusedComponent != null && (parent = UIUtil.findUltimateParent((Component)focusedComponent)) instanceof Window) {
            window = (Window)parent;
        }
        if (window == null) {
            window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        }
        if (window != null) {
            this.showInCenterOf(window);
        }
    }

    public void showUnderneathOf(@NotNull Component aComponent) {
        if (aComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aComponent", "com/intellij/ui/popup/AbstractPopup", "showUnderneathOf"));
        }
        this.show(new RelativePoint(aComponent, new Point(0, aComponent.getHeight())));
    }

    public void show(@NotNull RelativePoint aPoint) {
        if (aPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPoint", "com/intellij/ui/popup/AbstractPopup", "show"));
        }
        Point screenPoint = aPoint.getScreenPoint();
        this.show(aPoint.getComponent(), screenPoint.x, screenPoint.y, false);
    }

    public void showInScreenCoordinates(@NotNull Component owner, @NotNull Point point) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ui/popup/AbstractPopup", "showInScreenCoordinates"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/ui/popup/AbstractPopup", "showInScreenCoordinates"));
        }
        this.show(owner, point.x, point.y, false);
    }

    public void showInBestPositionFor(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ui/popup/AbstractPopup", "showInBestPositionFor"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            this.showInBestPositionFor(editor);
        } else {
            this.show(this.relativePointByQuickSearch(dataContext));
        }
    }

    public void showInFocusCenter() {
        Component focused = AbstractPopup.getWndManager().getFocusedComponent(this.myProject);
        if (focused != null) {
            this.showInCenterOf(focused);
        } else {
            WindowManager manager = WindowManager.getInstance();
            JFrame frame = this.myProject != null ? manager.getFrame(this.myProject) : manager.findVisibleFrame();
            this.showInCenterOf(frame.getRootPane());
        }
    }

    private RelativePoint relativePointByQuickSearch(DataContext dataContext) {
        Component focusedComponent;
        Rectangle dominantArea = (Rectangle)PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.getData(dataContext);
        if (dominantArea != null && (focusedComponent = AbstractPopup.getWndManager().getFocusedComponent(this.myProject)) != null) {
            JLayeredPane layeredPane;
            Window window = SwingUtilities.windowForComponent(focusedComponent);
            if (window instanceof JFrame) {
                layeredPane = ((JFrame)window).getLayeredPane();
            } else if (window instanceof JDialog) {
                layeredPane = ((JDialog)window).getLayeredPane();
            } else if (window instanceof JWindow) {
                layeredPane = ((JWindow)window).getLayeredPane();
            } else {
                throw new IllegalStateException("cannot find parent window: project=" + this.myProject + "; window=" + window);
            }
            return this.relativePointWithDominantRectangle(layeredPane, dominantArea);
        }
        return JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
    }

    public void showInBestPositionFor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/popup/AbstractPopup", "showInBestPositionFor"));
        }
        assert (editor.getComponent().isShowing()) : "Editor must be showing on the screen";
        DataContext context = ((EditorEx)editor).getDataContext();
        Rectangle dominantArea = (Rectangle)PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.getData(context);
        if (dominantArea != null && !this.myRequestFocus) {
            JLayeredPane layeredPane = editor.getContentComponent().getRootPane().getLayeredPane();
            this.show(this.relativePointWithDominantRectangle(layeredPane, dominantArea));
        } else {
            this.show(this.guessBestPopupLocation(editor));
        }
    }

    @NotNull
    private RelativePoint guessBestPopupLocation(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/popup/AbstractPopup", "guessBestPopupLocation"));
        }
        RelativePoint preferredLocation = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
        if (this.myDimensionServiceKey == null) {
            RelativePoint relativePoint = preferredLocation;
            if (relativePoint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup", "guessBestPopupLocation"));
            }
            return relativePoint;
        }
        Dimension preferredSize = DimensionService.getInstance().getSize(this.myDimensionServiceKey, this.myProject);
        if (preferredSize == null) {
            RelativePoint relativePoint = preferredLocation;
            if (relativePoint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup", "guessBestPopupLocation"));
            }
            return relativePoint;
        }
        Rectangle preferredBounds = new Rectangle(preferredLocation.getScreenPoint(), preferredSize);
        Rectangle adjustedBounds = new Rectangle(preferredBounds);
        ScreenUtil.moveRectangleToFitTheScreen((Rectangle)adjustedBounds);
        if (preferredBounds.y - adjustedBounds.y <= 0) {
            RelativePoint relativePoint = preferredLocation;
            if (relativePoint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup", "guessBestPopupLocation"));
            }
            return relativePoint;
        }
        int adjustedY = preferredBounds.y - editor.getLineHeight() * 3 / 2 - preferredSize.height;
        RelativePoint relativePoint = adjustedY >= 0 ? RelativePoint.fromScreen((Point)new Point(preferredBounds.x, adjustedY)) : preferredLocation;
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup", "guessBestPopupLocation"));
        }
        return relativePoint;
    }

    public void addPopupListener(JBPopupListener listener) {
        this.myListeners.add(listener);
    }

    private RelativePoint relativePointWithDominantRectangle(JLayeredPane layeredPane, Rectangle bounds) {
        RelativePoint relativePoint;
        Dimension dimension;
        Dimension preferredSize = this.getComponent().getPreferredSize();
        if (this.myDimensionServiceKey != null && (dimension = DimensionService.getInstance().getSize(this.myDimensionServiceKey, this.myProject)) != null) {
            preferredSize = dimension;
        }
        Point leftTopCorner = new Point(bounds.x + bounds.width, bounds.y);
        Point leftTopCornerScreen = (Point)leftTopCorner.clone();
        SwingUtilities.convertPointToScreen(leftTopCornerScreen, layeredPane);
        if (!ScreenUtil.isOutsideOnTheRightOFScreen((Rectangle)new Rectangle(leftTopCornerScreen.x, leftTopCornerScreen.y, preferredSize.width, preferredSize.height))) {
            relativePoint = new RelativePoint((Component)layeredPane, leftTopCorner);
        } else if (bounds.x > preferredSize.width) {
            relativePoint = new RelativePoint((Component)layeredPane, new Point(bounds.x - preferredSize.width, bounds.y));
        } else {
            this.setDimensionServiceKey(null);
            Rectangle screen = ScreenUtil.getScreenRectangle((int)leftTopCornerScreen.x, (int)leftTopCornerScreen.y);
            int spaceOnTheLeft = bounds.x;
            int spaceOnTheRight = screen.x + screen.width - leftTopCornerScreen.x;
            if (spaceOnTheLeft > spaceOnTheRight) {
                relativePoint = new RelativePoint((Component)layeredPane, new Point(0, bounds.y));
                this.myComponent.setPreferredSize(new Dimension(spaceOnTheLeft, Math.max(preferredSize.height, JBUI.scale((int)200))));
            } else {
                relativePoint = new RelativePoint((Component)layeredPane, leftTopCorner);
                this.myComponent.setPreferredSize(new Dimension(spaceOnTheRight, Math.max(preferredSize.height, JBUI.scale((int)200))));
            }
        }
        return relativePoint;
    }

    public final void closeOk(@Nullable InputEvent e) {
        this.setOk(true);
        this.cancel(e);
    }

    public final void cancel() {
        this.cancel(null);
    }

    public void setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public void cancel(InputEvent e) {
        if (this.myState == State.CANCEL || this.myState == State.DISPOSE) {
            return;
        }
        this.debugState("cancel popup", State.SHOWN);
        this.myState = State.CANCEL;
        if (this.isDisposed()) {
            return;
        }
        if (this.myPopup != null) {
            Container popupWindow;
            JRootPane root;
            if (!this.canClose()) {
                this.debugState("cannot cancel popup", State.CANCEL);
                this.myState = State.SHOWN;
                return;
            }
            this.storeDimensionSize(this.myContent.getSize());
            if (this.myUseDimServiceForXYLocation && (root = this.myComponent.getRootPane()) != null && (popupWindow = root.getParent()) != null && popupWindow.isShowing()) {
                this.storeLocation(popupWindow.getLocationOnScreen());
            }
            if (e instanceof MouseEvent) {
                IdeEventQueue.getInstance().blockNextEvents((MouseEvent)e);
            }
            this.myPopup.hide(false);
            if (ApplicationManagerEx.getApplicationEx() != null) {
                StackingPopupDispatcher.getInstance().onPopupHidden((JBPopup)this);
            }
            if (this.myInStack) {
                if (this.myFocusTrackback != null) {
                    this.myFocusTrackback.setForcedRestore(!this.myOk && this.myFocusable);
                    this.myFocusTrackback.restoreFocus();
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("cancel before show @ " + Thread.currentThread());
                }
            }
            this.disposePopup();
            if (this.myListeners != null) {
                for (JBPopupListener each : this.myListeners) {
                    each.onClosed(new LightweightWindowEvent((LightweightWindow)this, this.myOk));
                }
            }
        }
        Disposer.dispose((Disposable)this, (boolean)false);
        if (this.myProjectDisposable != null) {
            Disposer.dispose((Disposable)this.myProjectDisposable);
        }
    }

    public FocusTrackback getFocusTrackback() {
        return this.myFocusTrackback;
    }

    private void disposePopup() {
        if (this.myPopup != null) {
            this.myPopup.hide(true);
        }
        this.myPopup = null;
    }

    public boolean canClose() {
        return this.myCallBack == null || (Boolean)this.myCallBack.compute() != false;
    }

    public boolean isVisible() {
        return this.myPopup != null;
    }

    public void show(Component owner) {
        this.show(owner, -1, -1, true);
    }

    public void show(Component owner, int aScreenX, int aScreenY, boolean considerForcedXY) {
        Window window;
        Object root;
        Insets insets;
        Point storedLocation;
        if (ApplicationManagerEx.getApplicationEx() != null && ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Popup was already disposed. Recreate a new instance to show again");
        }
        assert (ApplicationManager.getApplication().isDispatchThread());
        this.debugState("show popup", State.INIT);
        this.myState = State.SHOWING;
        AbstractPopup.installWindowHook(this);
        this.installProjectDisposer();
        this.addActivity();
        final Component prevOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean shouldShow = this.beforeShow();
        if (!shouldShow) {
            this.removeActivity();
            this.debugState("rejected to show popup", State.SHOWING);
            this.myState = State.INIT;
            return;
        }
        this.prepareToShow();
        if (this.myInStack) {
            this.myFocusTrackback = new FocusTrackback((Object)this, owner, true);
            this.myFocusTrackback.setMustBeShown(true);
        }
        Dimension sizeToSet = null;
        if (this.myDimensionServiceKey != null) {
            sizeToSet = DimensionService.getInstance().getSize(this.myDimensionServiceKey, this.myProject);
        }
        if (this.myForcedSize != null) {
            sizeToSet = this.myForcedSize;
        }
        if (sizeToSet != null) {
            sizeToSet.width = Math.max(sizeToSet.width, this.myContent.getMinimumSize().width);
            sizeToSet.height = Math.max(sizeToSet.height, this.myContent.getMinimumSize().height);
            this.myContent.setSize(sizeToSet);
            this.myContent.setPreferredSize(sizeToSet);
        }
        Point xy = new Point(aScreenX, aScreenY);
        boolean adjustXY = true;
        if (this.myUseDimServiceForXYLocation && this.myDimensionServiceKey != null && (storedLocation = DimensionService.getInstance().getLocation(this.myDimensionServiceKey, this.myProject)) != null) {
            xy = storedLocation;
            adjustXY = false;
        }
        if (adjustXY && (insets = this.myContent.getInsets()) != null) {
            xy.x -= insets.left;
            xy.y -= insets.top;
        }
        if (considerForcedXY && this.myForcedLocation != null) {
            xy = this.myForcedLocation;
        }
        if (this.myLocateByContent) {
            Dimension captionSize = this.myHeaderPanel.getPreferredSize();
            xy.y -= captionSize.height;
        }
        Rectangle targetBounds = new Rectangle(xy, this.myContent.getPreferredSize());
        Rectangle original = new Rectangle(targetBounds);
        if (this.myLocateWithinScreen && this.myMovable) {
            ScreenUtil.moveToFit((Rectangle)targetBounds, (Rectangle)ScreenUtil.getScreenRectangle((int)aScreenX, (int)aScreenY), null);
        }
        if (this.myMouseOutCanceller != null) {
            this.myMouseOutCanceller.myEverEntered = targetBounds.equals(original);
        }
        this.myOwner = IdeFrameImpl.findNearestModalComponent(owner);
        if (this.myOwner == null) {
            this.myOwner = owner;
        }
        this.myRequestorComponent = owner;
        boolean forcedDialog = this.myMayBeParent || SystemInfo.isMac && !(this.myOwner instanceof IdeFrame) && this.myOwner != null && this.myOwner.isShowing();
        PopupComponent.Factory factory = this.getFactory(this.myForcedHeavyweight || this.myResizable, forcedDialog);
        this.myNativePopup = factory.isNativePopup();
        Component popupOwner = this.myOwner;
        if (popupOwner instanceof RootPaneContainer && (!(popupOwner instanceof IdeFrame) || Registry.is((String)"popup.fix.ide.frame.owner"))) {
            root = (RootPaneContainer)((Object)popupOwner);
            popupOwner = root.getRootPane();
            LOG.debug("popup owner fixed for JDK cache");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("expected preferred size: " + this.myContent.getPreferredSize());
        }
        this.myPopup = factory.getPopup(popupOwner, this.myContent, targetBounds.x, targetBounds.y, this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("  actual preferred size: " + this.myContent.getPreferredSize());
        }
        if (targetBounds.width != this.myContent.getWidth() || targetBounds.height != this.myContent.getHeight()) {
            LOG.debug("the expected size is not equal to the actual size");
            Window popup = this.myPopup.getWindow();
            if (popup != null) {
                popup.setSize(targetBounds.width, targetBounds.height);
                if (this.myContent.getParent().getComponentCount() != 1) {
                    LOG.debug("unexpected count of components in heavy-weight popup");
                }
            } else {
                LOG.debug("cannot fix size for non-heavy-weight popup");
            }
        }
        if (this.myResizable) {
            root = this.myContent.getRootPane();
            IdeGlassPaneImpl glass = new IdeGlassPaneImpl((JRootPane)root);
            ((JRootPane)root).setGlassPane(glass);
            ResizeComponentListener resizeListener = new ResizeComponentListener(this, glass);
            glass.addMousePreprocessor(resizeListener, (Disposable)this);
            glass.addMouseMotionPreprocessor(resizeListener, (Disposable)this);
        }
        if (this.myCaption != null && this.myMovable) {
            final MoveComponentListener moveListener = new MoveComponentListener(this.myCaption){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    if (e.isConsumed()) {
                        return;
                    }
                    if (UIUtil.isCloseClick((MouseEvent)e) && AbstractPopup.this.myCaption.isWithinPanel(e)) {
                        AbstractPopup.this.cancel();
                    }
                }
            };
            ListenerUtil.addMouseListener((Component)this.myCaption, moveListener);
            ListenerUtil.addMouseMotionListener((Component)this.myCaption, moveListener);
            final MyContentPanel saved = this.myContent;
            Disposer.register((Disposable)this, (Disposable)new Disposable(){

                public void dispose() {
                    ListenerUtil.removeMouseListener(saved, moveListener);
                    ListenerUtil.removeMouseMotionListener(saved, moveListener);
                }
            });
        }
        for (JBPopupListener listener : this.myListeners) {
            listener.beforeShown(new LightweightWindowEvent((LightweightWindow)this));
        }
        this.myPopup.setRequestFocus(this.myRequestFocus);
        this.myPopup.show();
        this.myWindow = window = AbstractPopup.getContentWindow(this.myContent);
        this.myWindowListener = new MyWindowListener();
        window.addWindowListener(this.myWindowListener);
        if (this.myFocusable) {
            window.setFocusableWindowState(true);
            window.setFocusable(true);
        }
        if (this.myWindow != null && !this.myMayBeParent && !(this.myWindow instanceof Frame)) {
            WindowManager.getInstance().doNotSuggestAsParent(this.myWindow);
        }
        this.setMinimumSize(this.myMinSize);
        final Runnable afterShow = new Runnable(){

            @Override
            public void run() {
                if (AbstractPopup.this.myPreferredFocusedComponent != null && AbstractPopup.this.myInStack && AbstractPopup.this.myFocusable) {
                    AbstractPopup.this.myFocusTrackback.registerFocusComponent(AbstractPopup.this.myPreferredFocusedComponent);
                    if (AbstractPopup.this.myPreferredFocusedComponent instanceof JTextComponent) {
                        IJSwingUtilities.moveMousePointerOn(AbstractPopup.this.myPreferredFocusedComponent);
                    }
                }
                AbstractPopup.this.removeActivity();
                AbstractPopup.this.afterShow();
            }
        };
        if (this.myRequestFocus) {
            this.getFocusManager().requestFocus(new FocusCommand(){

                @NotNull
                public ActionCallback run() {
                    if (AbstractPopup.this.isDisposed()) {
                        AbstractPopup.this.removeActivity();
                        ActionCallback.Done done = new ActionCallback.Done();
                        if (done == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup$9", "run"));
                        }
                        return done;
                    }
                    AbstractPopup.this._requestFocus();
                    final ActionCallback result = new ActionCallback();
                    final Runnable afterShowRunnable = new Runnable(){

                        @Override
                        public void run() {
                            afterShow.run();
                            result.setDone();
                        }
                    };
                    if (AbstractPopup.this.myNativePopup) {
                        final FocusRequestor furtherRequestor = AbstractPopup.this.getFocusManager().getFurtherRequestor();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (AbstractPopup.this.isDisposed()) {
                                    result.setRejected();
                                    return;
                                }
                                furtherRequestor.requestFocus(new FocusCommand(){

                                    @NotNull
                                    public ActionCallback run() {
                                        if (AbstractPopup.this.isDisposed()) {
                                            ActionCallback.Rejected rejected = new ActionCallback.Rejected();
                                            if (rejected == null) {
                                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup$9$2$2", "run"));
                                            }
                                            return rejected;
                                        }
                                        AbstractPopup.this._requestFocus();
                                        afterShowRunnable.run();
                                        ActionCallback.Done done = new ActionCallback.Done();
                                        if (done == null) {
                                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup$9$2$2", "run"));
                                        }
                                        return done;
                                    }
                                }, true).notify(result).doWhenProcessed(new Runnable(){

                                    @Override
                                    public void run() {
                                        AbstractPopup.this.removeActivity();
                                    }
                                });
                            }
                        });
                    } else {
                        afterShowRunnable.run();
                    }
                    ActionCallback actionCallback = result;
                    if (actionCallback == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup$9", "run"));
                    }
                    return actionCallback;
                }
            }, true).doWhenRejected(new Runnable(){

                @Override
                public void run() {
                    afterShow.run();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AbstractPopup.this.isDisposed()) {
                        AbstractPopup.this.removeActivity();
                        return;
                    }
                    if (X_WINDOW_FOCUS_BUG && !AbstractPopup.this.myRequestFocus && prevOwner != null && Registry.is((String)"actionSystem.xWindow.remove.focus.from.nonFocusable.popups")) {
                        new Alarm().addRequest(new Runnable(){

                            @Override
                            public void run() {
                                if (AbstractPopup.this.isFocused()) {
                                    IdeFocusManager.getInstance((Project)AbstractPopup.this.myProject).requestFocus(prevOwner, false);
                                }
                            }
                        }, Registry.intValue((String)"actionSystem.xWindow.remove.focus.from.nonFocusable.popups.delay"));
                    }
                    afterShow.run();
                }
            });
        }
        this.debugState("popup shown", State.SHOWING);
        this.myState = State.SHOWN;
    }

    public void focusPreferredComponent() {
        this._requestFocus();
    }

    private void installProjectDisposer() {
        DataContext context;
        Project project;
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c != null && (project = (Project)CommonDataKeys.PROJECT.getData(context = DataManager.getInstance().getDataContext(c))) != null) {
            this.myProjectDisposable = new Disposable(){

                public void dispose() {
                    if (!AbstractPopup.this.isDisposed()) {
                        Disposer.dispose((Disposable)AbstractPopup.this);
                    }
                }
            };
            Disposer.register((Disposable)project, (Disposable)this.myProjectDisposable);
        }
    }

    private static void installWindowHook(final AbstractPopup popup) {
        if (popup.myCancelOnWindow) {
            popup.myCancelOnWindow = false;
            new Alarm((Disposable)popup).addRequest(new Runnable(){

                @Override
                public void run() {
                    popup.myCancelOnWindow = true;
                }
            }, 100);
        }
    }

    private void addActivity() {
        UiActivityMonitor.getInstance().addActivity(this.myActivityKey);
    }

    private void removeActivity() {
        UiActivityMonitor.getInstance().removeActivity(this.myActivityKey);
    }

    private void prepareToShow() {
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point point = (Point)e.getPoint().clone();
                SwingUtilities.convertPointToScreen(point, e.getComponent());
                Dimension dimension = AbstractPopup.this.myContent.getSize();
                dimension.height = dimension.height + (AbstractPopup.this.myResizable && AbstractPopup.this.isToDrawMacCorner() ? AllIcons.General.MacCorner.getIconHeight() : 4);
                dimension.width += 4;
                Point locationOnScreen = AbstractPopup.this.myContent.getLocationOnScreen();
                Rectangle bounds = new Rectangle(new Point(locationOnScreen.x - 2, locationOnScreen.y - 2), dimension);
                if (!bounds.contains(point)) {
                    AbstractPopup.this.cancel();
                }
            }
        };
        this.myContent.addMouseListener(mouseAdapter);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                AbstractPopup.this.myContent.removeMouseListener(mouseAdapter);
            }
        });
        this.myContent.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractPopup.this.myCancelKeyEnabled) {
                    AbstractPopup.this.cancel();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.mySearchKeyListener = new SpeedSearchKeyListener();
        this.myContent.addKeyListener(this.mySearchKeyListener);
        if (this.myCancelOnMouseOutCallback != null || this.myCancelOnWindow) {
            this.myMouseOutCanceller = new Canceller();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.myMouseOutCanceller, 253L);
        }
        ChildFocusWatcher focusWatcher = new ChildFocusWatcher(this.myContent){

            @Override
            protected void onFocusGained(FocusEvent event) {
                AbstractPopup.this.setWindowActive(true);
            }

            @Override
            protected void onFocusLost(FocusEvent event) {
                AbstractPopup.this.setWindowActive(false);
            }
        };
        Disposer.register((Disposable)this, (Disposable)focusWatcher);
        this.mySpeedSearchPatternField = new JTextField();
        if (SystemInfo.isMac) {
            Font f = this.mySpeedSearchPatternField.getFont();
            this.mySpeedSearchPatternField.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        }
    }

    private Window updateMaskAndAlpha(Window window) {
        if (window == null) {
            return null;
        }
        WindowManagerEx wndManager = AbstractPopup.getWndManager();
        if (wndManager == null) {
            return window;
        }
        if (!wndManager.isAlphaModeEnabled(window)) {
            return window;
        }
        if (this.myAlpha != this.myLastAlpha) {
            wndManager.setAlphaModeRatio(window, this.myAlpha);
            this.myLastAlpha = this.myAlpha;
        }
        if (this.myMaskProvider != null) {
            Dimension size = window.getSize();
            Shape mask = this.myMaskProvider.getMask(size);
            wndManager.setWindowMask(window, mask);
        }
        WindowManagerEx.WindowShadowMode mode = this.myShadowed ? WindowManagerEx.WindowShadowMode.NORMAL : WindowManagerEx.WindowShadowMode.DISABLED;
        WindowManagerEx.getInstanceEx().setWindowShadow(window, mode);
        return window;
    }

    private static WindowManagerEx getWndManager() {
        return ApplicationManagerEx.getApplicationEx() != null ? WindowManagerEx.getInstanceEx() : null;
    }

    public boolean isDisposed() {
        return this.myContent == null;
    }

    protected boolean beforeShow() {
        if (ApplicationManagerEx.getApplicationEx() == null) {
            return true;
        }
        StackingPopupDispatcher.getInstance().onPopupShown((JBPopup)this, this.myInStack);
        return true;
    }

    protected void afterShow() {
    }

    protected final boolean requestFocus() {
        if (!this.myFocusable) {
            return false;
        }
        this.getFocusManager().requestFocus(new FocusCommand(){

            @NotNull
            public ActionCallback run() {
                AbstractPopup.this._requestFocus();
                ActionCallback.Done done = new ActionCallback.Done();
                if (done == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup$17", "run"));
                }
                return done;
            }
        }, true);
        return true;
    }

    private void _requestFocus() {
        if (!this.myFocusable) {
            return;
        }
        if (this.myPreferredFocusedComponent != null) {
            this.myPreferredFocusedComponent.requestFocus();
        }
    }

    private IdeFocusManager getFocusManager() {
        if (this.myProject != null) {
            return IdeFocusManager.getInstance((Project)this.myProject);
        }
        if (this.myOwner != null) {
            return IdeFocusManager.findInstanceByComponent((Component)this.myOwner);
        }
        return IdeFocusManager.findInstance();
    }

    private static JComponent getTargetComponent(Component aComponent) {
        if (aComponent instanceof JComponent) {
            return (JComponent)aComponent;
        }
        if (aComponent instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)aComponent)).getRootPane();
        }
        LOG.error("Cannot find target for:" + aComponent);
        return null;
    }

    private PopupComponent.Factory getFactory(boolean forceHeavyweight, boolean forceDialog) {
        if (Registry.is((String)"allow.dialog.based.popups")) {
            boolean cannotBeDialog;
            boolean noFocus = !this.myFocusable || !this.myRequestFocus;
            boolean bl = cannotBeDialog = noFocus && SystemInfo.isXWindow;
            if (!cannotBeDialog && (this.isPersistent() || forceDialog)) {
                return new PopupComponent.Factory.Dialog();
            }
        }
        if (forceHeavyweight) {
            return new PopupComponent.Factory.AwtHeavyweight();
        }
        return new PopupComponent.Factory.AwtDefault();
    }

    public JComponent getContent() {
        return this.myContent;
    }

    public void setLocation(RelativePoint p) {
        AbstractPopup.setLocation(p, this.myPopup);
    }

    private static void setLocation(RelativePoint p, PopupComponent popup) {
        if (popup == null) {
            return;
        }
        Window wnd = popup.getWindow();
        assert (wnd != null);
        wnd.setLocation(p.getScreenPoint());
    }

    public void pack(boolean width, boolean height) {
        if (!this.isVisible() || !width && !height) {
            return;
        }
        Dimension size = this.getSize();
        Dimension prefSize = this.myContent.computePreferredSize();
        if (width) {
            size.width = prefSize.width;
        }
        if (height) {
            size.height = prefSize.height;
        }
        size = this.computeWindowSize(size);
        Window window = AbstractPopup.getContentWindow(this.myContent);
        if (window != null) {
            window.setSize(size);
        }
    }

    public void pack() {
        Window window = AbstractPopup.getContentWindow(this.myContent);
        if (window != null) {
            window.pack();
        }
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    public void dispose() {
        Toolkit toolkit;
        if (this.myState == State.SHOWN) {
            LOG.debug("shown popup must be cancelled");
            this.cancel();
        }
        if (this.myState == State.DISPOSE) {
            return;
        }
        this.debugState("dispose popup", State.INIT, State.CANCEL);
        this.myState = State.DISPOSE;
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("start disposing " + this.myContent);
        }
        Disposer.dispose((Disposable)this, (boolean)false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPopup != null) {
            this.cancel(this.myDisposeEvent);
        }
        if (this.myContent != null) {
            this.myContent.removeAll();
            this.myContent.removeKeyListener(this.mySearchKeyListener);
        }
        this.myContent = null;
        this.myPreferredFocusedComponent = null;
        this.myComponent = null;
        this.myFocusTrackback = null;
        this.myCallBack = null;
        this.myListeners = null;
        if (this.myMouseOutCanceller != null && (toolkit = Toolkit.getDefaultToolkit()) != null) {
            toolkit.removeAWTEventListener(this.myMouseOutCanceller);
        }
        this.myMouseOutCanceller = null;
        this.resetWindow();
        if (this.myFinalRunnable != null) {
            final ActionCallback typeAheadDone = new ActionCallback();
            Runnable runFinal = new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(typeAheadDone.createSetDoneRunnable());
                    AbstractPopup.this.myFinalRunnable.run();
                    AbstractPopup.this.myFinalRunnable = null;
                }
            };
            IdeFocusManager.getInstance((Project)this.myProject).typeAheadUntil(typeAheadDone);
            this.getFocusManager().doWhenFocusSettlesDown(runFinal);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("stop disposing content");
        }
    }

    private void resetWindow() {
        if (this.myWindow != null && AbstractPopup.getWndManager() != null) {
            AbstractPopup.getWndManager().resetWindow(this.myWindow);
            if (this.myWindowListener != null) {
                this.myWindow.removeWindowListener(this.myWindowListener);
            }
            if (this.myWindow instanceof JWindow) {
                ((JWindow)this.myWindow).getRootPane().putClientProperty("JBPopup", null);
            }
            this.myWindow = null;
            this.myWindowListener = null;
        }
    }

    public void storeDimensionSize(Dimension size) {
        if (this.myDimensionServiceKey != null) {
            DimensionService.getInstance().setSize(this.myDimensionServiceKey, size, this.myProject);
        }
    }

    public void storeLocation(Point xy) {
        if (this.myDimensionServiceKey != null) {
            DimensionService.getInstance().setLocation(this.myDimensionServiceKey, xy, this.myProject);
        }
    }

    public boolean isCancelOnClickOutside() {
        return this.myCancelOnClickOutside;
    }

    public boolean isCancelOnWindowDeactivation() {
        return this.myCancelOnWindowDeactivation;
    }

    public void setLocation(@NotNull Point screenPoint) {
        if (screenPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenPoint", "com/intellij/ui/popup/AbstractPopup", "setLocation"));
        }
        if (this.myPopup == null) {
            this.myForcedLocation = screenPoint;
        } else {
            AbstractPopup.moveTo(this.myContent, screenPoint, this.myLocateByContent ? this.myHeaderPanel.getPreferredSize() : null);
        }
    }

    public static Window moveTo(JComponent content, Point screenPoint, Dimension headerCorrectionSize) {
        Window wnd = AbstractPopup.getContentWindow(content);
        if (wnd != null) {
            wnd.setCursor(Cursor.getDefaultCursor());
            if (headerCorrectionSize != null) {
                screenPoint.y -= headerCorrectionSize.height;
            }
            wnd.setLocation(screenPoint);
        }
        return wnd;
    }

    private static Window getContentWindow(Component content) {
        Window window = SwingUtilities.getWindowAncestor(content);
        if (window == null && LOG.isDebugEnabled()) {
            LOG.debug("no window ancestor for " + content);
        }
        return window;
    }

    public Point getLocationOnScreen() {
        Dimension headerCorrectionSize = this.myLocateByContent ? this.myHeaderPanel.getPreferredSize() : null;
        Point screenPoint = this.myContent.getLocationOnScreen();
        if (headerCorrectionSize != null) {
            screenPoint.y -= headerCorrectionSize.height;
        }
        return screenPoint;
    }

    public void setSize(@NotNull Dimension size) {
        if (size == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/ui/popup/AbstractPopup", "setSize"));
        }
        this.setSize(size, true);
    }

    private void setSize(Dimension size, boolean adjustByContent) {
        Dimension toSet = size;
        if (this.myPopup == null) {
            this.myForcedSize = toSet;
        } else {
            if (adjustByContent) {
                toSet = this.computeWindowSize(toSet);
            }
            this.updateMaskAndAlpha(AbstractPopup.setSize(this.myContent, toSet));
        }
    }

    private Dimension computeWindowSize(Dimension size) {
        if (this.myAdComponent != null && this.myAdComponent.isShowing()) {
            size.height += this.myAdComponent.getPreferredSize().height + 1;
        }
        return size;
    }

    public Dimension getSize() {
        if (this.myPopup != null) {
            Window popupWindow = AbstractPopup.getContentWindow(this.myContent);
            return popupWindow == null ? this.myForcedSize : popupWindow.getSize();
        }
        return this.myForcedSize;
    }

    public void moveToFitScreen() {
        if (this.myPopup == null) {
            return;
        }
        Window popupWindow = AbstractPopup.getContentWindow(this.myContent);
        if (popupWindow == null) {
            return;
        }
        Rectangle bounds = popupWindow.getBounds();
        ScreenUtil.moveRectangleToFitTheScreen((Rectangle)bounds);
        this.setLocation(bounds.getLocation());
        this.setSize(bounds.getSize(), false);
    }

    public static Window setSize(JComponent content, Dimension size) {
        Window popupWindow = AbstractPopup.getContentWindow(content);
        if (popupWindow == null) {
            return null;
        }
        Insets insets = content.getInsets();
        if (insets != null) {
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
        }
        content.setPreferredSize(size);
        popupWindow.pack();
        return popupWindow;
    }

    public static void setDefaultCursor(JComponent content) {
        Window wnd = AbstractPopup.getContentWindow(content);
        if (wnd != null) {
            wnd.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setCaption(String title) {
        if (this.myCaption instanceof TitlePanel) {
            ((TitlePanel)this.myCaption).setText(title);
        }
    }

    public boolean isPersistent() {
        return !this.myCancelOnClickOutside && !this.myCancelOnWindow;
    }

    public boolean isNativePopup() {
        return this.myNativePopup;
    }

    public void setUiVisible(boolean visible) {
        if (this.myPopup != null) {
            if (visible) {
                this.myPopup.show();
                Window window = this.getPopupWindow();
                if (window != null && this.myRestoreWindowSize != null) {
                    window.setSize(this.myRestoreWindowSize);
                    this.myRestoreWindowSize = null;
                }
            } else {
                Window window = this.getPopupWindow();
                if (window != null) {
                    this.myRestoreWindowSize = window.getSize();
                    window.setVisible(true);
                }
            }
        }
    }

    public Window getPopupWindow() {
        return this.myPopup.getWindow();
    }

    public void setUserData(List<Object> userData) {
        this.myUserData = userData;
    }

    public <T> T getUserData(Class<T> userDataClass) {
        if (this.myUserData != null) {
            for (Object o : this.myUserData) {
                if (!userDataClass.isInstance(o)) continue;
                Object t = o;
                return (T)t;
            }
        }
        return null;
    }

    public boolean isModalContext() {
        return this.myModalContext;
    }

    public boolean isFocused() {
        if (this.myComponent != null && AbstractPopup.isFocused(new Component[]{SwingUtilities.getWindowAncestor(this.myComponent)})) {
            return true;
        }
        return AbstractPopup.isFocused(this.myFocusOwners);
    }

    public static boolean isFocused(@Nullable Component[] components) {
        if (components == null) {
            return false;
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return false;
        }
        Window wnd = UIUtil.getWindow((Component)owner);
        for (Component each : components) {
            Window eachWindow;
            if (each == null || !SwingUtilities.isDescendingFrom(owner, each) || (eachWindow = UIUtil.getWindow((Component)each)) != wnd) continue;
            return true;
        }
        return false;
    }

    public boolean isCancelKeyEnabled() {
        return this.myCancelKeyEnabled;
    }

    @NotNull
    CaptionPanel getTitle() {
        CaptionPanel captionPanel = this.myCaption;
        if (captionPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup", "getTitle"));
        }
        return captionPanel;
    }

    private void setHeaderComponent(JComponent c) {
        boolean doRevalidate = false;
        if (this.myHeaderComponent != null) {
            this.myHeaderPanel.remove(this.myHeaderComponent);
            this.myHeaderPanel.add((Component)this.myCaption, "North");
            this.myHeaderComponent = null;
            doRevalidate = true;
        }
        if (c != null) {
            this.myHeaderPanel.remove((Component)this.myCaption);
            this.myHeaderPanel.add((Component)c, "North");
            this.myHeaderComponent = c;
            Dimension size = this.myContent.getSize();
            if (size.height < c.getPreferredSize().height * 2) {
                size.height += c.getPreferredSize().height;
                this.setSize(size);
            }
            doRevalidate = true;
        }
        if (doRevalidate) {
            this.myContent.revalidate();
        }
    }

    public void setWarning(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/popup/AbstractPopup", "setWarning"));
        }
        JBLabel label = new JBLabel(text, UIUtil.getBalloonWarningIcon(), 0);
        label.setOpaque(true);
        Color color = HintUtil.INFORMATION_COLOR;
        label.setBackground(color);
        label.setBorder(BorderFactory.createLineBorder(color, 3));
        this.myHeaderPanel.add((Component)label, "South");
    }

    public void addListener(JBPopupListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(JBPopupListener listener) {
        this.myListeners.remove(listener);
    }

    protected void onSpeedSearchPatternChanged() {
    }

    public Component getOwner() {
        return this.myRequestorComponent;
    }

    public void setMinimumSize(Dimension size) {
        Dimension sizeFromHeader = this.myHeaderPanel.getPreferredSize();
        if (sizeFromHeader == null) {
            sizeFromHeader = this.myHeaderPanel.getMinimumSize();
        }
        if (sizeFromHeader == null) {
            int minimumSize = this.myWindow.getGraphics().getFontMetrics(this.myHeaderPanel.getFont()).getHeight();
            sizeFromHeader = new Dimension(minimumSize, minimumSize);
        }
        if (size == null) {
            this.myMinSize = sizeFromHeader;
        } else {
            int width = Math.max(size.width, sizeFromHeader.width);
            int height = Math.max(size.height, sizeFromHeader.height);
            this.myMinSize = new Dimension(width, height);
        }
        if (this.myWindow != null) {
            this.myWindow.setMinimumSize(this.myMinSize);
        }
    }

    public void setFinalRunnable(Runnable finalRunnable) {
        this.myFinalRunnable = finalRunnable;
    }

    public void setOk(boolean ok) {
        this.myOk = ok;
    }

    public void setDataProvider(@NotNull DataProvider dataProvider) {
        if (dataProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/ui/popup/AbstractPopup", "setDataProvider"));
        }
        if (this.myContent != null) {
            this.myContent.setDataProvider(dataProvider);
        }
    }

    public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/popup/AbstractPopup", "dispatchKeyEvent"));
        }
        BooleanFunction<KeyEvent> handler = this.myKeyEventHandler;
        if (handler != null) {
            return handler.fun((Object)e);
        }
        if (AbstractPopup.isCloseRequest(e) && this.myCancelKeyEnabled) {
            this.cancel(e);
            return true;
        }
        return false;
    }

    @NotNull
    public Dimension getHeaderPreferredSize() {
        Dimension dimension = this.myHeaderPanel.getPreferredSize();
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup", "getHeaderPreferredSize"));
        }
        return dimension;
    }

    @NotNull
    public Dimension getFooterPreferredSize() {
        Dimension dimension = this.myAdComponent == null ? new Dimension(0, 0) : this.myAdComponent.getPreferredSize();
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/AbstractPopup", "getFooterPreferredSize"));
        }
        return dimension;
    }

    public static boolean isCloseRequest(KeyEvent e) {
        return e != null && e.getID() == 401 && e.getKeyCode() == 27 && e.getModifiers() == 0;
    }

    private class SpeedSearchKeyListener
    implements KeyListener {
        private SpeedSearchKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            AbstractPopup.this.mySpeedSearch.process(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            AbstractPopup.this.mySpeedSearch.process(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            AbstractPopup.this.mySpeedSearch.process(e);
        }
    }

    private class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            AbstractPopup.this.updateMaskAndAlpha(AbstractPopup.this.myWindow);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            AbstractPopup.this.resetWindow();
            AbstractPopup.this.cancel();
        }
    }

    private class Canceller
    implements AWTEventListener {
        private boolean myEverEntered = false;

        private Canceller() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event.getID() == 205) {
                if (AbstractPopup.this.myCancelOnWindow && AbstractPopup.this.myPopup != null && !AbstractPopup.this.myPopup.isPopupWindow(((WindowEvent)event).getWindow())) {
                    AbstractPopup.this.cancel();
                }
            } else if (event.getID() == 504) {
                if (this.withinPopup(event)) {
                    this.myEverEntered = true;
                }
            } else if (event.getID() == 503 && AbstractPopup.this.myCancelOnMouseOutCallback != null && this.myEverEntered && !this.withinPopup(event) && AbstractPopup.this.myCancelOnMouseOutCallback.check((MouseEvent)event)) {
                AbstractPopup.this.cancel();
            }
        }

        private boolean withinPopup(AWTEvent event) {
            if (!AbstractPopup.this.myContent.isShowing()) {
                return false;
            }
            MouseEvent mouse = (MouseEvent)event;
            Point point = mouse.getPoint();
            SwingUtilities.convertPointToScreen(point, mouse.getComponent());
            return new Rectangle(AbstractPopup.this.myContent.getLocationOnScreen(), AbstractPopup.this.myContent.getSize()).contains(point);
        }
    }

    public static class MyContentPanel
    extends JPanel
    implements DataProvider {
        private final boolean myResizable;
        private final boolean myDrawMacCorner;
        @Nullable
        private DataProvider myDataProvider;

        public MyContentPanel(boolean resizable, PopupBorder border, boolean drawMacCorner) {
            super(new BorderLayout());
            this.myResizable = resizable;
            this.myDrawMacCorner = drawMacCorner;
            this.setBorder((Border)border);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.myResizable && this.myDrawMacCorner) {
                AllIcons.General.MacCorner.paintIcon(this, g, this.getX() + this.getWidth() - AllIcons.General.MacCorner.getIconWidth(), this.getY() + this.getHeight() - AllIcons.General.MacCorner.getIconHeight());
            }
        }

        public Dimension computePreferredSize() {
            if (this.isPreferredSizeSet()) {
                Dimension setSize = this.getPreferredSize();
                this.setPreferredSize(null);
                Dimension result = this.getPreferredSize();
                this.setPreferredSize(setSize);
                return result;
            }
            return this.getPreferredSize();
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            return this.myDataProvider != null ? this.myDataProvider.getData(dataId) : null;
        }

        public void setDataProvider(@Nullable DataProvider dataProvider) {
            this.myDataProvider = dataProvider;
        }
    }

    private static enum State {
        NEW,
        INIT,
        SHOWING,
        SHOWN,
        CANCEL,
        DISPOSE;

    }
}

