/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.util.DetailController;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.DetailViewImpl;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.ItemWrapperListRenderer;
import com.intellij.ui.popup.util.MasterController;
import com.intellij.ui.popup.util.SplitterItem;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public class MasterDetailPopupBuilder
implements MasterController {
    private static final Color BORDER_COLOR = Gray._135;
    private final Project myProject;
    private ActionGroup myActions;
    private Delegate myDelegate;
    private boolean myCloseOnEnter;
    private DetailView myDetailView;
    private JLabel myPathLabel;
    private JBPopup myPopup;
    private JComponent myChooserComponent;
    private ActionToolbar myActionToolbar;
    private boolean myAddDetailViewToEast = true;
    private Dimension myMinSize;
    private boolean myCancelOnWindowDeactivation = true;
    private Runnable myDoneRunnable;
    private boolean myCancelOnClickOutside;
    private final DetailController myDetailController = new DetailController(this);
    private boolean myUseDimensionServiceForXYLocation;
    private String myDimensionServiceKey;

    public void setUseDimensionServiceForXYLocation(boolean useDimensionServiceForXYLocation) {
        this.myUseDimensionServiceForXYLocation = useDimensionServiceForXYLocation;
    }

    public String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    public void setDimensionServiceKey(String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
    }

    public MasterDetailPopupBuilder setDetailView(DetailView detailView) {
        this.myDetailView = detailView;
        this.myDetailController.setDetailView(this.myDetailView);
        return this;
    }

    public ActionToolbar getActionToolbar() {
        return this.myActionToolbar;
    }

    public MasterDetailPopupBuilder(Project project) {
        this.myProject = project;
    }

    public JBPopup createMasterDetailPopup() {
        String title;
        this.setupRenderer();
        this.myPathLabel = new JLabel(" ");
        this.myPathLabel.setHorizontalAlignment(4);
        Font font = this.myPathLabel.getFont();
        this.myPathLabel.setFont(font.deriveFont(10.0f));
        if (this.myDetailView == null) {
            this.myDetailView = new DetailViewImpl(this.myProject);
        }
        JPanel footerPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(BORDER_COLOR);
                g.drawLine(0, 0, this.getWidth(), 0);
            }
        };
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IdeFocusManager.getInstance((Project)MasterDetailPopupBuilder.this.myProject).doWhenFocusSettlesDown(new Runnable(){

                    @Override
                    public void run() {
                        ItemWrapper[] values = MasterDetailPopupBuilder.this.getSelectedItems();
                        if (values.length == 1) {
                            MasterDetailPopupBuilder.this.myDelegate.itemChosen(values[0], MasterDetailPopupBuilder.this.myProject, MasterDetailPopupBuilder.this.myPopup, false);
                        } else {
                            for (ItemWrapper value : values) {
                                if (!(value instanceof ItemWrapper)) continue;
                                MasterDetailPopupBuilder.this.myDelegate.itemChosen(value, MasterDetailPopupBuilder.this.myProject, MasterDetailPopupBuilder.this.myPopup, false);
                            }
                        }
                    }
                });
            }
        };
        footerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        footerPanel.add(this.myPathLabel);
        JComponent toolBar = null;
        if (this.myActions != null) {
            this.myActionToolbar = ActionManager.getInstance().createActionToolbar("", this.myActions, true);
            this.myActionToolbar.setReservePlaceAutoPopupIcon(false);
            this.myActionToolbar.setMinimumButtonSize(new Dimension(20, 20));
            toolBar = this.myActionToolbar.getComponent();
            toolBar.setOpaque(false);
        }
        PopupChooserBuilder builder = this.createInnerBuilder().setMovable(true).setResizable(true).setAutoselectOnMouseMove(false).setSettingButton(toolBar).setSouthComponent((JComponent)footerPanel).setCancelOnWindowDeactivation(this.myCancelOnWindowDeactivation).setCancelOnClickOutside(this.myCancelOnClickOutside).setUseDimensionServiceForXYLocation(this.myUseDimensionServiceForXYLocation);
        if (this.myDoneRunnable != null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    MasterDetailPopupBuilder.this.myDoneRunnable.run();
                }
            };
            if ((SystemInfo.isMacOSLion || SystemInfo.isMacOSMountainLion) && !UIUtil.isUnderDarcula()) {
                final JButton done = new JButton("Done");
                done.setMnemonic('o');
                done.addActionListener(actionListener);
                builder.setCommandButton(new ActiveComponent(){

                    public void setActive(boolean active) {
                    }

                    public JComponent getComponent() {
                        return done;
                    }
                });
            } else {
                builder.setCommandButton((ActiveComponent)new InplaceButton(new IconButton("Close", AllIcons.Actions.CloseNew, AllIcons.Actions.CloseNewHovered), actionListener));
            }
        }
        if ((title = this.myDelegate.getTitle()) != null) {
            builder.setTitle(title);
        }
        builder.setItemChoosenCallback(runnable).setCloseOnEnter(this.myCloseOnEnter).setMayBeParent(true).setDimensionServiceKey(this.myDimensionServiceKey).setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object o) {
                return ((ItemWrapper)o).speedSearchText();
            }
        });
        if (this.myMinSize != null) {
            builder.setMinSize(this.myMinSize);
        }
        this.myPopup = builder.createPopup();
        builder.getScrollPane().setBorder(IdeBorderFactory.createBorder((int)4));
        this.myPopup.addListener(new JBPopupListener(){

            public void beforeShown(LightweightWindowEvent event) {
            }

            public void onClosed(LightweightWindowEvent event) {
                MasterDetailPopupBuilder.this.myDetailView.clearEditor();
            }
        });
        if (this.myDoneRunnable != null) {
            new AnAction("Done"){

                public void actionPerformed(AnActionEvent e) {
                    MasterDetailPopupBuilder.this.myDoneRunnable.run();
                }
            }.registerCustomShortcutSet(10, 128, this.myPopup.getContent());
        }
        return this.myPopup;
    }

    private void setupRenderer() {
        if (this.myChooserComponent instanceof JList) {
            JList list = (JList)this.myChooserComponent;
            list.setCellRenderer(new ListItemRenderer(this.myDelegate, this.myProject));
        }
    }

    private PopupChooserBuilder createInnerBuilder() {
        if (this.myChooserComponent instanceof JList) {
            return new MyPopupChooserBuilder((JList)this.myChooserComponent);
        }
        if (this.myChooserComponent instanceof JTree) {
            return new MyPopupChooserBuilder((JTree)this.myChooserComponent);
        }
        return null;
    }

    @Override
    public ItemWrapper[] getSelectedItems() {
        Object[] values = new Object[]{};
        if (this.myChooserComponent instanceof JList) {
            values = ((JList)this.myChooserComponent).getSelectedValues();
        } else if (this.myChooserComponent instanceof JTree) {
            values = this.myDelegate.getSelectedItemsInTree();
        }
        ItemWrapper[] items = new ItemWrapper[values.length];
        for (int i = 0; i < values.length; ++i) {
            items[i] = (ItemWrapper)values[i];
        }
        return items;
    }

    public void setAddDetailViewToEast(boolean addDetailViewToEast) {
        this.myAddDetailViewToEast = addDetailViewToEast;
    }

    public MasterDetailPopupBuilder setMinSize(Dimension minSize) {
        this.myMinSize = minSize;
        return this;
    }

    public MasterDetailPopupBuilder setCancelOnWindowDeactivation(boolean cancelOnWindowDeactivation) {
        this.myCancelOnWindowDeactivation = cancelOnWindowDeactivation;
        return this;
    }

    public MasterDetailPopupBuilder setDoneRunnable(Runnable doneRunnable) {
        this.myDoneRunnable = doneRunnable;
        return this;
    }

    public void setCancelOnClickOutside(boolean cancelOnClickOutside) {
        this.myCancelOnClickOutside = cancelOnClickOutside;
    }

    @Override
    public JLabel getPathLabel() {
        return this.myPathLabel;
    }

    public static boolean allowedToRemoveItems(Object[] values) {
        for (Object value : values) {
            ItemWrapper item = (ItemWrapper)value;
            if (item.allowedToRemove()) continue;
            return false;
        }
        return values.length > 0;
    }

    public void removeSelectedItems(Project project) {
        if (this.myChooserComponent instanceof JList) {
            Object[] values;
            JList list = (JList)this.myChooserComponent;
            int index = list.getSelectedIndex();
            if (index == -1 || index >= list.getModel().getSize()) {
                return;
            }
            for (Object value : values = list.getSelectedValues()) {
                DefaultListModel model;
                ItemWrapper item = (ItemWrapper)value;
                DefaultListModel defaultListModel = model = list.getModel() instanceof DefaultListModel ? (DefaultListModel)list.getModel() : (DefaultListModel)((FilteringListModel)list.getModel()).getOriginalModel();
                if (!item.allowedToRemove()) continue;
                model.removeElement(item);
                if (model.getSize() > 0) {
                    if (model.getSize() == index) {
                        list.setSelectedIndex(model.getSize() - 1);
                    } else if (model.getSize() > index) {
                        list.setSelectedIndex(index);
                    }
                } else {
                    list.clearSelection();
                }
                item.removed(project);
            }
        } else {
            this.myDelegate.removeSelectedItemsInTree();
        }
    }

    public MasterDetailPopupBuilder setActionsGroup(@Nullable ActionGroup actions) {
        this.myActions = actions;
        return this;
    }

    public MasterDetailPopupBuilder setList(JBList list) {
        this.setChooser((JComponent)list);
        this.myDetailController.setList(list);
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                MasterDetailPopupBuilder.this.myDetailController.updateDetailView();
            }
        });
        return this;
    }

    private void setChooser(JComponent list) {
        this.myChooserComponent = list;
        list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    MasterDetailPopupBuilder.this.removeSelectedItems(MasterDetailPopupBuilder.this.myProject);
                } else if (e.getModifiersEx() == 0) {
                    MasterDetailPopupBuilder.this.myDelegate.handleMnemonic(e, MasterDetailPopupBuilder.this.myProject, MasterDetailPopupBuilder.this.myPopup);
                }
            }
        });
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                MasterDetailPopupBuilder.this.chooseItemWithEnterOrDoubleClick();
            }
        }.registerCustomShortcutSet(CommonShortcuts.ENTER, list);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                MasterDetailPopupBuilder.this.chooseItemWithEnterOrDoubleClick();
            }
        }.registerCustomShortcutSet(CommonShortcuts.DOUBLE_CLICK_1, list);
    }

    private void chooseItemWithEnterOrDoubleClick() {
        ItemWrapper[] items = this.getSelectedItems();
        if (items.length > 0) {
            this.myDelegate.itemChosen(items[0], this.myProject, this.myPopup, true);
        }
    }

    public MasterDetailPopupBuilder setDelegate(Delegate delegate) {
        this.myDelegate = delegate;
        return this;
    }

    public MasterDetailPopupBuilder setCloseOnEnter(boolean closeOnEnter) {
        this.myCloseOnEnter = closeOnEnter;
        return this;
    }

    private String getSplitterProportionKey() {
        return this.myDimensionServiceKey + ".splitter";
    }

    private class MyPopupChooserBuilder
    extends PopupChooserBuilder {
        public MyPopupChooserBuilder(JList list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/popup/util/MasterDetailPopupBuilder$MyPopupChooserBuilder", "<init>"));
            }
            super(list);
        }

        private MyPopupChooserBuilder(JTree tree) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/popup/util/MasterDetailPopupBuilder$MyPopupChooserBuilder", "<init>"));
            }
            super(tree);
        }

        protected void addCenterComponentToContentPane(JPanel contentPane, JComponent component) {
            if (MasterDetailPopupBuilder.this.myAddDetailViewToEast) {
                JBSplitter splitPane = new JBSplitter(0.3f);
                splitPane.setSplitterProportionKey(MasterDetailPopupBuilder.this.getSplitterProportionKey());
                splitPane.setFirstComponent(component);
                splitPane.setSecondComponent((JComponent)MasterDetailPopupBuilder.this.myDetailView);
                contentPane.add((Component)splitPane, "Center");
            } else {
                super.addCenterComponentToContentPane(contentPane, component);
            }
        }
    }

    public static class ListItemRenderer
    extends JPanel
    implements ListCellRenderer {
        private final Project myProject;
        private final ColoredListCellRenderer myRenderer;
        private final Delegate myDelegate;

        private ListItemRenderer(Delegate delegate, Project project) {
            super(new BorderLayout());
            this.myProject = project;
            this.setBackground(UIUtil.getListBackground());
            this.myDelegate = delegate;
            JComponent accessory = this.myDelegate.createAccessoryView(project);
            if (accessory != null) {
                this.add((Component)accessory, "West");
            }
            this.myRenderer = new ItemWrapperListRenderer(this.myProject, accessory);
            this.add((Component)this.myRenderer, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof SplitterItem) {
                String label = ((SplitterItem)value).getText();
                TitledSeparator separator = new TitledSeparator(label);
                separator.setBackground(UIUtil.getListBackground());
                separator.setForeground(UIUtil.getListForeground());
                return separator;
            }
            this.myRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.myRenderer.revalidate();
            return this;
        }
    }

    public static interface Delegate {
        @Nullable
        public String getTitle();

        public void handleMnemonic(KeyEvent var1, Project var2, JBPopup var3);

        @Nullable
        public JComponent createAccessoryView(Project var1);

        public Object[] getSelectedItemsInTree();

        public void itemChosen(ItemWrapper var1, Project var2, JBPopup var3, boolean var4);

        public void removeSelectedItemsInTree();
    }
}

