/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.ActiveAnnotationGutter;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateStackTraceAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(AnnotateStackTraceAction.class);
    private final EditorHyperlinkSupport myHyperlinks;
    private Map<Integer, LastRevision> cache;
    private int newestLine;
    private int maxDateLength;
    private final Editor myEditor;
    private boolean myGutterShowed;
    private final HashMap<VirtualFile, List<Integer>> files2lines;

    public AnnotateStackTraceAction(@NotNull Editor editor, @NotNull EditorHyperlinkSupport hyperlinks) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/unscramble/AnnotateStackTraceAction", "<init>"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/intellij/unscramble/AnnotateStackTraceAction", "<init>"));
        }
        super("Show files modification info", null, AllIcons.Actions.Annotate);
        this.newestLine = -1;
        this.maxDateLength = 0;
        this.myGutterShowed = false;
        this.files2lines = new HashMap();
        this.myHyperlinks = hyperlinks;
        this.myEditor = editor;
        this.myEditor.getColorsScheme().setColor(EditorColors.CARET_ROW_COLOR, EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.CARET_ROW_COLOR));
    }

    public void actionPerformed(AnActionEvent e) {
        this.cache = new HashMap<Integer, LastRevision>();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myEditor.getProject(), "Getting File History", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public boolean shouldStartInBackground() {
                return true;
            }

            public void onSuccess() {
            }

            private void showGutter() {
                EditorGutterAction action = new EditorGutterAction(){

                    public void doAction(int lineNum) {
                        RangeHighlighter key;
                        HyperlinkInfo info;
                        LastRevision revision = (LastRevision)AnnotateStackTraceAction.this.cache.get(lineNum);
                        List<RangeHighlighter> links = AnnotateStackTraceAction.this.myHyperlinks.findAllHyperlinksOnLine(lineNum);
                        if (!links.isEmpty() && (info = EditorHyperlinkSupport.getHyperlinkInfo(key = links.get(links.size() - 1))) instanceof FileHyperlinkInfo) {
                            VirtualFile file = ((FileHyperlinkInfo)info).getDescriptor().getFile();
                            Project project = this.getProject();
                            AbstractVcs vcs = ProjectLevelVcsManagerEx.getInstanceEx(project).getVcsFor(file);
                            if (vcs != null) {
                                VcsRevisionNumber number = revision.getNumber();
                                VcsKey vcsKey = vcs.getKeyInstanceMethod();
                                ShowAllAffectedGenericAction.showSubmittedFiles((Project)project, (VcsRevisionNumber)number, (VirtualFile)file, (VcsKey)vcsKey);
                            }
                        }
                    }

                    public Cursor getCursor(int lineNum) {
                        return Cursor.getPredefinedCursor(12);
                    }
                };
                AnnotateStackTraceAction.this.myEditor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)new ActiveAnnotationGutter(){

                    public void doAction(int lineNum) {
                    }

                    public Cursor getCursor(int lineNum) {
                        return Cursor.getDefaultCursor();
                    }

                    public String getLineText(int line, Editor editor) {
                        LastRevision revision = (LastRevision)AnnotateStackTraceAction.this.cache.get(line);
                        if (revision != null) {
                            return String.format("%" + AnnotateStackTraceAction.this.maxDateLength + "s", DateFormatUtil.formatPrettyDate((Date)revision.getDate())) + " " + revision.getAuthor();
                        }
                        return "";
                    }

                    public String getToolTip(int line, Editor editor) {
                        LastRevision revision = (LastRevision)AnnotateStackTraceAction.this.cache.get(line);
                        if (revision != null) {
                            return XmlStringUtil.wrapInHtml((CharSequence)(revision.getAuthor() + " " + DateFormatUtil.formatDateTime((Date)revision.getDate()) + "<br/>" + revision.getMessage()));
                        }
                        return null;
                    }

                    public EditorFontType getStyle(int line, Editor editor) {
                        return line == AnnotateStackTraceAction.this.newestLine ? EditorFontType.BOLD : EditorFontType.PLAIN;
                    }

                    public ColorKey getColor(int line, Editor editor) {
                        return AnnotationSource.LOCAL.getColor();
                    }

                    public Color getBgColor(int line, Editor editor) {
                        return null;
                    }

                    public List<AnAction> getPopupActions(int line, Editor editor) {
                        return Collections.emptyList();
                    }

                    public void gutterClosed() {
                        AnnotateStackTraceAction.this.myGutterShowed = false;
                    }
                }, action);
                AnnotateStackTraceAction.this.myGutterShowed = true;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/unscramble/AnnotateStackTraceAction$1", "run"));
                }
                Date newestDate = null;
                ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
                for (int line = 0; line < AnnotateStackTraceAction.this.myEditor.getDocument().getLineCount(); ++line) {
                    OpenFileDescriptor fileDescriptor;
                    RangeHighlighter key;
                    HyperlinkInfo info;
                    indicator.checkCanceled();
                    List<RangeHighlighter> links = AnnotateStackTraceAction.this.myHyperlinks.findAllHyperlinksOnLine(line);
                    if (links.size() <= 0 || !((info = EditorHyperlinkSupport.getHyperlinkInfo(key = links.get(links.size() - 1))) instanceof FileHyperlinkInfo) || (fileDescriptor = ((FileHyperlinkInfo)info).getDescriptor()) == null) continue;
                    VirtualFile file = fileDescriptor.getFile();
                    if (AnnotateStackTraceAction.this.files2lines.containsKey(file)) {
                        ((List)AnnotateStackTraceAction.this.files2lines.get(file)).add(line);
                        continue;
                    }
                    ArrayList<Integer> lines = new ArrayList<Integer>();
                    lines.add(line);
                    AnnotateStackTraceAction.this.files2lines.put(file, lines);
                    files.add(file);
                }
                for (VirtualFile file : files) {
                    int length;
                    indicator.checkCanceled();
                    LastRevision revision = this.getLastRevision(file);
                    if (revision == null) continue;
                    List lines = (List)AnnotateStackTraceAction.this.files2lines.get(file);
                    Date date = revision.getDate();
                    if (newestDate == null || date.after(newestDate)) {
                        newestDate = date;
                        AnnotateStackTraceAction.this.newestLine = (Integer)lines.get(0);
                    }
                    if ((length = DateFormatUtil.formatPrettyDate((Date)date).length()) > AnnotateStackTraceAction.this.maxDateLength) {
                        AnnotateStackTraceAction.this.maxDateLength = length;
                    }
                    for (Integer line : lines) {
                        AnnotateStackTraceAction.this.cache.put(line, revision);
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!AnnotateStackTraceAction.this.myGutterShowed) {
                                this.showGutter();
                            } else {
                                ((EditorGutterComponentEx)AnnotateStackTraceAction.this.myEditor.getGutter()).revalidateMarkup();
                            }
                        }
                    });
                }
            }

            @Nullable
            private LastRevision getLastRevision(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/unscramble/AnnotateStackTraceAction$1", "getLastRevision"));
                }
                try {
                    AbstractVcs vcs = VcsUtil.getVcsFor((Project)AnnotateStackTraceAction.this.myEditor.getProject(), (VirtualFile)file);
                    if (vcs == null) {
                        return null;
                    }
                    VcsHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
                    if (historyProvider == null) {
                        return null;
                    }
                    FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
                    if (historyProvider instanceof VcsHistoryProviderEx) {
                        VcsFileRevision revision = ((VcsHistoryProviderEx)historyProvider).getLastRevision(filePath);
                        if (revision == null) {
                            return null;
                        }
                        return LastRevision.create(revision);
                    }
                    VcsHistorySession session = historyProvider.createSessionFor(filePath);
                    if (session == null) {
                        return null;
                    }
                    List list = session.getRevisionList();
                    if (list == null || list.isEmpty()) {
                        return null;
                    }
                    return LastRevision.create((VcsFileRevision)list.get(0));
                }
                catch (VcsException ignored) {
                    LOG.warn((Throwable)ignored);
                    return null;
                }
            }
        });
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.cache == null || !this.myGutterShowed);
    }

    private static class LastRevision {
        @NotNull
        private final VcsRevisionNumber myNumber;
        @NotNull
        private final String myAuthor;
        @NotNull
        private final Date myDate;
        @NotNull
        private final String myMessage;

        public LastRevision(@NotNull VcsRevisionNumber number, @NotNull String author, @NotNull Date date, @NotNull String message) {
            if (number == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number", "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision", "<init>"));
            }
            if (author == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "author", "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision", "<init>"));
            }
            if (date == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision", "<init>"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision", "<init>"));
            }
            this.myNumber = number;
            this.myAuthor = author;
            this.myDate = date;
            this.myMessage = message;
        }

        @NotNull
        public static LastRevision create(@NotNull VcsFileRevision revision) {
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision", "create"));
            }
            VcsRevisionNumber number = revision.getRevisionNumber();
            String author = StringUtil.notNullize((String)revision.getAuthor(), (String)"Unknown");
            Date date = revision.getRevisionDate();
            String message = StringUtil.notNullize((String)revision.getCommitMessage());
            LastRevision lastRevision = new LastRevision(number, author, date, message);
            if (lastRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision", "create"));
            }
            return lastRevision;
        }

        @NotNull
        public VcsRevisionNumber getNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myNumber;
            if (vcsRevisionNumber == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision", "getNumber"));
            }
            return vcsRevisionNumber;
        }

        @NotNull
        public String getAuthor() {
            String string = this.myAuthor;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision", "getAuthor"));
            }
            return string;
        }

        @NotNull
        public Date getDate() {
            Date date = this.myDate;
            if (date == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision", "getDate"));
            }
            return date;
        }

        @NotNull
        public String getMessage() {
            String string = this.myMessage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision", "getMessage"));
            }
            return string;
        }
    }
}

