/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.CommitCountStage;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogFilterer;
import com.intellij.vcs.log.data.VcsLogHashMap;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.data.VisiblePackBuilder;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFiltererImpl
implements VcsLogFilterer {
    @NotNull
    private final SingleTaskController<Request, VisiblePack> myTaskController;
    @NotNull
    private final VisiblePackBuilder myVisiblePackBuilder;
    @NotNull
    private VcsLogFilterCollection myFilters;
    @NotNull
    private PermanentGraph.SortType mySortType;
    @NotNull
    private CommitCountStage myCommitCount;
    @Nullable
    private DataPack myDataPack;
    @NotNull
    private List<MoreCommitsRequest> myRequestsToRun;

    VcsLogFiltererImpl(final @NotNull Project project, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogHashMap hashMap, @NotNull Map<Integer, VcsCommitMetadata> topCommitsDetailsCache, @NotNull CommitDetailsGetter detailsGetter, @NotNull PermanentGraph.SortType initialSortType, @NotNull Consumer<VisiblePack> visiblePackConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "<init>"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "<init>"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "<init>"));
        }
        if (topCommitsDetailsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topCommitsDetailsCache", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "<init>"));
        }
        if (detailsGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsGetter", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "<init>"));
        }
        if (initialSortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSortType", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "<init>"));
        }
        if (visiblePackConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePackConsumer", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "<init>"));
        }
        this.myCommitCount = CommitCountStage.INITIAL;
        this.myRequestsToRun = ContainerUtil.newArrayList();
        this.myVisiblePackBuilder = new VisiblePackBuilder(providers, hashMap, topCommitsDetailsCache, detailsGetter);
        this.myFilters = new VcsLogFilterCollectionImpl(null, null, null, null, null, null, null);
        this.mySortType = initialSortType;
        this.myTaskController = new SingleTaskController<Request, VisiblePack>(visiblePackConsumer){

            @Override
            protected void startNewBackgroundTask() {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProgressManagerImpl.runProcessWithProgressAsynchronously(new MyTask(project, "Applying filters..."));
                    }
                });
            }
        };
    }

    @Override
    public void onRefresh(@NotNull DataPack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "onRefresh"));
        }
        this.myTaskController.request(new RefreshRequest(dataPack));
    }

    @Override
    public void onFiltersChange(@NotNull VcsLogFilterCollection newFilters) {
        if (newFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFilters", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "onFiltersChange"));
        }
        this.myTaskController.request(new FilterRequest(newFilters));
    }

    @Override
    public void onSortTypeChange(@NotNull PermanentGraph.SortType sortType) {
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "onSortTypeChange"));
        }
        this.myTaskController.request(new SortTypeRequest(sortType));
    }

    @Override
    public void moreCommitsNeeded(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoaded", "com/intellij/vcs/log/data/VcsLogFiltererImpl", "moreCommitsNeeded"));
        }
        this.myTaskController.request(new MoreCommitsRequest(onLoaded));
    }

    private static final class MoreCommitsRequest
    implements Request {
        @NotNull
        private final Runnable onLoaded;

        MoreCommitsRequest(@NotNull Runnable onLoaded) {
            if (onLoaded == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoaded", "com/intellij/vcs/log/data/VcsLogFiltererImpl$MoreCommitsRequest", "<init>"));
            }
            this.onLoaded = onLoaded;
        }
    }

    private static final class SortTypeRequest
    implements Request {
        private final PermanentGraph.SortType sortType;

        SortTypeRequest(PermanentGraph.SortType sortType) {
            this.sortType = sortType;
        }
    }

    private static final class FilterRequest
    implements Request {
        private final VcsLogFilterCollection filters;

        FilterRequest(VcsLogFilterCollection filters) {
            this.filters = filters;
        }
    }

    private static final class RefreshRequest
    implements Request {
        private final DataPack dataPack;

        RefreshRequest(DataPack dataPack) {
            this.dataPack = dataPack;
        }
    }

    private static interface Request {
    }

    private class MyTask
    extends Task.Backgroundable {
        public MyTask(@NotNull Project project, String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/vcs/log/data/VcsLogFiltererImpl$MyTask", "<init>"));
            }
            super(project, title);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            List requests;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/VcsLogFiltererImpl$MyTask", "run"));
            }
            VisiblePack visiblePack = null;
            while (!(requests = VcsLogFiltererImpl.this.myTaskController.popRequests()).isEmpty()) {
                RefreshRequest refreshRequest = (RefreshRequest)ContainerUtil.findLastInstance(requests, RefreshRequest.class);
                FilterRequest filterRequest = (FilterRequest)ContainerUtil.findLastInstance(requests, FilterRequest.class);
                SortTypeRequest sortTypeRequest = (SortTypeRequest)ContainerUtil.findLastInstance(requests, SortTypeRequest.class);
                List moreCommitsRequests = ContainerUtil.findAll(requests, MoreCommitsRequest.class);
                VcsLogFiltererImpl.this.myRequestsToRun.addAll(moreCommitsRequests);
                if (refreshRequest != null) {
                    VcsLogFiltererImpl.this.myDataPack = refreshRequest.dataPack;
                }
                if (filterRequest != null) {
                    VcsLogFiltererImpl.this.myFilters = filterRequest.filters;
                }
                if (sortTypeRequest != null) {
                    VcsLogFiltererImpl.this.mySortType = sortTypeRequest.sortType;
                }
                if (VcsLogFiltererImpl.this.myDataPack == null) continue;
                if (filterRequest != null) {
                    VcsLogFiltererImpl.this.myCommitCount = CommitCountStage.INITIAL;
                } else if (!moreCommitsRequests.isEmpty()) {
                    VcsLogFiltererImpl.this.myCommitCount = VcsLogFiltererImpl.this.myCommitCount.next();
                }
                Pair<VisiblePack, CommitCountStage> pair = VcsLogFiltererImpl.this.myVisiblePackBuilder.build(VcsLogFiltererImpl.this.myDataPack, VcsLogFiltererImpl.this.mySortType, VcsLogFiltererImpl.this.myFilters, VcsLogFiltererImpl.this.myCommitCount);
                visiblePack = (VisiblePack)pair.first;
                VcsLogFiltererImpl.this.myCommitCount = (CommitCountStage)((Object)pair.second);
            }
            VcsLogFiltererImpl.this.myTaskController.taskCompleted(visiblePack);
            if (visiblePack != null) {
                final List requestsToRun = VcsLogFiltererImpl.this.myRequestsToRun;
                VcsLogFiltererImpl.this.myRequestsToRun = ContainerUtil.newArrayList();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (MoreCommitsRequest request : requestsToRun) {
                            request.onLoaded.run();
                        }
                    }
                });
            }
        }
    }
}

