/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XSourcePositionImpl
implements XSourcePosition {
    private final VirtualFile myFile;
    private final int myLine;
    private final int myOffset;

    private XSourcePositionImpl(@NotNull VirtualFile file, int line, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/XSourcePositionImpl", "<init>"));
        }
        this.myFile = file;
        this.myLine = line;
        this.myOffset = offset;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XSourcePositionImpl", "getFile"));
        }
        return virtualFile;
    }

    @Nullable
    public static XSourcePositionImpl createByOffset(@Nullable VirtualFile file, int offset) {
        if (file == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        int line = offset < document.getTextLength() ? document.getLineNumber(offset) : -1;
        return new XSourcePositionImpl(file, line, offset);
    }

    @Nullable
    public static XSourcePositionImpl createByElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        VirtualFile file = element.getContainingFile().getVirtualFile();
        if (file == null) {
            return null;
        }
        return XSourcePositionImpl.createByOffset(file, element.getTextOffset());
    }

    @Nullable
    public static XSourcePositionImpl create(@Nullable VirtualFile file, int line) {
        int offset;
        if (file == null) {
            return null;
        }
        if (file instanceof LightVirtualFile || file instanceof HttpVirtualFile) {
            offset = -1;
        } else {
            Document document;
            Document document2 = document = file.isValid() ? FileDocumentManager.getInstance().getDocument(file) : null;
            if (document == null) {
                return null;
            }
            if (line < 0) {
                line = 0;
            }
            offset = line < document.getLineCount() ? document.getLineStartOffset(line) : -1;
        }
        return new XSourcePositionImpl(file, line, offset);
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XSourcePositionImpl", "createNavigatable"));
        }
        OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.createOpenFileDescriptor(project, this);
        if (openFileDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XSourcePositionImpl", "createNavigatable"));
        }
        return openFileDescriptor;
    }

    @NotNull
    public static OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XSourcePositionImpl", "createOpenFileDescriptor"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/impl/XSourcePositionImpl", "createOpenFileDescriptor"));
        }
        OpenFileDescriptor openFileDescriptor = position.getOffset() != -1 ? new OpenFileDescriptor(project, position.getFile(), position.getOffset()) : new OpenFileDescriptor(project, position.getFile(), position.getLine(), 0);
        if (openFileDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XSourcePositionImpl", "createOpenFileDescriptor"));
        }
        return openFileDescriptor;
    }

    public String toString() {
        return "XSourcePositionImpl[" + this.myFile + ":" + this.myLine + "(" + this.myOffset + ")]";
    }
}

