/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointAdapter;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import com.intellij.xdebugger.impl.breakpoints.ui.XLightBreakpointPropertiesPanel;
import com.intellij.xdebugger.impl.ui.BreakpointEditor;
import com.intellij.xdebugger.impl.ui.TextViewer;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerUIUtil {
    @NonNls
    public static final String FULL_VALUE_POPUP_DIMENSION_KEY = "XDebugger.FullValuePopup";

    private DebuggerUIUtil() {
    }

    public static void enableEditorOnCheck(final JCheckBox checkbox, final JComponent textfield) {
        checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = checkbox.isSelected();
                textfield.setEnabled(selected);
            }
        });
        textfield.setEnabled(checkbox.isSelected());
    }

    public static void focusEditorOnCheck(final JCheckBox checkbox, final JComponent component) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                component.requestFocus();
            }
        };
        checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (checkbox.isSelected()) {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
    }

    public static void invokeLater(Runnable runnable) {
        ApplicationManager.getApplication().invokeLater(runnable);
    }

    public static RelativePoint calcPopupLocation(Editor editor, int line) {
        Point p = editor.logicalPositionToXY(new LogicalPosition(line + 1, 0));
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        if (!visibleArea.contains(p)) {
            p = new Point((visibleArea.x + visibleArea.width) / 2, (visibleArea.y + visibleArea.height) / 2);
        }
        return new RelativePoint((Component)editor.getContentComponent(), p);
    }

    public static void showValuePopup(@NotNull XFullValueEvaluator evaluator, @NotNull MouseEvent event, @NotNull Project project, @Nullable Editor editor) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "showValuePopup"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "showValuePopup"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "showValuePopup"));
        }
        TextViewer textArea = new TextViewer("Evaluating...", project);
        textArea.setBackground(HintUtil.INFORMATION_COLOR);
        FullValueEvaluationCallbackImpl callback = new FullValueEvaluationCallbackImpl(textArea);
        evaluator.startEvaluation((XFullValueEvaluator.XFullValueEvaluationCallback)callback);
        Dimension size = DimensionService.getInstance().getSize(FULL_VALUE_POPUP_DIMENSION_KEY, project);
        if (size == null) {
            Dimension frameSize = WindowManager.getInstance().getFrame(project).getSize();
            size = new Dimension(frameSize.width / 2, frameSize.height / 2);
        }
        textArea.setPreferredSize(size);
        JBPopup popup = DebuggerUIUtil.createValuePopup(project, (JComponent)((Object)textArea), callback);
        if (editor == null) {
            popup.show(new RelativePoint(event.getComponent(), new Point(event.getX() - size.width, event.getY() - size.height)));
        } else {
            popup.showInBestPositionFor(editor);
        }
    }

    public static JBPopup createValuePopup(Project project, JComponent component, final @Nullable FullValueEvaluationCallbackImpl callback) {
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(component, null);
        builder.setResizable(true).setMovable(true).setDimensionServiceKey(project, FULL_VALUE_POPUP_DIMENSION_KEY, false).setRequestFocus(false);
        if (callback != null) {
            builder.setCancelCallback((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    callback.setObsolete();
                    return true;
                }
            });
        }
        return builder.createPopup();
    }

    public static void showXBreakpointEditorBalloon(final Project project, final @Nullable Point point, final JComponent component, boolean showAllOptions, final XBreakpoint breakpoint) {
        final XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        final XLightBreakpointPropertiesPanel<XBreakpointBase> propertiesPanel = new XLightBreakpointPropertiesPanel<XBreakpointBase>(project, breakpointManager, (XBreakpointBase)breakpoint, showAllOptions);
        final Ref balloonRef = Ref.create(null);
        final Ref isLoading = Ref.create((Object)Boolean.FALSE);
        final Ref moreOptionsRequested = Ref.create((Object)Boolean.FALSE);
        propertiesPanel.setDelegate(new XLightBreakpointPropertiesPanel.Delegate(){

            @Override
            public void showMoreOptions() {
                if (!((Boolean)isLoading.get()).booleanValue()) {
                    propertiesPanel.saveProperties();
                }
                if (!balloonRef.isNull()) {
                    ((Balloon)balloonRef.get()).hide();
                }
                DebuggerUIUtil.showXBreakpointEditorBalloon(project, point, component, true, breakpoint);
                moreOptionsRequested.set((Object)true);
            }
        });
        isLoading.set((Object)Boolean.TRUE);
        propertiesPanel.loadProperties();
        isLoading.set((Object)Boolean.FALSE);
        if (((Boolean)moreOptionsRequested.get()).booleanValue()) {
            return;
        }
        Runnable showMoreOptions = new Runnable(){

            @Override
            public void run() {
                propertiesPanel.saveProperties();
                propertiesPanel.dispose();
                BreakpointsDialogFactory.getInstance(project).showDialog(breakpoint);
            }
        };
        final JPanel mainPanel = propertiesPanel.getMainPanel();
        final Balloon balloon = DebuggerUIUtil.showBreakpointEditor(project, mainPanel, point, component, showMoreOptions, breakpoint);
        balloonRef.set((Object)balloon);
        XBreakpointAdapter breakpointListener = new XBreakpointAdapter<XBreakpoint<?>>(){

            public void breakpointRemoved(@NotNull XBreakpoint<?> removedBreakpoint) {
                if (removedBreakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removedBreakpoint", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$7", "breakpointRemoved"));
                }
                if (removedBreakpoint.equals((Object)breakpoint)) {
                    balloon.hide();
                }
            }
        };
        balloon.addListener((JBPopupListener)new JBPopupListener.Adapter((XBreakpointListener)breakpointListener){
            final /* synthetic */ XBreakpointListener val$breakpointListener;
            {
                this.val$breakpointListener = xBreakpointListener;
            }

            public void onClosed(LightweightWindowEvent event) {
                propertiesPanel.saveProperties();
                propertiesPanel.dispose();
                breakpointManager.removeBreakpointListener(this.val$breakpointListener);
            }
        });
        breakpointManager.addBreakpointListener((XBreakpointListener)breakpointListener);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeFocusManager.findInstance().requestFocus((Component)mainPanel, true);
            }
        });
    }

    public static Balloon showBreakpointEditor(Project project, JComponent mainPanel, Point whereToShow, JComponent component, final @Nullable Runnable showMoreOptions, Object breakpoint) {
        BreakpointEditor editor = new BreakpointEditor();
        editor.setPropertiesPanel(mainPanel);
        editor.setShowMoreOptionsLink(true);
        JPanel panel = editor.getMainPanel();
        final Balloon balloon = JBPopupFactory.getInstance().createDialogBalloonBuilder((JComponent)panel, null).setHideOnClickOutside(true).setCloseButtonEnabled(false).setAnimationCycle(0).setBlockClicksThroughBalloon(true).createBalloon();
        editor.setDelegate(new BreakpointEditor.Delegate(){

            @Override
            public void done() {
                balloon.hide();
            }

            @Override
            public void more() {
                assert (showMoreOptions != null);
                balloon.hide();
                showMoreOptions.run();
            }
        });
        if (whereToShow == null) {
            balloon.showInCenterOf(component);
        } else {
            Window window = SwingUtilities.windowForComponent(component);
            RelativePoint p = new RelativePoint((Component)component, whereToShow);
            if (window != null) {
                RelativePoint point = new RelativePoint((Component)window, new Point(0, 0));
                if (p.getScreenPoint().getX() - point.getScreenPoint().getX() < 40.0) {
                    p.getPoint().x += 40;
                }
            }
            balloon.show(p, Balloon.Position.below);
        }
        BreakpointsDialogFactory.getInstance(project).setBalloonToHide(balloon, breakpoint);
        return balloon;
    }

    @NotNull
    public static EditorColorsScheme getColorScheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "getColorScheme"));
        }
        return editorColorsScheme;
    }

    @NotNull
    public static EditorColorsScheme getColorScheme(@Nullable JComponent component) {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getColorSchemeForComponent((JComponent)component);
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil", "getColorScheme"));
        }
        return editorColorsScheme;
    }

    private static class FullValueEvaluationCallbackImpl
    implements XFullValueEvaluator.XFullValueEvaluationCallback {
        private final AtomicBoolean myObsolete = new AtomicBoolean(false);
        private final EditorTextField myTextArea;

        public FullValueEvaluationCallbackImpl(EditorTextField textArea) {
            this.myTextArea = textArea;
        }

        public void evaluated(@NotNull String fullValue) {
            if (fullValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValue", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$FullValueEvaluationCallbackImpl", "evaluated"));
            }
            this.evaluated(fullValue, null);
        }

        public void evaluated(final @NotNull String fullValue, final @Nullable Font font) {
            if (fullValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValue", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$FullValueEvaluationCallbackImpl", "evaluated"));
            }
            AppUIUtil.invokeOnEdt(new Runnable(){

                @Override
                public void run() {
                    FullValueEvaluationCallbackImpl.this.myTextArea.setText(fullValue);
                    if (font != null) {
                        FullValueEvaluationCallbackImpl.this.myTextArea.setFont(font);
                    }
                }
            });
        }

        public void errorOccurred(final @NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$FullValueEvaluationCallbackImpl", "errorOccurred"));
            }
            AppUIUtil.invokeOnEdt(new Runnable(){

                @Override
                public void run() {
                    FullValueEvaluationCallbackImpl.this.myTextArea.setForeground(XDebuggerUIConstants.ERROR_MESSAGE_ATTRIBUTES.getFgColor());
                    FullValueEvaluationCallbackImpl.this.myTextArea.setText(errorMessage);
                }
            });
        }

        private void setObsolete() {
            this.myObsolete.set(true);
        }

        public boolean isObsolete() {
            return this.myObsolete.get();
        }
    }
}

