/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.breadcrumbs.BreadcrumbsComponent;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import com.intellij.xml.breadcrumbs.BreadcrumbsItemListener;
import com.intellij.xml.breadcrumbs.BreadcrumbsPresentationProvider;
import com.intellij.xml.breadcrumbs.BreadcrumbsPsiItem;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreadcrumbsXmlWrapper
implements BreadcrumbsItemListener<BreadcrumbsPsiItem>,
Disposable {
    private final BreadcrumbsComponent<BreadcrumbsPsiItem> myComponent;
    private final Project myProject;
    private Editor myEditor;
    private Collection<RangeHighlighter> myHighlighed;
    private final VirtualFile myFile;
    private boolean myUserCaretChange;
    private final MergingUpdateQueue myQueue;
    private final BreadcrumbsInfoProvider myInfoProvider;
    private final JPanel myWrapperPanel;
    public static final Key<BreadcrumbsXmlWrapper> BREADCRUMBS_COMPONENT_KEY = new Key("BREADCRUMBS_KEY");

    public BreadcrumbsXmlWrapper(final @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "<init>"));
        }
        this.myEditor = editor;
        this.myEditor.putUserData(BREADCRUMBS_COMPONENT_KEY, (Object)this);
        Project project = editor.getProject();
        assert (project != null);
        this.myProject = project;
        Document document = this.myEditor.getDocument();
        this.myFile = FileDocumentManager.getInstance().getFile(document);
        FileStatusManager manager = FileStatusManager.getInstance((Project)project);
        manager.addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                BreadcrumbsXmlWrapper.this.updateCrumbs();
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$1", "fileStatusChanged"));
                }
            }
        }, (Disposable)this);
        UISettings.getInstance().addUISettingsListener(new UISettingsListener(){

            public void uiSettingsChanged(UISettings source) {
                BreadcrumbsXmlWrapper.this.updateCrumbs();
            }
        }, (Disposable)this);
        this.myInfoProvider = BreadcrumbsXmlWrapper.findInfoProvider(BreadcrumbsXmlWrapper.findViewProvider(this.myFile, this.myProject));
        CaretAdapter caretListener = new CaretAdapter(){

            public void caretPositionChanged(CaretEvent e) {
                if (BreadcrumbsXmlWrapper.this.myUserCaretChange) {
                    BreadcrumbsXmlWrapper.this.queueUpdate(editor);
                }
                BreadcrumbsXmlWrapper.this.myUserCaretChange = true;
            }
        };
        editor.getCaretModel().addCaretListener((CaretListener)caretListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable((CaretListener)caretListener){
            final /* synthetic */ CaretListener val$caretListener;
            {
                this.val$caretListener = caretListener;
            }

            public void dispose() {
                editor.getCaretModel().removeCaretListener(this.val$caretListener);
            }
        });
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                VirtualFile file;
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$5", "propertyChanged"));
                }
                PsiFile psiFile = event.getFile();
                VirtualFile virtualFile = file = psiFile == null ? null : psiFile.getVirtualFile();
                if (!Comparing.equal((Object)file, (Object)BreadcrumbsXmlWrapper.this.myFile)) {
                    return;
                }
                BreadcrumbsXmlWrapper.this.queueUpdate(editor);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$5", "childrenChanged"));
                }
                this.propertyChanged(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$5", "childMoved"));
                }
                this.propertyChanged(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$5", "childReplaced"));
                }
                this.propertyChanged(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$5", "childRemoved"));
                }
                this.propertyChanged(event);
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$5", "childAdded"));
                }
                this.propertyChanged(event);
            }
        }, (Disposable)this);
        this.myComponent = new BreadcrumbsComponent();
        this.myComponent.addBreadcrumbsItemListener((BreadcrumbsItemListener)this);
        Font editorFont = editor.getColorsScheme().getFont(EditorFontType.PLAIN);
        this.myComponent.setFont(editorFont.deriveFont(0, editorFont.getSize2D()));
        final ComponentAdapter resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BreadcrumbsXmlWrapper.this.queueUpdate(editor);
            }
        };
        this.myComponent.addComponentListener((ComponentListener)resizeListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                BreadcrumbsXmlWrapper.this.myComponent.removeComponentListener((ComponentListener)resizeListener);
            }
        });
        this.myQueue = new MergingUpdateQueue("Breadcrumbs.Queue", 200, true, this.myComponent);
        this.myQueue.queue((Update)new MyUpdate(this, editor));
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector(this.myComponent, (Activatable)this.myQueue));
        Disposer.register((Disposable)this, (Disposable)this.myQueue);
        this.myWrapperPanel = new JPanel();
        this.myWrapperPanel.setLayout(new BorderLayout());
        this.myWrapperPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
        this.myWrapperPanel.setOpaque(false);
        this.myWrapperPanel.add((Component)this.myComponent, "Center");
    }

    private void updateCrumbs() {
        if (this.myComponent != null && this.myEditor != null) {
            Font editorFont = this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN);
            this.myComponent.setFont(editorFont.deriveFont(0, editorFont.getSize2D()));
            this.updateCrumbs(this.myEditor.getCaretModel().getLogicalPosition());
        }
    }

    public void queueUpdate(Editor editor) {
        this.myQueue.cancelAllUpdates();
        this.myQueue.queue((Update)new MyUpdate(this, editor));
    }

    private void moveEditorCaretTo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "moveEditorCaretTo"));
        }
        if (element.isValid()) {
            this.setUserCaretChange(false);
            this.myEditor.getCaretModel().moveToOffset(element.getTextOffset());
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    @Nullable
    private static BreadcrumbsInfoProvider findProviderForElement(@NotNull PsiElement element, BreadcrumbsInfoProvider defaultProvider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "findProviderForElement"));
        }
        BreadcrumbsInfoProvider provider = BreadcrumbsXmlWrapper.getInfoProvider(element.getLanguage());
        return provider == null ? defaultProvider : provider;
    }

    private static PsiElement[] toPsiElementArray(Collection<BreadcrumbsPsiItem> items) {
        PsiElement[] elements = new PsiElement[items.size()];
        int index = 0;
        for (BreadcrumbsPsiItem item : items) {
            elements[index++] = item.getPsiElement();
        }
        return elements;
    }

    @Nullable
    private static CrumbPresentation[] getCrumbPresentations(PsiElement[] elements) {
        for (BreadcrumbsPresentationProvider provider : (BreadcrumbsPresentationProvider[])BreadcrumbsPresentationProvider.EP_NAME.getExtensions()) {
            CrumbPresentation[] presentations = provider.getCrumbPresentations(elements);
            if (presentations == null) continue;
            return presentations;
        }
        return null;
    }

    private void setUserCaretChange(boolean userCaretChange) {
        this.myUserCaretChange = userCaretChange;
    }

    @Nullable
    private static LinkedList<BreadcrumbsPsiItem> getPresentableLineElements(@NotNull LogicalPosition position, VirtualFile file, Editor editor, Project project, BreadcrumbsInfoProvider defaultInfoProvider) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "getPresentableLineElements"));
        }
        LinkedList<BreadcrumbsPsiItem> result = BreadcrumbsXmlWrapper.getLineElements(editor.logicalPositionToOffset(position), file, project, defaultInfoProvider);
        if (result == null) {
            return null;
        }
        PsiElement[] elements = BreadcrumbsXmlWrapper.toPsiElementArray(result);
        CrumbPresentation[] presentations = BreadcrumbsXmlWrapper.getCrumbPresentations(elements);
        if (presentations != null) {
            int i = 0;
            for (BreadcrumbsPsiItem item : result) {
                item.setPresentation(presentations[i++]);
            }
        }
        return result;
    }

    @Nullable
    public static PsiElement[] getLinePsiElements(int offset, VirtualFile file, Project project, BreadcrumbsInfoProvider infoProvider) {
        LinkedList<BreadcrumbsPsiItem> lineElements = BreadcrumbsXmlWrapper.getLineElements(offset, file, project, infoProvider);
        return lineElements != null ? BreadcrumbsXmlWrapper.toPsiElementArray(lineElements) : null;
    }

    @Nullable
    private static LinkedList<BreadcrumbsPsiItem> getLineElements(int offset, VirtualFile file, Project project, BreadcrumbsInfoProvider defaultInfoProvider) {
        PsiElement element = BreadcrumbsXmlWrapper.findFirstBreadcrumbedElement(offset, file, project, defaultInfoProvider);
        if (element == null) {
            return null;
        }
        LinkedList<BreadcrumbsPsiItem> result = new LinkedList<BreadcrumbsPsiItem>();
        while (element != null) {
            BreadcrumbsInfoProvider provider = BreadcrumbsXmlWrapper.findProviderForElement(element, defaultInfoProvider);
            if (provider != null && provider.acceptElement(element)) {
                result.addFirst(new BreadcrumbsPsiItem(element, provider));
            }
            element = provider != null ? provider.getParent(element) : element.getParent();
        }
        return result;
    }

    @Nullable
    private static PsiElement findFirstBreadcrumbedElement(int offset, VirtualFile file, Project project, BreadcrumbsInfoProvider defaultInfoProvider) {
        if (file == null || !file.isValid()) {
            return null;
        }
        PriorityQueue<PsiElement> leafs = new PriorityQueue<PsiElement>(3, new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                return o2.getTextRange().getStartOffset() - o1.getTextRange().getStartOffset();
            }
        });
        FileViewProvider viewProvider = BreadcrumbsXmlWrapper.findViewProvider(file, project);
        if (viewProvider == null) {
            return null;
        }
        for (Language language : viewProvider.getLanguages()) {
            ContainerUtil.addIfNotNull((Object)viewProvider.findElementAt(offset, language), leafs);
        }
        while (!leafs.isEmpty()) {
            PsiElement element = (PsiElement)leafs.remove();
            if (!element.isValid()) continue;
            BreadcrumbsInfoProvider provider = BreadcrumbsXmlWrapper.findProviderForElement(element, defaultInfoProvider);
            if (provider != null && provider.acceptElement(element)) {
                return element;
            }
            if (element instanceof PsiFile) continue;
            ContainerUtil.addIfNotNull((Object)element.getParent(), leafs);
        }
        return null;
    }

    @Nullable
    private static FileViewProvider findViewProvider(VirtualFile file, Project project) {
        if (file == null) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findViewProvider(file);
    }

    private void updateCrumbs(LogicalPosition position) {
        if (this.myFile != null && this.myEditor != null) {
            if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
                return;
            }
            this.myComponent.setItems(BreadcrumbsXmlWrapper.getPresentableLineElements(position, this.myFile, this.myEditor, this.myProject, this.myInfoProvider));
        }
    }

    @Nullable
    public static BreadcrumbsInfoProvider findInfoProvider(@Nullable FileViewProvider viewProvider) {
        BreadcrumbsInfoProvider provider;
        block4: {
            provider = null;
            if (viewProvider == null) break block4;
            WebEditorOptions webEditorOptions = WebEditorOptions.getInstance();
            Language baseLang = viewProvider.getBaseLanguage();
            provider = BreadcrumbsXmlWrapper.getInfoProvider(baseLang);
            if (!webEditorOptions.isBreadcrumbsEnabledInXml() && baseLang == XMLLanguage.INSTANCE) {
                return null;
            }
            if (!webEditorOptions.isBreadcrumbsEnabled() && baseLang != XMLLanguage.INSTANCE) {
                return null;
            }
            if (provider == null) {
                Language language;
                Iterator i$ = viewProvider.getLanguages().iterator();
                while (i$.hasNext() && (provider = BreadcrumbsXmlWrapper.getInfoProvider(language = (Language)i$.next())) == null) {
                }
            }
        }
        return provider;
    }

    public JComponent getComponent() {
        return this.myWrapperPanel;
    }

    public void itemSelected(@NotNull BreadcrumbsPsiItem item, int modifiers) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "itemSelected"));
        }
        PsiElement psiElement = item.getPsiElement();
        this.moveEditorCaretTo(psiElement);
        if (BitUtil.isSet((int)modifiers, (int)1) || BitUtil.isSet((int)modifiers, (int)4)) {
            TextRange range = psiElement.getTextRange();
            this.myEditor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    public void itemHovered(@Nullable BreadcrumbsPsiItem item) {
        if (this.myHighlighed != null) {
            for (RangeHighlighter highlighter : this.myHighlighed) {
                HighlightManager.getInstance((Project)this.myProject).removeSegmentHighlighter(this.myEditor, highlighter);
            }
            this.myHighlighed = null;
        }
        if (item != null) {
            TextRange range = item.getPsiElement().getTextRange();
            TextAttributes attributes = new TextAttributes();
            CrumbPresentation p = item.getPresentation();
            Color color = p != null ? p.getBackgroundColor(false, false, false) : BreadcrumbsComponent.ButtonSettings.DEFAULT_BG_COLOR;
            Color background = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.CARET_ROW_COLOR);
            attributes.setBackgroundColor(XmlTagTreeHighlightingUtil.makeTransparent(color, background, 0.3));
            this.myHighlighed = new ArrayList<RangeHighlighter>(1);
            HighlightManager.getInstance((Project)this.myProject).addRangeHighlight(this.myEditor, range.getStartOffset(), range.getEndOffset(), attributes, true, true, this.myHighlighed);
        }
    }

    @Nullable
    public static BreadcrumbsXmlWrapper getBreadcrumbsComponent(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "getBreadcrumbsComponent"));
        }
        return (BreadcrumbsXmlWrapper)editor.getUserData(BREADCRUMBS_COMPONENT_KEY);
    }

    public void dispose() {
        this.myEditor.putUserData(BREADCRUMBS_COMPONENT_KEY, null);
        this.myEditor = null;
    }

    @Nullable
    private static BreadcrumbsInfoProvider getInfoProvider(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper", "getInfoProvider"));
        }
        for (BreadcrumbsInfoProvider provider : (BreadcrumbsInfoProvider[])Extensions.getExtensions((ExtensionPointName)BreadcrumbsInfoProvider.EP_NAME)) {
            for (Language language1 : provider.getLanguages()) {
                if (!language.isKindOf(language1)) continue;
                return provider;
            }
        }
        return null;
    }

    private class MyUpdate
    extends Update {
        private final BreadcrumbsXmlWrapper myBreadcrumbsComponent;
        private final Editor myEditor;

        public MyUpdate(@NotNull BreadcrumbsXmlWrapper c, Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$MyUpdate", "<init>"));
            }
            super((Object)c);
            this.myBreadcrumbsComponent = c;
            this.myEditor = editor;
        }

        public void run() {
            this.myBreadcrumbsComponent.updateCrumbs(this.myEditor.getCaretModel().getLogicalPosition());
        }

        public boolean canEat(Update update) {
            return true;
        }
    }
}

