/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.google.common.base.CharMatcher;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.rpc.CommandProcessor;

public final class NameMapper {
    public static final String S1 = ",()[]{}=";
    private static final CharMatcher NAME_TRIMMER = CharMatcher.INVISIBLE.or(CharMatcher.anyOf((CharSequence)",()[]{}=.&:"));
    private static final CharMatcher OPERATOR_TRIMMER = CharMatcher.INVISIBLE.or(CharMatcher.anyOf((CharSequence)",()[]{}="));
    private final Document document;
    private final Document generatedDocument;
    private final MappingList sourceMappings;
    private final SourceMap sourceMap;
    private Map<String, String> rawNameToSource;

    NameMapper(@NotNull Document document, @NotNull Document generatedDocument, @NotNull MappingList sourceMappings, @NotNull SourceMap sourceMap) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/javascript/debugger/NameMapper", "<init>"));
        }
        if (generatedDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatedDocument", "com/jetbrains/javascript/debugger/NameMapper", "<init>"));
        }
        if (sourceMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMappings", "com/jetbrains/javascript/debugger/NameMapper", "<init>"));
        }
        if (sourceMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMap", "com/jetbrains/javascript/debugger/NameMapper", "<init>"));
        }
        this.document = document;
        this.generatedDocument = generatedDocument;
        this.sourceMappings = sourceMappings;
        this.sourceMap = sourceMap;
    }

    @Nullable
    public Map<String, String> getRawNameToSource() {
        return this.rawNameToSource;
    }

    @Nullable
    public String map(@NotNull PsiElement identifierOrNamedElement) {
        if (identifierOrNamedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifierOrNamedElement", "com/jetbrains/javascript/debugger/NameMapper", "map"));
        }
        int offset = identifierOrNamedElement.getTextOffset();
        int line = this.document.getLineNumber(offset);
        int sourceEntryIndex = this.sourceMappings.indexOf(line, offset - this.document.getLineStartOffset(line));
        if (sourceEntryIndex == -1) {
            return null;
        }
        MappingEntry sourceEntry = this.sourceMappings.get(sourceEntryIndex);
        MappingEntry next = this.sourceMappings.getNextOnTheSameLine(sourceEntryIndex, false);
        if (next != null && this.sourceMappings.getColumn(next) == this.sourceMappings.getColumn(sourceEntry)) {
            NameMapper.warnSeveralMapping(identifierOrNamedElement);
            return null;
        }
        String sourceEntryName = sourceEntry.getName();
        String generatedName = NameMapper.trimName(NameMapper.getGeneratedName(this.generatedDocument, this.sourceMap, sourceEntry), true);
        if (!generatedName.isEmpty()) {
            String sourceName = sourceEntryName;
            if (sourceName == null) {
                String string = sourceName = identifierOrNamedElement instanceof PsiNamedElement ? ((PsiNamedElement)identifierOrNamedElement).getName() : identifierOrNamedElement.getText();
                if (sourceName == null) {
                    return null;
                }
            }
            if (this.rawNameToSource == null) {
                this.rawNameToSource = new THashMap();
            }
            this.rawNameToSource.put(generatedName, sourceName);
            return generatedName;
        }
        return null;
    }

    public static void warnSeveralMapping(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/javascript/debugger/NameMapper", "warnSeveralMapping"));
        }
        CommandProcessor.LOG.warn("incorrect sourcemap, several mappings for named element " + element);
    }

    @NotNull
    public static String trimName(@NotNull CharSequence rawGeneratedName, boolean isLastToken) {
        if (rawGeneratedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawGeneratedName", "com/jetbrains/javascript/debugger/NameMapper", "trimName"));
        }
        String generatedName = (isLastToken ? NAME_TRIMMER : OPERATOR_TRIMMER).trimFrom(rawGeneratedName);
        int i = generatedName.indexOf(61);
        String string = i > 0 ? NAME_TRIMMER.trimFrom((CharSequence)generatedName.substring(0, i)) : generatedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/NameMapper", "trimName"));
        }
        return string;
    }

    @NotNull
    private static CharSequence getGeneratedName(@NotNull Document document, @NotNull SourceMap sourceMap, @NotNull MappingEntry sourceEntry) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/javascript/debugger/NameMapper", "getGeneratedName"));
        }
        if (sourceMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMap", "com/jetbrains/javascript/debugger/NameMapper", "getGeneratedName"));
        }
        if (sourceEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceEntry", "com/jetbrains/javascript/debugger/NameMapper", "getGeneratedName"));
        }
        int lineStartOffset = document.getLineStartOffset(sourceEntry.getGeneratedLine());
        MappingEntry nextGeneratedMapping = sourceMap.getMappings().getNextOnTheSameLine(sourceEntry);
        int endOffset = nextGeneratedMapping == null ? document.getLineEndOffset(sourceEntry.getGeneratedLine()) : lineStartOffset + nextGeneratedMapping.getGeneratedColumn();
        CharSequence charSequence = document.getImmutableCharSequence().subSequence(lineStartOffset + sourceEntry.getGeneratedColumn(), endOffset);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/NameMapper", "getGeneratedName"));
        }
        return charSequence;
    }
}

