/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import com.intellij.openapi.util.ActionCallback;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.ConsumerRunnable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Vm;

public abstract class ValueManager<VM extends Vm> {
    private final AtomicInteger cacheStamp = new AtomicInteger();
    private volatile boolean obsolete;
    protected final VM vm;

    protected ValueManager(VM vm) {
        this.vm = vm;
    }

    public void clearCaches() {
        this.cacheStamp.incrementAndGet();
    }

    @NotNull
    public ConsumerRunnable getClearCachesTask() {
        ConsumerRunnable consumerRunnable = new ConsumerRunnable(){

            @Override
            public void run() {
                ValueManager.this.clearCaches();
            }
        };
        if (consumerRunnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ValueManager", "getClearCachesTask"));
        }
        return consumerRunnable;
    }

    public final int getCacheStamp() {
        return this.cacheStamp.get();
    }

    public final boolean isObsolete() {
        return this.obsolete;
    }

    public final void markObsolete() {
        this.obsolete = true;
    }

    public final boolean rejectIfObsolete(@NotNull ActionCallback result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/debugger/values/ValueManager", "rejectIfObsolete"));
        }
        if (this.isObsolete()) {
            result.reject("Obsolete context");
            return true;
        }
        return false;
    }

    @NotNull
    public static <T> Promise<T> reject() {
        Promise promise = Promise.reject("Obsolete context");
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ValueManager", "reject"));
        }
        return promise;
    }

    @NotNull
    public VM getVm() {
        VM VM = this.vm;
        if (VM == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ValueManager", "getVm"));
        }
        return VM;
    }
}

