/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ExceptionUtil;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

public abstract class RestService
extends HttpRequestHandler {
    protected static final Logger LOG = Logger.getInstance(RestService.class);

    public final boolean isSupported(@NotNull FullHttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "isSupported"));
        }
        if (!this.isMethodSupported(request.method())) {
            return false;
        }
        String prefix = "rest";
        String uri = request.uri();
        String serviceName = this.getServiceName();
        int minLength = 1 + prefix.length() + 1 + serviceName.length();
        if (uri.length() >= minLength && uri.charAt(0) == '/' && uri.regionMatches(true, 1, prefix, 0, prefix.length()) && uri.regionMatches(true, 2 + prefix.length(), serviceName, 0, serviceName.length())) {
            if (uri.length() == minLength) {
                return true;
            }
            char c = uri.charAt(minLength + 1);
            return c == '/' || c == '?';
        }
        return false;
    }

    protected abstract boolean isMethodSupported(@NotNull HttpMethod var1);

    @NotNull
    protected abstract String getServiceName();

    public final boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/RestService", "process"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "process"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/RestService", "process"));
        }
        try {
            String error = this.execute(urlDecoder, request, context);
            if (error == null) {
                Responses.send((HttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK), context.channel(), (HttpRequest)request);
            } else {
                Responses.sendStatus(HttpResponseStatus.BAD_REQUEST, context.channel(), error, (HttpRequest)request);
            }
        }
        catch (Throwable e) {
            HttpResponseStatus status;
            if (e instanceof MalformedJsonException || e instanceof IllegalStateException && e.getMessage().startsWith("Expected a ")) {
                LOG.warn(e);
                status = HttpResponseStatus.BAD_REQUEST;
            } else {
                LOG.error(e);
                status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            }
            Responses.sendStatus(status, context.channel(), ExceptionUtil.getThrowableText((Throwable)e), (HttpRequest)request);
        }
        return true;
    }

    @Nullable(value="error text or null if successful")
    public abstract String execute(@NotNull QueryStringDecoder var1, @NotNull FullHttpRequest var2, @NotNull ChannelHandlerContext var3) throws IOException;

    @NotNull
    protected static JsonReader createJsonReader(@NotNull FullHttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "createJsonReader"));
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new ByteBufInputStream(request.content()), CharsetToolkit.UTF8_CHARSET));
        reader.setLenient(true);
        JsonReader jsonReader = reader;
        if (jsonReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/RestService", "createJsonReader"));
        }
        return jsonReader;
    }

    @Nullable
    protected static Project guessProject() {
        Project project;
        IdeFrame lastFocusedFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project project2 = project = lastFocusedFrame == null ? null : lastFocusedFrame.getProject();
        if (project == null) {
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            return openProjects.length > 0 ? openProjects[0] : null;
        }
        return project;
    }
}

