/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Responses {
    static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };
    private static String SERVER_HEADER_VALUE;

    public static FullHttpResponse response(HttpResponseStatus status) {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.EMPTY_BUFFER);
    }

    public static HttpResponse response(@Nullable String contentType, @Nullable ByteBuf content) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content == null ? Unpooled.EMPTY_BUFFER : content);
        if (contentType != null) {
            response.headers().add("Content-Type", (Object)contentType);
        }
        return response;
    }

    public static void addDate(HttpResponse response) {
        if (!response.headers().contains("Date")) {
            Responses.addDate(response, Calendar.getInstance().getTime());
        }
    }

    public static void addDate(HttpResponse response, Date date) {
        response.headers().set("Date", (Object)DATE_FORMAT.get().format(date));
    }

    public static void addNoCache(HttpResponse response) {
        response.headers().add("Cache-Control", (Object)"no-cache, no-store, must-revalidate, max-age=0");
        response.headers().add("Pragma", (Object)"no-cache");
    }

    @Nullable
    public static String getServerHeaderValue() {
        Application app;
        if (SERVER_HEADER_VALUE == null && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            SERVER_HEADER_VALUE = ApplicationInfoEx.getInstanceEx().getFullApplicationName();
        }
        return SERVER_HEADER_VALUE;
    }

    public static void addServer(HttpResponse response) {
        if (Responses.getServerHeaderValue() != null) {
            response.headers().add("Server", (Object)Responses.getServerHeaderValue());
        }
    }

    public static void send(@NotNull HttpResponse response, Channel channel, @Nullable HttpRequest request) {
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "org/jetbrains/io/Responses", "send"));
        }
        if (response.status() != HttpResponseStatus.NOT_MODIFIED && !HttpHeaders.isContentLengthSet((HttpMessage)response)) {
            HttpHeaders.setContentLength((HttpMessage)response, (long)(response instanceof FullHttpResponse ? (long)((FullHttpResponse)response).content().readableBytes() : 0L));
        }
        Responses.addCommonHeaders(response);
        Responses.send(response, channel, request != null && !Responses.addKeepAliveIfNeed(response, request));
    }

    public static boolean addKeepAliveIfNeed(HttpResponse response, HttpRequest request) {
        if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
            HttpHeaders.setKeepAlive((HttpMessage)response, (boolean)true);
            return true;
        }
        return false;
    }

    public static void addCommonHeaders(HttpResponse response) {
        Responses.addServer(response);
        Responses.addDate(response);
    }

    public static void send(CharSequence content, Channel channel, @Nullable HttpRequest request) {
        Responses.send(content, CharsetUtil.US_ASCII, channel, request);
    }

    public static void send(CharSequence content, Charset charset, Channel channel, @Nullable HttpRequest request) {
        Responses.send((HttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)content, (Charset)charset)), channel, request);
    }

    private static void send(@NotNull HttpResponse response, @NotNull Channel channel, boolean close) {
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "org/jetbrains/io/Responses", "send"));
        }
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/Responses", "send"));
        }
        if (!channel.isActive()) {
            return;
        }
        ChannelFuture future = channel.write((Object)response);
        if (!(response instanceof FullHttpResponse)) {
            channel.write((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        channel.flush();
        if (close) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public static void sendStatus(HttpResponseStatus responseStatus, Channel channel) {
        Responses.sendStatus(responseStatus, channel, null);
    }

    public static void sendStatus(HttpResponseStatus responseStatus, Channel channel, @Nullable HttpRequest request) {
        Responses.sendStatus(responseStatus, channel, null, request);
    }

    public static void sendStatus(@NotNull HttpResponseStatus responseStatus, Channel channel, @Nullable String description, @Nullable HttpRequest request) {
        if (responseStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "responseStatus", "org/jetbrains/io/Responses", "sendStatus"));
        }
        Responses.send(Responses.createStatusResponse(responseStatus, request, description), channel, request);
    }

    private static HttpResponse createStatusResponse(HttpResponseStatus responseStatus, @Nullable HttpRequest request, @Nullable String description) {
        if (request != null && request.method() == HttpMethod.HEAD) {
            return Responses.response(responseStatus);
        }
        StringBuilder builder = new StringBuilder();
        String message = responseStatus.toString();
        builder.append("<!doctype html><title>").append(message).append("</title>").append("<h1 style=\"text-align: center\">").append(message).append("</h1>");
        if (description != null) {
            builder.append("<p>").append(description).append("</p>");
        }
        builder.append("<hr/><p style=\"text-align: center\">").append(StringUtil.notNullize((String)Responses.getServerHeaderValue(), (String)"")).append("</p>");
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.copiedBuffer((CharSequence)builder, (Charset)CharsetUtil.UTF_8));
        response.headers().set("Content-Type", (Object)"text/html");
        return response;
    }
}

