/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.jetbrains.io.jsonRpc.JsonRpcServer;
import org.jetbrains.io.webSocket.Client;
import org.jetbrains.io.webSocket.ExceptionHandler;
import org.jetbrains.io.webSocket.WebSocketServer;

public class IdeaAwareJsonRpcServer
extends JsonRpcServer {
    private final QueueProcessor<ByteBuf> messageQueueProcessor = new QueueProcessor((Consumer)new Consumer<ByteBuf>(){

        public void consume(ByteBuf message) {
            IdeaAwareJsonRpcServer.super.doSend(-1, null, message);
        }
    });

    public IdeaAwareJsonRpcServer(WebSocketServer webSocketServer, ExceptionHandler exceptionHandler) {
        super(webSocketServer, exceptionHandler);
    }

    @Override
    protected <T> void doSend(int messageId, List<AsyncResult<Pair<Client, T>>> results, ByteBuf message) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            LOG.assertTrue(messageId == -1 && results == null);
            this.messageQueueProcessor.add((Object)message);
        } else {
            super.doSend(messageId, results, message);
        }
    }
}

