/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import java.nio.channels.ClosedChannelException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.webSocket.Client;

class WebSocketClient
extends Client {
    private final WebSocketServerHandshaker handshaker;

    public WebSocketClient(@NotNull Channel channel, @NotNull WebSocketServerHandshaker handshaker) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/webSocket/WebSocketClient", "<init>"));
        }
        if (handshaker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handshaker", "org/jetbrains/io/webSocket/WebSocketClient", "<init>"));
        }
        super(channel);
        this.handshaker = handshaker;
    }

    @Override
    public ChannelFuture send(@NotNull ByteBuf message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/io/webSocket/WebSocketClient", "send"));
        }
        if (!this.channel.isOpen()) {
            return this.channel.newFailedFuture((Throwable)new ClosedChannelException());
        }
        return this.channel.writeAndFlush((Object)new TextWebSocketFrame(message));
    }

    @Override
    void sendHeartbeat() {
        this.channel.writeAndFlush((Object)new PingWebSocketFrame());
    }

    public void disconnect(@NotNull CloseWebSocketFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "org/jetbrains/io/webSocket/WebSocketClient", "disconnect"));
        }
        this.handshaker.close(this.channel, frame);
    }
}

