/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.webSocket.Client;
import org.jetbrains.io.webSocket.ExceptionHandler;
import org.jetbrains.io.webSocket.MessageChannelHandler;
import org.jetbrains.io.webSocket.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;
import org.jetbrains.io.webSocket.WebSocketServer;
import org.jetbrains.io.webSocket.WebSocketServerListener;

public abstract class WebSocketHandshakeHandler
extends HttpRequestHandler
implements WebSocketServerListener,
ExceptionHandler {
    private static final Logger LOG = Logger.getInstance(WebSocketHandshakeHandler.class);
    static final AttributeKey<Client> CLIENT = AttributeKey.valueOf((String)"WebSocketHandler.client");
    private final AtomicNotNullLazyValue<WebSocketServer> server = new AtomicNotNullLazyValue<WebSocketServer>(){

        @NotNull
        protected WebSocketServer compute() {
            WebSocketServer result = new WebSocketServer(WebSocketHandshakeHandler.this, WebSocketHandshakeHandler.this);
            Disposable serverDisposable = BuiltInServerManager.getInstance().getServerDisposable();
            assert (serverDisposable != null);
            Disposer.register((Disposable)serverDisposable, (Disposable)result);
            WebSocketHandshakeHandler.this.serverCreated(result);
            WebSocketServer webSocketServer = result;
            if (webSocketServer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler$1", "compute"));
            }
            return webSocketServer;
        }
    };

    public boolean isSupported(@NotNull FullHttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "isSupported"));
        }
        return request.method() == HttpMethod.GET && "WebSocket".equalsIgnoreCase(request.headers().get("Upgrade")) && request.uri().length() > 2;
    }

    protected void serverCreated(@NotNull WebSocketServer server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "serverCreated"));
        }
    }

    @Override
    public void exceptionCaught(Throwable e) {
        NettyUtil.log(e, LOG);
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "process"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "process"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "process"));
        }
        this.handleWebSocketRequest(context, request, urlDecoder);
        return true;
    }

    private void handleWebSocketRequest(final ChannelHandlerContext context, FullHttpRequest request, final QueryStringDecoder uriDecoder) {
        WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory("ws://" + HttpHeaders.getHost((HttpMessage)request) + uriDecoder.path(), null, false, 0x6400000);
        WebSocketServerHandshaker handshaker = factory.newHandshaker((HttpRequest)request);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)context.channel());
            return;
        }
        if (!context.channel().isOpen()) {
            return;
        }
        final WebSocketClient client = new WebSocketClient(context.channel(), handshaker);
        context.attr(CLIENT).set((Object)client);
        handshaker.handshake(context.channel(), request).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    WebSocketServer webSocketServer = (WebSocketServer)WebSocketHandshakeHandler.this.server.getValue();
                    webSocketServer.addClient(client);
                    MessageChannelHandler messageChannelHandler = new MessageChannelHandler(webSocketServer, WebSocketHandshakeHandler.this.getMessageServer());
                    BuiltInServer.replaceDefaultHandler(context, (ChannelHandler)messageChannelHandler);
                    ChannelHandlerContext messageChannelHandlerContext = context.pipeline().context((ChannelHandler)messageChannelHandler);
                    context.pipeline().addBefore(messageChannelHandlerContext.name(), "webSocketFrameAggregator", (ChannelHandler)new WebSocketFrameAggregator(0x6400000));
                    messageChannelHandlerContext.attr(CLIENT).set((Object)client);
                    WebSocketHandshakeHandler.this.connected(client, uriDecoder.parameters());
                }
            }
        });
    }

    @NotNull
    protected abstract MessageServer getMessageServer();

    @Override
    public void connected(@NotNull Client client, Map<String, List<String>> parameters) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/webSocket/WebSocketHandshakeHandler", "connected"));
        }
    }
}

