/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SimpleTimerTask;
import gnu.trove.THashSet;
import gnu.trove.TObjectProcedure;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.webSocket.Client;
import org.jetbrains.io.webSocket.ExceptionHandler;
import org.jetbrains.io.webSocket.ExceptionHandlerImpl;
import org.jetbrains.io.webSocket.WebSocketHandshakeHandler;
import org.jetbrains.io.webSocket.WebSocketServerListener;
import org.jetbrains.io.webSocket.WebSocketServerOptions;

public class WebSocketServer
implements Disposable {
    private final SimpleTimerTask heartbeatTimer;
    @Nullable
    private final WebSocketServerListener listener;
    final ExceptionHandler exceptionHandler;
    private final THashSet<Client> clients;

    public WebSocketServer() {
        this(null, new ExceptionHandlerImpl());
    }

    public WebSocketServer(@Nullable WebSocketServerListener listener, @NotNull ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionHandler", "org/jetbrains/io/webSocket/WebSocketServer", "<init>"));
        }
        this(null, exceptionHandler, listener);
    }

    public WebSocketServer(@Nullable WebSocketServerOptions options, @NotNull ExceptionHandler exceptionHandler, @Nullable WebSocketServerListener listener) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionHandler", "org/jetbrains/io/webSocket/WebSocketServer", "<init>"));
        }
        this.clients = new THashSet();
        this.exceptionHandler = exceptionHandler;
        this.listener = listener;
        this.heartbeatTimer = SimpleTimer.getInstance().setUp(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                THashSet tHashSet = WebSocketServer.this.clients;
                synchronized (tHashSet) {
                    if (WebSocketServer.this.clients.isEmpty()) {
                        return;
                    }
                    WebSocketServer.this.clients.forEach((TObjectProcedure)new TObjectProcedure<Client>(){

                        public boolean execute(Client client) {
                            if (client.channel.isActive()) {
                                client.sendHeartbeat();
                            }
                            return true;
                        }
                    });
                }
            }
        }, (long)(options == null ? new WebSocketServerOptions() : options).heartbeatDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/webSocket/WebSocketServer", "addClient"));
        }
        THashSet<Client> tHashSet = this.clients;
        synchronized (tHashSet) {
            this.clients.add((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientCount() {
        THashSet<Client> tHashSet = this.clients;
        synchronized (tHashSet) {
            return this.clients.size();
        }
    }

    public boolean hasClients() {
        return this.getClientCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.heartbeatTimer.cancel();
        }
        finally {
            THashSet<Client> tHashSet = this.clients;
            synchronized (tHashSet) {
                this.clients.clear();
            }
        }
    }

    public void sendResponse(@NotNull Client client, @NotNull ByteBuf message) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/webSocket/WebSocketServer", "sendResponse"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/io/webSocket/WebSocketServer", "sendResponse"));
        }
        if (client.channel.isOpen()) {
            client.send(message);
        }
    }

    @Nullable
    public <T> AsyncResult<T> send(Client client, int messageId, ByteBuf message) {
        try {
            return client.send(messageId, message);
        }
        catch (Throwable e) {
            this.exceptionHandler.exceptionCaught(e);
            return null;
        }
    }

    public AsyncResult removeAsyncResult(Client client, int messageId) {
        return (AsyncResult)client.messageCallbackMap.remove(messageId);
    }

    public <T> void send(final int messageId, final ByteBuf message, final @Nullable List<AsyncResult<Pair<Client, T>>> results) {
        this.forEachClient(new TObjectProcedure<Client>(){
            private boolean first;

            public boolean execute(Client client) {
                try {
                    AsyncResult result = client.send(messageId, this.first ? message : message.duplicate());
                    this.first = false;
                    if (results != null) {
                        results.add(result);
                    }
                }
                catch (Throwable e) {
                    WebSocketServer.this.exceptionHandler.exceptionCaught(e);
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean disconnectClient(@NotNull ChannelHandlerContext context, @NotNull Client client, boolean closeChannel) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/webSocket/WebSocketServer", "disconnectClient"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/webSocket/WebSocketServer", "disconnectClient"));
        }
        THashSet<Client> tHashSet = this.clients;
        synchronized (tHashSet) {
            if (!this.clients.remove((Object)client)) {
                return false;
            }
        }
        try {
            context.attr(WebSocketHandshakeHandler.CLIENT).set(null);
            if (closeChannel) {
                context.channel().close();
            }
            client.rejectAsyncResults(this.exceptionHandler);
        }
        finally {
            if (this.listener != null) {
                this.listener.disconnected(client);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachClient(@NotNull TObjectProcedure<Client> procedure) {
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "org/jetbrains/io/webSocket/WebSocketServer", "forEachClient"));
        }
        THashSet<Client> tHashSet = this.clients;
        synchronized (tHashSet) {
            if (this.clients.isEmpty()) {
                return;
            }
            this.clients.forEach(procedure);
        }
    }
}

