/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import io.netty.buffer.ByteBuf;
import java.nio.CharBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.ChannelBufferToString;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;

public abstract class MessageDecoder
extends SimpleChannelInboundHandlerAdapter<ByteBuf> {
    protected int contentLength;
    protected final StringBuilder builder = new StringBuilder(64);
    private CharBuffer chunkedContent;
    private int consumedContentByteCount = 0;

    protected final int parseContentLength() {
        return MessageDecoder.parseInt(this.builder, 0, false, 10);
    }

    @Nullable
    protected String doReadContent(@NotNull ByteBuf buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/rpc/MessageDecoder", "doReadContent"));
        }
        int required = this.contentLength - this.consumedContentByteCount;
        if (buffer.readableBytes() < required) {
            if (this.chunkedContent == null) {
                this.chunkedContent = CharBuffer.allocate(this.contentLength);
            }
            int count = buffer.readableBytes();
            ChannelBufferToString.readIntoCharBuffer(this.chunkedContent, buffer, count);
            this.consumedContentByteCount += count;
            return null;
        }
        if (this.chunkedContent != null) {
            ChannelBufferToString.readIntoCharBuffer(this.chunkedContent, buffer, required);
            String result = ChannelBufferToString.charBufferToString(this.chunkedContent);
            this.chunkedContent = null;
            this.consumedContentByteCount = 0;
            return result;
        }
        return ChannelBufferToString.readString(buffer, required);
    }

    private static int parseInt(CharSequence value, int start, boolean isNegative, int radix) {
        int i;
        int end = value.length();
        int result = 0;
        for (i = start; i < end; ++i) {
            int digit;
            char c = value.charAt(i);
            int n = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (digit = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (digit < 0 || digit >= radix) break;
            int newResult = result * radix - digit;
            if (newResult > result) {
                throw new NumberFormatException("Overflow parsing " + value.subSequence(start, end));
            }
            result = newResult;
        }
        if (result == 0 && (end == 0 || value.charAt(i - 1) != '0')) {
            throw new NumberFormatException("Invalid integer representation for " + value.subSequence(start, end));
        }
        if (result == Integer.MIN_VALUE && !isNegative) {
            throw new NumberFormatException("Overflow parsing " + value.subSequence(start, end));
        }
        return isNegative ? result : -result;
    }
}

