/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.SystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.SystemImageList;
import com.android.tools.idea.avdmanager.SystemImagePreview;
import com.android.tools.idea.wizard.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.base.Predicate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSystemImageStep
extends DynamicWizardStepWithHeaderAndDescription
implements SystemImageList.SystemImageSelectionListener {
    private SystemImageList mySystemImageList;
    private JPanel myPanel;
    private SystemImagePreview mySystemImagePreview;
    private Device myCurrentDevice;
    private Project myProject;

    public ChooseSystemImageStep(@Nullable Project project, @Nullable Disposable parentDisposable) {
        super("System Image", "Select a system image", null, parentDisposable);
        this.$$$setupUI$$$();
        this.mySystemImageList.addSelectionListener(this);
        Predicate<AvdWizardConstants.SystemImageDescription> filter = new Predicate<AvdWizardConstants.SystemImageDescription>(){

            public boolean apply(AvdWizardConstants.SystemImageDescription input) {
                if (ChooseSystemImageStep.this.myCurrentDevice == null) {
                    return true;
                }
                String deviceTagId = ChooseSystemImageStep.this.myCurrentDevice.getTagId();
                IdDisplay inputTag = input.getTag();
                if (inputTag == null) {
                    return true;
                }
                if (deviceTagId == null || deviceTagId.equals(SystemImage.DEFAULT_TAG.getId())) {
                    return inputTag.getId().equals(SystemImage.DEFAULT_TAG.getId()) || !inputTag.equals((Object)AvdWizardConstants.TV_TAG) && !inputTag.equals((Object)AvdWizardConstants.WEAR_TAG);
                }
                return deviceTagId.equals(inputTag.getId());
            }
        };
        this.mySystemImageList.setFilter(filter);
        this.mySystemImageList.setBorder(BorderFactory.createLineBorder((Color)JBColor.lightGray));
        this.setBodyComponent(this.myPanel);
    }

    @Override
    public boolean validate() {
        return this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY) != null;
    }

    @Override
    public boolean isStepVisible() {
        Boolean isInEditMode = this.myState.get(AvdWizardConstants.IS_IN_EDIT_MODE_KEY);
        if (isInEditMode != null && isInEditMode.booleanValue()) {
            return this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY) == null;
        }
        return true;
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        this.myCurrentDevice = this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        AvdWizardConstants.SystemImageDescription selectedImage = this.myState.get(AvdWizardConstants.SYSTEM_IMAGE_KEY);
        this.mySystemImageList.refreshImages(false);
        this.mySystemImageList.setSelectedImage(selectedImage);
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Choose System Image Step" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ChooseSystemImageStep", "getStepName"));
        }
        return "Choose System Image Step";
    }

    @Override
    public void onSystemImageSelected(@Nullable AvdWizardConstants.SystemImageDescription systemImage) {
        this.mySystemImagePreview.setImage(systemImage);
        this.myState.put(AvdWizardConstants.SYSTEM_IMAGE_KEY, systemImage);
    }

    @Override
    @Nullable
    protected JBColor getTitleBackgroundColor() {
        return WizardConstants.ANDROID_NPW_HEADER_COLOR;
    }

    @Override
    @Nullable
    protected JBColor getTitleTextColor() {
        return WizardConstants.ANDROID_NPW_HEADER_TEXT_COLOR;
    }

    private void createUIComponents() {
        this.mySystemImageList = new SystemImageList(this.myProject);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SystemImagePreview systemImagePreview;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        SystemImageList systemImageList = this.mySystemImageList;
        jPanel.add((Component)systemImageList, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.mySystemImagePreview = systemImagePreview = new SystemImagePreview();
        jPanel.add((Component)systemImagePreview, new GridConstraints(0, 1, 1, 1, 4, 2, 0, 3, null, new Dimension(360, -1), new Dimension(360, -1)));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

