/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.android.utils.Pair;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EditableModel;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TranslationDialog
extends DialogWrapper {
    private final AndroidFacet myFacet;
    private Locale myLocale;
    private TranslationModel myModel;
    private boolean myCreate;
    private static final int KEY_COLUMN = 0;
    private static final int DEFAULT_TRANSLATION_COLUMN = 1;
    private static final int NEW_TRANSLATION_COLUMN = 2;

    TranslationDialog(@NotNull AndroidFacet facet, @NotNull Locale locale, boolean create) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/configurations/TranslationDialog", "<init>"));
        }
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/android/tools/idea/configurations/TranslationDialog", "<init>"));
        }
        super(facet.getModule().getProject());
        this.myFacet = facet;
        this.myLocale = locale;
        this.myCreate = create;
        String localeLabel = LocaleMenuAction.getLocaleLabel(this.myLocale, false);
        this.setTitle(String.format((create ? "Add" : "Edit") + " Translation for %1$s", localeLabel));
        this.init();
        this.setOKActionEnabled(false);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myModel = new TranslationModel();
        final JBTable table = new JBTable((TableModel)this.myModel);
        table.setSelectionMode(0);
        table.setStriped(true);
        JTextField textField = new JTextField();
        DefaultCellEditor cellEditor = new DefaultCellEditor(textField);
        cellEditor.setClickCountToStart(1);
        table.setDefaultEditor(String.class, (TableCellEditor)cellEditor);
        table.setRowHeight(textField.getPreferredSize().height);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)table).disableAddAction().disableRemoveAction();
        JPanel panel = decorator.createPanel();
        panel.setPreferredSize(new Dimension(800, 800));
        if (this.myModel.getRowCount() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    table.requestFocus();
                    table.editCellAt(0, 2);
                }
            });
        }
        return panel;
    }

    public boolean createTranslation() {
        return this.myModel.createTranslation();
    }

    private class TranslationModel
    extends AbstractTableModel
    implements EditableModel {
        private Map<String, String> myTranslations;
        private Map<String, ResourceValue> myValues;
        private String[] myKeys;
        private final FolderConfiguration myFolderConfig = new FolderConfiguration();

        public TranslationModel() {
            ProjectResourceRepository resources = ProjectResourceRepository.getProjectResources(TranslationDialog.this.myFacet, true);
            this.myFolderConfig.setLanguageQualifier(new LanguageQualifier("xx"));
            this.myValues = resources.getConfiguredResources(ResourceType.STRING, this.myFolderConfig);
            this.myKeys = this.myValues.keySet().toArray(new String[this.myValues.size()]);
            Arrays.sort(this.myKeys);
            this.myTranslations = Maps.newHashMapWithExpectedSize((int)this.myKeys.length);
            if (!TranslationDialog.this.myCreate && TranslationDialog.this.myLocale.hasLanguage()) {
                FolderConfiguration config = new FolderConfiguration();
                config.setLanguageQualifier(((TranslationDialog)TranslationDialog.this).myLocale.language);
                if (TranslationDialog.this.myLocale.hasRegion()) {
                    config.setRegionQualifier(((TranslationDialog)TranslationDialog.this).myLocale.region);
                }
                for (String key : this.myKeys) {
                    ResourceValue value;
                    LanguageQualifier languageQualifier;
                    ResourceItem match;
                    List items = resources.getResourceItem(ResourceType.STRING, key);
                    if (items == null || (match = (ResourceItem)config.findMatchingConfigurable(items)) == null || !((TranslationDialog)TranslationDialog.this).myLocale.language.equals((Object)(languageQualifier = match.getConfiguration().getLanguageQualifier())) || (value = match.getResourceValue(false)) == null) continue;
                    this.myTranslations.put(key, value.getValue());
                }
            }
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.myKeys.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            String key = this.myKeys[row];
            switch (col) {
                case 0: {
                    return key;
                }
                case 1: {
                    ResourceValue value = this.myValues.get(key);
                    if (value != null) {
                        return value.getValue();
                    }
                    return "";
                }
            }
            String translation = this.myTranslations.get(key);
            if (translation != null) {
                return translation;
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Key";
                }
                case 1: {
                    return "Default";
                }
                case 2: {
                    return LocaleMenuAction.getLocaleLabel(TranslationDialog.this.myLocale, false);
                }
            }
            assert (false) : column;
            return "";
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            String string = aValue.toString();
            if (!string.isEmpty() && !TranslationDialog.this.isOKActionEnabled()) {
                TranslationDialog.this.setOKActionEnabled(true);
            }
            this.myTranslations.put(this.myKeys[row], string);
        }

        public void addRow() {
            throw new UnsupportedOperationException();
        }

        public void removeRow(int index) {
            throw new UnsupportedOperationException();
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            String temp = this.myKeys[oldIndex];
            this.myKeys[oldIndex] = this.myKeys[newIndex];
            this.myKeys[newIndex] = temp;
        }

        public boolean createTranslation() {
            Pair result = (Pair)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Pair<String, VirtualFile>>(){

                @Nullable
                public Pair<String, VirtualFile> compute() {
                    if (TranslationDialog.this.myCreate) {
                        return TranslationModel.this.createTranslationFile();
                    }
                    return TranslationModel.this.updateTranslations();
                }
            });
            String error = (String)result.getFirst();
            VirtualFile newFile = (VirtualFile)result.getSecond();
            Project project = TranslationDialog.this.myFacet.getModule().getProject();
            if (error != null) {
                Messages.showErrorDialog((Project)project, (String)error, (String)"Create Translation");
                return false;
            }
            if (newFile != null) {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project, newFile, -1);
                FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
            }
            return true;
        }

        private Pair<String, VirtualFile> createTranslationFile() {
            FolderConfiguration folderConfig = new FolderConfiguration();
            folderConfig.setLanguageQualifier(((TranslationDialog)TranslationDialog.this).myLocale.language);
            if (TranslationDialog.this.myLocale.hasRegion()) {
                folderConfig.setRegionQualifier(((TranslationDialog)TranslationDialog.this).myLocale.region);
            }
            String folderName = folderConfig.getFolderName(ResourceFolderType.VALUES);
            String fileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STRING);
            assert (fileName != null);
            try {
                VirtualFile res = TranslationDialog.this.myFacet.getPrimaryResourceDir();
                assert (res != null);
                VirtualFile newParentFolder = res.findChild(folderName);
                if (newParentFolder == null && (newParentFolder = res.createChildDirectory((Object)this, folderName)) == null) {
                    return Pair.of((Object)String.format("Could not create folder %1$s in %2$s", folderName, res.getPath()), null);
                }
                VirtualFile existing = newParentFolder.findChild(fileName);
                String text = this.createTranslationXml(true);
                if (existing != null && existing.exists()) {
                    return Pair.of((Object)String.format("File 'res/%1$s/%2$s' already exists!", folderName, fileName), null);
                }
                VirtualFile newFile = newParentFolder.createChildData((Object)this, fileName);
                VfsUtil.saveText((VirtualFile)newFile, (String)text);
                return Pair.of(null, (Object)newFile);
            }
            catch (IOException e2) {
                return Pair.of((Object)String.format("Failed to create File 'res/%1$s/%2$s' : %3$s", folderName, fileName, e2.getMessage()), null);
            }
        }

        private Pair<String, VirtualFile> updateTranslations() {
            VirtualFile file;
            VirtualFile resDir;
            VirtualFile firstFile = null;
            PsiManager manager = PsiManager.getInstance((Project)TranslationDialog.this.myFacet.getModule().getProject());
            FolderConfiguration config = new FolderConfiguration();
            config.setLanguageQualifier(((TranslationDialog)TranslationDialog.this).myLocale.language);
            if (TranslationDialog.this.myLocale.hasRegion()) {
                config.setRegionQualifier(((TranslationDialog)TranslationDialog.this).myLocale.region);
            }
            ProjectResourceRepository resources = ProjectResourceRepository.getProjectResources(TranslationDialog.this.myFacet, true);
            Map existing = resources.getConfiguredResources(ResourceType.STRING, config);
            HashSet handled = Sets.newHashSet();
            for (String key : this.myKeys) {
                ResourceValue value = (ResourceValue)existing.get(key);
                if (value == null || !value.getValue().equals(this.myTranslations.get(key))) continue;
                handled.add(key);
            }
            block1: for (String key : this.myKeys) {
                XmlFile resourceFile;
                XmlTag rootTag;
                PsiFile file2;
                VirtualFile definedIn;
                ResourceFile source;
                LanguageQualifier languageQualifier;
                ResourceItem match;
                List items = resources.getResourceItem(ResourceType.STRING, key);
                if (items == null || (match = (ResourceItem)config.findMatchingConfigurable(items)) == null || !((TranslationDialog)TranslationDialog.this).myLocale.language.equals((Object)(languageQualifier = match.getConfiguration().getLanguageQualifier())) || (source = (ResourceFile)match.getSource()) == null || (definedIn = LocalFileSystem.getInstance().findFileByIoFile(source.getFile())) == null) continue;
                if (firstFile == null) {
                    firstFile = definedIn;
                }
                if (handled.contains(key) || (file2 = manager.findFile(definedIn)) == null || !(file2 instanceof XmlFile) || (rootTag = (resourceFile = (XmlFile)file2).getRootTag()) == null) continue;
                for (XmlTag item : rootTag.getSubTags()) {
                    XmlAttribute name = item.getAttribute("name");
                    if (name == null || !key.equals(name.getValue())) continue;
                    String translation = this.myTranslations.get(key);
                    if (translation == null || translation.isEmpty()) {
                        item.delete();
                    } else {
                        String escaped = ValueXmlHelper.escapeResourceString((String)translation);
                        XmlTagValue itemValue = item.getValue();
                        itemValue.setText(escaped);
                    }
                    firstFile = definedIn;
                    handled.add(key);
                    continue block1;
                }
            }
            String fileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STRING);
            assert (fileName != null);
            String folderName = ResourceFolderType.VALUES.getName() + '-' + ((TranslationDialog)TranslationDialog.this).myLocale.language.getValue();
            boolean format = false;
            List<String> folders = Collections.singletonList(folderName);
            for (String key : this.myKeys) {
                String value;
                if (handled.contains(key) || (value = this.myTranslations.get(key)) == null || value.trim().isEmpty()) continue;
                Module module = TranslationDialog.this.myFacet.getModule();
                AndroidResourceUtil.createValueResource(module, key, ResourceType.STRING, fileName, folders, value);
                format = true;
            }
            if (format && (resDir = TranslationDialog.this.myFacet.getPrimaryResourceDir()) != null && (file = resDir.findFileByRelativePath(folderName + '/' + fileName)) != null) {
                firstFile = file;
                PsiFile psiFile = manager.findFile(file);
                if (psiFile != null) {
                    CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
                    codeStyleManager.reformat((PsiElement)psiFile);
                }
            }
            return Pair.of(null, firstFile);
        }

        private String createTranslationXml(boolean includeRoot) {
            StringBuilder sb = new StringBuilder(this.myKeys.length * 120);
            if (includeRoot) {
                sb.append("<resources>\n\n");
            }
            for (String key : this.myKeys) {
                String value = this.myTranslations.get(key);
                if (value == null || value.trim().isEmpty()) continue;
                sb.append("    <string name=\"");
                sb.append(key);
                sb.append("\">");
                sb.append(ValueXmlHelper.escapeResourceString((String)value));
                sb.append("</string>\n");
            }
            if (includeRoot) {
                sb.append("\n</resources>");
            }
            return sb.toString();
        }
    }
}

