/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenshot;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.RawImage;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.awt.image.BufferedImage;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ScreenshotTask
extends Task.Modal {
    private final IDevice myDevice;
    private String myError;
    private BufferedImage myImage;

    public ScreenshotTask(@NotNull Project project, @NotNull IDevice device) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/ddms/screenshot/ScreenshotTask", "<init>"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/ddms/screenshot/ScreenshotTask", "<init>"));
        }
        super(project, AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]), false);
        this.myDevice = device;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        RawImage rawImage;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/ddms/screenshot/ScreenshotTask", "run"));
        }
        indicator.setIndeterminate(true);
        indicator.setText(AndroidBundle.message("android.ddms.screenshot.task.step.obtain", new Object[0]));
        try {
            rawImage = this.myDevice.getScreenshot();
        }
        catch (Exception e) {
            this.myError = AndroidBundle.message("android.ddms.screenshot.task.error1", e.getMessage());
            return;
        }
        if (rawImage.bpp != 16 && rawImage.bpp != 32) {
            this.myError = AndroidBundle.message("android.ddms.screenshot.task.error.invalid.bpp", rawImage.bpp);
            return;
        }
        indicator.setText(AndroidBundle.message("android.ddms.screenshot.task.step.load", new Object[0]));
        this.myImage = new BufferedImage(rawImage.width, rawImage.height, 2);
        for (int y = 0; y < rawImage.height; ++y) {
            for (int x = 0; x < rawImage.width; ++x) {
                int argb = rawImage.getARGB((x + y * rawImage.width) * (rawImage.bpp / 8));
                this.myImage.setRGB(x, y, argb);
            }
        }
    }

    public BufferedImage getScreenshot() {
        return this.myImage;
    }

    public String getError() {
        return this.myError;
    }
}

