/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.model;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.Transient;
import com.android.tools.idea.editors.navigation.model.ActivityState;
import com.android.tools.idea.editors.navigation.model.EventDispatcher;
import com.android.tools.idea.editors.navigation.model.Locator;
import com.android.tools.idea.editors.navigation.model.MenuState;
import com.android.tools.idea.editors.navigation.model.ModelPoint;
import com.android.tools.idea.editors.navigation.model.State;
import com.android.tools.idea.editors.navigation.model.StatePointEntry;
import com.android.tools.idea.editors.navigation.model.Transition;
import com.intellij.openapi.util.Condition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NavigationModel {
    private final EventDispatcher<Event> listeners = new EventDispatcher();
    private final ArrayList<State> states = new ArrayList();
    private final ArrayList<Transition> transitions = new ArrayList();
    private final Map<State, ModelPoint> stateToLocation = new HashMap<State, ModelPoint>();

    @Transient
    public ArrayList<State> getStates() {
        return this.states;
    }

    @Transient
    public ArrayList<Transition> getTransitions() {
        return this.transitions;
    }

    @Transient
    public Map<State, ModelPoint> getStateToLocation() {
        return this.stateToLocation;
    }

    private static StatePointEntry toEntry(Map.Entry<State, ModelPoint> entry) {
        return new StatePointEntry(entry.getKey(), entry.getValue());
    }

    public Collection<StatePointEntry> getLocations() {
        ArrayList<StatePointEntry> result = new ArrayList<StatePointEntry>();
        for (Map.Entry<State, ModelPoint> entry : this.stateToLocation.entrySet()) {
            result.add(NavigationModel.toEntry(entry));
        }
        return result;
    }

    public void setLocations(Collection<StatePointEntry> locations) {
        for (StatePointEntry entry : locations) {
            this.stateToLocation.put(entry.state, entry.point);
        }
    }

    public void addState(State state) {
        if (this.states.contains(state)) {
            return;
        }
        this.states.add(state);
        this.listeners.notify(Event.insert(State.class));
    }

    public void removeState(State state) {
        this.states.remove(state);
        for (Transition t : new ArrayList<Transition>(this.transitions)) {
            if (t.getSource().getState() != state && t.getDestination().getState() != state) continue;
            this.remove(t);
        }
        this.listeners.notify(Event.delete(State.class));
    }

    private void updateStates(State state) {
        if (!this.states.contains(state)) {
            this.states.add(state);
        }
    }

    public boolean add(Transition transition) {
        boolean result = this.transitions.add(transition);
        this.updateStates(transition.getSource().getState());
        this.updateStates(transition.getDestination().getState());
        this.listeners.notify(Event.insert(Transition.class));
        return result;
    }

    public boolean remove(Transition transition) {
        boolean result = this.transitions.remove(transition);
        this.listeners.notify(Event.delete(Transition.class));
        return result;
    }

    public void accept(State.Visitor visitor) {
        for (State state : this.states) {
            state.accept(visitor);
        }
    }

    @Transient
    public Map<String, ActivityState> getActivities() {
        final HashMap<String, ActivityState> activities = new HashMap<String, ActivityState>();
        this.accept(new State.BaseVisitor(){

            @Override
            public void visit(ActivityState activityState) {
                activities.put(activityState.getClassName(), activityState);
            }
        });
        return activities;
    }

    @Transient
    public Map<String, MenuState> getMenus() {
        final HashMap<String, MenuState> menus = new HashMap<String, MenuState>();
        this.accept(new State.BaseVisitor(){

            @Override
            public void visit(MenuState menuState) {
                menus.put(menuState.getXmlResourceName(), menuState);
            }
        });
        return menus;
    }

    @Nullable
    public Transition findTransitionWithSource(@NonNull Locator source) {
        for (Transition transition : this.getTransitions()) {
            if (!source.equals(transition.getSource())) continue;
            return transition;
        }
        return null;
    }

    @Nullable
    public Transition findTransition(@NonNull Condition<Transition> condition) {
        for (Transition transition : this.getTransitions()) {
            if (!condition.value((Object)transition)) continue;
            return transition;
        }
        return null;
    }

    @Nullable
    public MenuState findAssociatedMenuState(State state) {
        final Locator locator = Locator.of(state, null);
        Transition transition = this.findTransition(new Condition<Transition>(){

            public boolean value(Transition transition) {
                return locator.equals(transition.getSource()) && transition.getDestination().getState() instanceof MenuState;
            }
        });
        if (transition != null) {
            return (MenuState)transition.getDestination().getState();
        }
        return null;
    }

    public List<State> findDestinationsFor(@NotNull State source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/editors/navigation/model/NavigationModel", "findDestinationsFor"));
        }
        ArrayList<State> result = new ArrayList<State>();
        for (Transition transition : this.getTransitions()) {
            if (!source.equals(transition.getSource().getState())) continue;
            result.add(transition.getDestination().getState());
        }
        return result;
    }

    public void clear() {
        this.states.clear();
        this.transitions.clear();
    }

    public void copyAllStatesAndTransitionsFrom(NavigationModel source) {
        this.states.addAll(source.getStates());
        this.transitions.addAll(source.getTransitions());
    }

    @Transient
    public EventDispatcher<Event> getListeners() {
        return this.listeners;
    }

    public static class Event {
        public final Operation operation;
        public final Class<?> operandType;

        public Event(@NonNull Operation operation, @NonNull Class operandType) {
            this.operation = operation;
            this.operandType = operandType;
        }

        public static Event of(@NonNull Operation operation, @NonNull Class operandType) {
            return new Event(operation, operandType);
        }

        public static Event insert(@NonNull Class operandType) {
            return Event.of(Operation.INSERT, operandType);
        }

        public static Event update(@NonNull Class operandType) {
            return Event.of(Operation.UPDATE, operandType);
        }

        public static Event delete(@NonNull Class operandType) {
            return Event.of(Operation.DELETE, operandType);
        }

        public static enum Operation {
            INSERT,
            UPDATE,
            DELETE;

        }
    }
}

