/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.actions.AndroidNewModuleAction;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.structure.ConfigurableHost;
import com.android.tools.idea.gradle.structure.ConfigurationErrorsPanel;
import com.android.tools.idea.gradle.structure.DefaultSdksConfigurable;
import com.android.tools.idea.gradle.structure.ProjectConfigurationError;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ModuleTypeComparator;
import com.android.tools.idea.structure.AndroidModuleConfigurable;
import com.android.tools.idea.structure.AndroidProjectConfigurable;
import com.google.common.collect.Lists;
import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ThreeState;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectStructureConfigurable
extends BaseConfigurable
implements GradleSyncListener,
SearchableConfigurable,
ConfigurableHost {
    public static final DataKey<AndroidProjectStructureConfigurable> KEY = DataKey.create((String)"AndroidProjectStructureConfiguration");
    private static final Logger LOG = Logger.getInstance(AndroidProjectStructureConfigurable.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Disposable myDisposable;
    private boolean myUiInitialized;
    private JPanel myNotificationPanel;
    private Splitter mySplitter;
    private SidePanel mySidePanel;
    private ConfigurationErrorsPanel myErrorsPanel;
    @NotNull
    private final Wrapper myDetails;
    @NotNull
    private final UiState myUiState;
    @NotNull
    private final DefaultSdksConfigurable mySdksConfigurable;
    @NotNull
    private final List<Configurable> myConfigurables;
    private final GradleSettingsFile mySettingsFile;
    private JComponent myToFocus;

    @NotNull
    public static AndroidProjectStructureConfigurable getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "getInstance"));
        }
        AndroidProjectStructureConfigurable androidProjectStructureConfigurable = (AndroidProjectStructureConfigurable)ServiceManager.getService((Project)project, AndroidProjectStructureConfigurable.class);
        if (androidProjectStructureConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "getInstance"));
        }
        return androidProjectStructureConfigurable;
    }

    public boolean showDialogAndSelectSdksPage() {
        return this.doShowDialog(new Runnable(){

            @Override
            public void run() {
                AndroidProjectStructureConfigurable.this.mySidePanel.selectSdk();
            }
        });
    }

    public boolean showDialogAndSelect(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "showDialogAndSelect"));
        }
        return this.doShowDialog(new Runnable(){

            @Override
            public void run() {
                AndroidProjectStructureConfigurable.this.mySidePanel.select(module);
            }
        });
    }

    public boolean showDialogAndSelectDependency(final @NotNull Module module, final @NotNull GradleCoordinate dependency) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "showDialogAndSelectDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "showDialogAndSelectDependency"));
        }
        return this.doShowDialog(new Runnable(){

            @Override
            public void run() {
                AndroidModuleConfigurable configurable = AndroidProjectStructureConfigurable.this.mySidePanel.select(module);
                if (configurable != null) {
                    configurable.selectDependency(dependency);
                }
            }
        });
    }

    public boolean showDialog() {
        return this.doShowDialog(null);
    }

    private boolean doShowDialog(@Nullable Runnable advanceInit) {
        return ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)this, advanceInit);
    }

    public AndroidProjectStructureConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "<init>"));
        }
        this.myDetails = new Wrapper();
        this.myConfigurables = Lists.newLinkedList();
        this.myProject = project;
        this.myUiState = new UiState(project);
        this.mySdksConfigurable = new DefaultSdksConfigurable(this, project);
        this.myConfigurables.add(this.mySdksConfigurable);
        if (!project.isDefault()) {
            this.myConfigurables.add((Configurable)new AndroidProjectConfigurable(project));
        }
        this.mySettingsFile = GradleSettingsFile.get(project);
        this.myDisposable = new Disposable(){

            public void dispose() {
            }
        };
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"project.settings.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        MainPanel component = new MainPanel();
        this.mySplitter = new Splitter(false, 0.15f);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.initSidePanel();
        this.mySplitter.setFirstComponent((JComponent)this.mySidePanel);
        this.mySplitter.setSecondComponent((JComponent)this.myDetails);
        component.add((Component)this.mySplitter, "Center");
        this.myNotificationPanel = new JPanel();
        Color background = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
        if (background == null) {
            background = JBColor.GRAY;
        }
        this.myNotificationPanel.setBackground(background);
        this.myNotificationPanel.setLayout(new BoxLayout(this.myNotificationPanel, 1));
        component.add((Component)this.myNotificationPanel, "North");
        this.myErrorsPanel = new ConfigurationErrorsPanel();
        component.add((Component)this.myErrorsPanel, "South");
        this.myUiInitialized = true;
        MessageBusConnection connection = this.myProject.getMessageBus().connect(this.myDisposable);
        connection.subscribe(GradleSyncState.GRADLE_SYNC_TOPIC, (Object)this);
        return component;
    }

    private void initSidePanel() {
        this.mySidePanel = new SidePanel();
    }

    public boolean isModified() {
        for (Configurable configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return super.isModified();
    }

    public void apply() throws ConfigurationException {
        this.validateState();
        if (this.myErrorsPanel.hasCriticalErrors()) {
            return;
        }
        boolean dataChanged = false;
        for (Configurable configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            dataChanged = true;
            configurable.apply();
        }
        if (!this.myProject.isDefault() && (dataChanged || GradleSyncState.getInstance(this.myProject).isSyncNeeded() == ThreeState.YES)) {
            GradleProjectImporter.getInstance().requestProjectSync(this.myProject, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Resetting project structure");
        try {
            for (Configurable configurable : this.myConfigurables) {
                configurable.reset();
            }
            if (this.myUiInitialized) {
                this.validateState();
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
                this.removeModules();
                Module[] modules = moduleManager.getModules();
                Arrays.sort(modules, ModuleTypeComparator.INSTANCE);
                Module toSelect = null;
                for (Module module : modules) {
                    AndroidModuleConfigurable configurable = this.addModule(module);
                    if (configurable == null) continue;
                    this.myConfigurables.add((Configurable)configurable);
                    if (!configurable.getDisplayName().equals(this.myUiState.lastSelectedConfigurable)) continue;
                    toSelect = module;
                }
                if (this.myUiState.proportion > 0.0f) {
                    this.mySplitter.setProportion(this.myUiState.proportion);
                }
                this.mySidePanel.reset();
                if (toSelect != null) {
                    this.mySidePanel.select(toSelect);
                } else {
                    this.mySidePanel.selectSdk();
                }
            }
        }
        finally {
            token.finish();
        }
    }

    private void removeModules() {
        Iterator<Configurable> it = this.myConfigurables.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof AndroidModuleConfigurable)) continue;
            it.remove();
        }
    }

    @Nullable
    private AndroidModuleConfigurable addModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "addModule"));
        }
        String gradlePath = AndroidProjectStructureConfigurable.getGradlePath(module);
        AndroidModuleConfigurable configurable = null;
        if (StringUtil.isNotEmpty((String)gradlePath)) {
            configurable = new AndroidModuleConfigurable(this.myProject, module, gradlePath);
            configurable.reset();
        }
        return configurable;
    }

    private void validateState() {
        this.myErrorsPanel.removeAllErrors();
        List<ProjectConfigurationError> errors = this.mySdksConfigurable.validateState();
        if (!errors.isEmpty()) {
            Runnable navigationTask = new Runnable(){

                @Override
                public void run() {
                    AndroidProjectStructureConfigurable.this.selectConfigurable(AndroidProjectStructureConfigurable.this.mySdksConfigurable, false);
                }
            };
            for (ProjectConfigurationError error : errors) {
                error.setNavigationTask(navigationTask);
            }
        }
        this.myErrorsPanel.addErrors(errors);
    }

    @Nullable
    private static String getGradlePath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "getGradlePath"));
        }
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
        return gradleFacet != null ? ((AndroidGradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH : null;
    }

    private void selectConfigurable(@NotNull Configurable configurable, boolean requestFocus) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "selectConfigurable"));
        }
        JComponent content = configurable.createComponent();
        assert (content != null);
        this.myDetails.setContent(content);
        if (requestFocus) {
            JComponent toFocus = configurable instanceof BaseConfigurable ? ((BaseConfigurable)configurable).getPreferredFocusedComponent() : IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)content);
            if (toFocus == null) {
                toFocus = content;
            }
            this.myToFocus = toFocus;
            toFocus.requestFocusInWindow();
        }
        this.myUiState.lastSelectedConfigurable = configurable.getDisplayName();
        AndroidProjectStructureConfigurable.revalidateAndRepaint((JComponent)this.myDetails);
    }

    public void disposeUIResources() {
        if (!this.myUiInitialized) {
            return;
        }
        this.myUiState.storeValues(this.myProject);
        this.myUiState.proportion = this.mySplitter.getProportion();
        for (Configurable configurable : this.myConfigurables) {
            configurable.disposeUIResources();
        }
        Disposer.dispose((Disposable)this.myDisposable);
        Disposer.dispose((Disposable)this.myErrorsPanel);
        this.myUiInitialized = false;
    }

    @NotNull
    public String getId() {
        if ("android.project.structure" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "getId"));
        }
        return "android.project.structure";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myToFocus;
    }

    @Override
    public void syncStarted(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "syncStarted"));
        }
        if (this.myUiInitialized) {
            this.myNotificationPanel.removeAll();
            EditorNotificationPanel notification = new EditorNotificationPanel();
            notification.setText("Gradle project sync in progress...");
            this.myNotificationPanel.add((Component)notification);
            AndroidProjectStructureConfigurable.revalidateAndRepaint(this.myNotificationPanel);
        }
    }

    @Override
    public void syncSucceeded(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "syncSucceeded"));
        }
        this.myNotificationPanel.removeAll();
        AndroidProjectStructureConfigurable.revalidateAndRepaint(this.myNotificationPanel);
        this.reset();
    }

    @Override
    public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "syncFailed"));
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "syncFailed"));
        }
        this.myNotificationPanel.removeAll();
        AndroidProjectStructureConfigurable.revalidateAndRepaint(this.myNotificationPanel);
        this.reset();
    }

    @Override
    public void syncSkipped(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "syncSkipped"));
        }
    }

    private static void revalidateAndRepaint(@NotNull JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable", "revalidateAndRepaint"));
        }
        c.revalidate();
        c.repaint();
    }

    @Override
    public void requestValidation() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AndroidProjectStructureConfigurable.this.myErrorsPanel != null) {
                    AndroidProjectStructureConfigurable.this.validateState();
                }
            }
        });
    }

    private class DeleteModuleAction
    extends DumbAwareAction {
        @NotNull
        private final SidePanel mySidePanel;

        DeleteModuleAction(SidePanel sidePanel) {
            if (sidePanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sidePanel", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable$DeleteModuleAction", "<init>"));
            }
            super(CommonBundle.message((String)"button.delete", (Object[])new Object[0]), CommonBundle.message((String)"button.delete", (Object[])new Object[0]), PlatformIcons.DELETE_ICON);
            this.mySidePanel = sidePanel;
            this.registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)this.mySidePanel.myList);
        }

        public void actionPerformed(AnActionEvent e) {
            Object selectedValue = this.mySidePanel.myList.getSelectedValue();
            if (!(selectedValue instanceof AndroidModuleConfigurable)) {
                throw new IllegalStateException("The current selection does not represent a module");
            }
            AndroidModuleConfigurable configurable = (AndroidModuleConfigurable)((Object)selectedValue);
            Object editableObject = configurable.getEditableObject();
            if (!(editableObject instanceof Module)) {
                throw new IllegalStateException("Unable to find the module to delete");
            }
            String question = this.mySidePanel.getModuleCount() == 1 ? ProjectBundle.message((String)"module.remove.last.confirmation", (Object[])new Object[0]) : ProjectBundle.message((String)"module.remove.confirmation", (Object[])new Object[]{configurable.getDisplayName()});
            if (Messages.showYesNoDialog((Project)AndroidProjectStructureConfigurable.this.myProject, (String)question, (String)ProjectBundle.message((String)"module.remove.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
            final Module module = (Module)editableObject;
            final String gradlePath = this.getGradlePath(module);
            if (StringUtil.isEmpty((String)gradlePath)) {
                String msg = String.format("The module '%1$s' does not have a Gradle path", module.getName());
                throw new IllegalStateException(msg);
            }
            RunResult result = new WriteCommandAction.Simple(module.getProject(), new PsiFile[0]){

                protected void run() throws Throwable {
                    DeleteModuleAction.this.delete(module);
                    if (AndroidProjectStructureConfigurable.this.mySettingsFile != null) {
                        AndroidProjectStructureConfigurable.this.mySettingsFile.removeModule(gradlePath);
                    }
                }
            }.execute();
            Throwable error = result.getThrowable();
            if (error != null) {
                String msg = String.format("Failed to remove module '%1$s'", module.getName());
                LOG.error(msg, error);
                return;
            }
            AndroidProjectStructureConfigurable.this.myConfigurables.remove((Object)configurable);
            this.mySidePanel.reset();
            GradleProjectImporter.getInstance().requestProjectSync(AndroidProjectStructureConfigurable.this.myProject, null);
        }

        @NotNull
        private String getGradlePath(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable$DeleteModuleAction", "getGradlePath"));
            }
            AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
            if (facet == null) {
                String msg = String.format("The module '%1$s' is not a Gradle module", module.getName());
                throw new IllegalStateException(msg);
            }
            String path = ((AndroidGradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH;
            if (StringUtil.isEmpty((String)path)) {
                String msg = String.format("The module '%1$s' does not have a Gradle path", module.getName());
                throw new IllegalStateException(msg);
            }
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable$DeleteModuleAction", "getGradlePath"));
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delete(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable$DeleteModuleAction", "delete"));
            }
            if (module.isDisposed()) {
                return;
            }
            ModuleManager moduleManager = ModuleManager.getInstance((Project)module.getProject());
            ModifiableModuleModel modifiableModel = moduleManager.getModifiableModel();
            try {
                modifiableModel.disposeModule(module);
            }
            finally {
                modifiableModel.commit();
            }
        }

        public void update(AnActionEvent e) {
            Object selectedValue = this.mySidePanel.myList.getSelectedValue();
            e.getPresentation().setEnabled(selectedValue instanceof AndroidModuleConfigurable);
        }
    }

    private static class UiState {
        private static final String ANDROID_PROJECT_STRUCTURE_LAST_SELECTED_PROPERTY = "android.project.structure.last.selected";
        private static final String ANDROID_PROJECT_STRUCTURE_PROPORTION_PROPERTY = "android.project.structure.proportion";
        float proportion;
        String lastSelectedConfigurable;

        UiState(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable$UiState", "<init>"));
            }
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
            this.lastSelectedConfigurable = propertiesComponent.getValue(ANDROID_PROJECT_STRUCTURE_LAST_SELECTED_PROPERTY);
            this.proportion = UiState.toFloat(propertiesComponent.getValue(ANDROID_PROJECT_STRUCTURE_PROPORTION_PROPERTY));
        }

        private static float toFloat(@Nullable String val) {
            if (val != null) {
                try {
                    return Float.parseFloat(val);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0.15f;
        }

        void storeValues(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable$UiState", "storeValues"));
            }
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
            propertiesComponent.setValue(ANDROID_PROJECT_STRUCTURE_LAST_SELECTED_PROPERTY, this.lastSelectedConfigurable);
            propertiesComponent.setValue(ANDROID_PROJECT_STRUCTURE_PROPORTION_PROPERTY, String.valueOf(this.proportion));
        }
    }

    private class SidePanel
    extends JPanel {
        @NotNull
        private final JBList myList;
        @NotNull
        private final DefaultListModel myListModel;
        private int myFirstModuleIndex;

        SidePanel() {
            super(new BorderLayout());
            this.myListModel = new DefaultListModel();
            this.myFirstModuleIndex = 0;
            this.myList = new JBList((ListModel)this.myListModel);
            ListItemDescriptor descriptor = new ListItemDescriptor(){

                @Nullable
                public String getTextFor(Object value) {
                    if (value instanceof Configurable) {
                        return ((Configurable)value).getDisplayName();
                    }
                    return value != null ? value.toString() : "";
                }

                @Nullable
                public String getTooltipFor(Object value) {
                    if (value instanceof AndroidModuleConfigurable) {
                        Module module = (Module)((AndroidModuleConfigurable)((Object)value)).getEditableObject();
                        return new File(module.getModuleFilePath()).getAbsolutePath();
                    }
                    return null;
                }

                @Nullable
                public Icon getIconFor(Object value) {
                    if (value instanceof AndroidModuleConfigurable) {
                        Module module = (Module)((AndroidModuleConfigurable)((Object)value)).getEditableObject();
                        return module.isDisposed() ? AllIcons.Nodes.Module : GradleUtil.getModuleIcon(module);
                    }
                    return null;
                }

                public boolean hasSeparatorAboveOf(Object value) {
                    return SidePanel.this.myListModel.indexOf(value) == SidePanel.this.myFirstModuleIndex;
                }

                @Nullable
                public String getCaptionAboveOf(Object value) {
                    return this.hasSeparatorAboveOf(value) ? "Modules" : null;
                }
            };
            this.myList.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer(descriptor));
            this.myList.setSelectionMode(0);
            this.myList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    Object selection = SidePanel.this.myList.getSelectedValue();
                    if (selection instanceof Configurable) {
                        AndroidProjectStructureConfigurable.this.selectConfigurable((Configurable)selection, true);
                    }
                }
            });
            this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myList), "Center");
            if (!AndroidProjectStructureConfigurable.this.myProject.isDefault()) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add(this.createAddAction());
                group.add((AnAction)new DeleteModuleAction(this));
                JComponent toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
                this.add((Component)toolbar, "North");
            }
        }

        private void reset() {
            this.myListModel.clear();
            this.myFirstModuleIndex = 0;
            for (Configurable configurable : AndroidProjectStructureConfigurable.this.myConfigurables) {
                this.myListModel.addElement(configurable);
                if (configurable instanceof AndroidModuleConfigurable) continue;
                this.myFirstModuleIndex = this.myListModel.size();
            }
        }

        @NotNull
        private AnAction createAddAction() {
            AndroidNewModuleAction action = new AndroidNewModuleAction("New Module", null, IconUtil.getAddIcon());
            Keymap active = KeymapManager.getInstance().getActiveKeymap();
            if (active != null) {
                Shortcut[] shortcuts = active.getShortcuts("NewElement");
                action.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), this);
            }
            AndroidNewModuleAction androidNewModuleAction = action;
            if (androidNewModuleAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable$SidePanel", "createAddAction"));
            }
            return androidNewModuleAction;
        }

        private int getModuleCount() {
            int count = 0;
            for (Configurable configurable : AndroidProjectStructureConfigurable.this.myConfigurables) {
                if (!(configurable instanceof AndroidModuleConfigurable)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension original = super.getMinimumSize();
            return new Dimension(Math.max(original.width, 100), original.height);
        }

        @Nullable
        AndroidModuleConfigurable select(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/AndroidProjectStructureConfigurable$SidePanel", "select"));
            }
            for (int i = 0; i < this.myListModel.size(); ++i) {
                Object object = this.myListModel.elementAt(i);
                if (!(object instanceof AndroidModuleConfigurable) || ((AndroidModuleConfigurable)((Object)object)).getEditableObject() != module) continue;
                this.myList.setSelectedValue(object, true);
                return (AndroidModuleConfigurable)((Object)object);
            }
            return null;
        }

        void selectSdk() {
            this.myList.setSelectedValue((Object)AndroidProjectStructureConfigurable.this.mySdksConfigurable, true);
        }
    }

    private class MainPanel
    extends JPanel
    implements DataProvider {
        MainPanel() {
            super(new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (KEY.is(dataId)) {
                return AndroidProjectStructureConfigurable.this;
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(1024, 768);
        }
    }
}

