/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.legacy.ILegacyPullParser;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.idea.rendering.LayoutPullParserFactory;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.utils.XmlUtils;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

public class MenuLayoutParserFactory
extends LayoutPullParserFactory {
    @NotNull
    private static final String FRAME_LAYOUT_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<FrameLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"match_parent\" />\n";
    @NotNull
    private final RenderService myRenderService;

    public MenuLayoutParserFactory(@NotNull RenderService renderService) {
        if (renderService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderService", "com/android/tools/idea/rendering/MenuLayoutParserFactory", "<init>"));
        }
        assert (renderService.supportsCapability(12)) : "Action Bar not supported.";
        this.myRenderService = renderService;
    }

    @NotNull
    public ILayoutPullParser render() {
        Document frameLayoutDocument = XmlUtils.parseDocumentSilently((String)FRAME_LAYOUT_XML, (boolean)true);
        if (frameLayoutDocument == null) {
            ILegacyPullParser iLegacyPullParser = MenuLayoutParserFactory.createEmptyParser();
            if (iLegacyPullParser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/MenuLayoutParserFactory", "render"));
            }
            return iLegacyPullParser;
        }
        String resourceName = ResourceHelper.getResourceName((PsiFile)this.myRenderService.getPsiFile());
        this.myRenderService.getLayoutlibCallback().getActionBarCallback().setMenuIdNames(Collections.singletonList(resourceName));
        HashMap viewCookies = Maps.newHashMap();
        DomPullParser domPullParser = new DomPullParser(frameLayoutDocument.getDocumentElement()).setViewCookies(viewCookies);
        if (domPullParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/MenuLayoutParserFactory", "render"));
        }
        return domPullParser;
    }
}

