/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.actions.AndroidActionGroupRemover;
import com.android.tools.idea.actions.AndroidActionRemover;
import com.android.tools.idea.actions.AndroidImportModuleAction;
import com.android.tools.idea.actions.AndroidImportProjectAction;
import com.android.tools.idea.actions.AndroidMakeModuleAction;
import com.android.tools.idea.actions.AndroidMakeProjectAction;
import com.android.tools.idea.actions.AndroidNewModuleAction;
import com.android.tools.idea.actions.AndroidNewModuleInGroupAction;
import com.android.tools.idea.actions.AndroidNewProjectAction;
import com.android.tools.idea.actions.AndroidRebuildProjectAction;
import com.android.tools.idea.actions.AndroidTemplateProjectSettingsGroup;
import com.android.tools.idea.actions.AndroidTemplateProjectStructureAction;
import com.android.tools.idea.actions.CreateLibraryFromFilesAction;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.android.tools.idea.run.ArrayMapRenderer;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.startup.AndroidCodeStyleSettingsModifier;
import com.android.tools.idea.welcome.AndroidStudioWelcomeScreenProvider;
import com.android.tools.idea.welcome.FirstRunWizardMode;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.actions.TemplateProjectSettingsGroup;
import com.intellij.ide.projectView.actions.MarkRootGroup;
import com.intellij.ide.projectView.impl.MoveModuleToGroupTopLevel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidStudioSpecificInitializer
implements Runnable {
    public static final int GRADLE_DAEMON_TIMEOUT_MS = -1;
    private static final Logger LOG;
    private static final List<String> IDE_SETTINGS_TO_REMOVE;
    @NonNls
    private static final String USE_IDEA_NEW_PROJECT_WIZARDS = "use.idea.newProjectWizard";
    @NonNls
    private static final String USE_JPS_MAKE_ACTIONS = "use.idea.jpsMakeActions";
    @NonNls
    private static final String USE_IDEA_NEW_FILE_POPUPS = "use.idea.newFilePopupActions";
    @NonNls
    private static final String USE_IDEA_PROJECT_STRUCTURE = "use.idea.projectStructure";
    @NonNls
    public static final String ENABLE_EXPERIMENTAL_ACTIONS = "enable.experimental.actions";
    @NonNls
    private static final String ANDROID_SDK_FOLDER_NAME = "sdk";
    private static final String[] ANDROID_SDK_RELATIVE_PATHS;

    public static boolean isAndroidStudio() {
        return "AndroidStudio".equals(PlatformUtils.getPlatformPrefix());
    }

    @Override
    public void run() {
        CodeStyleSettings settings;
        AndroidStudioSpecificInitializer.checkInstallation();
        AndroidStudioSpecificInitializer.cleanUpIdePreferences();
        if (!Boolean.getBoolean(USE_IDEA_NEW_PROJECT_WIZARDS)) {
            AndroidStudioSpecificInitializer.replaceIdeaNewProjectActions();
        }
        if (!Boolean.getBoolean(USE_IDEA_PROJECT_STRUCTURE)) {
            AndroidStudioSpecificInitializer.replaceProjectStructureActions();
        }
        if (!Boolean.getBoolean(USE_JPS_MAKE_ACTIONS)) {
            AndroidStudioSpecificInitializer.replaceIdeaMakeActions();
        }
        if (!Boolean.getBoolean(USE_IDEA_NEW_FILE_POPUPS)) {
            AndroidStudioSpecificInitializer.hideIdeaNewFilePopupActions();
        }
        try {
            AndroidStudioSpecificInitializer.setupSdks();
        }
        catch (Exception e) {
            LOG.error("Unexpected error while setting up SDKs: ", (Throwable)e);
        }
        AndroidStudioSpecificInitializer.registerAppClosing();
        CodeStyleScheme scheme = CodeStyleSchemes.getInstance().getDefaultScheme();
        if (scheme != null && (settings = scheme.getCodeStyleSettings()) != null) {
            AndroidCodeStyleSettingsModifier.modify(settings);
        }
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getScheme("Default");
        TextAttributes textAttributes = colorsScheme.getAttributes(HighlighterColors.TEXT);
        TextAttributes xmlTagAttributes = colorsScheme.getAttributes(XmlHighlighterColors.XML_TAG);
        xmlTagAttributes.setBackgroundColor(textAttributes.getBackgroundColor());
        NodeRendererSettings.getInstance().addPluginRenderer((NodeRenderer)new ArrayMapRenderer("android.util.ArrayMap"));
        NodeRendererSettings.getInstance().addPluginRenderer((NodeRenderer)new ArrayMapRenderer("android.support.v4.util.ArrayMap"));
        AndroidStudioSpecificInitializer.checkAndSetAndroidSdkSources();
    }

    private static void checkInstallation() {
        String studioHome = PathManager.getHomePath();
        if (StringUtil.isEmpty((String)studioHome)) {
            LOG.info("Unable to find Studio home directory");
            return;
        }
        File studioHomePath = new File(FileUtil.toSystemDependentName((String)studioHome));
        if (!studioHomePath.isDirectory()) {
            LOG.info(String.format("The path '%1$s' does not belong to an existing directory", studioHomePath.getPath()));
            return;
        }
        File androidPluginLibFolderPath = new File(studioHomePath, FileUtil.join((String[])new String[]{"plugins", "android", "lib"}));
        if (!androidPluginLibFolderPath.isDirectory()) {
            LOG.info(String.format("The path '%1$s' does not belong to an existing directory", androidPluginLibFolderPath.getPath()));
            return;
        }
        String cause = null;
        File[] children = FileUtil.notNullize((File[])androidPluginLibFolderPath.listFiles());
        if (AndroidStudioSpecificInitializer.hasMoreThanOneBuilderModelFile(children)) {
            cause = "(Found multiple versions of builder-model-*.jar in plugins/android/lib.)";
        } else if (new File(studioHomePath, FileUtil.join((String[])new String[]{"plugins", "android-designer"})).exists()) {
            cause = "(Found plugins/android-designer which should not be present.)";
        }
        if (cause != null) {
            String msg = "Your Android Studio installation is corrupt and will not work properly.\n" + cause + "\n" + "This usually happens if Android Studio is extracted into an existing older version.\n\n" + "Please reinstall (and make sure the new installation directory is empty first.)";
            String title = "Corrupt Installation";
            int option = Messages.showDialog((String)msg, (String)title, (String[])new String[]{"Quit", "Proceed Anyway"}, (int)0, (Icon)Messages.getErrorIcon());
            if (option == 0) {
                ApplicationManagerEx.getApplicationEx().exit();
            }
        }
    }

    @VisibleForTesting
    static boolean hasMoreThanOneBuilderModelFile(@NotNull File[] libraryFiles) {
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/android/tools/idea/startup/AndroidStudioSpecificInitializer", "hasMoreThanOneBuilderModelFile"));
        }
        int builderModelFileCount = 0;
        for (File file : libraryFiles) {
            String fileName = file.getName();
            if (!fileName.startsWith("builder-model-") || !"jar".equals(FileUtilRt.getExtension((String)fileName)) || ++builderModelFileCount <= 1) continue;
            return true;
        }
        return false;
    }

    private static void cleanUpIdePreferences() {
        try {
            ExtensionPoint ideConfigurable = Extensions.getRootArea().getExtensionPoint(Configurable.APPLICATION_CONFIGURABLE);
            GradleUtil.cleanUpPreferences((ExtensionPoint<ConfigurableEP<Configurable>>)ideConfigurable, IDE_SETTINGS_TO_REMOVE);
        }
        catch (Throwable e) {
            LOG.info("Failed to clean up IDE preferences", e);
        }
    }

    private static void replaceIdeaNewProjectActions() {
        AndroidStudioSpecificInitializer.replaceAction("NewProject", new AndroidNewProjectAction());
        AndroidStudioSpecificInitializer.replaceAction("NewModule", new AndroidNewModuleAction());
        AndroidStudioSpecificInitializer.replaceAction("NewModuleInGroup", new AndroidNewModuleInGroupAction());
        AndroidStudioSpecificInitializer.replaceAction("ImportProject", new AndroidImportProjectAction());
        AndroidStudioSpecificInitializer.replaceAction("CreateLibraryFromFile", new CreateLibraryFromFilesAction());
        AndroidStudioSpecificInitializer.replaceAction("ImportModule", new AndroidImportModuleAction());
        AndroidStudioSpecificInitializer.hideAction("GenerateAntBuild", "Generate Ant Build...");
        AndroidStudioSpecificInitializer.hideAction("AddFrameworkSupport", "Add Framework Support...");
        AndroidStudioSpecificInitializer.hideAction("BuildArtifact", "Build Artifacts...");
        AndroidStudioSpecificInitializer.hideAction("RunTargetAction", "Run Ant Target");
        AndroidStudioSpecificInitializer.replaceProjectPopupActions();
        AndroidStudioSpecificInitializer.replaceIdeaWelcomeScreenActions();
    }

    private static void replaceIdeaWelcomeScreenActions() {
        ActionManager am = ActionManager.getInstance();
        AndroidNewProjectAction welcomeScreenNewProject = new AndroidNewProjectAction();
        welcomeScreenNewProject.getTemplatePresentation().setText("Start a new Android Studio project");
        AndroidStudioSpecificInitializer.replaceAction("WelcomeScreen.CreateNewProject", welcomeScreenNewProject);
        AndroidImportProjectAction welcomeScreenImportProject = new AndroidImportProjectAction();
        welcomeScreenImportProject.getTemplatePresentation().setText("Import Non-Android Studio project");
        AndroidStudioSpecificInitializer.replaceAction("WelcomeScreen.ImportProject", welcomeScreenImportProject);
        AndroidStudioSpecificInitializer.moveAction("WelcomeScreen.ImportProject", "WelcomeScreen.QuickStart.IDEA", "WelcomeScreen.QuickStart", new Constraints(Anchor.AFTER, "WelcomeScreen.GetFromVcs"));
        am.getAction("WelcomeScreen.OpenProject").getTemplatePresentation().setText("Open an existing Android Studio project");
        am.getAction("WelcomeScreen.GetFromVcs").getTemplatePresentation().setText("Check out project from Version Control");
    }

    private static void replaceProjectStructureActions() {
        DefaultActionGroup projectSettingsGroup;
        AnAction[] children;
        AndroidTemplateProjectStructureAction showDefaultProjectStructureAction = new AndroidTemplateProjectStructureAction();
        showDefaultProjectStructureAction.getTemplatePresentation().setText("Default Project Structure...");
        AndroidStudioSpecificInitializer.replaceAction("TemplateProjectStructure", showDefaultProjectStructureAction);
        ActionManager am = ActionManager.getInstance();
        AnAction action = am.getAction("WelcomeScreen.Configure.IDEA");
        if (action instanceof DefaultActionGroup && (children = (projectSettingsGroup = (DefaultActionGroup)action).getChildren(null)).length == 1 && children[0] instanceof TemplateProjectSettingsGroup) {
            projectSettingsGroup.replaceAction(children[0], (AnAction)new AndroidTemplateProjectSettingsGroup());
        }
    }

    private static void replaceIdeaMakeActions() {
        AndroidStudioSpecificInitializer.replaceAction("CompileDirty", new AndroidMakeProjectAction());
        AndroidStudioSpecificInitializer.replaceAction("MakeModule", new AndroidMakeModuleAction());
        AndroidStudioSpecificInitializer.replaceAction("CompileProject", new AndroidRebuildProjectAction());
        AndroidStudioSpecificInitializer.hideAction("Compile", "Compile Module(s)");
    }

    private static void replaceAction(String actionId, AnAction newAction) {
        ActionManager am = ActionManager.getInstance();
        AnAction oldAction = am.getAction(actionId);
        if (oldAction != null) {
            newAction.getTemplatePresentation().setIcon(oldAction.getTemplatePresentation().getIcon());
            am.unregisterAction(actionId);
        }
        am.registerAction(actionId, newAction);
    }

    private static void moveAction(@NotNull String actionId, @NotNull String oldGroupId, @NotNull String groupId, @NotNull Constraints constraints) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/android/tools/idea/startup/AndroidStudioSpecificInitializer", "moveAction"));
        }
        if (oldGroupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldGroupId", "com/android/tools/idea/startup/AndroidStudioSpecificInitializer", "moveAction"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/startup/AndroidStudioSpecificInitializer", "moveAction"));
        }
        if (constraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/android/tools/idea/startup/AndroidStudioSpecificInitializer", "moveAction"));
        }
        ActionManager am = ActionManager.getInstance();
        AnAction action = am.getAction(actionId);
        AnAction group = am.getAction(groupId);
        AnAction oldGroup = am.getAction(oldGroupId);
        if (action != null && oldGroup != null && group != null && oldGroup instanceof DefaultActionGroup && group instanceof DefaultActionGroup) {
            ((DefaultActionGroup)oldGroup).getChildren(null);
            ((DefaultActionGroup)oldGroup).remove(action);
            ((DefaultActionGroup)group).add(action, constraints);
        }
    }

    private static void hideAction(@NotNull String actionId, @NotNull String backupText) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/android/tools/idea/startup/AndroidStudioSpecificInitializer", "hideAction"));
        }
        if (backupText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backupText", "com/android/tools/idea/startup/AndroidStudioSpecificInitializer", "hideAction"));
        }
        AnAction oldAction = ActionManager.getInstance().getAction(actionId);
        if (oldAction != null) {
            AndroidActionRemover newAction = new AndroidActionRemover(oldAction, backupText);
            AndroidStudioSpecificInitializer.replaceAction(actionId, newAction);
        }
    }

    private static void replaceProjectPopupActions() {
        ArrayDeque<Pair> stack = new ArrayDeque<Pair>();
        stack.add(Pair.of((Object)null, (Object)ActionManager.getInstance().getAction("ProjectViewPopupMenu")));
        while (!stack.isEmpty()) {
            Pair entry = (Pair)stack.pop();
            DefaultActionGroup parent = (DefaultActionGroup)entry.getFirst();
            AnAction action = (AnAction)entry.getSecond();
            if (action instanceof DefaultActionGroup) {
                DefaultActionGroup actionGroup = (DefaultActionGroup)action;
                for (AnAction child : actionGroup.getChildActionsOrStubs()) {
                    stack.push(Pair.of((Object)actionGroup, (Object)child));
                }
            }
            if (action instanceof MoveModuleToGroupTopLevel) {
                parent.remove(action);
                parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action, "Move Module to Group"), new Constraints(Anchor.AFTER, "OpenModuleSettings"));
                continue;
            }
            if (!(action instanceof MarkRootGroup)) continue;
            parent.remove(action);
            parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action, "Mark Directory As"), new Constraints(Anchor.AFTER, "OpenModuleSettings"));
        }
    }

    private static void setupSdks() {
        File androidHome = DefaultSdks.getDefaultAndroidHome();
        if (androidHome != null) {
            return;
        }
        if (AndroidPlugin.isGuiTestingMode()) {
            return;
        }
        final Sdk sdk = AndroidStudioSpecificInitializer.findFirstCompatibleAndroidSdk();
        if (sdk != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    String androidHome = sdk.getHomePath();
                    assert (androidHome != null);
                    DefaultSdks.createAndroidSdksForAllTargets(new File(FileUtil.toSystemDependentName((String)androidHome)));
                }
            });
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                File androidSdkPath = AndroidStudioSpecificInitializer.getAndroidSdkPath();
                if (androidSdkPath == null) {
                    return;
                }
                FirstRunWizardMode wizardMode = AndroidStudioWelcomeScreenProvider.getWizardMode();
                boolean promptSdkSelection = wizardMode == null;
                Sdk sdk = AndroidSdkUtils.createNewAndroidPlatform(androidSdkPath.getPath(), promptSdkSelection);
                if (sdk != null && sdk.getName().startsWith("Android ")) {
                    Sdk jdk;
                    SdkModificator sdkModificator = sdk.getSdkModificator();
                    sdkModificator.setName("Android " + sdk.getName().substring("Android ".length()));
                    sdkModificator.commitChanges();
                    AndroidSdkAdditionalData additionalData = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData();
                    if (additionalData != null && (jdk = additionalData.getJavaSdk()) != null) {
                        sdkModificator = jdk.getSdkModificator();
                        sdkModificator.setName("JDK");
                        sdkModificator.commitChanges();
                    }
                    DefaultSdks.createAndroidSdksForAllTargets(androidSdkPath);
                }
            }
        });
    }

    @Nullable
    private static Sdk findFirstCompatibleAndroidSdk() {
        List<Sdk> sdks = AndroidSdkUtils.getAllAndroidSdks();
        for (Sdk sdk : sdks) {
            String sdkPath = sdk.getHomePath();
            if (!VersionCheck.isCompatibleVersion(sdkPath)) continue;
            return sdk;
        }
        if (!sdks.isEmpty()) {
            return sdks.get(0);
        }
        return null;
    }

    @Nullable
    private static File getAndroidSdkPath() {
        String studioHome = PathManager.getHomePath();
        if (StringUtil.isEmpty((String)studioHome)) {
            LOG.info("Unable to find Studio home directory");
        } else {
            LOG.info(String.format("Found Studio home directory at: '%1$s'", studioHome));
            for (String path : ANDROID_SDK_RELATIVE_PATHS) {
                File dir = new File(studioHome, path);
                String absolutePath = FileUtil.toCanonicalPath((String)dir.getAbsolutePath());
                LOG.info(String.format("Looking for Android SDK at '%1$s'", absolutePath));
                if (!AndroidSdkType.getInstance().isValidSdkHome(absolutePath)) continue;
                LOG.info(String.format("Found Android SDK at '%1$s'", absolutePath));
                return new File(absolutePath);
            }
        }
        LOG.info("Unable to locate SDK within the Android studio installation.");
        String androidHomeValue = System.getenv("ANDROID_HOME");
        String msg = String.format("Checking if ANDROID_HOME is set: '%1$s' is '%2$s'", "ANDROID_HOME", androidHomeValue);
        LOG.info(msg);
        if (!StringUtil.isEmpty((String)androidHomeValue) && AndroidSdkType.getInstance().isValidSdkHome(androidHomeValue)) {
            LOG.info("Using Android SDK specified by the environment variable.");
            return new File(FileUtil.toSystemDependentName((String)androidHomeValue));
        }
        String sdkPath = AndroidStudioSpecificInitializer.getLastSdkPathUsedByAndroidTools();
        msg = !StringUtil.isEmpty((String)sdkPath) && AndroidSdkType.getInstance().isValidSdkHome(androidHomeValue) ? String.format("Last SDK used by Android tools: '%1$s'", sdkPath) : "Unable to locate last SDK used by Android tools";
        LOG.info(msg);
        return sdkPath == null ? null : new File(FileUtil.toSystemDependentName((String)sdkPath));
    }

    @Nullable
    private static String getLastSdkPathUsedByAndroidTools() {
        String userHome = SystemProperties.getUserHome();
        if (userHome == null) {
            return null;
        }
        File f = new File(new File(userHome, ".android"), "ddms.cfg");
        if (!f.exists()) {
            return null;
        }
        try {
            Properties properties = PropertiesUtil.getProperties(f);
            return properties.getProperty("lastSdkPath");
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void hideIdeaNewFilePopupActions() {
        AndroidStudioSpecificInitializer.hideAction("NewHtmlFile", "HTML File");
        AndroidStudioSpecificInitializer.hideAction("NewPackageInfo", "package-info.java");
        AndroidStudioSpecificInitializer.hideAction("NewForm", "GUI Form");
        AndroidStudioSpecificInitializer.hideAction("NewDialog", "Dialog");
        AndroidStudioSpecificInitializer.hideAction("NewFormSnapshot", "Form Snapshot");
        AndroidStudioSpecificInitializer.replaceAction("Groovy.NewClass", (AnAction)new EmptyAction());
        AndroidStudioSpecificInitializer.replaceAction("Groovy.NewScript", (AnAction)new EmptyAction());
    }

    private static void registerAppClosing() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            public void appClosing() {
                GradleUtil.stopAllGradleDaemons();
            }
        });
    }

    private static void checkAndSetAndroidSdkSources() {
        for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
            AndroidStudioSpecificInitializer.checkAndSetSources(sdk);
        }
    }

    private static void checkAndSetSources(@NotNull Sdk sdk) {
        AndroidSdkAdditionalData androidSdkData;
        AndroidPlatform platform;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ANDROID_SDK_FOLDER_NAME, "com/android/tools/idea/startup/AndroidStudioSpecificInitializer", "checkAndSetSources"));
        }
        VirtualFile[] storedSources = sdk.getRootProvider().getFiles(OrderRootType.SOURCES);
        if (storedSources.length > 0) {
            return;
        }
        SdkAdditionalData sdkData = sdk.getSdkAdditionalData();
        if (sdkData instanceof AndroidSdkAdditionalData && (platform = (androidSdkData = (AndroidSdkAdditionalData)sdkData).getAndroidPlatform()) != null) {
            SdkModificator sdkModificator = sdk.getSdkModificator();
            IAndroidTarget target = platform.getTarget();
            AndroidSdkUtils.findAndSetPlatformSources(target, sdkModificator);
            sdkModificator.commitChanges();
        }
    }

    static {
        System.setProperty("external.system.remote.process.idle.ttl.ms", String.valueOf(-1));
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            System.setProperty("gradle.disable.enhanced.tooling.api", "true");
        }
        LOG = Logger.getInstance((String)"#com.android.tools.idea.startup.AndroidStudioSpecificInitializer");
        IDE_SETTINGS_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"org.jetbrains.plugins.javaFX.JavaFxSettingsConfigurable", "org.intellij.plugins.xpathView.XPathConfigurable", "org.intellij.lang.xpath.xslt.impl.XsltConfigImpl$UIImpl"});
        ANDROID_SDK_RELATIVE_PATHS = new String[]{ANDROID_SDK_FOLDER_NAME, File.separator + ".." + File.separator + ANDROID_SDK_FOLDER_NAME};
    }
}

