/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.manifmerger.ICallback;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.templates.FmActivityToLayoutMethod;
import com.android.tools.idea.templates.FmCamelCaseToUnderscoreMethod;
import com.android.tools.idea.templates.FmClassNameToResourceMethod;
import com.android.tools.idea.templates.FmEscapePropertyValueMethod;
import com.android.tools.idea.templates.FmEscapeXmlAttributeMethod;
import com.android.tools.idea.templates.FmEscapeXmlStringMethod;
import com.android.tools.idea.templates.FmExtractLettersMethod;
import com.android.tools.idea.templates.FmHasDependencyMethod;
import com.android.tools.idea.templates.FmLayoutToActivityMethod;
import com.android.tools.idea.templates.FmSlashedPackageNameMethod;
import com.android.tools.idea.templates.FmUnderscoreToCamelCaseMethod;
import com.android.tools.idea.templates.GradleFileMerger;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.TypedVariable;
import com.android.utils.ILogger;
import com.android.utils.SdkUtils;
import com.android.utils.StdLogger;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.SystemProperties;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Template {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.Template");
    static final int CURRENT_FORMAT = 4;
    private static final String DATA_ROOT = "root";
    public static final String TEMPLATE_XML_NAME = "template.xml";
    public static final String GRADLE_PROJECT_SETTINGS_FILE = "settings.gradle";
    private static final Pattern INCLUDE_PATTERN = Pattern.compile("(^|\\n)\\s*include +(':[^']+', *)*':[^']+'");
    private static final Pattern COMPILE_PATTERN = Pattern.compile("compile[ \\t]*'([^'\\n]+)'");
    private static final String INDENT = "    ";
    public static Exception ourMostRecentException;
    public static final String TAG_MERGE = "merge";
    public static final String TAG_EXECUTE = "execute";
    public static final String TAG_GLOBALS = "globals";
    public static final String TAG_GLOBAL = "global";
    public static final String TAG_PARAMETER = "parameter";
    public static final String TAG_COPY = "copy";
    public static final String TAG_INSTANTIATE = "instantiate";
    public static final String TAG_OPEN = "open";
    public static final String TAG_THUMB = "thumb";
    public static final String TAG_THUMBS = "thumbs";
    public static final String TAG_DEPENDENCY = "dependency";
    public static final String TAG_ICONS = "icons";
    public static final String TAG_MKDIR = "mkdir";
    public static final String ATTR_FORMAT = "format";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_DEFAULT = "default";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_MAVEN = "mavenUrl";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_HELP = "help";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_AT = "at";
    public static final String ATTR_CONSTRAINTS = "constraints";
    public static final String ATTR_VISIBILITY = "visibility";
    public static final String ATTR_ENABLED = "enabled";
    public static final String ATTR_SOURCE_URL = "href";
    public static final String ATTR_TEMPLATE_MERGE_STRATEGY = "templateMergeStrategy";
    public static final String VALUE_MERGE_STRATEGY_REPLACE = "replace";
    public static final String VALUE_MERGE_STRATEGY_PRESERVE = "preserve";
    public static final String CATEGORY_ACTIVITIES = "activities";
    public static final String CATEGORY_ACTIVITY = "Activity";
    public static final String CATEGORY_PROJECTS = "gradle-projects";
    public static final String CATEGORY_OTHER = "other";
    public static final String CATEGORY_APPLICATION = "Application";
    public static final String BLOCK_DEPENDENCIES = "dependencies";
    private final List<File> myFilesToOpen;
    private final File myTemplateRoot;
    private File myOutputRoot;
    private File myModuleRoot;
    private final MyTemplateLoader myLoader;
    private TemplateMetadata myMetadata;
    private Project myProject;
    private boolean myNeedsGradleSync;

    @NotNull
    public static Template createFromPath(@NotNull File rootPath) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/android/tools/idea/templates/Template", "createFromPath"));
        }
        Template template = new Template(rootPath);
        if (template == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createFromPath"));
        }
        return template;
    }

    @NotNull
    public static Template createFromName(@NotNull String category, @NotNull String name) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/android/tools/idea/templates/Template", "createFromName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_NAME, "com/android/tools/idea/templates/Template", "createFromName"));
        }
        TemplateManager manager = TemplateManager.getInstance();
        List<File> templates = manager.getTemplates(category);
        for (File file : templates) {
            if (!file.getName().equals(name) || !category.equals(file.getParentFile().getName())) continue;
            Template template = new Template(file);
            if (template == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createFromName"));
            }
            return template;
        }
        Template template = new Template(new File(TemplateManager.getTemplateRootFolder(), category + File.separator + name));
        if (template == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createFromName"));
        }
        return template;
    }

    private Template(@NotNull File rootPath) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/android/tools/idea/templates/Template", "<init>"));
        }
        this.myFilesToOpen = Lists.newArrayList();
        this.myTemplateRoot = rootPath;
        this.myLoader = new MyTemplateLoader(this.myTemplateRoot.getPath());
    }

    @Deprecated
    public void render(@NotNull File outputRootPath, @NotNull File moduleRootPath, @NotNull Map<String, Object> args) {
        if (outputRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputRootPath", "com/android/tools/idea/templates/Template", "render"));
        }
        if (moduleRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootPath", "com/android/tools/idea/templates/Template", "render"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "render"));
        }
        this.render(outputRootPath, moduleRootPath, args, null);
    }

    public void render(@NotNull File outputRootPath, @NotNull File moduleRootPath, @NotNull Map<String, Object> args, @Nullable Project project) {
        List dependencyList;
        Object maybeDependencyList;
        if (outputRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputRootPath", "com/android/tools/idea/templates/Template", "render"));
        }
        if (moduleRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootPath", "com/android/tools/idea/templates/Template", "render"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "render"));
        }
        assert (outputRootPath.isDirectory()) : outputRootPath;
        this.myFilesToOpen.clear();
        this.myOutputRoot = outputRootPath;
        this.myModuleRoot = moduleRootPath;
        this.myProject = project;
        Map<String, Object> paramMap = Template.createParameterMap(args);
        Template.enforceParameterTypes(this.getMetadata(), args);
        Configuration freemarker = new Configuration();
        freemarker.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        freemarker.setTemplateLoader((TemplateLoader)this.myLoader);
        this.processFile(freemarker, new File(TEMPLATE_XML_NAME), paramMap);
        if (paramMap.containsKey("dependencyList") && (maybeDependencyList = paramMap.get("dependencyList")) instanceof List && !(dependencyList = (List)maybeDependencyList).isEmpty()) {
            try {
                this.mergeDependenciesIntoFile(freemarker, paramMap, GradleUtil.getGradleBuildFilePath(moduleRootPath));
                this.myNeedsGradleSync = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.myNeedsGradleSync && this.myProject != null) {
            GradleProjectImporter.getInstance().requestProjectSync(this.myProject, null);
        }
    }

    @NotNull
    public File getRootPath() {
        File file = this.myTemplateRoot;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getRootPath"));
        }
        return file;
    }

    @Nullable
    public TemplateMetadata getMetadata() {
        if (this.myMetadata == null) {
            this.myMetadata = TemplateManager.getInstance().getTemplate(this.myTemplateRoot);
        }
        return this.myMetadata;
    }

    @NotNull
    public List<File> getFilesToOpen() {
        List<File> list = this.myFilesToOpen;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getFilesToOpen"));
        }
        return list;
    }

    @NotNull
    public static Map<String, Object> createParameterMap(@NotNull Map<String, Object> args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "createParameterMap"));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("slashedPackageName", new FmSlashedPackageNameMethod());
        paramMap.put("camelCaseToUnderscore", new FmCamelCaseToUnderscoreMethod());
        paramMap.put("underscoreToCamelCase", new FmUnderscoreToCamelCaseMethod());
        paramMap.put("activityToLayout", new FmActivityToLayoutMethod());
        paramMap.put("layoutToActivity", new FmLayoutToActivityMethod());
        paramMap.put("classToResource", new FmClassNameToResourceMethod());
        paramMap.put("escapeXmlAttribute", new FmEscapeXmlAttributeMethod());
        paramMap.put("escapeXmlText", new FmEscapeXmlStringMethod());
        paramMap.put("escapeXmlString", new FmEscapeXmlStringMethod());
        paramMap.put("escapePropertyValue", new FmEscapePropertyValueMethod());
        paramMap.put("extractLetters", new FmExtractLettersMethod());
        paramMap.put("hasDependency", new FmHasDependencyMethod(paramMap));
        paramMap.put("dependencyList", new LinkedList());
        if (ApplicationManager.getApplication() != null && TemplateManager.getTemplateRootFolder() != null) {
            paramMap.put("templateRoot", TemplateManager.getTemplateRootFolder().getAbsolutePath());
        }
        paramMap.putAll(args);
        HashMap<String, Object> hashMap = paramMap;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createParameterMap"));
        }
        return hashMap;
    }

    private static void enforceParameterTypes(@NotNull TemplateMetadata metadata, @NotNull Map<String, Object> args) {
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/templates/Template", "enforceParameterTypes"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "enforceParameterTypes"));
        }
        for (Parameter p : metadata.getParameters()) {
            Object o = args.get(p.id);
            if (o == null) continue;
            switch (p.type) {
                case STRING: {
                    if (o instanceof String) break;
                    args.put(p.id, o.toString());
                    break;
                }
                case BOOLEAN: {
                    if (o instanceof Boolean) break;
                    args.put(p.id, Boolean.parseBoolean(o.toString()));
                    break;
                }
                case ENUM: {
                    break;
                }
                case SEPARATOR: {
                    break;
                }
                case EXTERNAL: {
                    break;
                }
            }
        }
        Template.convertApisToInt(args);
    }

    public static void convertApisToInt(@NotNull Map<String, Object> args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "convertApisToInt"));
        }
        Template.convertToInt("buildApi", args);
        Template.convertToInt("minApiLevel", args);
        Template.convertToInt("targetApi", args);
    }

    private static void convertToInt(@NotNull String key, @NotNull Map<String, Object> args) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/templates/Template", "convertToInt"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/Template", "convertToInt"));
        }
        Object value = args.get(key);
        if (value instanceof String) {
            Integer result;
            try {
                result = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                result = SdkVersionInfo.getApiByPreviewName((String)((String)value), (boolean)true);
            }
            args.put(key, result);
        }
    }

    private void processFile(final @NotNull Configuration freemarker, @NotNull File file, final @NotNull Map<String, Object> paramMap) {
        if (freemarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freemarker", "com/android/tools/idea/templates/Template", "processFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_FILE, "com/android/tools/idea/templates/Template", "processFile"));
        }
        if (paramMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/android/tools/idea/templates/Template", "processFile"));
        }
        try {
            String xml;
            if (Template.hasExtension(file, ".xml")) {
                xml = TemplateUtils.readTextFile(this.getTemplateFile(file));
                if (xml == null) {
                    return;
                }
            } else {
                this.myLoader.setTemplateFile(this.getTemplateFile(file));
                xml = Template.processFreemarkerTemplate(freemarker, paramMap, file.getName());
            }
            xml = XmlUtils.stripBom((String)xml);
            InputSource inputSource = new InputSource(new StringReader(xml));
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    if (Template.TAG_PARAMETER.equals(name)) {
                        String id = attributes.getValue(Template.ATTR_ID);
                        if (!paramMap.containsKey(id)) {
                            String type;
                            String value = attributes.getValue(Template.ATTR_DEFAULT);
                            Object mapValue = value;
                            if (value != null && !value.isEmpty() && "boolean".equals(type = attributes.getValue(Template.ATTR_TYPE))) {
                                mapValue = Boolean.valueOf(value);
                            }
                            paramMap.put(id, mapValue);
                        }
                    } else if (Template.TAG_GLOBAL.equals(name)) {
                        String id = attributes.getValue(Template.ATTR_ID);
                        if (!paramMap.containsKey(id)) {
                            paramMap.put(id, TypedVariable.parseGlobal(attributes));
                        }
                    } else if (Template.TAG_GLOBALS.equals(name)) {
                        File globalsFile = Template.getPath(attributes, Template.ATTR_FILE);
                        if (globalsFile != null) {
                            Template.this.processFile(freemarker, globalsFile, paramMap);
                        }
                    } else if (Template.TAG_EXECUTE.equals(name)) {
                        File recipeFile = Template.getPath(attributes, Template.ATTR_FILE);
                        if (recipeFile != null) {
                            Template.this.executeRecipeFile(freemarker, recipeFile, paramMap);
                        }
                    } else if (!(name.equals("template") || name.equals("category") || name.equals("option") || name.equals(Template.TAG_THUMBS) || name.equals(Template.TAG_THUMB) || name.equals(Template.TAG_ICONS) || name.equals(Template.TAG_DEPENDENCY) || name.equals("formfactor"))) {
                        LOG.error("WARNING: Unknown template directive " + name);
                    }
                }
            });
        }
        catch (Exception e) {
            ourMostRecentException = e;
            LOG.warn((Throwable)e);
        }
    }

    private void executeRecipeFile(final @NotNull Configuration freemarker, @NotNull File file, final @NotNull Map<String, Object> paramMap) {
        if (freemarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freemarker", "com/android/tools/idea/templates/Template", "executeRecipeFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_FILE, "com/android/tools/idea/templates/Template", "executeRecipeFile"));
        }
        if (paramMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/android/tools/idea/templates/Template", "executeRecipeFile"));
        }
        try {
            this.myLoader.setTemplateFile(this.getTemplateFile(file));
            String xml = Template.processFreemarkerTemplate(freemarker, paramMap, file.getName());
            xml = XmlUtils.stripBom((String)xml);
            InputSource inputSource = new InputSource(new StringReader(xml));
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    try {
                        boolean instantiate = Template.TAG_INSTANTIATE.equals(name);
                        if (Template.TAG_COPY.equals(name) || instantiate) {
                            File fromFile = Template.getPath(attributes, Template.ATTR_FROM);
                            File toFile = Template.getPath(attributes, Template.ATTR_TO);
                            if (toFile == null || toFile.getPath().isEmpty()) {
                                toFile = Template.getPath(attributes, Template.ATTR_FROM);
                                toFile = TemplateUtils.stripSuffix(toFile, ".ftl");
                            }
                            if (instantiate) {
                                Template.this.instantiate(freemarker, paramMap, fromFile, toFile);
                            } else {
                                Template.this.copyTemplateResource(fromFile, toFile);
                            }
                        } else if (Template.TAG_MERGE.equals(name)) {
                            File fromFile = Template.getPath(attributes, Template.ATTR_FROM);
                            File toFile = Template.getPath(attributes, Template.ATTR_TO);
                            if (toFile == null || toFile.getPath().isEmpty()) {
                                toFile = Template.getPath(attributes, Template.ATTR_FROM);
                                toFile = TemplateUtils.stripSuffix(toFile, ".ftl");
                            }
                            Template.this.merge(freemarker, paramMap, fromFile, toFile);
                        } else if (name.equals(Template.TAG_OPEN)) {
                            File relativePath = Template.getPath(attributes, Template.ATTR_FILE);
                            if (relativePath != null && !relativePath.getPath().isEmpty()) {
                                Template.this.myFilesToOpen.add(relativePath);
                            }
                        } else if (name.equals(Template.TAG_MKDIR)) {
                            File relativePath = Template.getPath(attributes, Template.ATTR_AT);
                            if (relativePath != null && !relativePath.getPath().isEmpty()) {
                                File targetFile = Template.this.getTargetFile(relativePath);
                                Template.checkedCreateDirectoryIfMissing(targetFile);
                            }
                        } else if (name.equals(Template.TAG_DEPENDENCY)) {
                            String url = attributes.getValue(Template.ATTR_MAVEN);
                            List dependencyList = (List)paramMap.get("dependencyList");
                            if (url != null) {
                                dependencyList.add(url);
                            }
                        } else if (!name.equals("recipe")) {
                            LOG.warn("WARNING: Unknown template directive " + name);
                        }
                    }
                    catch (Exception e) {
                        ourMostRecentException = e;
                        LOG.warn((Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            ourMostRecentException = e;
            LOG.warn((Throwable)e);
        }
    }

    private void merge(@NotNull Configuration freemarker, @NotNull Map<String, Object> paramMap, @NotNull File relativeFrom, @NotNull File to) throws IOException, TemplateException {
        String contents;
        String sourceText;
        if (freemarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freemarker", "com/android/tools/idea/templates/Template", TAG_MERGE));
        }
        if (paramMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/android/tools/idea/templates/Template", TAG_MERGE));
        }
        if (relativeFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeFrom", "com/android/tools/idea/templates/Template", TAG_MERGE));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_TO, "com/android/tools/idea/templates/Template", TAG_MERGE));
        }
        String targetText = null;
        if (!Template.hasExtension(to = this.getTargetFile(to), ".xml") && !Template.hasExtension(to, ".gradle")) {
            throw new RuntimeException("Only XML or Gradle files can be merged at this point: " + to);
        }
        if (to.exists()) {
            targetText = Files.toString((File)to, (Charset)Charsets.UTF_8);
        } else if (to.getParentFile() != null) {
            Template.checkedCreateDirectoryIfMissing(to.getParentFile());
        }
        if (targetText == null) {
            boolean instantiate = Template.hasExtension(relativeFrom, ".ftl");
            if (instantiate) {
                this.instantiate(freemarker, paramMap, relativeFrom, to);
            } else {
                this.copyTemplateResource(relativeFrom, to);
            }
            return;
        }
        File from = this.getFullPath(relativeFrom);
        if (Template.hasExtension(relativeFrom, ".ftl")) {
            this.myLoader.setTemplateFile(from);
            sourceText = Template.processFreemarkerTemplate(freemarker, paramMap, from.getName());
        } else {
            sourceText = TemplateUtils.readTextFile(from);
            if (sourceText == null) {
                return;
            }
        }
        if (to.getName().equals(GRADLE_PROJECT_SETTINGS_FILE)) {
            contents = Template.mergeGradleSettingsFile(sourceText, targetText);
            this.myNeedsGradleSync = true;
        } else if (to.getName().equals("build.gradle")) {
            contents = GradleFileMerger.mergeGradleFiles(sourceText, targetText, this.myProject);
            this.myNeedsGradleSync = true;
        } else if (Template.hasExtension(to, ".xml")) {
            contents = Template.mergeXml(sourceText, targetText, to, paramMap);
        } else {
            throw new RuntimeException("Only XML or Gradle settings files can be merged at this point: " + to);
        }
        this.writeFile(contents, to);
    }

    private static String mergeXml(String sourceXml, String targetXml, File targetFile, Map<String, Object> paramMap) {
        boolean modified;
        boolean ok;
        org.w3c.dom.Document currentDocument = XmlUtils.parseDocumentSilently((String)targetXml, (boolean)true);
        assert (currentDocument != null) : targetXml;
        org.w3c.dom.Document fragment = XmlUtils.parseDocumentSilently((String)sourceXml, (boolean)true);
        assert (fragment != null) : sourceXml;
        XmlFormatStyle formatStyle = XmlFormatStyle.MANIFEST;
        String fileName = targetFile.getName();
        if (fileName.equals("AndroidManifest.xml")) {
            XmlDocument mergedDocument = Template.mergeManifest(targetFile, sourceXml);
            ok = mergedDocument != null;
            modified = ok;
            if (ok) {
                currentDocument = mergedDocument.getXml();
            }
        } else {
            String parentFolderName = targetFile.getParentFile().getName();
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentFolderName);
            formatStyle = folderType != null ? Template.getXmlFormatStyleForFile(targetFile) : XmlFormatStyle.FILE;
            modified = Template.mergeResourceFile(currentDocument, fragment, folderType, paramMap);
            ok = true;
        }
        String contents = null;
        if (ok) {
            if (modified) {
                contents = XmlPrettyPrinter.prettyPrint((Node)currentDocument, (XmlFormatPreferences)Template.createXmlFormatPreferences(), (XmlFormatStyle)formatStyle, (String)"\n", (boolean)targetXml.endsWith("\n"));
            }
        } else {
            contents = Template.wrapWithMergeConflict(targetXml, sourceXml);
        }
        return contents;
    }

    private static String wrapWithMergeConflict(String original, String added) {
        String sep = "\n";
        return "<<<<<<< Original" + sep + original + sep + "=======" + sep + added + ">>>>>>> Added" + sep;
    }

    private static boolean mergeResourceFile(@NotNull org.w3c.dom.Document currentDocument, @NotNull org.w3c.dom.Document fragment, @Nullable ResourceFolderType folderType, @NotNull Map<String, Object> paramMap) {
        if (currentDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDocument", "com/android/tools/idea/templates/Template", "mergeResourceFile"));
        }
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/android/tools/idea/templates/Template", "mergeResourceFile"));
        }
        if (paramMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/android/tools/idea/templates/Template", "mergeResourceFile"));
        }
        boolean modified = false;
        NamedNodeMap attributes = fragment.getDocumentElement().getAttributes();
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                if (!attribute.getName().startsWith("xmlns:")) continue;
                currentDocument.getDocumentElement().setAttribute(attribute.getName(), attribute.getValue());
            }
        }
        Element root = fragment.getDocumentElement();
        NodeList children = root.getChildNodes();
        ArrayList<Node> nodes = new ArrayList<Node>(children.getLength());
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node child = children.item(i);
            nodes.add(child);
            root.removeChild(child);
        }
        Collections.reverse(nodes);
        root = currentDocument.getDocumentElement();
        if (folderType == ResourceFolderType.VALUES) {
            Element element;
            HashMap<String, Element> old = new HashMap<String, Element>();
            NodeList newSiblings = root.getChildNodes();
            for (int i = newSiblings.getLength() - 1; i >= 0; --i) {
                String name;
                Node child = newSiblings.item(i);
                if (child.getNodeType() != 1 || (name = Template.getResourceId(element = (Element)child)) == null) continue;
                old.put(name, element);
            }
            for (Node node : nodes) {
                Node replace;
                if (node.getNodeType() != 1) continue;
                element = (Element)currentDocument.importNode(node, true);
                String mergeStrategy = element.getAttribute(ATTR_TEMPLATE_MERGE_STRATEGY);
                element.removeAttribute(ATTR_TEMPLATE_MERGE_STRATEGY);
                String name = Template.getResourceId(element);
                Node node2 = replace = name != null ? (Node)old.get(name) : null;
                if (replace != null) {
                    if (VALUE_MERGE_STRATEGY_REPLACE.equals(mergeStrategy)) {
                        root.replaceChild(element, replace);
                        modified = true;
                        continue;
                    }
                    if (VALUE_MERGE_STRATEGY_PRESERVE.equals(mergeStrategy)) continue;
                    LOG.warn("Warning: Ignoring name conflict in resource file for name " + name);
                    continue;
                }
                root.appendChild(element);
                modified = true;
            }
        } else {
            for (Node node : nodes) {
                root.appendChild(currentDocument.importNode(node, true));
                modified = true;
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static XmlDocument mergeManifest(@NotNull File targetManifest, @NotNull String mergeText) {
        if (targetManifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetManifest", "com/android/tools/idea/templates/Template", "mergeManifest"));
        }
        if (mergeText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeText", "com/android/tools/idea/templates/Template", "mergeManifest"));
        }
        File tempFile = null;
        try {
            tempFile = FileUtil.createTempFile((String)"manifmerge", (String)".xml");
            FileUtil.writeToFile((File)tempFile, (String)mergeText);
            StdLogger logger = new StdLogger(StdLogger.Level.INFO);
            ManifestMerger2.Invoker merger = ManifestMerger2.newMerger((File)targetManifest, (ILogger)logger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.EXTRACT_FQCNS}).addLibraryManifest(tempFile);
            MergingReport mergeReport = merger.merge();
            if (mergeReport.getMergedDocument().isPresent()) {
                XmlDocument xmlDocument = (XmlDocument)mergeReport.getMergedDocument().get();
                return xmlDocument;
            }
            XmlDocument xmlDocument = null;
            return xmlDocument;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (ManifestMerger2.MergeFailureException e) {
            LOG.error((Throwable)e);
            try {
                FileUtil.appendToFile((File)tempFile, (String)String.format("<!--%s-->", e.getMessage()));
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        return null;
    }

    private static String mergeGradleSettingsFile(@NotNull String source, @NotNull String dest) throws IOException, TemplateException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/templates/Template", "mergeGradleSettingsFile"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/templates/Template", "mergeGradleSettingsFile"));
        }
        StringBuilder contents = new StringBuilder(dest);
        for (String line : Splitter.on((char)'\n').omitEmptyStrings().trimResults().split((CharSequence)source)) {
            if (!line.startsWith("include")) {
                throw new RuntimeException("When merging settings.gradle files, only include directives can be merged.");
            }
            line = line.substring("include".length()).trim();
            Matcher matcher = INCLUDE_PATTERN.matcher(contents);
            if (matcher.find()) {
                contents.insert(matcher.end(), ", " + line);
                continue;
            }
            contents.insert(0, "include " + line + SystemProperties.getLineSeparator());
        }
        return contents.toString();
    }

    private void mergeDependenciesIntoFile(@NotNull Configuration freemarker, @NotNull Map<String, Object> paramMap, @NotNull File gradleBuildFile) throws IOException, TemplateException {
        if (freemarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freemarker", "com/android/tools/idea/templates/Template", "mergeDependenciesIntoFile"));
        }
        if (paramMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/android/tools/idea/templates/Template", "mergeDependenciesIntoFile"));
        }
        if (gradleBuildFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleBuildFile", "com/android/tools/idea/templates/Template", "mergeDependenciesIntoFile"));
        }
        File templateFile = new File(TemplateManager.getTemplateRootFolder().getPath(), FileUtil.join((String[])new String[]{"gradle", "utils", "dependencies.gradle.ftl"}));
        this.myLoader.setTemplateFile(templateFile);
        String contents = Template.processFreemarkerTemplate(freemarker, paramMap, templateFile.getName());
        String destinationContents = gradleBuildFile.exists() ? TemplateUtils.readTextFile(gradleBuildFile) : "";
        if (destinationContents == null) {
            destinationContents = "";
        }
        String result = GradleFileMerger.mergeGradleFiles(contents, destinationContents, this.myProject);
        this.writeFile(result, gradleBuildFile);
    }

    private void instantiate(@NotNull Configuration freemarker, @NotNull Map<String, Object> paramMap, @NotNull File relativeFrom, @NotNull File to) throws IOException, TemplateException {
        boolean isDirectory;
        if (freemarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freemarker", "com/android/tools/idea/templates/Template", TAG_INSTANTIATE));
        }
        if (paramMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/android/tools/idea/templates/Template", TAG_INSTANTIATE));
        }
        if (relativeFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeFrom", "com/android/tools/idea/templates/Template", TAG_INSTANTIATE));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_TO, "com/android/tools/idea/templates/Template", TAG_INSTANTIATE));
        }
        boolean bl = isDirectory = relativeFrom.getName().indexOf(46) == -1;
        if (isDirectory) {
            this.copyTemplateResource(relativeFrom, to);
        } else {
            File from = this.getFullPath(relativeFrom);
            this.myLoader.setTemplateFile(from);
            String contents = Template.processFreemarkerTemplate(freemarker, paramMap, from.getName());
            contents = this.format(contents, to);
            File targetFile = this.getTargetFile(to);
            VfsUtil.createDirectories((String)targetFile.getParentFile().getAbsolutePath());
            this.writeFile(contents, targetFile);
        }
    }

    @NotNull
    private File getFullPath(@NotNull File fromFile) {
        if (fromFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFile", "com/android/tools/idea/templates/Template", "getFullPath"));
        }
        if (fromFile.isAbsolute()) {
            File file = fromFile;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getFullPath"));
            }
            return file;
        }
        File file = new File(this.myTemplateRoot, DATA_ROOT + File.separator + fromFile);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getFullPath"));
        }
        return file;
    }

    @NotNull
    private File getTargetFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_FILE, "com/android/tools/idea/templates/Template", "getTargetFile"));
        }
        if (file.isAbsolute()) {
            File file2 = file;
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getTargetFile"));
            }
            return file2;
        }
        File file3 = new File(this.myOutputRoot, file.getPath());
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getTargetFile"));
        }
        return file3;
    }

    @NotNull
    private File getTemplateFile(@NotNull File relativeFile) throws IOException {
        if (relativeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeFile", "com/android/tools/idea/templates/Template", "getTemplateFile"));
        }
        File file = new File(this.myTemplateRoot, relativeFile.getPath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getTemplateFile"));
        }
        return file;
    }

    @NotNull
    private static String processFreemarkerTemplate(@NotNull Configuration freemarker, @NotNull Map<String, Object> paramMap, @NotNull String name) throws IOException, TemplateException {
        if (freemarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freemarker", "com/android/tools/idea/templates/Template", "processFreemarkerTemplate"));
        }
        if (paramMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/android/tools/idea/templates/Template", "processFreemarkerTemplate"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_NAME, "com/android/tools/idea/templates/Template", "processFreemarkerTemplate"));
        }
        freemarker.template.Template inputsTemplate = freemarker.getTemplate(name);
        StringWriter out = new StringWriter();
        inputsTemplate.process(paramMap, (Writer)out);
        out.flush();
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "processFreemarkerTemplate"));
        }
        return string;
    }

    @NotNull
    private static XmlFormatPreferences createXmlFormatPreferences() {
        XmlFormatPreferences xmlFormatPreferences = XmlFormatPreferences.defaults();
        if (xmlFormatPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "createXmlFormatPreferences"));
        }
        return xmlFormatPreferences;
    }

    @NotNull
    private static XmlFormatStyle getXmlFormatStyleForFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_FILE, "com/android/tools/idea/templates/Template", "getXmlFormatStyleForFile"));
        }
        if ("AndroidManifest.xml".equals(file.getName())) {
            XmlFormatStyle xmlFormatStyle = XmlFormatStyle.MANIFEST;
            if (xmlFormatStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getXmlFormatStyleForFile"));
            }
            return xmlFormatStyle;
        }
        if (file.getParent() != null) {
            String parentName = file.getParentFile().getName();
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentName);
            XmlFormatStyle xmlFormatStyle = Template.getXmlFormatStyleForFolderType(folderType);
            if (xmlFormatStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getXmlFormatStyleForFile"));
            }
            return xmlFormatStyle;
        }
        XmlFormatStyle xmlFormatStyle = XmlFormatStyle.FILE;
        if (xmlFormatStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getXmlFormatStyleForFile"));
        }
        return xmlFormatStyle;
    }

    @NotNull
    private static XmlFormatStyle getXmlFormatStyleForFolderType(@NotNull ResourceFolderType folderType) {
        if (folderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderType", "com/android/tools/idea/templates/Template", "getXmlFormatStyleForFolderType"));
        }
        switch (folderType) {
            case LAYOUT: {
                XmlFormatStyle xmlFormatStyle = XmlFormatStyle.LAYOUT;
                if (xmlFormatStyle == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getXmlFormatStyleForFolderType"));
                }
                return xmlFormatStyle;
            }
            case COLOR: 
            case VALUES: {
                XmlFormatStyle xmlFormatStyle = XmlFormatStyle.RESOURCE;
                if (xmlFormatStyle == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getXmlFormatStyleForFolderType"));
                }
                return xmlFormatStyle;
            }
        }
        XmlFormatStyle xmlFormatStyle = XmlFormatStyle.FILE;
        if (xmlFormatStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "getXmlFormatStyleForFolderType"));
        }
        return xmlFormatStyle;
    }

    private static String getResourceId(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/templates/Template", "getResourceId"));
        }
        String name = element.getAttribute(ATTR_NAME);
        if (name == null) {
            name = element.getAttribute(ATTR_ID);
        }
        return name;
    }

    private String format(@NotNull String contents, File to) {
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/android/tools/idea/templates/Template", ATTR_FORMAT));
        }
        Project project = this.myProject;
        if (project == null) {
            project = ProjectManagerEx.getInstanceEx().getDefaultProject();
        }
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(to.getName());
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(to.getName(), type, (CharSequence)StringUtil.convertLineSeparators((String)contents));
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
        return file.getText();
    }

    private void copyTemplateResource(@NotNull File relativeFrom, @NotNull File output) throws IOException {
        if (relativeFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeFrom", "com/android/tools/idea/templates/Template", "copyTemplateResource"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/android/tools/idea/templates/Template", "copyTemplateResource"));
        }
        this.copy(this.getFullPath(relativeFrom), this.getTargetFile(output));
    }

    private void copy(@NotNull File src, @NotNull File dest) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/templates/Template", TAG_COPY));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/templates/Template", TAG_COPY));
        }
        VirtualFile sourceFile = VfsUtil.findFileByIoFile((File)src, (boolean)true);
        assert (sourceFile != null) : src;
        File parentPath = src.isDirectory() ? dest : dest.getParentFile();
        VirtualFile destFolder = Template.checkedCreateDirectoryIfMissing(parentPath);
        if (src.isDirectory()) {
            this.copyDirectory(sourceFile, destFolder);
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(sourceFile);
            if (document != null) {
                this.writeFile(document.getText(), dest);
            } else {
                VfsUtilCore.copyFile((Object)this, (VirtualFile)sourceFile, (VirtualFile)destFolder, (String)dest.getName());
            }
        }
    }

    private void copyDirectory(final @NotNull VirtualFile src, final @NotNull VirtualFile dest) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/templates/Template", "copyDirectory"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/templates/Template", "copyDirectory"));
        }
        final File destinationFile = VfsUtilCore.virtualToIoFile((VirtualFile)dest);
        VfsUtilCore.visitChildrenRecursively((VirtualFile)src, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", Template.ATTR_FILE, "com/android/tools/idea/templates/Template$3", "visitFile"));
                }
                try {
                    return Template.this.copyFile(file, src, destinationFile, dest);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
        }, IOException.class);
    }

    private boolean copyFile(VirtualFile file, VirtualFile src, File destinationFile, VirtualFile dest) throws IOException {
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)src, (char)File.separatorChar);
        if (relativePath == null) {
            LOG.error(file.getPath() + " is not a child of " + src, (Throwable)new Exception());
            return false;
        }
        if (file.isDirectory()) {
            Template.checkedCreateDirectoryIfMissing(new File(destinationFile, relativePath));
        } else {
            VirtualFile targetDir = dest;
            if (relativePath.indexOf(File.separatorChar) > 0) {
                String directories = relativePath.substring(0, relativePath.lastIndexOf(File.separatorChar));
                File newParent = new File(destinationFile, directories);
                targetDir = Template.checkedCreateDirectoryIfMissing(newParent);
            }
            VfsUtilCore.copyFile((Object)this, (VirtualFile)file, (VirtualFile)targetDir);
        }
        return true;
    }

    @NotNull
    public static VirtualFile checkedCreateDirectoryIfMissing(@NotNull File directory) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/android/tools/idea/templates/Template", "checkedCreateDirectoryIfMissing"));
        }
        VirtualFile dir = VfsUtil.createDirectoryIfMissing((String)directory.getAbsolutePath());
        if (dir == null) {
            throw new IOException("Unable to create " + directory.getAbsolutePath());
        }
        VirtualFile virtualFile = dir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template", "checkedCreateDirectoryIfMissing"));
        }
        return virtualFile;
    }

    private void writeFile(@Nullable String contents, @NotNull File to) throws IOException {
        Document document;
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_TO, "com/android/tools/idea/templates/Template", "writeFile"));
        }
        if (contents == null) {
            return;
        }
        VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(to);
        if (vf == null) {
            VirtualFile parentDir = Template.checkedCreateDirectoryIfMissing(to.getParentFile());
            vf = parentDir.createChildData((Object)this, to.getName());
        }
        if ((document = FileDocumentManager.getInstance().getDocument(vf)) != null) {
            document.setText((CharSequence)contents.replaceAll("\r\n", "\n"));
            FileDocumentManager.getInstance().saveDocument(document);
        } else {
            vf.setBinaryContent(contents.getBytes(Charsets.UTF_8), -1L, -1L, (Object)this);
        }
    }

    @Nullable
    private static File getPath(@NotNull Attributes attributes, @NotNull String name) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/templates/Template", "getPath"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_NAME, "com/android/tools/idea/templates/Template", "getPath"));
        }
        String value = attributes.getValue(name);
        if (value == null) {
            return null;
        }
        String unescapedString = XmlUtils.fromXmlAttributeValue((String)value);
        return new File(FileUtil.toSystemDependentName((String)unescapedString));
    }

    private static boolean hasExtension(File file, String extension) {
        String noDotExtension = extension.startsWith(".") ? extension.substring(1) : extension;
        return Files.getFileExtension((String)file.getName()).equalsIgnoreCase(noDotExtension);
    }

    static class AdtManifestMergeCallback
    implements ICallback {
        AdtManifestMergeCallback() {
        }

        public int queryCodenameApiLevel(@NotNull String codename) {
            if (codename == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codename", "com/android/tools/idea/templates/Template$AdtManifestMergeCallback", "queryCodenameApiLevel"));
            }
            try {
                IAndroidTarget t;
                AndroidVersion version = new AndroidVersion(codename);
                String hashString = AndroidTargetHash.getPlatformHashString((AndroidVersion)version);
                AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
                if (sdkData != null && (t = sdkData.getLocalSdk().getTargetFromHashString(hashString)) != null) {
                    return t.getVersion().getApiLevel();
                }
            }
            catch (AndroidVersion.AndroidVersionException androidVersionException) {
                // empty catch block
            }
            return 0;
        }
    }

    private static final class MyTemplateLoader
    implements TemplateLoader {
        private String myPrefix;

        public MyTemplateLoader(@Nullable String prefix) {
            this.myPrefix = prefix;
        }

        public void setTemplateFile(@NotNull File file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", Template.ATTR_FILE, "com/android/tools/idea/templates/Template$MyTemplateLoader", "setTemplateFile"));
            }
            this.setTemplateParent(file.getParentFile());
        }

        public void setTemplateParent(@NotNull File parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/templates/Template$MyTemplateLoader", "setTemplateParent"));
            }
            this.myPrefix = parent.getPath();
        }

        @NotNull
        public Reader getReader(@NotNull Object templateSource, @NotNull String encoding) throws IOException {
            if (templateSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateSource", "com/android/tools/idea/templates/Template$MyTemplateLoader", "getReader"));
            }
            if (encoding == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "com/android/tools/idea/templates/Template$MyTemplateLoader", "getReader"));
            }
            URL url = (URL)templateSource;
            InputStreamReader inputStreamReader = new InputStreamReader(url.openStream(), encoding);
            if (inputStreamReader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/Template$MyTemplateLoader", "getReader"));
            }
            return inputStreamReader;
        }

        public long getLastModified(Object templateSource) {
            return 0L;
        }

        @Nullable
        public Object findTemplateSource(@NotNull String name) throws IOException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", Template.ATTR_NAME, "com/android/tools/idea/templates/Template$MyTemplateLoader", "findTemplateSource"));
            }
            String path = this.myPrefix != null ? this.myPrefix + '/' + name : name;
            File file = new File(path);
            if (file.exists()) {
                return SdkUtils.fileToUrl((File)file);
            }
            return null;
        }

        public void closeTemplateSource(Object templateSource) throws IOException {
        }
    }
}

