/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.InstallOperation;
import com.android.tools.idea.welcome.InstallationCancelledException;
import com.android.tools.idea.welcome.WizardException;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DownloadOperation
extends InstallOperation<File, File> {
    @NotNull
    private final String myUrl;

    public DownloadOperation(@NotNull InstallContext context, @NotNull String url, double progressShare) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/DownloadOperation", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/welcome/DownloadOperation", "<init>"));
        }
        super(context, progressShare);
        this.myUrl = url;
    }

    @NotNull
    private static String getFileName(@NotNull String urlString) {
        block5: {
            String string;
            if (urlString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlString", "com/android/tools/idea/welcome/DownloadOperation", "getFileName"));
            }
            try {
                if (!URLUtil.containsScheme((String)urlString)) break block5;
                URL url = new URL(urlString);
                string = PathUtil.getFileName((String)url.getPath());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/DownloadOperation", "getFileName"));
            }
            return string;
        }
        String string = PathUtil.getFileName((String)urlString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/DownloadOperation", "getFileName"));
        }
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected File perform(@NotNull ProgressIndicator indicator, @NotNull File arg) throws WizardException, InstallationCancelledException {
        File file;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/DownloadOperation", "perform"));
        }
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/welcome/DownloadOperation", "perform"));
        }
        DownloadableFileService fileService = DownloadableFileService.getInstance();
        DownloadableFileDescription myDescription = fileService.createFileDescription(this.myUrl, DownloadOperation.getFileName(this.myUrl));
        FileDownloader downloader = fileService.createDownloader((List)ImmutableList.of((Object)myDescription), "Android Studio components");
        while (true) {
            try {
                List result = downloader.download(this.myContext.getTempDirectory());
                if (result.size() != 1) throw new WizardException("Unable to download " + this.myUrl);
                file = (File)((Pair)result.get(0)).getFirst();
            }
            catch (IOException e) {
                String details = StringUtil.isEmpty((String)e.getMessage()) ? "Unable to download Android Studio components." : e.getMessage();
                this.promptToRetry(details + "\n\nPlease check your Internet connection and retry.", details, e);
                continue;
            }
            catch (ProcessCanceledException e) {
                throw new InstallationCancelledException();
            }
            break;
        }
        if (file != null) return file;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/DownloadOperation", "perform"));
    }

    @Override
    public void cleanup(@NotNull File result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/welcome/DownloadOperation", "cleanup"));
        }
        if (result.isFile() && FileUtil.isAncestor((File)result, (File)this.myContext.getTempDirectory(), (boolean)false)) {
            FileUtil.delete((File)result);
        }
    }
}

