/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.welcome.FirstRunWizardMode;
import com.android.tools.idea.welcome.JdkLocationStep;
import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class SetupJdkPath
extends DynamicWizardPath {
    private static ScopedStateStore.Key<String> KEY_JDK_LOCATION = ScopedStateStore.createKey("jdk.location", ScopedStateStore.Scope.PATH, String.class);
    @NotNull
    private final FirstRunWizardMode myMode;
    private JdkLocationStep myJdkLocationStep;

    public SetupJdkPath(@NotNull FirstRunWizardMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/welcome/SetupJdkPath", "<init>"));
        }
        this.myMode = mode;
        this.myJdkLocationStep = new JdkLocationStep(KEY_JDK_LOCATION, this.myMode);
    }

    @Override
    public boolean isPathVisible() {
        Sdk defaultJdk = DefaultSdks.getDefaultJdk(JavaSdkVersion.JDK_1_7);
        return defaultJdk == null;
    }

    @Override
    protected void init() {
        String path = null;
        File javaDir = this.myMode.getJavaDir();
        if (javaDir != null) {
            path = javaDir.getAbsolutePath();
        }
        this.myState.put(KEY_JDK_LOCATION, path);
        this.addStep(this.myJdkLocationStep);
    }

    @Override
    @NotNull
    public String getPathName() {
        if ("Setup JDK" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/SetupJdkPath", "getPathName"));
        }
        return "Setup JDK";
    }

    @Override
    public boolean performFinishingActions() {
        String path = this.myState.get(KEY_JDK_LOCATION);
        assert (path != null);
        DefaultSdks.setDefaultJavaHome(new File(path));
        return true;
    }

    public boolean showsStep() {
        return this.isPathVisible() && this.myJdkLocationStep.isStepVisible();
    }
}

