/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run.testing;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.Variant;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.google.common.base.Predicate;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.android.dom.manifest.Instrumentation;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.run.AndroidApplicationLauncher;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.AndroidRunConfigurationEditor;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.android.run.testing.AndroidTestConsoleProperties;
import org.jetbrains.android.run.testing.AndroidTestListener;
import org.jetbrains.android.run.testing.TestRunParameters;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestRunConfiguration
extends AndroidRunConfigurationBase
implements RefactoringListenerProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.run.testing.AndroidTestRunConfiguration");
    public static final int TEST_ALL_IN_MODULE = 0;
    public static final int TEST_ALL_IN_PACKAGE = 1;
    public static final int TEST_CLASS = 2;
    public static final int TEST_METHOD = 3;
    public int TESTING_TYPE = 0;
    public String INSTRUMENTATION_RUNNER_CLASS = "";
    public String METHOD_NAME = "";
    public String CLASS_NAME = "";
    public String PACKAGE_NAME = "";

    public AndroidTestRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    @Override
    protected Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration", "supportsRunningLibraryProjects"));
        }
        if (!facet.isGradleProject()) {
            return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
        }
        IdeaAndroidProject project = facet.getIdeaAndroidProject();
        if (project == null) {
            return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
        }
        AndroidArtifact testArtifact = project.findInstrumentationTestArtifactInSelectedVariant();
        String testTask = testArtifact != null ? testArtifact.getAssembleTaskName() : null;
        return new Pair((Object)(testTask != null ? 1 : 0), (Object)AndroidBundle.message("android.cannot.run.library.project.in.this.buildtype", new Object[0]));
    }

    public boolean isGeneratedName() {
        String name = this.getName();
        if (!(this.TESTING_TYPE != 2 && this.TESTING_TYPE != 3 || this.CLASS_NAME != null && this.CLASS_NAME.length() != 0)) {
            return JavaExecutionUtil.isNewName((String)name);
        }
        if (this.TESTING_TYPE == 3 && (this.METHOD_NAME == null || this.METHOD_NAME.length() == 0)) {
            return JavaExecutionUtil.isNewName((String)name);
        }
        return Comparing.equal((String)name, (String)this.suggestedName());
    }

    public String suggestedName() {
        if (this.TESTING_TYPE == 1) {
            return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{this.PACKAGE_NAME});
        }
        if (this.TESTING_TYPE == 2) {
            return ProgramRunnerUtil.shortenName((String)JavaExecutionUtil.getShortClassName((String)this.CLASS_NAME), (int)0);
        }
        if (this.TESTING_TYPE == 3) {
            return ProgramRunnerUtil.shortenName((String)this.METHOD_NAME, (int)2) + "()";
        }
        return ExecutionBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Override
    public void checkConfiguration(@NotNull AndroidFacet facet) throws RuntimeConfigurationException {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration", "checkConfiguration"));
        }
        Module module = facet.getModule();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        switch (this.TESTING_TYPE) {
            case 1: {
                PsiPackage testPackage = facade.findPackage(this.PACKAGE_NAME);
                if (testPackage != null) break;
                throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"package.does.not.exist.error.message", (Object[])new Object[]{this.PACKAGE_NAME}));
            }
            case 2: {
                PsiClass testClass = ((JavaRunConfigurationModule)this.getConfigurationModule()).checkModuleAndClassName(this.CLASS_NAME, ExecutionBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
                if (JUnitUtil.isTestClass((PsiClass)testClass)) break;
                throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{this.CLASS_NAME}));
            }
            case 3: {
                this.checkTestMethod();
            }
        }
        if (this.INSTRUMENTATION_RUNNER_CLASS.length() > 0 && facade.findClass(this.INSTRUMENTATION_RUNNER_CLASS, module.getModuleWithDependenciesAndLibrariesScope(true)) == null) {
            throw new RuntimeConfigurationError(AndroidBundle.message("instrumentation.runner.class.not.specified.error", new Object[0]));
        }
    }

    @Override
    public AndroidRunningState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Module module;
        int count;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration", "getState"));
        }
        AndroidRunningState state = super.getState(executor, env);
        if (state == null) {
            return null;
        }
        AndroidFacet facet = state.getFacet();
        AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
        if (!facet.isGradleProject() && !configuration.getState().PACK_TEST_CODE && (count = AndroidTestRunConfiguration.getTestSourceRootCount(module = facet.getModule())) > 0) {
            String message = "Code and resources under test source " + (count > 1 ? "roots" : "root") + " aren't included into debug APK.\nWould you like to include them and recompile " + module.getName() + " module?" + "\n(You may change this option in Android facet settings later)";
            int result = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)message, (String)"Test code not included into APK", (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                configuration.getState().PACK_TEST_CODE = true;
            } else if (result == 2) {
                return null;
            }
        }
        return state;
    }

    private static int getTestSourceRootCount(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration", "getTestSourceRootCount"));
        }
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        return manager.getSourceRoots(true).length - manager.getSourceRoots(false).length;
    }

    private void checkTestMethod() throws RuntimeConfigurationException {
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        PsiClass testClass = configurationModule.checkModuleAndClassName(this.CLASS_NAME, ExecutionBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
        if (!JUnitUtil.isTestClass((PsiClass)testClass)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{this.CLASS_NAME}));
        }
        if (this.METHOD_NAME == null || this.METHOD_NAME.trim().length() == 0) {
            throw new RuntimeConfigurationError(ExecutionBundle.message((String)"method.name.not.specified.error.message", (Object[])new Object[0]));
        }
        JUnitUtil.TestMethodFilter filter = new JUnitUtil.TestMethodFilter(testClass);
        boolean found = false;
        boolean testAnnotated = false;
        for (PsiMethod method : testClass.findMethodsByName(this.METHOD_NAME, true)) {
            if (filter.value(method)) {
                found = true;
            }
            if (!JUnitUtil.isTestAnnotated((PsiMethod)method)) continue;
            testAnnotated = true;
        }
        if (!found) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"test.method.doesnt.exist.error.message", (Object[])new Object[]{this.METHOD_NAME}));
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)testClass, (String)"org.junit.runner.RunWith", (boolean)true) && !testAnnotated) {
            try {
                PsiClass testCaseClass = JUnitUtil.getTestCaseClass((Module)configurationModule.getModule());
                if (!testClass.isInheritor(testCaseClass, true)) {
                    throw new RuntimeConfigurationError(ExecutionBundle.message((String)"class.isnt.inheritor.of.testcase.error.message", (Object[])new Object[]{this.CLASS_NAME}));
                }
            }
            catch (JUnitUtil.NoJUnitException e) {
                throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)AndroidBundle.message("cannot.find.testcase.error", new Object[0]), (Object[])new Object[0]));
            }
        }
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        AndroidRunConfigurationEditor<AndroidTestRunConfiguration> editor = new AndroidRunConfigurationEditor<AndroidTestRunConfiguration>(project, new Predicate<AndroidFacet>(){

            public boolean apply(@Nullable AndroidFacet facet) {
                return facet != null && (Boolean)AndroidTestRunConfiguration.this.supportsRunningLibraryProjects(facet).getFirst() != false;
            }
        });
        editor.setConfigurationSpecificEditor(new TestRunParameters(project, editor.getModuleSelector()));
        AndroidRunConfigurationEditor<AndroidTestRunConfiguration> androidRunConfigurationEditor = editor;
        if (androidRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration", "getConfigurationEditor"));
        }
        return androidRunConfigurationEditor;
    }

    @Override
    @NotNull
    protected ConsoleView attachConsole(AndroidRunningState state, Executor executor) throws ExecutionException {
        AndroidTestConsoleProperties properties = new AndroidTestConsoleProperties(this, executor);
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createAndAttachConsole((String)"Android", (ProcessHandler)state.getProcessHandler(), (TestConsoleProperties)properties, (ExecutionEnvironment)state.getEnvironment());
        Disposer.register((Disposable)state.getFacet().getModule().getProject(), (Disposable)consoleView);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration", "attachConsole"));
        }
        return baseTestsOutputConsoleView;
    }

    @Override
    protected boolean supportMultipleDevices() {
        return false;
    }

    @Override
    protected AndroidApplicationLauncher getApplicationLauncher(AndroidFacet facet) {
        Variant selectedVariant;
        String testRunner;
        String runner = this.INSTRUMENTATION_RUNNER_CLASS.length() > 0 ? this.INSTRUMENTATION_RUNNER_CLASS : AndroidTestRunConfiguration.getRunnerFromManifest(facet);
        IdeaAndroidProject ideaAndroidProject = facet.getIdeaAndroidProject();
        if (runner == null && ideaAndroidProject != null && (testRunner = (selectedVariant = ideaAndroidProject.getSelectedVariant()).getMergedFlavor().getTestInstrumentationRunner()) != null) {
            runner = testRunner;
        }
        return new MyApplicationLauncher(runner);
    }

    @Nullable
    private static String getRunnerFromManifest(AndroidFacet facet) {
        Manifest manifest = facet.getManifest();
        if (manifest != null) {
            for (Instrumentation instrumentation : manifest.getInstrumentations()) {
                PsiClass instrumentationClass;
                if (instrumentation == null || (instrumentationClass = (PsiClass)instrumentation.getInstrumentationClass().getValue()) == null) continue;
                return instrumentationClass.getQualifiedName();
            }
        }
        return null;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (element instanceof PsiPackage) {
            String pkgName = ((PsiPackage)element).getQualifiedName();
            if (this.TESTING_TYPE == 1 && !StringUtil.equals((CharSequence)pkgName, (CharSequence)this.PACKAGE_NAME)) {
                return null;
            }
            if (this.TESTING_TYPE != 1 && !StringUtil.equals((CharSequence)pkgName, (CharSequence)StringUtil.getPackageName((String)this.CLASS_NAME))) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration$2", "elementRenamedOrMoved"));
                    }
                    if (newElement instanceof PsiPackage) {
                        String newPkgName = ((PsiPackage)newElement).getQualifiedName();
                        if (AndroidTestRunConfiguration.this.TESTING_TYPE == 1) {
                            AndroidTestRunConfiguration.this.PACKAGE_NAME = newPkgName;
                        } else {
                            AndroidTestRunConfiguration.this.CLASS_NAME = AndroidTestRunConfiguration.this.CLASS_NAME.replace(StringUtil.getPackageName((String)AndroidTestRunConfiguration.this.CLASS_NAME), newPkgName);
                        }
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration$2", "undoElementMovedOrRenamed"));
                    }
                    if (oldQualifiedName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration$2", "undoElementMovedOrRenamed"));
                    }
                    if (newElement instanceof PsiPackage) {
                        if (AndroidTestRunConfiguration.this.TESTING_TYPE == 1) {
                            AndroidTestRunConfiguration.this.PACKAGE_NAME = oldQualifiedName;
                        } else {
                            AndroidTestRunConfiguration.this.CLASS_NAME = AndroidTestRunConfiguration.this.CLASS_NAME.replace(StringUtil.getPackageName((String)AndroidTestRunConfiguration.this.CLASS_NAME), oldQualifiedName);
                        }
                    }
                }
            };
        }
        if ((this.TESTING_TYPE == 2 || this.TESTING_TYPE == 3) && element instanceof PsiClass) {
            if (!StringUtil.equals((CharSequence)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)element)), (CharSequence)this.CLASS_NAME)) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration$3", "elementRenamedOrMoved"));
                    }
                    if (newElement instanceof PsiClass) {
                        AndroidTestRunConfiguration.this.CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)newElement));
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration$3", "undoElementMovedOrRenamed"));
                    }
                    if (oldQualifiedName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration$3", "undoElementMovedOrRenamed"));
                    }
                    if (newElement instanceof PsiClass) {
                        AndroidTestRunConfiguration.this.CLASS_NAME = oldQualifiedName;
                    }
                }
            };
        }
        if (this.TESTING_TYPE == 3 && element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            if (!StringUtil.equals((CharSequence)psiMethod.getName(), (CharSequence)this.METHOD_NAME)) {
                return null;
            }
            PsiClass psiClass = psiMethod.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            String fqName = psiClass.getQualifiedName();
            if (fqName != null && !StringUtil.equals((CharSequence)fqName, (CharSequence)this.CLASS_NAME)) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration$4", "elementRenamedOrMoved"));
                    }
                    if (newElement instanceof PsiMethod) {
                        AndroidTestRunConfiguration.this.METHOD_NAME = ((PsiMethod)newElement).getName();
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration$4", "undoElementMovedOrRenamed"));
                    }
                    if (oldQualifiedName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration$4", "undoElementMovedOrRenamed"));
                    }
                    if (newElement instanceof PsiMethod) {
                        AndroidTestRunConfiguration.this.METHOD_NAME = oldQualifiedName;
                    }
                }
            };
        }
        return null;
    }

    private class MyApplicationLauncher
    extends AndroidApplicationLauncher {
        private final String myInstrumentationTestRunner;

        private MyApplicationLauncher(String instrumentationTestRunner) {
            this.myInstrumentationTestRunner = instrumentationTestRunner;
        }

        @Override
        public AndroidApplicationLauncher.LaunchResult launch(@NotNull AndroidRunningState state, @NotNull IDevice device) throws IOException, AdbCommandRejectedException, TimeoutException {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration$MyApplicationLauncher", "launch"));
            }
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/testing/AndroidTestRunConfiguration$MyApplicationLauncher", "launch"));
            }
            state.getProcessHandler().notifyTextAvailable("Running tests\n", ProcessOutputTypes.STDOUT);
            RemoteAndroidTestRunner runner = new RemoteAndroidTestRunner(state.getTestPackageName(), this.myInstrumentationTestRunner, (IShellEnabledDevice)device);
            switch (AndroidTestRunConfiguration.this.TESTING_TYPE) {
                case 1: {
                    runner.setTestPackageName(AndroidTestRunConfiguration.this.PACKAGE_NAME);
                    break;
                }
                case 2: {
                    runner.setClassName(AndroidTestRunConfiguration.this.CLASS_NAME);
                    break;
                }
                case 3: {
                    runner.setMethodName(AndroidTestRunConfiguration.this.CLASS_NAME, AndroidTestRunConfiguration.this.METHOD_NAME);
                }
            }
            runner.setDebug(state.isDebugMode());
            try {
                runner.run(new ITestRunListener[]{new AndroidTestListener(state)});
            }
            catch (ShellCommandUnresponsiveException e) {
                LOG.info((Throwable)e);
                state.getProcessHandler().notifyTextAvailable("Error: time out", ProcessOutputTypes.STDERR);
            }
            return AndroidApplicationLauncher.LaunchResult.SUCCESS;
        }
    }
}

