/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.Collections;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelBinding;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelRuleRegistrar;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityModelProjection<M>
implements ModelProjection<M> {
    private final ModelType<? super M> type;
    private final boolean canBeViewedAsReadOnly;
    private final boolean canBeViewedAsWritable;

    public IdentityModelProjection(ModelType<? super M> type, boolean canBeViewedAsReadOnly, boolean canBeViewedAsWritable) {
        this.type = type;
        this.canBeViewedAsReadOnly = canBeViewedAsReadOnly;
        this.canBeViewedAsWritable = canBeViewedAsWritable;
    }

    @Override
    public <T> boolean canBeViewedAsWritable(ModelType<T> targetType) {
        return this.canBeViewedAsWritable && targetType.isAssignableFrom(this.type);
    }

    @Override
    public <T> boolean canBeViewedAsReadOnly(ModelType<T> targetType) {
        return this.canBeViewedAsReadOnly && targetType.isAssignableFrom(this.type);
    }

    @Override
    public <T> ModelView<? extends T> asWritable(ModelBinding<T> reference, ModelRuleDescriptor sourceDescriptor, Inputs inputs, ModelRuleRegistrar modelRegistry, M instance) {
        if (this.canBeViewedAsWritable(reference.getReference().getType())) {
            return this.view(instance);
        }
        return null;
    }

    @Override
    public <T> ModelView<? extends T> asReadOnly(ModelType<T> targetType, M instance) {
        if (this.canBeViewedAsReadOnly(targetType)) {
            return this.view(instance);
        }
        return null;
    }

    private <T> ModelView<? extends T> view(M instance) {
        ModelView<? super M> cast = InstanceModelView.of(this.type, instance);
        return cast;
    }

    @Override
    public Iterable<String> getWritableTypeDescriptions() {
        if (this.canBeViewedAsWritable) {
            return Collections.singleton(IdentityModelProjection.description(this.type));
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<String> getReadableTypeDescriptions() {
        if (this.canBeViewedAsReadOnly) {
            return Collections.singleton(IdentityModelProjection.description(this.type));
        }
        return Collections.emptySet();
    }

    public static String description(ModelType<?> type) {
        return type.toString() + " (or assignment compatible type thereof)";
    }
}

