/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.conflict;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.NodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;

public class ConflictVersion
extends BaseNodeDescription {
    private final SVNURL myRepositoryRoot;
    private final String myPath;
    private final long myPegRevision;

    @Nullable
    public static ConflictVersion create(@Nullable SVNConflictVersion conflictVersion) {
        ConflictVersion result = null;
        if (conflictVersion != null) {
            result = new ConflictVersion(conflictVersion.getRepositoryRoot(), conflictVersion.getPath(), conflictVersion.getPegRevision(), NodeKind.from(conflictVersion.getKind()));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public ConflictVersion(SVNURL repositoryRoot, String path, long pegRevision, @NotNull NodeKind nodeKind) {
        void kind;
        if (nodeKind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/idea/svn/conflict/ConflictVersion", "<init>"));
        }
        super((NodeKind)kind);
        this.myRepositoryRoot = repositoryRoot;
        this.myPath = path;
        this.myPegRevision = pegRevision;
    }

    public SVNURL getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public String getPath() {
        return this.myPath;
    }

    public long getPegRevision() {
        return this.myPegRevision;
    }

    @NotNull
    public NodeKind getKind() {
        NodeKind nodeKind = this.myKind;
        if (nodeKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/conflict/ConflictVersion", "getKind"));
        }
        return nodeKind;
    }

    @NotNull
    public String toPresentableString() {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.myRepositoryRoot != null ? this.myRepositoryRoot : "");
        urlBuilder.append("/");
        urlBuilder.append(this.myPath != null ? this.myPath : "...");
        String string = "(" + (Object)((Object)this.getKind()) + ") " + urlBuilder + "@" + this.getPegRevision();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/conflict/ConflictVersion", "toPresentableString"));
        }
        return string;
    }

    @NotNull
    public static String toPresentableString(@Nullable ConflictVersion version) {
        String string = version == null ? "" : version.toPresentableString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/conflict/ConflictVersion", "toPresentableString"));
        }
        return string;
    }
}

