/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsoleManager;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.util.XmlXpathHelper;

public class BeforeTestEvent
extends AbstractTestEvent {
    public BeforeTestEvent(GradleTestsExecutionConsoleManager consoleManager) {
        super(consoleManager);
    }

    @Override
    public void process(XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        String testId = this.getTestId(eventXml);
        String parentTestId = this.getParentTestId(eventXml);
        String name = this.getTestName(eventXml);
        String fqClassName = this.getTestClassName(eventXml);
        String locationUrl = this.findLocationUrl(name, fqClassName);
        final GradleSMTestProxy testProxy = new GradleSMTestProxy(name, false, locationUrl, fqClassName);
        testProxy.setStarted();
        testProxy.setLocator(this.getConsoleManager().getUrlProvider());
        this.getConsoleManager().getTestsMap().put(testId, testProxy);
        if (StringUtil.isEmpty((String)parentTestId)) {
            this.addToInvokeLater(new Runnable(){

                @Override
                public void run() {
                    BeforeTestEvent.this.getResultsViewer().getTestsRootNode().addChild((SMTestProxy)testProxy);
                }
            });
        } else {
            final SMTestProxy parentTestProxy = this.getConsoleManager().getTestsMap().get(parentTestId);
            if (parentTestProxy != null) {
                this.addToInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        parentTestProxy.addChild((SMTestProxy)testProxy);
                    }
                });
            }
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                BeforeTestEvent.this.getResultsViewer().onTestStarted((SMTestProxy)testProxy);
            }
        });
    }
}

