/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service;

import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.gradle.StartParameter;
import org.gradle.util.DistributionLocator;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleLog;
import org.jetbrains.plugins.gradle.util.GradleUtil;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;

public class GradleInstallationManager {
    public static final Pattern GRADLE_JAR_FILE_PATTERN;
    public static final Pattern ANY_GRADLE_JAR_FILE_PATTERN;
    public static final Pattern ANT_JAR_PATTERN;
    public static final Pattern IVY_JAR_PATTERN;
    private static final String[] GRADLE_START_FILE_NAMES;
    @NonNls
    private static final String GRADLE_ENV_PROPERTY_NAME;
    @NotNull
    private final PlatformFacade myPlatformFacade;
    @Nullable
    private Ref<File> myCachedGradleHomeFromPath;

    public GradleInstallationManager(@NotNull PlatformFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/plugins/gradle/service/GradleInstallationManager", "<init>"));
        }
        this.myPlatformFacade = facade;
    }

    @Nullable
    public Collection<File> getAllLibraries(@Nullable File gradleHome) {
        File plugins;
        if (gradleHome == null || !gradleHome.isDirectory()) {
            return null;
        }
        ArrayList result = ContainerUtilRt.newArrayList();
        File libs = new File(gradleHome, "lib");
        File[] files = libs.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".jar")) continue;
                result.add(file);
            }
        }
        if ((files = (plugins = new File(libs, "plugins")).listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".jar")) continue;
                result.add(file);
            }
        }
        return result.isEmpty() ? null : result;
    }

    @Nullable
    public File getGradleHome(@Nullable Project project, @NotNull String linkedProjectPath) {
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "org/jetbrains/plugins/gradle/service/GradleInstallationManager", "getGradleHome"));
        }
        return this.doGetGradleHome(project, linkedProjectPath);
    }

    @Nullable
    public Sdk getGradleJdk(@Nullable Project project, @NotNull String linkedProjectPath) {
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "org/jetbrains/plugins/gradle/service/GradleInstallationManager", "getGradleJdk"));
        }
        return this.doGetGradleJdk(project, linkedProjectPath);
    }

    @Nullable
    private Sdk doGetGradleJdk(@Nullable Project project, String linkedProjectPath) {
        Sdk sdk;
        if (project == null) {
            return null;
        }
        GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(linkedProjectPath);
        if (settings == null) {
            return null;
        }
        String gradleJvm = settings.getGradleJvm();
        try {
            sdk = ExternalSystemJdkUtil.getJdk((Project)project, (String)gradleJvm);
        }
        catch (ExternalSystemJdkException e) {
            throw new ExternalSystemJdkException(String.format("Invalid Gradle JDK configuration found. <a href='%s'>Open Gradle Settings</a> \n", "#open_external_system_settings"), linkedProjectPath, (Throwable)e, new String[]{"#open_external_system_settings"});
        }
        if (sdk == null && gradleJvm != null) {
            throw new ExternalSystemJdkException(String.format("Invalid Gradle JDK configuration found. <a href='%s'>Open Gradle Settings</a> \n", "#open_external_system_settings"), linkedProjectPath, null, new String[]{"#open_external_system_settings"});
        }
        return sdk;
    }

    @Nullable
    private File doGetGradleHome(@Nullable Project project, @NotNull String linkedProjectPath) {
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "org/jetbrains/plugins/gradle/service/GradleInstallationManager", "doGetGradleHome"));
        }
        if (project == null) {
            return null;
        }
        GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(linkedProjectPath);
        if (settings == null || settings.getDistributionType() == null) {
            return null;
        }
        return this.getGradleHome(settings.getDistributionType(), linkedProjectPath, settings.getGradleHome());
    }

    @Nullable
    public File getGradleHome(@NotNull DistributionType distributionType, @NotNull String linkedProjectPath, @Nullable String gradleHome) {
        if (distributionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "distributionType", "org/jetbrains/plugins/gradle/service/GradleInstallationManager", "getGradleHome"));
        }
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "org/jetbrains/plugins/gradle/service/GradleInstallationManager", "getGradleHome"));
        }
        File candidate = null;
        switch (distributionType) {
            case LOCAL: {
                if (gradleHome == null) break;
                candidate = new File(gradleHome);
                break;
            }
            case DEFAULT_WRAPPED: {
                WrapperConfiguration wrapperConfiguration = GradleUtil.getWrapperConfiguration(linkedProjectPath);
                candidate = this.getWrappedGradleHome(linkedProjectPath, wrapperConfiguration);
                break;
            }
            case WRAPPED: {
                break;
            }
            case BUNDLED: {
                WrapperConfiguration bundledWrapperSettings = new WrapperConfiguration();
                DistributionLocator distributionLocator = new DistributionLocator();
                bundledWrapperSettings.setDistribution(distributionLocator.getDistributionFor(GradleVersion.current()));
                candidate = this.getWrappedGradleHome(linkedProjectPath, bundledWrapperSettings);
            }
        }
        File result = null;
        if (candidate != null) {
            File file = result = this.isGradleSdkHome(candidate) ? candidate : null;
        }
        if (result != null) {
            return result;
        }
        return this.getAutodetectedGradleHome();
    }

    @Nullable
    public File getAutodetectedGradleHome() {
        File result = this.getGradleHomeFromPath();
        return result == null ? this.getGradleHomeFromEnvProperty() : result;
    }

    @Nullable
    public VirtualFile getGradleHome(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        VirtualFile[] roots = OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots();
        if (roots == null) {
            return null;
        }
        for (VirtualFile root : roots) {
            if (root == null || !this.isGradleSdkHome(root)) continue;
            return root;
        }
        return null;
    }

    @Nullable
    public VirtualFile getGradleHome(@Nullable Module module, @Nullable Project project, @NotNull String linkedProjectPath) {
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "org/jetbrains/plugins/gradle/service/GradleInstallationManager", "getGradleHome"));
        }
        VirtualFile result = this.getGradleHome(module);
        if (result != null) {
            return result;
        }
        File home = this.getGradleHome(project, linkedProjectPath);
        return home == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(home);
    }

    @Nullable
    public File getGradleHomeFromPath() {
        Ref<File> ref = this.myCachedGradleHomeFromPath;
        if (ref != null) {
            return (File)ref.get();
        }
        String path = System.getenv("PATH");
        if (path == null) {
            return null;
        }
        for (String pathEntry : path.split(File.pathSeparator)) {
            File dir = new File(pathEntry);
            if (!dir.isDirectory()) continue;
            for (String fileName : GRADLE_START_FILE_NAMES) {
                File candidate;
                File startFile = new File(dir, fileName);
                if (!startFile.isFile() || !this.isGradleSdkHome(candidate = dir.getParentFile())) continue;
                this.myCachedGradleHomeFromPath = new Ref((Object)candidate);
                return candidate;
            }
        }
        return null;
    }

    @Nullable
    public File getGradleHomeFromEnvProperty() {
        String path = System.getenv(GRADLE_ENV_PROPERTY_NAME);
        if (path == null) {
            return null;
        }
        File candidate = new File(path);
        return this.isGradleSdkHome(candidate) ? candidate : null;
    }

    public boolean isGradleSdkHome(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return this.isGradleSdkHome(new File(file.getPath()));
    }

    public boolean isGradleSdkHome(@Nullable File file) {
        if (file == null) {
            return false;
        }
        File libs = new File(file, "lib");
        if (!libs.isDirectory()) {
            if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
                GradleLog.LOG.info(String.format("Gradle sdk check failed for the path '%s'. Reason: it doesn't have a child directory named 'lib'", file.getAbsolutePath()));
            }
            return false;
        }
        boolean found = this.isGradleSdk(libs.listFiles());
        if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
            GradleLog.LOG.info(String.format("Gradle home check %s for the path '%s'", found ? "passed" : "failed", file.getAbsolutePath()));
        }
        return found;
    }

    public boolean isGradleSdkHome(String gradleHomePath) {
        return this.isGradleSdkHome(new File(gradleHomePath));
    }

    public boolean isGradleSdk(VirtualFile ... files) {
        if (files == null) {
            return false;
        }
        File[] arg = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            arg[i] = new File(files[i].getPath());
        }
        return this.isGradleSdk(arg);
    }

    private boolean isGradleSdk(File ... files) {
        return this.findGradleJar(files) != null;
    }

    @Nullable
    private File findGradleJar(File ... files) {
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (!GRADLE_JAR_FILE_PATTERN.matcher(file.getName()).matches()) continue;
            return file;
        }
        if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
            StringBuilder filesInfo = new StringBuilder();
            for (File file : files) {
                filesInfo.append(file.getAbsolutePath()).append(';');
            }
            if (filesInfo.length() > 0) {
                filesInfo.setLength(filesInfo.length() - 1);
            }
            GradleLog.LOG.info(String.format("Gradle sdk check fails. Reason: no one of the given files matches gradle JAR pattern (%s). Files: %s", GRADLE_JAR_FILE_PATTERN.toString(), filesInfo));
        }
        return null;
    }

    @Nullable
    public List<VirtualFile> getClassRoots(@Nullable Project project) {
        List<File> files = this.getClassRoots(project, null);
        if (files == null) {
            return null;
        }
        final LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        final JarFileSystem jarFileSystem = JarFileSystem.getInstance();
        return ContainerUtil.mapNotNull(files, (Function)new Function<File, VirtualFile>(){

            public VirtualFile fun(File file) {
                VirtualFile virtualFile = localFileSystem.refreshAndFindFileByIoFile(file);
                return virtualFile != null ? jarFileSystem.getJarRootForLocalFile(virtualFile) : null;
            }
        });
    }

    @Nullable
    public List<File> getClassRoots(@Nullable Project project, @Nullable String rootProjectPath) {
        if (project == null) {
            return null;
        }
        if (rootProjectPath == null) {
            for (Module module : this.myPlatformFacade.getModules(project)) {
                rootProjectPath = module.getOptionValue("external.root.project.path");
                List<File> result = this.findGradleSdkClasspath(project, rootProjectPath);
                if (result.isEmpty()) continue;
                return result;
            }
        } else {
            return this.findGradleSdkClasspath(project, rootProjectPath);
        }
        return null;
    }

    private List<File> findGradleSdkClasspath(Project project, String rootProjectPath) {
        Collection<File> libraries;
        ArrayList<File> result = new ArrayList<File>();
        if (StringUtil.isEmpty((String)rootProjectPath)) {
            return result;
        }
        File gradleHome = this.getGradleHome(project, rootProjectPath);
        if (gradleHome == null || !gradleHome.isDirectory()) {
            return result;
        }
        File src = new File(gradleHome, "src");
        if (src.isDirectory()) {
            if (new File(src, "org").isDirectory()) {
                this.addRoots(result, src);
            } else {
                this.addRoots(result, src.listFiles());
            }
        }
        if ((libraries = this.getAllLibraries(gradleHome)) == null) {
            return result;
        }
        for (File file : libraries) {
            if (!this.isGradleBuildClasspathLibrary(file)) continue;
            ContainerUtil.addIfNotNull(result, (Object)file);
        }
        return result;
    }

    private boolean isGradleBuildClasspathLibrary(File file) {
        String fileName = file.getName();
        return ANY_GRADLE_JAR_FILE_PATTERN.matcher(fileName).matches() || ANT_JAR_PATTERN.matcher(fileName).matches() || IVY_JAR_PATTERN.matcher(fileName).matches() || GroovyConfigUtils.matchesGroovyAll((String)fileName);
    }

    private void addRoots(@NotNull List<File> result, File ... files) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/gradle/service/GradleInstallationManager", "addRoots"));
        }
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file == null || !file.isDirectory()) continue;
            result.add(file);
        }
    }

    private File getWrappedGradleHome(String linkedProjectPath, @Nullable WrapperConfiguration wrapperConfiguration) {
        if (wrapperConfiguration == null) {
            return null;
        }
        File gradleSystemDir = "PROJECT".equals(wrapperConfiguration.getDistributionBase()) ? new File(linkedProjectPath, ".gradle") : StartParameter.DEFAULT_GRADLE_USER_HOME;
        if (!gradleSystemDir.isDirectory()) {
            return null;
        }
        PathAssembler.LocalDistribution localDistribution = new PathAssembler(gradleSystemDir).getDistribution(wrapperConfiguration);
        if (localDistribution.getDistributionDir() == null) {
            return null;
        }
        File[] distFiles = localDistribution.getDistributionDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() && StringUtil.startsWith((CharSequence)f.getName(), (CharSequence)"gradle-");
            }
        });
        return distFiles == null || distFiles.length == 0 ? null : distFiles[0];
    }

    static {
        ANT_JAR_PATTERN = Pattern.compile("ant(-(.*))?\\.jar");
        IVY_JAR_PATTERN = Pattern.compile("ivy(-(.*))?\\.jar");
        GRADLE_JAR_FILE_PATTERN = Pattern.compile(System.getProperty("gradle.pattern.core.jar", "gradle-(core-)?(\\d.*)\\.jar"));
        ANY_GRADLE_JAR_FILE_PATTERN = Pattern.compile(System.getProperty("gradle.pattern.core.jar", "gradle-(.*)\\.jar"));
        GRADLE_START_FILE_NAMES = System.getProperty("gradle.start.file.names", "gradle:gradle.cmd:gradle.sh").split(":");
        GRADLE_ENV_PROPERTY_NAME = System.getProperty("gradle.home.env.key", "GRADLE_HOME");
    }
}

