/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.console.GroovyShellActionBase;
import org.jetbrains.plugins.groovy.console.GroovyShellRunner;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;

public class GroovyConsoleAction
extends GroovyShellActionBase
implements DumbAware {
    @Override
    protected GroovyShellRunner getRunner(Module module) {
        return GroovyShellRunner.getAppropriateRunner(module);
    }

    @Override
    public String getTitle() {
        return "Groovy Console";
    }

    @Override
    protected LanguageConsoleImpl createConsole(Project project, String title) {
        return new LanguageConsoleImpl(project, title, GroovyLanguage.INSTANCE){

            @NotNull
            protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/console/GroovyConsoleAction$1", "createFile"));
                }
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/plugins/groovy/console/GroovyConsoleAction$1", "createFile"));
                }
                GroovyCodeFragment groovyCodeFragment = new GroovyCodeFragment(this.getProject(), virtualFile);
                if (groovyCodeFragment == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyConsoleAction$1", "createFile"));
                }
                return groovyCodeFragment;
            }
        };
    }
}

