/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.field;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldHandler;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldSettings;

public class GrIntroduceFieldProcessor {
    private static final Logger LOG = Logger.getInstance(GrIntroduceFieldProcessor.class);
    private final GrIntroduceContext myContext;
    private final GrIntroduceFieldSettings mySettings;
    @Nullable
    private GrExpression myInitializer;
    @Nullable
    private GrVariable myLocalVariable;

    public GrIntroduceFieldProcessor(@NotNull GrIntroduceContext context, @NotNull GrIntroduceFieldSettings settings) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "<init>"));
        }
        this.myContext = context;
        this.mySettings = settings;
    }

    @Nullable
    public GrVariable run() {
        PsiClass targetClass;
        PsiElement scope = this.myContext.getScope();
        PsiClass psiClass = targetClass = scope instanceof GroovyFileBase ? ((GroovyFileBase)scope).getScriptClass() : (PsiClass)scope;
        if (targetClass == null) {
            return null;
        }
        GrVariableDeclaration declaration = this.insertField(targetClass);
        GrVariable field = declaration.getVariables()[0];
        if (this.mySettings.removeLocalVar()) {
            this.myLocalVariable = GrIntroduceHandlerBase.resolveLocalVar(this.myContext);
            assert (this.myLocalVariable != null) : this.myContext.getExpression() + ", " + this.myContext.getVar() + ", " + this.myContext.getStringPart();
        }
        this.myInitializer = (GrExpression)this.getInitializer().copy();
        List<PsiElement> replaced = this.processOccurrences(targetClass, field);
        switch (this.mySettings.initializeIn()) {
            case CUR_METHOD: {
                this.initializeInMethod(field, replaced);
                break;
            }
            case FIELD_DECLARATION: {
                field.setInitializerGroovy(this.myInitializer);
                break;
            }
            case CONSTRUCTOR: {
                this.initializeInConstructor(field);
                break;
            }
            case SETUP_METHOD: {
                this.initializeInSetup(field);
            }
        }
        JavaCodeStyleManager.getInstance((Project)declaration.getProject()).shortenClassReferences((PsiElement)declaration);
        if (this.mySettings.removeLocalVar()) {
            GrIntroduceHandlerBase.deleteLocalVar(this.myLocalVariable);
        }
        return field;
    }

    @NotNull
    private List<PsiElement> processOccurrences(@NotNull PsiClass targetClass, @NotNull GrVariable field) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "processOccurrences"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "processOccurrences"));
        }
        if (this.myContext.getStringPart() != null) {
            GrExpression expr = this.myContext.getStringPart().replaceLiteralWithConcatenation(field.getName());
            PsiElement occurrence = this.replaceOccurrence(field, expr, targetClass);
            this.updateCaretPosition(occurrence);
            List<PsiElement> list = Collections.singletonList(occurrence);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "processOccurrences"));
            }
            return list;
        }
        if (this.mySettings.replaceAllOccurrences()) {
            GroovyRefactoringUtil.sortOccurrences(this.myContext.getOccurrences());
            ArrayList result = ContainerUtil.newArrayList();
            for (PsiElement occurrence : this.myContext.getOccurrences()) {
                result.add(this.replaceOccurrence(field, occurrence, targetClass));
            }
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "processOccurrences"));
            }
            return arrayList;
        }
        GrVariable var = this.myContext.getVar();
        if (var != null) {
            GrExpression initializer = var.getInitializerGroovy();
            if (initializer != null) {
                List<PsiElement> list = Collections.singletonList(this.replaceOccurrence(field, initializer, targetClass));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "processOccurrences"));
                }
                return list;
            }
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "processOccurrences"));
            }
            return list;
        }
        GrExpression expression = this.myContext.getExpression();
        assert (expression != null);
        if (PsiUtil.isExpressionStatement(expression)) {
            List<PsiElement> list = Collections.singletonList(expression);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "processOccurrences"));
            }
            return list;
        }
        List<PsiElement> list = Collections.singletonList(this.replaceOccurrence(field, expression, targetClass));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "processOccurrences"));
        }
        return list;
    }

    private void updateCaretPosition(@NotNull PsiElement occurrence) {
        if (occurrence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrence", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "updateCaretPosition"));
        }
        this.myContext.getEditor().getCaretModel().moveToOffset(occurrence.getTextRange().getEndOffset());
        this.myContext.getEditor().getSelectionModel().removeSelection();
    }

    @NotNull
    protected GrVariableDeclaration insertField(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "insertField"));
        }
        GrVariableDeclaration declaration = this.createField(targetClass);
        if (targetClass instanceof GrEnumTypeDefinition) {
            GrEnumConstantList enumConstants = ((GrEnumTypeDefinition)targetClass).getEnumConstantList();
            GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)targetClass.addAfter((PsiElement)declaration, (PsiElement)enumConstants);
            if (grVariableDeclaration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "insertField"));
            }
            return grVariableDeclaration;
        }
        if (targetClass instanceof GrTypeDefinition) {
            PsiElement anchor = GrIntroduceFieldProcessor.getAnchorForDeclaration((GrTypeDefinition)targetClass);
            GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)targetClass.addAfter((PsiElement)declaration, anchor);
            if (grVariableDeclaration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "insertField"));
            }
            return grVariableDeclaration;
        }
        assert (targetClass instanceof GroovyScriptClass);
        GroovyFile file = ((GroovyScriptClass)targetClass).getContainingFile();
        Object[] elements = file.getMethods();
        if (elements.length == 0) {
            elements = file.getStatements();
        }
        PsiElement anchor = (PsiElement)ArrayUtil.getFirstElement((Object[])elements);
        GrVariableDeclaration grVariableDeclaration = (GrVariableDeclaration)file.addBefore(declaration, anchor);
        if (grVariableDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "insertField"));
        }
        return grVariableDeclaration;
    }

    @Nullable
    private static PsiElement getAnchorForDeclaration(@NotNull GrTypeDefinition targetClass) {
        GrMembersDeclaration[] declarations;
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "getAnchorForDeclaration"));
        }
        PsiElement anchor = targetClass.getBody().getLBrace();
        for (GrMembersDeclaration declaration : declarations = targetClass.getMemberDeclarations()) {
            if (declaration instanceof GrVariableDeclaration) {
                anchor = declaration;
            }
            if (declaration instanceof GrVariableDeclaration) continue;
            return anchor;
        }
        return anchor;
    }

    void initializeInSetup(@NotNull GrVariable field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "initializeInSetup"));
        }
        PsiMethod setUpMethod = TestFrameworks.getInstance().findOrCreateSetUpMethod((PsiClass)this.myContext.getScope());
        assert (setUpMethod instanceof GrMethod);
        GrOpenBlock body = ((GrMethod)setUpMethod).getBlock();
        PsiElement anchor = this.findAnchorForAssignment(body);
        this.generateAssignment(field, (GrStatement)anchor, body, null);
    }

    void initializeInMethod(@NotNull GrVariable field, @NotNull List<PsiElement> replaced) {
        PsiElement anchor;
        GrOpenBlock container;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "initializeInMethod"));
        }
        if (replaced == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replaced", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "initializeInMethod"));
        }
        PsiElement _scope = this.myContext.getScope();
        PsiElement scope = _scope instanceof GroovyScriptClass ? ((GroovyScriptClass)_scope).getContainingFile() : _scope;
        PsiElement place = replaced.get(0);
        GrMember member = GrIntroduceFieldHandler.getContainer(place, scope);
        GrVariableDeclarationOwner grVariableDeclarationOwner = member instanceof GrMethod ? ((GrMethod)member).getBlock() : (member instanceof GrClassInitializer ? ((GrClassInitializer)member).getBlock() : (container = place.getContainingFile() instanceof GroovyFile ? (GroovyFile)place.getContainingFile() : null));
        assert (container != null);
        if (this.mySettings.removeLocalVar()) {
            GrVariable variable = this.myLocalVariable;
            anchor = PsiTreeUtil.getParentOfType((PsiElement)variable, GrStatement.class);
        } else {
            anchor = GrIntroduceHandlerBase.findAnchor(replaced.toArray(new PsiElement[replaced.size()]), container);
            GrIntroduceHandlerBase.assertStatement(anchor, this.myContext.getScope());
        }
        PsiElement occurrence = replaced.get(0);
        if (!this.mySettings.replaceAllOccurrences() && !GrIntroduceFieldProcessor.isRefToField(occurrence, field) && PsiUtil.isExpressionStatement(occurrence)) {
            this.generateAssignment(field, (GrStatement)anchor, container, occurrence);
        } else {
            this.generateAssignment(field, (GrStatement)anchor, container, null);
        }
    }

    private static boolean isRefToField(@NotNull PsiElement occurrence, @NotNull PsiElement field) {
        if (occurrence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrence", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "isRefToField"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "isRefToField"));
        }
        return occurrence instanceof GrReferenceExpression && ((GrReferenceExpression)occurrence).resolve() == field;
    }

    void initializeInConstructor(@NotNull GrVariable field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "initializeInConstructor"));
        }
        PsiClass scope = (PsiClass)this.myContext.getScope();
        if (scope instanceof GrAnonymousClassDefinition) {
            this.initializeInAnonymousClassInitializer(field, (GrAnonymousClassDefinition)scope);
        } else {
            this.initializeInConstructor(field, scope);
        }
    }

    private void initializeInConstructor(@NotNull GrVariable field, @NotNull PsiClass scope) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "initializeInConstructor"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "initializeInConstructor"));
        }
        PsiMethod[] constructors = scope.getConstructors();
        if (constructors.length == 0) {
            constructors = new PsiMethod[]{this.generateConstructor(scope)};
        }
        for (PsiMethod constructor : constructors) {
            GrConstructorInvocation invocation = PsiImplUtil.getChainingConstructorInvocation((GrMethod)constructor);
            if (invocation != null && invocation.isThisCall()) continue;
            PsiElement anchor = this.findAnchorForAssignment(((GrMethod)constructor).getBlock());
            this.generateAssignment(field, (GrStatement)anchor, ((GrMethod)constructor).getBlock(), null);
        }
    }

    @NotNull
    private PsiMethod generateConstructor(@NotNull PsiClass scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "generateConstructor"));
        }
        String name = scope.getName();
        LOG.assertTrue(name != null, (Object)scope.getText());
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myContext.getProject());
        GrMethod constructor = factory.createConstructorFromText(name, ArrayUtil.EMPTY_STRING_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, "{}", (PsiElement)scope);
        if (scope instanceof GroovyScriptClass) {
            constructor.getModifierList().setModifierProperty("def", true);
        }
        PsiMethod psiMethod = (PsiMethod)scope.add((PsiElement)constructor);
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "generateConstructor"));
        }
        return psiMethod;
    }

    private void initializeInAnonymousClassInitializer(@NotNull GrVariable field, @NotNull GrAnonymousClassDefinition scope) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "initializeInAnonymousClassInitializer"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "initializeInAnonymousClassInitializer"));
        }
        GrClassInitializer[] initializers = scope.getInitializers();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myContext.getProject());
        GrClassInitializer initializer = initializers.length == 0 ? (GrClassInitializer)scope.add(factory.createClassInitializer()) : initializers[0];
        PsiElement anchor = this.findAnchorForAssignment(initializer.getBlock());
        this.generateAssignment(field, (GrStatement)anchor, initializer.getBlock(), null);
    }

    private void generateAssignment(@NotNull GrVariable field, @Nullable GrStatement anchor, @NotNull GrStatementOwner defaultContainer, @Nullable PsiElement occurrenceToDelete) {
        GrStatementOwner block;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "generateAssignment"));
        }
        if (defaultContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultContainer", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "generateAssignment"));
        }
        if (this.myInitializer == null) {
            return;
        }
        GrAssignmentExpression init = (GrAssignmentExpression)GroovyPsiElementFactory.getInstance(this.myContext.getProject()).createExpressionFromText(this.mySettings.getName() + " = " + this.myInitializer.getText());
        if (anchor != null) {
            anchor = GroovyRefactoringUtil.addBlockIntoParent(anchor);
            LOG.assertTrue(anchor.getParent() instanceof GrStatementOwner);
            block = (GrStatementOwner)anchor.getParent();
        } else {
            block = defaultContainer;
        }
        init = (GrAssignmentExpression)block.addStatementBefore(init, anchor);
        this.replaceOccurrence(field, init.getLValue(), (PsiClass)this.myContext.getScope());
        if (occurrenceToDelete != null) {
            occurrenceToDelete.delete();
        }
    }

    @Nullable
    private GrExpression extractVarInitializer() {
        assert (this.myLocalVariable != null);
        return this.myLocalVariable.getInitializerGroovy();
    }

    @Nullable
    private PsiElement findAnchorForAssignment(final GrCodeBlock block) {
        List elements = ContainerUtil.findAll((Object[])this.myContext.getOccurrences(), (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)element, (boolean)true);
            }
        });
        if (elements.isEmpty()) {
            return null;
        }
        return GrIntroduceHandlerBase.findAnchor((PsiElement[])ContainerUtil.toArray((List)elements, (Object[])new PsiElement[elements.size()]), block);
    }

    @NotNull
    private PsiElement replaceOccurrence(@NotNull GrVariable field, @NotNull PsiElement occurrence, @NotNull PsiClass containingClass) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "replaceOccurrence"));
        }
        if (occurrence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrence", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "replaceOccurrence"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "replaceOccurrence"));
        }
        boolean isOriginal = occurrence == this.myContext.getExpression();
        GrReferenceExpression newExpr = GrIntroduceFieldProcessor.createRefExpression(field, occurrence, containingClass);
        PsiElement replaced = occurrence instanceof GrExpression ? ((GrExpression)occurrence).replaceWithExpression(newExpr, false) : occurrence.replace((PsiElement)newExpr);
        if (replaced instanceof GrQualifiedReference) {
            GrReferenceAdjuster.shortenReference((GrQualifiedReference)replaced);
        }
        if (isOriginal) {
            this.updateCaretPosition(replaced);
        }
        PsiElement psiElement = replaced;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "replaceOccurrence"));
        }
        return psiElement;
    }

    @NotNull
    private static GrReferenceExpression createRefExpression(@NotNull GrVariable field, @NotNull PsiElement place, @NotNull PsiClass containingClass) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "createRefExpression"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "createRefExpression"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "createRefExpression"));
        }
        String qname = containingClass.getQualifiedName();
        String prefix = qname != null ? qname + "." : "";
        String refText = field.hasModifierProperty("static") ? prefix + field.getName() : prefix + "this." + field.getName();
        GrReferenceExpression grReferenceExpression = GroovyPsiElementFactory.getInstance(place.getProject()).createReferenceExpressionFromText(refText, place);
        if (grReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "createRefExpression"));
        }
        return grReferenceExpression;
    }

    @NotNull
    private GrVariableDeclaration createField(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "createField"));
        }
        String name = this.mySettings.getName();
        PsiType type = this.mySettings.getSelectedType();
        String modifier = this.mySettings.getVisibilityModifier();
        ArrayList<String> modifiers = new ArrayList<String>();
        if (targetClass instanceof GroovyScriptClass) {
            modifiers.add("@groovy.transform.Field");
        }
        if (this.mySettings.isStatic()) {
            modifiers.add("static");
        }
        if (!"packageLocal".equals(modifier)) {
            modifiers.add(modifier);
        }
        if (this.mySettings.declareFinal()) {
            modifiers.add("final");
        }
        String[] arr_modifiers = ArrayUtil.toStringArray(modifiers);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.myContext.getProject());
        if (targetClass instanceof GroovyScriptClass) {
            GrVariableDeclaration grVariableDeclaration = factory.createVariableDeclaration(arr_modifiers, (GrExpression)null, type, name);
            if (grVariableDeclaration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "createField"));
            }
            return grVariableDeclaration;
        }
        GrVariableDeclaration grVariableDeclaration = factory.createFieldDeclaration(arr_modifiers, name, null, type);
        if (grVariableDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldProcessor", "createField"));
        }
        return grVariableDeclaration;
    }

    @Nullable
    protected GrExpression getInitializer() {
        if (this.mySettings.removeLocalVar()) {
            return this.extractVarInitializer();
        }
        GrExpression expression = this.myContext.getExpression();
        StringPartInfo stringPart = this.myContext.getStringPart();
        if (expression != null) {
            return expression;
        }
        if (stringPart != null) {
            return stringPart.createLiteralFromSelected();
        }
        throw new IncorrectOperationException("cannot be here!");
    }
}

