/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaCompilerOutputImpl;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaContentRootImpl;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaSourceDirectoryImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ModuleExtendedModelImpl;

public class ModuleExtendedModelBuilderImpl
implements ModelBuilderService {
    private static final String SOURCE_SETS_PROPERTY = "sourceSets";
    private static final String TEST_SRC_DIRS_PROPERTY = "testSrcDirs";

    public boolean canBuild(String modelName) {
        return ModuleExtendedModel.class.getName().equals(modelName);
    }

    @Nullable
    public Object buildAll(String modelName, Project project) {
        Object sourceSets;
        String moduleName = project.getName();
        String moduleGroup = project.getGroup().toString();
        String moduleVersion = project.getVersion().toString();
        File buildDir = project.getBuildDir();
        ModuleExtendedModelImpl moduleVersionModel = new ModuleExtendedModelImpl(moduleName, moduleGroup, moduleVersion, buildDir);
        ArrayList<File> artifacts = new ArrayList<File>();
        for (Task task : project.getTasks()) {
            if (!(task instanceof Jar)) continue;
            Jar jar = (Jar)task;
            artifacts.add(jar.getArchivePath());
        }
        moduleVersionModel.setArtifacts(artifacts);
        HashSet<String> sourceDirectories = new HashSet<String>();
        HashSet<String> testDirectories = new HashSet<String>();
        HashSet resourceDirectories = new HashSet();
        HashSet<String> testResourceDirectories = new HashSet<String>();
        ArrayList<File> testClassesDirs = new ArrayList<File>();
        for (Task task : project.getTasks()) {
            Object testSrcDirs;
            if (!(task instanceof Test)) continue;
            Test test = (Test)task;
            testClassesDirs.add(test.getTestClassesDir());
            if (!test.hasProperty(TEST_SRC_DIRS_PROPERTY) || !((testSrcDirs = test.property(TEST_SRC_DIRS_PROPERTY)) instanceof Iterable)) continue;
            for (Object dir : (Iterable)Iterable.class.cast(testSrcDirs)) {
                ModuleExtendedModelBuilderImpl.addFilePath(testDirectories, dir);
            }
        }
        IdeaCompilerOutputImpl compilerOutput = new IdeaCompilerOutputImpl();
        if (project.hasProperty(SOURCE_SETS_PROPERTY) && (sourceSets = project.property(SOURCE_SETS_PROPERTY)) instanceof SourceSetContainer) {
            SourceSetContainer sourceSetContainer = (SourceSetContainer)sourceSets;
            for (SourceSet sourceSet : sourceSetContainer) {
                boolean isTestDir;
                SourceSetOutput output = sourceSet.getOutput();
                if ("test".equals(sourceSet.getName())) {
                    compilerOutput.setTestClassesDir(output.getClassesDir());
                    compilerOutput.setTestResourcesDir(output.getResourcesDir());
                }
                if ("main".equals(sourceSet.getName())) {
                    compilerOutput.setMainClassesDir(output.getClassesDir());
                    compilerOutput.setMainResourcesDir(output.getResourcesDir());
                }
                for (File javaSrcDir : sourceSet.getAllJava().getSrcDirs()) {
                    isTestDir = ModuleExtendedModelBuilderImpl.isTestDir(sourceSet, testClassesDirs);
                    ModuleExtendedModelBuilderImpl.addFilePath(isTestDir ? testDirectories : sourceDirectories, javaSrcDir);
                }
                for (File resourcesSrcDir : sourceSet.getResources().getSrcDirs()) {
                    isTestDir = ModuleExtendedModelBuilderImpl.isTestDir(sourceSet, testClassesDirs);
                    ModuleExtendedModelBuilderImpl.addFilePath(isTestDir ? testResourceDirectories : resourceDirectories, resourcesSrcDir);
                }
            }
        }
        File projectDir = project.getProjectDir();
        IdeaContentRootImpl contentRoot = new IdeaContentRootImpl(projectDir);
        HashSet<String> ideaSourceDirectories = new HashSet<String>();
        HashSet<String> ideaTestDirectories = new HashSet<String>();
        HashSet<String> ideaGeneratedDirectories = new HashSet<String>();
        HashSet<File> excludeDirectories = new HashSet<File>();
        ModuleExtendedModelBuilderImpl.enrichDataFromIdeaPlugin(project, excludeDirectories, ideaSourceDirectories, ideaTestDirectories, ideaGeneratedDirectories);
        if (ideaSourceDirectories.isEmpty()) {
            sourceDirectories.clear();
            resourceDirectories.clear();
        }
        if (ideaTestDirectories.isEmpty()) {
            testDirectories.clear();
            testResourceDirectories.clear();
        }
        ideaSourceDirectories.removeAll(resourceDirectories);
        sourceDirectories.removeAll(ideaTestDirectories);
        sourceDirectories.addAll(ideaSourceDirectories);
        ideaTestDirectories.removeAll(testResourceDirectories);
        testDirectories.addAll(ideaTestDirectories);
        resourceDirectories.removeAll(sourceDirectories);
        testDirectories.removeAll(sourceDirectories);
        testResourceDirectories.removeAll(testDirectories);
        for (String javaDir : sourceDirectories) {
            contentRoot.addSourceDirectory(new IdeaSourceDirectoryImpl(new File(javaDir), ideaGeneratedDirectories.contains(javaDir)));
        }
        for (String testDir : testDirectories) {
            contentRoot.addTestDirectory(new IdeaSourceDirectoryImpl(new File(testDir), ideaGeneratedDirectories.contains(testDir)));
        }
        for (String resourceDir : resourceDirectories) {
            contentRoot.addResourceDirectory(new IdeaSourceDirectoryImpl(new File(resourceDir)));
        }
        for (String testResourceDir : testResourceDirectories) {
            contentRoot.addTestResourceDirectory(new IdeaSourceDirectoryImpl(new File(testResourceDir)));
        }
        for (File excludeDir : excludeDirectories) {
            contentRoot.addExcludeDirectory(excludeDir);
        }
        moduleVersionModel.setContentRoots(Collections.singleton(contentRoot));
        moduleVersionModel.setCompilerOutput(compilerOutput);
        return moduleVersionModel;
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/tooling/builder/ModuleExtendedModelBuilderImpl", "getErrorMessageBuilder"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/tooling/builder/ModuleExtendedModelBuilderImpl", "getErrorMessageBuilder"));
        }
        ErrorMessageBuilder errorMessageBuilder = ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Other").withDescription("Unable to resolve all content root directories");
        if (errorMessageBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/tooling/builder/ModuleExtendedModelBuilderImpl", "getErrorMessageBuilder"));
        }
        return errorMessageBuilder;
    }

    private static boolean isTestDir(SourceSet sourceSet, List<File> testClassesDirs) {
        if ("test".equals(sourceSet.getName())) {
            return true;
        }
        if ("main".equals(sourceSet.getName())) {
            return false;
        }
        File sourceSetClassesDir = sourceSet.getOutput().getClassesDir();
        for (File testClassesDir : testClassesDirs) {
            do {
                if (!sourceSetClassesDir.getPath().equals(testClassesDir.getPath())) continue;
                return true;
            } while ((testClassesDir = testClassesDir.getParentFile()) != null);
        }
        return false;
    }

    private static void addFilePath(Set<String> filePathSet, Object file) {
        if (file instanceof File) {
            try {
                filePathSet.add(((File)file).getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void enrichDataFromIdeaPlugin(Project project, Set<File> excludeDirectories, Set<String> javaDirectories, Set<String> testDirectories, Set<String> ideaGeneratedDirectories) {
        IdeaPlugin ideaPlugin = (IdeaPlugin)project.getPlugins().getPlugin(IdeaPlugin.class);
        if (ideaPlugin == null) {
            return;
        }
        IdeaModel ideaModel = ideaPlugin.getModel();
        if (ideaModel == null || ideaModel.getModule() == null) {
            return;
        }
        for (File excludeDir : ideaModel.getModule().getExcludeDirs()) {
            excludeDirectories.add(excludeDir);
        }
        for (File file : ideaModel.getModule().getSourceDirs()) {
            javaDirectories.add(file.getPath());
        }
        for (File file : ideaModel.getModule().getTestSourceDirs()) {
            testDirectories.add(file.getPath());
        }
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"2.2")) >= 0) {
            for (File file : ideaModel.getModule().getGeneratedSourceDirs()) {
                ideaGeneratedDirectories.add(file.getPath());
            }
        }
    }
}

