/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgRebaseCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final HgRepository repo;

    public HgRebaseCommand(@NotNull Project project, @NotNull HgRepository repo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgRebaseCommand", "<init>"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgRebaseCommand", "<init>"));
        }
        this.project = project;
        this.repo = repo;
    }

    @Nullable
    public HgCommandResult startRebase() {
        return this.performRebase(ArrayUtil.EMPTY_STRING_ARRAY);
    }

    @Nullable
    public HgCommandResult continueRebase() {
        return this.performRebase("--continue");
    }

    @Nullable
    public HgCommandResult abortRebase() {
        return this.performRebase("--abort");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private HgCommandResult performRebase(String ... args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/zmlx/hg4idea/command/HgRebaseCommand", "performRebase"));
        }
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.project);
        try {
            HgCommandResult result = new HgCommandExecutor(this.project).executeInCurrentThread(this.repo.getRoot(), "rebase", ContainerUtil.list((Object[])args));
            this.repo.update();
            ((HgUpdater)this.project.getMessageBus().syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.project, null);
            HgCommandResult hgCommandResult = result;
            return hgCommandResult;
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.project, (AccessToken)token);
        }
    }
}

