/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgErrorHandler;
import org.zmlx.hg4idea.HgFileStatusEnum;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgCommandExitCode;
import org.zmlx.hg4idea.command.HgCommitCommand;
import org.zmlx.hg4idea.command.HgHeadsCommand;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.command.HgMergePreviewCommand;
import org.zmlx.hg4idea.command.HgPullCommand;
import org.zmlx.hg4idea.command.HgRebaseCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.provider.update.HgUpdateConfigurationSettings;
import org.zmlx.hg4idea.provider.update.HgUpdateType;
import org.zmlx.hg4idea.provider.update.HgUpdater;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRegularUpdater
implements HgUpdater {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile repoRoot;
    @NotNull
    private final HgUpdateConfigurationSettings updateConfiguration;
    private static final Logger LOG = Logger.getInstance(HgRegularUpdater.class);

    public HgRegularUpdater(@NotNull Project project, @NotNull VirtualFile repository, @NotNull HgUpdateConfigurationSettings configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/update/HgRegularUpdater", "<init>"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/provider/update/HgRegularUpdater", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/zmlx/hg4idea/provider/update/HgRegularUpdater", "<init>"));
        }
        this.project = project;
        this.repoRoot = repository;
        this.updateConfiguration = configuration;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean update(UpdatedFiles updatedFiles, ProgressIndicator indicator, List<VcsException> warnings) throws VcsException {
        HgCommandExitCode pullResult;
        indicator.setText(HgVcsMessages.message("hg4idea.progress.updating", this.repoRoot.getPath()));
        String defaultPath = HgUtil.getRepositoryDefaultPath(this.project, this.repoRoot);
        if (StringUtil.isEmptyOrSpaces((String)defaultPath)) {
            throw new VcsException(HgVcsMessages.message("hg4idea.warning.no-default-update-path", this.repoRoot.getPath()));
        }
        List<HgRevisionNumber> branchHeadsBeforePull = new HgHeadsCommand(this.project, this.repoRoot).execute();
        if (branchHeadsBeforePull.size() > 1) {
            HgRegularUpdater.reportWarning(warnings, HgVcsMessages.message("hg4idea.update.warning.multipleHeadsBeforeUpdate", this.repoRoot.getPath()));
        }
        if (this.updateConfiguration.shouldPull() && (pullResult = this.pull(this.repoRoot, indicator)) == HgCommandExitCode.ERROR) {
            return false;
        }
        List<HgRevisionNumber> parentsBeforeUpdate = new HgWorkingCopyRevisionsCommand(this.project).parents(this.repoRoot);
        if (parentsBeforeUpdate.size() > 1) {
            throw new VcsException(HgVcsMessages.message("hg4idea.update.error.uncommittedMerge", this.repoRoot.getPath()));
        }
        indicator.setText2(HgVcsMessages.message("hg4idea.progress.countingHeads", new Object[0]));
        List<HgRevisionNumber> branchHeadsAfterPull = new HgHeadsCommand(this.project, this.repoRoot).execute();
        List<HgRevisionNumber> pulledBranchHeads = HgRegularUpdater.determinePulledBranchHeads(branchHeadsBeforePull, branchHeadsAfterPull);
        List<HgRevisionNumber> remainingOriginalBranchHeads = HgRegularUpdater.determingRemainingOriginalBranchHeads(branchHeadsBeforePull, branchHeadsAfterPull);
        HgUpdateType updateType = this.updateConfiguration.getUpdateType();
        if (branchHeadsAfterPull.size() > 1 && updateType != HgUpdateType.ONLY_UPDATE) {
            if (updateType != HgUpdateType.MERGE) {
                this.processRebase(indicator, updatedFiles);
                return true;
            }
            this.abortOnLocalChanges();
            this.abortOnMultiplePulledHeads(pulledBranchHeads);
            this.abortOnMultipleLocalHeads(remainingOriginalBranchHeads);
            HgCommandResult mergeResult = this.doMerge(indicator);
            if (this.updateConfiguration.shouldCommitAfterMerge()) {
                this.commitOrWarnAboutConflicts(warnings, mergeResult);
            }
        } else {
            this.update(this.repoRoot, indicator, updatedFiles, warnings);
        }
        this.resolvePossibleConflicts(updatedFiles);
        return true;
    }

    private static List<HgRevisionNumber> determingRemainingOriginalBranchHeads(List<HgRevisionNumber> branchHeadsBeforePull, List<HgRevisionNumber> branchHeadsAfterPull) {
        ArrayList<HgRevisionNumber> originalBranchHeadsRemaining = new ArrayList<HgRevisionNumber>();
        for (HgRevisionNumber headAfterPull : branchHeadsAfterPull) {
            if (!branchHeadsBeforePull.contains(headAfterPull)) continue;
            originalBranchHeadsRemaining.add(headAfterPull);
        }
        return originalBranchHeadsRemaining;
    }

    private static List<HgRevisionNumber> determinePulledBranchHeads(List<HgRevisionNumber> branchHeadsBeforePull, List<HgRevisionNumber> branchHeadsAfterPull) {
        ArrayList<HgRevisionNumber> pulledBranchHeads = new ArrayList<HgRevisionNumber>(branchHeadsAfterPull);
        pulledBranchHeads.removeAll(branchHeadsBeforePull);
        return pulledBranchHeads;
    }

    private void abortOnMultipleLocalHeads(List<HgRevisionNumber> originalBranchHeadsRemaining) throws VcsException {
        if (originalBranchHeadsRemaining.size() != 1) {
            throw new VcsException(HgVcsMessages.message("hg4idea.update.error.merge.multipleLocalHeads", this.repoRoot.getPath()));
        }
    }

    private void abortOnMultiplePulledHeads(List<HgRevisionNumber> newBranchHeadsAfterPull) throws VcsException {
        if (newBranchHeadsAfterPull.size() != 1) {
            throw new VcsException(HgVcsMessages.message("hg4idea.update.error.merge.multipleRemoteHeads", newBranchHeadsAfterPull.size(), this.repoRoot.getPath()));
        }
    }

    private void updateToPulledHead(VirtualFile repo, UpdatedFiles updatedFiles, HgRevisionNumber newHead, ProgressIndicator indicator) {
        indicator.setText2(HgVcsMessages.message("hg4idea.update.progress.updating.to.pulled.head", new Object[0]));
        HgRevisionNumber parentBeforeUpdate = new HgWorkingCopyRevisionsCommand(this.project).firstParent(repo);
        HgUpdateCommand updateCommand = new HgUpdateCommand(this.project, this.repoRoot);
        updateCommand.setRevision(newHead.getChangeset());
        updateCommand.setClean(true);
        updateCommand.execute();
        HgRevisionNumber commonParent = this.findCommonParent(newHead, parentBeforeUpdate);
        this.addUpdatedFiles(repo, updatedFiles, commonParent, newHead);
    }

    @Nullable
    private HgRevisionNumber findCommonParent(HgRevisionNumber newHead, HgRevisionNumber parentBeforeUpdate) {
        List<HgRevisionNumber> pulledRevisions = new HgMergePreviewCommand(this.project, newHead, parentBeforeUpdate, 1).execute(this.repoRoot);
        if (pulledRevisions == null || pulledRevisions.isEmpty()) {
            return null;
        }
        HgRevisionNumber pulledRevision = pulledRevisions.get(0);
        List<HgRevisionNumber> parentRevisions = new HgWorkingCopyRevisionsCommand(this.project).getRevisions(this.repoRoot, "parent", null, pulledRevision, true);
        if (parentRevisions.isEmpty()) {
            return null;
        }
        return parentRevisions.get(0);
    }

    private void commitOrWarnAboutConflicts(List<VcsException> exceptions, HgCommandResult mergeResult) throws VcsException {
        if (mergeResult.getExitValue() == 0) {
            try {
                HgRepository hgRepository = HgUtil.getRepositoryForFile(this.project, this.repoRoot);
                if (hgRepository == null) {
                    LOG.warn("Couldn't find repository info for " + this.repoRoot.getName());
                    return;
                }
                new HgCommitCommand(this.project, hgRepository, "Automated merge").execute();
            }
            catch (HgCommandException e) {
                throw new VcsException((Throwable)e);
            }
        } else {
            HgRegularUpdater.reportWarning(exceptions, HgVcsMessages.message("hg4idea.update.warning.merge.conflicts", this.repoRoot.getPath()));
        }
    }

    private HgCommandResult doMerge(ProgressIndicator indicator) throws VcsException {
        indicator.setText2(HgVcsMessages.message("hg4idea.update.progress.merging", new Object[0]));
        HgMergeCommand mergeCommand = new HgMergeCommand(this.project, this.repoRoot);
        return mergeCommand.merge();
    }

    private void processRebase(ProgressIndicator indicator, UpdatedFiles updatedFiles) throws VcsException {
        indicator.setText2(HgVcsMessages.message("hg4idea.progress.rebase", new Object[0]));
        HgRepository repository = (HgRepository)HgUtil.getRepositoryManager(this.project).getRepositoryForRoot(this.repoRoot);
        if (repository == null) {
            throw new VcsException("Repository not found for root " + this.repoRoot);
        }
        HgRebaseCommand rebaseCommand = new HgRebaseCommand(this.project, repository);
        HgCommandResult result = new HgRebaseCommand(this.project, repository).startRebase();
        if (HgErrorUtil.isAbort(result)) {
            new HgCommandResultNotifier(this.project).notifyError(result, "Hg Error", "Couldn't rebase repository.");
            return;
        }
        while (result.getExitValue() == 1) {
            this.resolvePossibleConflicts(updatedFiles);
            if (!HgConflictResolver.findConflicts(this.project, this.repoRoot).isEmpty()) break;
            result = rebaseCommand.continueRebase();
            if (!HgErrorUtil.isAbort(result)) continue;
            new HgCommandResultNotifier(this.project).notifyError(result, "Hg Error", "Couldn't continue rebasing");
            break;
        }
        repository.update();
        this.repoRoot.refresh(true, true);
    }

    private void abortOnLocalChanges() throws VcsException {
        if (this.getLocalChanges().size() != 0) {
            throw new VcsException(HgVcsMessages.message("hg4idea.update.error.localchanges", this.repoRoot.getPath()));
        }
    }

    private void resolvePossibleConflicts(UpdatedFiles updatedFiles) {
        new HgConflictResolver(this.project, updatedFiles).resolve(this.repoRoot);
    }

    private Set<HgChange> getLocalChanges() {
        HgStatusCommand statusCommand = new HgStatusCommand.Builder(true).unknown(false).ignored(false).build(this.project);
        return statusCommand.execute(this.repoRoot);
    }

    private HgCommandExitCode pull(VirtualFile repo, ProgressIndicator indicator) throws VcsException {
        indicator.setText2(HgVcsMessages.message("hg4idea.progress.pull.with.update", new Object[0]));
        HgPullCommand hgPullCommand = new HgPullCommand(this.project, repo);
        String defaultPath = HgUtil.getRepositoryDefaultPath(this.project, repo);
        hgPullCommand.setSource(defaultPath);
        return hgPullCommand.execute();
    }

    private void update(@NotNull VirtualFile repo, ProgressIndicator indicator, UpdatedFiles updatedFiles, List<VcsException> warnings) throws VcsException {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/provider/update/HgRegularUpdater", "update"));
        }
        indicator.setText2(HgVcsMessages.message("hg4idea.progress.updatingworkingdir", new Object[0]));
        HgRevisionNumber parentBeforeUpdate = new HgWorkingCopyRevisionsCommand(this.project).firstParent(repo);
        HgUpdateCommand hgUpdateCommand = new HgUpdateCommand(this.project, repo);
        HgCommandResult updateResult = hgUpdateCommand.execute();
        String warningMessages = HgErrorHandler.ensureSuccess(updateResult).getRawError();
        HgRegularUpdater.handlePossibleWarning(warnings, warningMessages);
        HgRevisionNumber parentAfterUpdate = new HgWorkingCopyRevisionsCommand(this.project).firstParent(repo);
        this.addUpdatedFiles(repo, updatedFiles, parentBeforeUpdate, parentAfterUpdate);
    }

    private static void handlePossibleWarning(List<VcsException> exceptions, String possibleWarning) {
        if (!StringUtil.isEmptyOrSpaces((String)possibleWarning)) {
            HgRegularUpdater.reportWarning(exceptions, possibleWarning);
        }
    }

    private static void reportWarning(List<VcsException> exceptions, String warningMessage) {
        VcsException warningException = new VcsException(warningMessage);
        warningException.setIsWarning(true);
        exceptions.add(warningException);
    }

    private void addUpdatedFiles(VirtualFile repo, UpdatedFiles updatedFiles, HgRevisionNumber parentBeforeUpdate, HgRevisionNumber parentAfterUpdate) {
        if (parentAfterUpdate == null || parentBeforeUpdate == null) {
            return;
        }
        if (parentAfterUpdate.equals(parentBeforeUpdate)) {
            return;
        }
        HgStatusCommand statusCommand = new HgStatusCommand.Builder(true).ignored(false).unknown(false).baseRevision(parentBeforeUpdate).targetRevision(parentAfterUpdate).build(this.project);
        Set<HgChange> changes = statusCommand.execute(repo);
        for (HgChange change : changes) {
            HgFileStatusEnum status = change.getStatus();
            switch (status) {
                case ADDED: {
                    HgRegularUpdater.addToGroup(updatedFiles, change, "CREATED");
                    break;
                }
                case MODIFIED: {
                    HgRegularUpdater.addToGroup(updatedFiles, change, "UPDATED");
                    break;
                }
                case DELETED: {
                    HgRegularUpdater.addToGroup(updatedFiles, change, "REMOVED_FROM_REPOSITORY");
                    break;
                }
                case COPY: {
                    HgRegularUpdater.addToGroup(updatedFiles, change, "CHANGED_ON_SERVER");
                    break;
                }
            }
        }
    }

    private static void addToGroup(UpdatedFiles updatedFiles, HgChange change, String id) {
        updatedFiles.getGroupById(id).add(change.afterFile().getFile().getAbsolutePath(), "hg4idea", null);
    }
}

