/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogProviderRequirementsEx;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogSorter;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitTag;
import git4idea.GitUserRegistry;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitHistoryUtils;
import git4idea.log.GitBekParentFixer;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogProvider
implements VcsLogProvider {
    private static final Logger LOG = Logger.getInstance(GitLogProvider.class);
    public static final Function<VcsRef, String> GET_TAG_NAME = new Function<VcsRef, String>(){

        public String fun(VcsRef ref) {
            return ref.getType() == GitRefManager.TAG ? ref.getName() : null;
        }
    };
    public static final TObjectHashingStrategy<VcsRef> DONT_CONSIDER_SHA = new TObjectHashingStrategy<VcsRef>(){

        public int computeHashCode(@NotNull VcsRef ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "git4idea/log/GitLogProvider$2", "computeHashCode"));
            }
            return 31 * ref.getName().hashCode() + ref.getType().hashCode();
        }

        public boolean equals(@NotNull VcsRef ref1, @NotNull VcsRef ref2) {
            if (ref1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref1", "git4idea/log/GitLogProvider$2", "equals"));
            }
            if (ref2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref2", "git4idea/log/GitLogProvider$2", "equals"));
            }
            return ref1.getName().equals(ref2.getName()) && ref1.getType().equals(ref2.getType());
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitUserRegistry myUserRegistry;
    @NotNull
    private final VcsLogRefManager myRefSorter;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;

    public GitLogProvider(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager, @NotNull VcsLogObjectsFactory factory, @NotNull GitUserRegistry userRegistry) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/log/GitLogProvider", "<init>"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/log/GitLogProvider", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/log/GitLogProvider", "<init>"));
        }
        if (userRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userRegistry", "git4idea/log/GitLogProvider", "<init>"));
        }
        this.myProject = project;
        this.myRepositoryManager = repositoryManager;
        this.myUserRegistry = userRegistry;
        this.myRefSorter = new GitRefManager((RepositoryManager<GitRepository>)this.myRepositoryManager);
        this.myVcsObjectsFactory = factory;
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
    }

    @NotNull
    public VcsLogProvider.DetailedLogData readFirstBlock(@NotNull VirtualFile root, @NotNull VcsLogProvider.Requirements requirements) throws VcsException {
        Collection<Object> allDetails;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "readFirstBlock"));
        }
        if (requirements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirements", "git4idea/log/GitLogProvider", "readFirstBlock"));
        }
        if (!this.isRepositoryReady(root)) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readFirstBlock"));
            }
            return logDataImpl;
        }
        GitRepository repository = (GitRepository)ObjectUtils.assertNotNull((Object)this.myRepositoryManager.getRepositoryForRoot(root));
        int commitCount = requirements.getCommitCount() * 2;
        String[] params = new String[]{"HEAD", "--branches", "--remotes", "--max-count=" + commitCount};
        boolean refresh = requirements instanceof VcsLogProviderRequirementsEx && ((VcsLogProviderRequirementsEx)requirements).isRefresh();
        VcsLogProvider.DetailedLogData data = GitHistoryUtils.loadMetadata(this.myProject, root, true, params);
        Set safeRefs = data.getRefs();
        OpenTHashSet allRefs = new OpenTHashSet((Collection)safeRefs, DONT_CONSIDER_SHA);
        Set<VcsRef> branches = this.readBranches(repository);
        GitLogProvider.addNewElements(allRefs, branches);
        Set<String> currentTagNames = null;
        VcsLogProvider.DetailedLogData commitsFromTags = null;
        if (!refresh) {
            allDetails = data.getCommits();
        } else {
            VcsLogProviderRequirementsEx rex = (VcsLogProviderRequirementsEx)requirements;
            currentTagNames = this.readCurrentTagNames(root);
            GitLogProvider.addOldStillExistingTags((Set<VcsRef>)allRefs, currentTagNames, rex.getPreviousRefs());
            allDetails = GitLogProvider.newHashSet(data.getCommits());
            Set previousTags = GitLogProvider.newHashSet(ContainerUtil.mapNotNull((Collection)rex.getPreviousRefs(), GET_TAG_NAME));
            Set safeTags = GitLogProvider.newHashSet(ContainerUtil.mapNotNull((Collection)safeRefs, GET_TAG_NAME));
            Set<String> newUnmatchedTags = GitLogProvider.remove(currentTagNames, previousTags, safeTags);
            if (!newUnmatchedTags.isEmpty()) {
                commitsFromTags = this.loadSomeCommitsOnTaggedBranches(root, commitCount, newUnmatchedTags);
                GitLogProvider.addNewElements(allDetails, commitsFromTags.getCommits());
                GitLogProvider.addNewElements(allRefs, commitsFromTags.getRefs());
            }
        }
        StopWatch sw = StopWatch.start((String)("sorting commits in " + root.getName()));
        List<VcsCommitMetadata> sortedCommits = VcsLogSorter.sortByDateTopoOrder((Collection)allDetails);
        sortedCommits = sortedCommits.subList(0, Math.min(sortedCommits.size(), requirements.getCommitCount()));
        sw.report();
        if (LOG.isDebugEnabled()) {
            GitLogProvider.validateDataAndReportError(root, (Set<VcsRef>)allRefs, sortedCommits, data, branches, currentTagNames, commitsFromTags);
        }
        LogDataImpl logDataImpl = new LogDataImpl((Set)allRefs, sortedCommits);
        if (logDataImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readFirstBlock"));
        }
        return logDataImpl;
    }

    private static void validateDataAndReportError(final VirtualFile root, final Set<VcsRef> allRefs, final List<VcsCommitMetadata> sortedCommits, final VcsLogProvider.DetailedLogData firstBlockSyncData, final Set<VcsRef> manuallyReadBranches, final @Nullable Set<String> currentTagNames, final @Nullable VcsLogProvider.DetailedLogData commitsFromTags) {
        StopWatch sw = StopWatch.start((String)("validating data in " + root.getName()));
        final Set refs = ContainerUtil.map2Set(allRefs, (Function)new Function<VcsRef, Hash>(){

            public Hash fun(VcsRef ref) {
                return ref.getCommitHash();
            }
        });
        PermanentGraphImpl.newInstance(sortedCommits, (GraphColorManager)new GraphColorManager<Hash>(){

            public int getColorOfBranch(Hash headCommit) {
                return 0;
            }

            public int getColorOfFragment(Hash headCommit, int magicIndex) {
                return 0;
            }

            public int compareHeads(Hash head1, Hash head2) {
                if (!refs.contains(head1) || !refs.contains(head2)) {
                    LOG.error("GitLogProvider returned inconsistent data", new Attachment[]{new Attachment("error-details.txt", GitLogProvider.printErrorDetails(root, allRefs, sortedCommits, firstBlockSyncData, manuallyReadBranches, currentTagNames, commitsFromTags))});
                }
                return 0;
            }
        }, (Set)refs);
        sw.report();
    }

    private static String printErrorDetails(VirtualFile root, Set<VcsRef> allRefs, List<VcsCommitMetadata> sortedCommits, VcsLogProvider.DetailedLogData firstBlockSyncData, Set<VcsRef> manuallyReadBranches, @Nullable Set<String> currentTagNames, @Nullable VcsLogProvider.DetailedLogData commitsFromTags) {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + root.getName() + "]\n");
        sb.append("First block data from Git:\n");
        sb.append(GitLogProvider.printLogData(firstBlockSyncData));
        sb.append("\n\nManually read refs:\n");
        sb.append(GitLogProvider.printRefs(manuallyReadBranches));
        sb.append("\n\nCurrent tag names:\n");
        if (currentTagNames != null) {
            sb.append(StringUtil.join(currentTagNames, (String)", "));
            if (commitsFromTags != null) {
                sb.append(GitLogProvider.printLogData(commitsFromTags));
            } else {
                sb.append("\n\nCommits from new tags were not read.\n");
            }
        } else {
            sb.append("\n\nCurrent tags were not read\n");
        }
        sb.append("\n\nResult:\n");
        sb.append("\nCommits (last 100): \n");
        sb.append(GitLogProvider.printCommits(sortedCommits));
        sb.append("\nAll refs:\n");
        sb.append(GitLogProvider.printRefs(allRefs));
        return sb.toString();
    }

    private static String printLogData(VcsLogProvider.DetailedLogData firstBlockSyncData) {
        StringBuilder sb = new StringBuilder();
        sb.append("Last 100 commits:\n");
        sb.append(GitLogProvider.printCommits(firstBlockSyncData.getCommits()));
        sb.append("\nRefs:\n");
        sb.append(GitLogProvider.printRefs(firstBlockSyncData.getRefs()));
        return sb.toString();
    }

    private static String printCommits(List<VcsCommitMetadata> commits) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.min(commits.size(), 100); ++i) {
            GraphCommit commit = (GraphCommit)commits.get(i);
            sb.append(String.format("%s -> %s\n", ((Hash)commit.getId()).toShortString(), StringUtil.join((Collection)commit.getParents(), (Function)new Function<Hash, String>(){

                public String fun(Hash hash) {
                    return hash.toShortString();
                }
            }, (String)", ")));
        }
        return sb.toString();
    }

    private static String printRefs(Set<VcsRef> refs) {
        return StringUtil.join(refs, (Function)new Function<VcsRef, String>(){

            public String fun(VcsRef ref) {
                return ref.getCommitHash().toShortString() + " : " + ref.getName();
            }
        }, (String)"\n");
    }

    private static void addOldStillExistingTags(@NotNull Set<VcsRef> allRefs, @NotNull Set<String> currentTags, @NotNull Set<VcsRef> previousRefs) {
        if (allRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allRefs", "git4idea/log/GitLogProvider", "addOldStillExistingTags"));
        }
        if (currentTags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTags", "git4idea/log/GitLogProvider", "addOldStillExistingTags"));
        }
        if (previousRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousRefs", "git4idea/log/GitLogProvider", "addOldStillExistingTags"));
        }
        for (VcsRef ref : previousRefs) {
            if (allRefs.contains(ref) || !currentTags.contains(ref.getName())) continue;
            allRefs.add(ref);
        }
    }

    @NotNull
    private Set<String> readCurrentTagNames(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "readCurrentTagNames"));
        }
        StopWatch sw = StopWatch.start((String)("reading tags in " + root.getName()));
        Set<String> tags = GitLogProvider.newHashSet();
        GitTag.listAsStrings(this.myProject, root, tags, null);
        sw.report();
        Set<String> set = tags;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readCurrentTagNames"));
        }
        return set;
    }

    @NotNull
    private static <T> Set<T> remove(@NotNull Set<T> original, Set<T> ... toRemove) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "git4idea/log/GitLogProvider", "remove"));
        }
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "git4idea/log/GitLogProvider", "remove"));
        }
        Set<T> result = GitLogProvider.newHashSet(original);
        for (Set<T> set : toRemove) {
            result.removeAll(set);
        }
        Set<T> set = result;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "remove"));
        }
        return set;
    }

    private static <T> void addNewElements(@NotNull Collection<T> original, @NotNull Collection<T> toAdd) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "git4idea/log/GitLogProvider", "addNewElements"));
        }
        if (toAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAdd", "git4idea/log/GitLogProvider", "addNewElements"));
        }
        for (T item : toAdd) {
            if (original.contains(item)) continue;
            original.add(item);
        }
    }

    @NotNull
    private VcsLogProvider.DetailedLogData loadSomeCommitsOnTaggedBranches(@NotNull VirtualFile root, int commitCount, @NotNull Collection<String> unmatchedTags) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "loadSomeCommitsOnTaggedBranches"));
        }
        if (unmatchedTags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unmatchedTags", "git4idea/log/GitLogProvider", "loadSomeCommitsOnTaggedBranches"));
        }
        StopWatch sw = StopWatch.start((String)("loading commits on tagged branch in " + root.getName()));
        ArrayList<String> params = new ArrayList<String>();
        params.add("--max-count=" + commitCount);
        params.addAll(unmatchedTags);
        sw.report();
        VcsLogProvider.DetailedLogData detailedLogData = GitHistoryUtils.loadMetadata(this.myProject, root, true, ArrayUtil.toStringArray(params));
        if (detailedLogData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "loadSomeCommitsOnTaggedBranches"));
        }
        return detailedLogData;
    }

    @NotNull
    public VcsLogProvider.LogData readAllHashes(@NotNull VirtualFile root, final @NotNull Consumer<TimedVcsCommit> commitConsumer) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "readAllHashes"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/log/GitLogProvider", "readAllHashes"));
        }
        if (!this.isRepositoryReady(root)) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readAllHashes"));
            }
            return logDataImpl;
        }
        ArrayList<String> parameters = new ArrayList<String>(GitHistoryUtils.LOG_ALL);
        parameters.add("--sparse");
        final GitBekParentFixer parentFixer = GitBekParentFixer.prepare(root, this);
        Set userRegistry = GitLogProvider.newHashSet();
        Set refs = GitLogProvider.newHashSet();
        GitHistoryUtils.readCommits(this.myProject, root, parameters, (Consumer<VcsUser>)new CollectConsumer(userRegistry), (Consumer<VcsRef>)new CollectConsumer(refs), new Consumer<TimedVcsCommit>(){

            public void consume(TimedVcsCommit commit) {
                commitConsumer.consume((Object)parentFixer.fixCommit(commit));
            }
        });
        LogDataImpl logDataImpl = new LogDataImpl(refs, userRegistry);
        if (logDataImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readAllHashes"));
        }
        return logDataImpl;
    }

    @NotNull
    public List<? extends VcsShortCommitDetails> readShortDetails(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "readShortDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "git4idea/log/GitLogProvider", "readShortDetails"));
        }
        List<? extends VcsShortCommitDetails> list = GitHistoryUtils.readMiniDetails(this.myProject, root, hashes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readShortDetails"));
        }
        return list;
    }

    @NotNull
    public List<? extends VcsFullCommitDetails> readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "readFullDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "git4idea/log/GitLogProvider", "readFullDetails"));
        }
        String noWalk = GitVersionSpecialty.NO_WALK_UNSORTED.existsIn(this.myVcs.getVersion()) ? "--no-walk=unsorted" : "--no-walk";
        ArrayList<String> params = new ArrayList<String>();
        params.add(noWalk);
        params.addAll(hashes);
        List<GitCommit> list = GitHistoryUtils.history(this.myProject, root, ArrayUtil.toStringArray(params));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readFullDetails"));
        }
        return list;
    }

    @NotNull
    private Set<VcsRef> readBranches(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/log/GitLogProvider", "readBranches"));
        }
        StopWatch sw = StopWatch.start((String)("readBranches in " + repository.getRoot().getName()));
        VirtualFile root = repository.getRoot();
        repository.update();
        Collection<GitLocalBranch> localBranches = repository.getBranches().getLocalBranches();
        Collection<GitRemoteBranch> remoteBranches = repository.getBranches().getRemoteBranches();
        THashSet refs = new THashSet(localBranches.size() + remoteBranches.size());
        for (GitLocalBranch localBranch : localBranches) {
            refs.add(this.myVcsObjectsFactory.createRef(localBranch.getHash(), localBranch.getName(), GitRefManager.LOCAL_BRANCH, root));
        }
        for (GitRemoteBranch remoteBranch : remoteBranches) {
            refs.add(this.myVcsObjectsFactory.createRef(remoteBranch.getHash(), remoteBranch.getNameForLocalOperations(), GitRefManager.REMOTE_BRANCH, root));
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision != null) {
            refs.add(this.myVcsObjectsFactory.createRef(HashImpl.build((String)currentRevision), "HEAD", GitRefManager.HEAD, root));
        }
        sw.report();
        THashSet tHashSet = refs;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "readBranches"));
        }
        return tHashSet;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        if (vcsKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getSupportedVcs"));
        }
        return vcsKey;
    }

    @NotNull
    public VcsLogRefManager getReferenceManager() {
        VcsLogRefManager vcsLogRefManager = this.myRefSorter;
        if (vcsLogRefManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getReferenceManager"));
        }
        return vcsLogRefManager;
    }

    public void subscribeToRootRefreshEvents(final @NotNull Collection<VirtualFile> roots, final @NotNull VcsLogRefresher refresher) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/log/GitLogProvider", "subscribeToRootRefreshEvents"));
        }
        if (refresher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresher", "git4idea/log/GitLogProvider", "subscribeToRootRefreshEvents"));
        }
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            @Override
            public void repositoryChanged(@NotNull GitRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/log/GitLogProvider$8", "repositoryChanged"));
                }
                VirtualFile root = repository.getRoot();
                if (roots.contains(root)) {
                    refresher.refresh(root);
                }
            }
        });
    }

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        Collection files;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
        }
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterCollection", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
        }
        if (!this.isRepositoryReady(root)) {
            List<TimedVcsCommit> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
            }
            return list;
        }
        ArrayList filterParameters = ContainerUtil.newArrayList();
        if (filterCollection.getBranchFilter() != null) {
            GitRepository repository = this.getRepository(root);
            assert (repository != null) : "repository is null for root " + root + " but was previously reported as 'ready'";
            boolean atLeastOneBranchExists = false;
            for (String branchName : filterCollection.getBranchFilter().getBranchNames()) {
                if (!branchName.equals("HEAD") && repository.getBranches().findBranchByName(branchName) == null) continue;
                filterParameters.add(branchName);
                atLeastOneBranchExists = true;
            }
            if (!atLeastOneBranchExists) {
                List<TimedVcsCommit> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
                }
                return list;
            }
        } else {
            filterParameters.addAll(GitHistoryUtils.LOG_ALL);
        }
        if (filterCollection.getUserFilter() != null) {
            String authorFilter = StringUtil.join((Collection)filterCollection.getUserFilter().getUserNames(root), (String)"|");
            filterParameters.add(GitLogProvider.prepareParameter("author", StringUtil.escapeChar((String)StringUtil.escapeBackSlashes((String)authorFilter), (char)'|')));
        }
        if (filterCollection.getDateFilter() != null) {
            VcsLogDateFilter filter = filterCollection.getDateFilter();
            if (filter.getAfter() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("after", filter.getAfter().toString()));
            }
            if (filter.getBefore() != null) {
                filterParameters.add(GitLogProvider.prepareParameter("before", filter.getBefore().toString()));
            }
        }
        if (filterCollection.getTextFilter() != null) {
            String textFilter = filterCollection.getTextFilter().getText();
            filterParameters.add(GitLogProvider.prepareParameter("grep", textFilter));
        }
        filterParameters.add("--regexp-ignore-case");
        if (maxCount > 0) {
            filterParameters.add(GitLogProvider.prepareParameter("max-count", String.valueOf(maxCount)));
        }
        filterParameters.add("--date-order");
        if (filterCollection.getStructureFilter() != null && !(files = filterCollection.getStructureFilter().getFiles()).isEmpty()) {
            filterParameters.add("--simplify-merges");
            filterParameters.add("--");
            for (VirtualFile file : files) {
                filterParameters.add(file.getPath());
            }
        }
        ArrayList commits = ContainerUtil.newArrayList();
        GitHistoryUtils.readCommits(this.myProject, root, filterParameters, (Consumer<VcsUser>)Consumer.EMPTY_CONSUMER, (Consumer<VcsRef>)Consumer.EMPTY_CONSUMER, (Consumer<TimedVcsCommit>)new CollectConsumer((Collection)commits));
        ArrayList arrayList = commits;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getCommitsMatchingFilter"));
        }
        return arrayList;
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "getCurrentUser"));
        }
        return this.myUserRegistry.getOrReadUser(root);
    }

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash commitHash) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "getContainingBranches"));
        }
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "git4idea/log/GitLogProvider", "getContainingBranches"));
        }
        Collection<String> collection = GitBranchUtil.getBranches(this.myProject, root, true, true, commitHash.asString());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "getContainingBranches"));
        }
        return collection;
    }

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> property) {
        if (property == VcsLogProperties.LIGHTWEIGHT_BRANCHES) {
            return (T)Boolean.TRUE;
        }
        return null;
    }

    private static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }

    @Nullable
    private GitRepository getRepository(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "getRepository"));
        }
        this.myRepositoryManager.waitUntilInitialized();
        return (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
    }

    private boolean isRepositoryReady(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogProvider", "isRepositoryReady"));
        }
        GitRepository repository = this.getRepository(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            return false;
        }
        if (repository.isFresh()) {
            LOG.info("Fresh repository: " + root);
            return false;
        }
        return true;
    }

    @NotNull
    private static <T> Set<T> newHashSet() {
        THashSet tHashSet = new THashSet();
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "newHashSet"));
        }
        return tHashSet;
    }

    @NotNull
    private static <T> Set<T> newHashSet(@NotNull Collection<T> initialCollection) {
        if (initialCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialCollection", "git4idea/log/GitLogProvider", "newHashSet"));
        }
        THashSet tHashSet = new THashSet(initialCollection);
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogProvider", "newHashSet"));
        }
        return tHashSet;
    }
}

