/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.SecondaryFunctionsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssertExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class AssertProcessor {
    private static final VarType CLASS_ASSERTION_ERROR = new VarType(8, 0, "java/lang/AssertionError");

    public static void buildAssertions(ClassesProcessor.ClassNode node) {
        ClassWrapper wrapper = node.getWrapper();
        StructField field = AssertProcessor.findAssertionField(node);
        if (field != null) {
            String key = InterpreterUtil.makeUniqueKey(field.getName(), field.getDescriptor());
            boolean res = false;
            for (MethodWrapper meth : wrapper.getMethods()) {
                RootStatement root = meth.root;
                if (root == null) continue;
                res |= AssertProcessor.replaceAssertions(root, wrapper.getClassStruct().qualifiedName, key);
            }
            if (res) {
                wrapper.getHiddenMembers().add(key);
            }
        }
    }

    private static StructField findAssertionField(ClassesProcessor.ClassNode node) {
        ClassWrapper wrapper = node.getWrapper();
        boolean noSynthFlag = DecompilerContext.getOption("nns");
        for (StructField fd : wrapper.getClassStruct().getFields()) {
            ConstExprent cexpr;
            InvocationExprent invexpr;
            FunctionExprent fexpr;
            String keyField = InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor());
            if (!wrapper.getStaticFieldInitializers().containsKey(keyField) || !fd.hasModifier(8) || !fd.hasModifier(16) || !noSynthFlag && !fd.isSynthetic()) continue;
            FieldDescriptor fdescr = FieldDescriptor.parseDescriptor(fd.getDescriptor());
            if (!VarType.VARTYPE_BOOLEAN.equals(fdescr.type)) continue;
            Exprent initializer = wrapper.getStaticFieldInitializers().getWithKey(keyField);
            if (initializer.type != 6 || (fexpr = (FunctionExprent)initializer).getFuncType() != 12 || fexpr.getLstOperands().get((int)0).type != 8 || (invexpr = (InvocationExprent)fexpr.getLstOperands().get(0)).getInstance() == null || invexpr.getInstance().type != 3 || !"desiredAssertionStatus".equals(invexpr.getName()) || !"java/lang/Class".equals(invexpr.getClassname()) || !invexpr.getLstParameters().isEmpty() || !VarType.VARTYPE_CLASS.equals((cexpr = (ConstExprent)invexpr.getInstance()).getConstType())) continue;
            ClassesProcessor.ClassNode nd = node;
            while (nd != null && !nd.getWrapper().getClassStruct().qualifiedName.equals(cexpr.getValue())) {
                nd = nd.parent;
            }
            if (nd == null) continue;
            return fd;
        }
        return null;
    }

    private static boolean replaceAssertions(Statement statement, String classname, String key) {
        boolean res = false;
        for (Statement st : statement.getStats()) {
            res |= AssertProcessor.replaceAssertions(st, classname, key);
        }
        boolean replaced = true;
        while (replaced) {
            replaced = false;
            for (Statement st : statement.getStats()) {
                if (st.type != 2 || !AssertProcessor.replaceAssertion(statement, (IfStatement)st, classname, key)) continue;
                replaced = true;
                break;
            }
            res |= replaced;
        }
        return res;
    }

    private static boolean replaceAssertion(Statement parent, IfStatement stat, String classname, String key) {
        Statement ifstat = stat.getIfstat();
        InvocationExprent throwError = AssertProcessor.isAssertionError(ifstat);
        if (throwError == null) {
            return false;
        }
        Object[] exprres = AssertProcessor.getAssertionExprent(stat.getHeadexprent().getCondition().copy(), classname, key);
        if (!((Boolean)exprres[1]).booleanValue()) {
            return false;
        }
        ArrayList<Exprent> lstParams = new ArrayList<Exprent>();
        FunctionExprent ascond = null;
        Exprent retcond = null;
        if (exprres[0] != null) {
            ascond = new FunctionExprent(12, (Exprent)exprres[0], (Set<Integer>)throwError.bytecode);
            retcond = SecondaryFunctionsHelper.propagateBoolNot(ascond);
        }
        lstParams.add(retcond == null ? ascond : retcond);
        if (!throwError.getLstParameters().isEmpty()) {
            lstParams.add(throwError.getLstParameters().get(0));
        }
        AssertExprent asexpr = new AssertExprent(lstParams);
        Statement newstat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
        newstat.setExprents(Arrays.asList(asexpr));
        Statement first = stat.getFirst();
        if (stat.iftype == IfStatement.IFTYPE_IFELSE || first.getExprents() != null && !first.getExprents().isEmpty()) {
            Statement ifelse;
            List<StatEdge> lstSuccs;
            first.removeSuccessor(stat.getIfEdge());
            first.removeSuccessor(stat.getElseEdge());
            ArrayList<Statement> lstStatements = new ArrayList<Statement>();
            if (first.getExprents() != null && !first.getExprents().isEmpty()) {
                lstStatements.add(first);
            }
            lstStatements.add(newstat);
            if (stat.iftype == IfStatement.IFTYPE_IFELSE) {
                lstStatements.add(stat.getElsestat());
            }
            SequenceStatement sequence = new SequenceStatement(lstStatements);
            sequence.setAllParent();
            for (int i = 0; i < sequence.getStats().size() - 1; ++i) {
                ((Statement)sequence.getStats().get(i)).addSuccessor(new StatEdge(1, (Statement)sequence.getStats().get(i), (Statement)sequence.getStats().get(i + 1)));
            }
            if (stat.iftype == IfStatement.IFTYPE_IFELSE && !(lstSuccs = (ifelse = stat.getElsestat()).getAllSuccessorEdges()).isEmpty()) {
                StatEdge endedge = lstSuccs.get(0);
                if (endedge.closure == stat) {
                    sequence.addLabeledEdge(endedge);
                }
            }
            newstat = sequence;
        }
        newstat.getVarDefinitions().addAll(stat.getVarDefinitions());
        parent.replaceStatement(stat, newstat);
        return true;
    }

    private static InvocationExprent isAssertionError(Statement stat) {
        NewExprent nexpr;
        ExitExprent exexpr;
        if (stat == null || stat.getExprents() == null || stat.getExprents().size() != 1) {
            return null;
        }
        Exprent expr = stat.getExprents().get(0);
        if (expr.type == 4 && (exexpr = (ExitExprent)expr).getExitType() == 1 && exexpr.getValue().type == 10 && CLASS_ASSERTION_ERROR.equals((nexpr = (NewExprent)exexpr.getValue()).getNewType()) && nexpr.getConstructor() != null) {
            return nexpr.getConstructor();
        }
        return null;
    }

    private static Object[] getAssertionExprent(Exprent exprent, String classname, String key) {
        if (exprent.type == 6) {
            FunctionExprent fexpr = (FunctionExprent)exprent;
            if (fexpr.getFuncType() == 48) {
                Exprent param;
                int i;
                for (i = 0; i < 2; ++i) {
                    param = fexpr.getLstOperands().get(i);
                    if (!AssertProcessor.isAssertionField(param, classname, key)) continue;
                    return new Object[]{fexpr.getLstOperands().get(1 - i), true};
                }
                for (i = 0; i < 2; ++i) {
                    param = fexpr.getLstOperands().get(i);
                    Object[] res = AssertProcessor.getAssertionExprent(param, classname, key);
                    if (!((Boolean)res[1]).booleanValue()) continue;
                    if (param != res[0]) {
                        fexpr.getLstOperands().set(i, (Exprent)res[0]);
                    }
                    return new Object[]{fexpr, true};
                }
            } else if (AssertProcessor.isAssertionField(fexpr, classname, key)) {
                return new Object[]{null, true};
            }
        }
        return new Object[]{exprent, false};
    }

    private static boolean isAssertionField(Exprent exprent, String classname, String key) {
        FieldExprent fdparam;
        FunctionExprent fparam;
        return exprent.type == 6 && (fparam = (FunctionExprent)exprent).getFuncType() == 12 && fparam.getLstOperands().get((int)0).type == 5 && classname.equals((fdparam = (FieldExprent)fparam.getLstOperands().get(0)).getClassname()) && key.equals(InterpreterUtil.makeUniqueKey(fdparam.getName(), fdparam.getDescriptor().descriptorString));
    }
}

