/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.pty4j.PtyProcess;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PtyCommandLine
extends GeneralCommandLine {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.PtyCommandLine");

    @Override
    @NotNull
    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "com/intellij/execution/configurations/PtyCommandLine", "startProcess"));
        }
        if (SystemInfo.isUnix) {
            Process process;
            try {
                process = this.startProcessWithPty(commands, true);
            }
            catch (Throwable e) {
                LOG.error("Couldn't run process with PTY", e);
            }
            if (process == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PtyCommandLine", "startProcess"));
            }
            return process;
        }
        Process process = super.startProcess(commands);
        if (process == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PtyCommandLine", "startProcess"));
        }
        return process;
    }

    @NotNull
    public Process startProcessWithPty(@NotNull List<String> commands, boolean console) throws IOException {
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "com/intellij/execution/configurations/PtyCommandLine", "startProcessWithPty"));
        }
        HashMap<String, String> env = new HashMap<String, String>();
        this.setupEnvironment(env);
        if (this.isRedirectErrorStream()) {
            LOG.error("Launching process with PTY and redirected error stream is unsupported yet");
        }
        File workDirectory = this.getWorkDirectory();
        PtyProcess ptyProcess = PtyProcess.exec((String[])ArrayUtil.toStringArray(commands), env, (String)(workDirectory != null ? workDirectory.getPath() : null), (boolean)console);
        if (ptyProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/PtyCommandLine", "startProcessWithPty"));
        }
        return ptyProcess;
    }
}

