/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="module")
public class RunConfigurationModule
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(RunConfigurationModule.class);
    @NonNls
    private static final String ELEMENT = "module";
    @NonNls
    private static final String ATTRIBUTE = "name";
    private Module myModule;
    @Attribute(value="name")
    private String myModuleName;
    private final Project myProject;

    public RunConfigurationModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/configurations/RunConfigurationModule", "<init>"));
        }
        this.myModule = null;
        this.myProject = project;
    }

    public void readExternal(@NotNull Element element) {
        String moduleName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/configurations/RunConfigurationModule", "readExternal"));
        }
        List modules = element.getChildren(ELEMENT);
        LOG.assertTrue(modules.size() <= 1);
        if (modules.size() == 1 && !StringUtil.isEmpty((String)(moduleName = ((Element)modules.get(0)).getAttributeValue(ATTRIBUTE)))) {
            this.myModuleName = moduleName;
        }
    }

    public void writeExternal(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/configurations/RunConfigurationModule", "writeExternal"));
        }
        parent.addContent(new Element(ELEMENT).setAttribute(ATTRIBUTE, this.getModuleName()));
    }

    public void init() {
        Module[] modules;
        if (StringUtil.isEmptyOrSpaces((String)this.getModuleName()) && (modules = this.getModuleManager().getModules()).length > 0) {
            this.setModule(modules[0]);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/RunConfigurationModule", "getProject"));
        }
        return project;
    }

    @Transient
    @Nullable
    public Module getModule() {
        if (this.myModuleName != null) {
            this.myModule = this.findModule(this.myModuleName);
        }
        if (this.myModule != null && this.myModule.isDisposed()) {
            this.myModule = null;
        }
        return this.myModule;
    }

    @Nullable
    public Module findModule(final String moduleName) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Module>(){

            @Nullable
            public Module compute() {
                return RunConfigurationModule.this.getModuleManager().findModuleByName(moduleName);
            }
        });
    }

    public void setModule(Module module) {
        this.myModule = module;
        this.myModuleName = module != null ? module.getName() : null;
    }

    public String getModuleName() {
        return StringUtil.notNullize((String)this.myModuleName);
    }

    private ModuleManager getModuleManager() {
        return ModuleManager.getInstance(this.myProject);
    }

    public void checkForWarning() throws RuntimeConfigurationException {
        Module module = this.getModule();
        if (module != null) {
            if (ModuleRootManager.getInstance(module).getSdk() == null) {
                throw new RuntimeConfigurationWarning(ExecutionBundle.message("no.jdk.specified.for.module.warning.text", module.getName()));
            }
        } else {
            if (this.myModuleName != null) {
                throw new RuntimeConfigurationError(ExecutionBundle.message("module.doesn.t.exist.in.project.error.text", this.myModuleName));
            }
            throw new RuntimeConfigurationError(ExecutionBundle.message("module.not.specified.error.text", new Object[0]));
        }
    }
}

