/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.Nullable;

public class PsiTypeVisitor<A> {
    @Nullable
    public A visitType(PsiType type) {
        return null;
    }

    @Nullable
    public A visitPrimitiveType(PsiPrimitiveType primitiveType) {
        return this.visitType(primitiveType);
    }

    @Nullable
    public A visitArrayType(PsiArrayType arrayType) {
        return this.visitType(arrayType);
    }

    @Nullable
    public A visitClassType(PsiClassType classType) {
        return this.visitType(classType);
    }

    @Nullable
    public A visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
        return this.visitWildcardType(capturedWildcardType.getWildcard());
    }

    @Nullable
    public A visitWildcardType(PsiWildcardType wildcardType) {
        return this.visitType(wildcardType);
    }

    @Nullable
    public A visitEllipsisType(PsiEllipsisType ellipsisType) {
        return this.visitArrayType(ellipsisType);
    }

    @Nullable
    public A visitDisjunctionType(PsiDisjunctionType disjunctionType) {
        return this.visitType(disjunctionType);
    }

    @Nullable
    public A visitIntersectionType(PsiIntersectionType intersectionType) {
        PsiType type = intersectionType.getConjuncts()[0];
        return type.accept(this);
    }

    @Nullable
    public A visitDiamondType(PsiDiamondType diamondType) {
        return this.visitType(diamondType);
    }

    @Nullable
    public A visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
        PsiLambdaExpression lambdaExpression = lambdaExpressionType.getExpression();
        PsiType interfaceType = lambdaExpression.getFunctionalInterfaceType();
        if (interfaceType != null) {
            return interfaceType.accept(this);
        }
        return this.visitType(lambdaExpressionType);
    }

    public A visitMethodReferenceType(PsiMethodReferenceType methodReferenceType) {
        PsiMethodReferenceExpression expression = methodReferenceType.getExpression();
        PsiType interfaceType = expression.getFunctionalInterfaceType();
        if (interfaceType != null) {
            return interfaceType.accept(this);
        }
        return this.visitType(methodReferenceType);
    }
}

