/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.augment;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAugmentProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + PsiAugmentProvider.class.getName()));
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.lang.psiAugmentProvider");

    @NotNull
    public abstract <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement var1, @NotNull Class<Psi> var2);

    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        List result = Collections.emptyList();
        for (PsiAugmentProvider provider : (PsiAugmentProvider[])Extensions.getExtensions(EP_NAME)) {
            List<Psi> augments = provider.getAugments(element, type);
            if (augments.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new ArrayList(augments.size());
            }
            result.addAll(augments);
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/augment/PsiAugmentProvider", "collectAugments"));
        }
        return list;
    }

    @Nullable
    protected PsiType inferType(PsiTypeElement typeElement) {
        return null;
    }

    @Nullable
    public static PsiType getInferredType(PsiTypeElement typeElement) {
        for (PsiAugmentProvider provider : (PsiAugmentProvider[])Extensions.getExtensions(EP_NAME)) {
            try {
                PsiType type = provider.inferType(typeElement);
                if (type == null) continue;
                return type;
            }
            catch (Exception e) {
                LOG.error("provider: " + provider, (Throwable)e);
            }
        }
        return null;
    }
}

