/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.tabs.impl.JBEditorTabsPainter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class DefaultEditorTabsPainter
extends JBEditorTabsPainter {
    private static final int ACTIVE_TAB_SHADOW_HEIGHT = 3;

    @Override
    public void doPaintInactive(Graphics2D g2d, Rectangle effectiveBounds, int x, int y, int w, int h, Color tabColor, int row, int column, boolean vertical) {
        if (tabColor != null) {
            g2d.setPaint(UIUtil.getGradientPaint((float)x, (float)y, (Color)Gray._200, (float)x, (float)(y + effectiveBounds.height), (Color)Gray._130));
            g2d.fillRect(x, y, w, h);
            g2d.setColor(ColorUtil.toAlpha((Color)tabColor, (int)150));
            g2d.fillRect(x, y, w, h);
        } else {
            g2d.setPaint(UIUtil.getGradientPaint((float)x, (float)y, (Color)Gray._255.withAlpha(180), (float)x, (float)(y + effectiveBounds.height), (Color)Gray._255.withAlpha(100)));
            g2d.fillRect(x, y, w, h);
        }
        if (row == 0) {
            g2d.setColor(Gray._200.withAlpha(200));
        } else {
            g2d.setColor(Gray._255.withAlpha(100));
        }
        g2d.drawLine(x, y, x + w - 1, y);
        if (!vertical) {
            DefaultEditorTabsPainter.drawShadow(g2d, x, w, y + h);
        }
    }

    private static void drawShadow(Graphics2D g, int x, int w, int shadowBottom) {
        int shadowTop = shadowBottom - 3;
        g.setPaint(UIUtil.getGradientPaint((float)x, (float)shadowTop, (Color)Gray.TRANSPARENT, (float)x, (float)shadowBottom, (Color)Gray._0.withAlpha(30)));
        g.fillRect(x, shadowTop, w, 3);
    }

    @Override
    public void doPaintBackground(Graphics2D g, Rectangle clip, boolean vertical, Rectangle rectangle) {
        g.setColor(UIUtil.getPanelBackground());
        g.fill(clip);
        g.setColor(Gray._0.withAlpha(80));
        g.fill(clip);
        int x = rectangle.x;
        int y = rectangle.y;
        g.setPaint(UIUtil.getGradientPaint((float)x, (float)y, (Color)Gray._255.withAlpha(160), (float)x, (float)(rectangle.y + rectangle.height), (Color)Gray._255.withAlpha(120)));
        g.fillRect(x, rectangle.y, rectangle.width, rectangle.height + (vertical ? 1 : 0));
        if (!vertical) {
            g.setColor((Color)Gray._210);
            g.drawLine(x, rectangle.y, x + rectangle.width, rectangle.y);
            DefaultEditorTabsPainter.drawShadow(g, rectangle.x, rectangle.width, rectangle.y + rectangle.height);
        }
    }

    private static Color multiplyColor(Color c) {
        return new Color(c.getRed() * c.getRed() / 255, c.getGreen() * c.getGreen() / 255, c.getBlue() * c.getBlue() / 255);
    }

    @Override
    public void fillSelectionAndBorder(Graphics2D g, JBTabsImpl.ShapeInfo selectedShape, Color tabColor, int x, int y, int height) {
        if (tabColor != null) {
            g.setColor(DefaultEditorTabsPainter.multiplyColor(tabColor));
            g.fill(selectedShape.fillPath.getShape());
            g.setPaint(UIUtil.getGradientPaint((float)x, (float)y, (Color)Gray._255.withAlpha(150), (float)x, (float)(y + height), (Color)Gray._255.withAlpha(0)));
        } else {
            g.setPaint(UIUtil.getGradientPaint((float)x, (float)y, (Color)Gray._255, (float)x, (float)(y + height), (Color)Gray._230));
        }
        g.fill(selectedShape.fillPath.getShape());
        g.setColor(Gray._255.withAlpha(180));
        g.draw(selectedShape.fillPath.getShape());
        g.draw(selectedShape.labelPath.transformLine(selectedShape.labelPath.getMaxX() - selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getY() + selectedShape.labelPath.deltaY(1), selectedShape.labelPath.getMaxX() - selectedShape.labelPath.deltaX(1), selectedShape.labelPath.getMaxY() - selectedShape.labelPath.deltaY(4)));
    }

    @Override
    public Color getBackgroundColor() {
        return Gray._142;
    }
}

