/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.profile.DefaultProfileInjector;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.profiles.activation.JdkPrefixProfileActivator;
import org.apache.maven.profiles.activation.OperatingSystemProfileActivator;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.apache.maven.profiles.activation.SystemPropertyProfileActivator;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.project.inheritance.DefaultModelInheritanceAssembler;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.path.DefaultPathTranslator;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.AetherModelConverter;
import org.jetbrains.idea.maven.server.Maven3ServerConsoleLogger;
import org.jetbrains.idea.maven.server.Maven3ServerGlobals;
import org.jetbrains.idea.maven.server.Maven3WorkspaceReader;
import org.jetbrains.idea.maven.server.MavenEffectivePomDumper;
import org.jetbrains.idea.maven.server.MavenLeakDetector;
import org.jetbrains.idea.maven.server.MavenModelConverter;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerConsole;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicatorWrapper;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.MyFileProfileActivator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.RemoteNativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.TransferListenerAdapter;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ArtifactFactory;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ArtifactResolver;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator2;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3RepositoryMetadataManager;
import org.jetbrains.idea.maven.server.embedder.FieldAccessor;
import org.jetbrains.idea.maven.server.embedder.MavenExecutionResult;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.graph.PreorderNodeListGenerator;

public class Maven3ServerEmbedderImpl
extends MavenRemoteObject
implements MavenServerEmbedder {
    private static final boolean USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING = System.getProperty("idea.maven3.use.compat.resolver") != null;
    @NotNull
    private final DefaultPlexusContainer myContainer;
    @NotNull
    private final Settings myMavenSettings;
    private final ArtifactRepository myLocalRepository;
    private final Maven3ServerConsoleLogger myConsoleWrapper;
    private final Properties mySystemProperties;
    private volatile MavenServerProgressIndicator myCurrentIndicator;
    private MavenWorkspaceMap myWorkspaceMap;
    private Date myBuildStartTime;
    private boolean myAlwaysUpdateSnapshots;

    public Maven3ServerEmbedderImpl(MavenServerSettings settings) throws RemoteException {
        Object cliRequest;
        Class<?> cliRequestClass;
        File mavenHome = settings.getMavenHome();
        if (mavenHome != null) {
            System.setProperty("maven.home", mavenHome.getPath());
        }
        this.myConsoleWrapper = new Maven3ServerConsoleLogger();
        this.myConsoleWrapper.setThreshold(settings.getLoggingLevel());
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        MavenCli cli = new MavenCli(classWorld){

            protected void customizeContainer(PlexusContainer container) {
                ((DefaultPlexusContainer)container).setLoggerManager((LoggerManager)new BaseLoggerManager(){

                    protected Logger createLogger(String s) {
                        return Maven3ServerEmbedderImpl.this.myConsoleWrapper;
                    }
                });
            }
        };
        try {
            cliRequestClass = MavenCli.class.getClassLoader().loadClass("org.apache.maven.cli.MavenCli$CliRequest");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class \"org.apache.maven.cli.MavenCli$CliRequest\" not found");
        }
        try {
            String[] commandLineOptions = new String[settings.getUserProperties().size()];
            int idx = 0;
            for (Map.Entry<Object, Object> each : settings.getUserProperties().entrySet()) {
                commandLineOptions[idx++] = "-D" + each.getKey() + "=" + each.getValue();
            }
            Constructor<?> constructor = cliRequestClass.getDeclaredConstructor(String[].class, ClassWorld.class);
            constructor.setAccessible(true);
            cliRequest = constructor.newInstance(commandLineOptions, classWorld);
            for (String each : new String[]{"initialize", "cli", "properties", "container"}) {
                Method m = MavenCli.class.getDeclaredMethod(each, cliRequestClass);
                m.setAccessible(true);
                m.invoke((Object)cli, cliRequest);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.myContainer = (DefaultPlexusContainer)FieldAccessor.get(MavenCli.class, cli, "container");
        this.myContainer.getLoggerManager().setThreshold(settings.getLoggingLevel());
        this.mySystemProperties = (Properties)FieldAccessor.get(cliRequestClass, cliRequest, "systemProperties");
        if (settings.getProjectJdk() != null) {
            this.mySystemProperties.setProperty("java.home", settings.getProjectJdk());
        }
        this.myMavenSettings = Maven3ServerEmbedderImpl.buildSettings((SettingsBuilder)FieldAccessor.get(MavenCli.class, cli, "settingsBuilder"), settings, this.mySystemProperties, (Properties)FieldAccessor.get(cliRequestClass, cliRequest, "userProperties"));
        this.myLocalRepository = this.createLocalRepository();
    }

    private static Settings buildSettings(SettingsBuilder builder, MavenServerSettings settings, Properties systemProperties, Properties userProperties) throws RemoteException {
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setGlobalSettingsFile(settings.getGlobalSettingsFile());
        settingsRequest.setUserSettingsFile(settings.getUserSettingsFile());
        settingsRequest.setSystemProperties(systemProperties);
        settingsRequest.setUserProperties(userProperties);
        Settings result = new Settings();
        try {
            result = builder.build((SettingsBuildingRequest)settingsRequest).getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            Maven3ServerGlobals.getLogger().info(e);
        }
        result.setOffline(settings.isOffline());
        if (settings.getLocalRepository() != null) {
            result.setLocalRepository(settings.getLocalRepository().getPath());
        }
        if (result.getLocalRepository() == null) {
            result.setLocalRepository(new File(SystemProperties.getUserHome(), ".m2/repository").getPath());
        }
        return result;
    }

    public <T> T getComponent(Class<T> clazz, String roleHint) {
        try {
            return (T)this.myContainer.lookup(clazz.getName(), roleHint);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getComponent(Class<T> clazz) {
        try {
            return (T)this.myContainer.lookup(clazz.getName());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    private ArtifactRepository createLocalRepository() {
        try {
            ArtifactRepository localRepository = this.getComponent(RepositorySystem.class).createLocalRepository(new File(this.myMavenSettings.getLocalRepository()));
            String customRepoId = System.getProperty("maven3.localRepository.id");
            if (customRepoId != null) {
                localRepository.setId(customRepoId);
            }
            return localRepository;
        }
        catch (InvalidRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public void customize(@Nullable MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, @NotNull MavenServerConsole console, @NotNull MavenServerProgressIndicator indicator, boolean alwaysUpdateSnapshots) throws RemoteException {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "customize"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "customize"));
        }
        try {
            ((CustomMaven3ArtifactFactory)this.getComponent(ArtifactFactory.class)).customize();
            ((CustomMaven3ArtifactResolver)this.getComponent(ArtifactResolver.class)).customize(workspaceMap, failOnUnresolvedDependency);
            ((CustomMaven3RepositoryMetadataManager)this.getComponent(RepositoryMetadataManager.class)).customize(workspaceMap);
            this.myWorkspaceMap = workspaceMap;
            this.myBuildStartTime = new Date();
            this.myAlwaysUpdateSnapshots = alwaysUpdateSnapshots;
            this.setConsoleAndIndicator(console, (MavenServerProgressIndicator)new MavenServerProgressIndicatorWrapper(indicator));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    private void setConsoleAndIndicator(MavenServerConsole console, MavenServerProgressIndicator indicator) {
        this.myConsoleWrapper.setWrappee(console);
        this.myCurrentIndicator = indicator;
    }

    @NotNull
    public MavenServerExecutionResult resolveProject(@NotNull File file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles) throws RemoteException, MavenServerProcessCanceledException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolveProject"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolveProject"));
        }
        if (inactiveProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inactiveProfiles", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolveProject"));
        }
        DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener((Logger)this.myConsoleWrapper);
        MavenExecutionResult result = this.doResolveProject(file, new ArrayList<String>(activeProfiles), new ArrayList<String>(inactiveProfiles), Arrays.asList(listener));
        MavenServerExecutionResult mavenServerExecutionResult = this.createExecutionResult(file, result, listener.getRootNode());
        if (mavenServerExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolveProject"));
        }
        return mavenServerExecutionResult;
    }

    @Nullable
    public String evaluateEffectivePom(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles) throws RemoteException, MavenServerProcessCanceledException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "evaluateEffectivePom"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "evaluateEffectivePom"));
        }
        if (inactiveProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inactiveProfiles", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "evaluateEffectivePom"));
        }
        return MavenEffectivePomDumper.evaluateEffectivePom(this, file, activeProfiles, inactiveProfiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithMavenSession(MavenExecutionRequest request, Runnable runnable) {
        DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
        RepositorySystemSession repositorySession = maven.newRepositorySession(request);
        request.getProjectBuildingRequest().setRepositorySession(repositorySession);
        MavenSession mavenSession = new MavenSession((PlexusContainer)this.myContainer, repositorySession, request, (org.apache.maven.execution.MavenExecutionResult)new DefaultMavenExecutionResult());
        LegacySupport legacySupport = this.getComponent(LegacySupport.class);
        MavenSession oldSession = legacySupport.getSession();
        legacySupport.setSession(mavenSession);
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(Collections.<MavenProject>emptyList())) {
                listener.afterSessionStart(mavenSession);
            }
        }
        catch (MavenExecutionException e) {
            throw new RuntimeException(e);
        }
        try {
            runnable.run();
        }
        finally {
            legacySupport.setSession(oldSession);
        }
    }

    @NotNull
    public MavenExecutionResult doResolveProject(final @NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, final List<ResolutionListener> listeners) throws RemoteException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "doResolveProject"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "doResolveProject"));
        }
        if (inactiveProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inactiveProfiles", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "doResolveProject"));
        }
        final MavenExecutionRequest request = this.createRequest(file, activeProfiles, inactiveProfiles, Collections.<String>emptyList());
        request.setUpdateSnapshots(this.myAlwaysUpdateSnapshots);
        final AtomicReference ref = new AtomicReference();
        this.executeWithMavenSession(request, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List results;
                    ProjectBuilder builder = Maven3ServerEmbedderImpl.this.getComponent(ProjectBuilder.class);
                    CustomMaven3ModelInterpolator2 modelInterpolator = (CustomMaven3ModelInterpolator2)Maven3ServerEmbedderImpl.this.getComponent(ModelInterpolator.class);
                    String savedLocalRepository = modelInterpolator.getLocalRepository();
                    modelInterpolator.setLocalRepository(request.getLocalRepositoryPath().getAbsolutePath());
                    try {
                        results = builder.build(Collections.singletonList(new File(file.getPath())), false, request.getProjectBuildingRequest());
                    }
                    finally {
                        modelInterpolator.setLocalRepository(savedLocalRepository);
                    }
                    ProjectBuildingResult buildingResult = (ProjectBuildingResult)results.get(0);
                    MavenProject project = buildingResult.getProject();
                    RepositorySystemSession repositorySession = Maven3ServerEmbedderImpl.this.getComponent(LegacySupport.class).getRepositorySession();
                    if (repositorySession instanceof DefaultRepositorySystemSession) {
                        ((DefaultRepositorySystemSession)repositorySession).setTransferListener((TransferListener)new TransferListenerAdapter(Maven3ServerEmbedderImpl.this.myCurrentIndicator));
                        if (Maven3ServerEmbedderImpl.this.myWorkspaceMap != null) {
                            ((DefaultRepositorySystemSession)repositorySession).setWorkspaceReader((WorkspaceReader)new Maven3WorkspaceReader(Maven3ServerEmbedderImpl.this.myWorkspaceMap));
                        }
                    }
                    ArrayList<Exception> exceptions = new ArrayList<Exception>();
                    Maven3ServerEmbedderImpl.this.loadExtensions(project, exceptions);
                    project.setDependencyArtifacts(project.createArtifacts(Maven3ServerEmbedderImpl.this.getComponent(ArtifactFactory.class), null, null));
                    if (USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING) {
                        ArtifactResolutionRequest resolutionRequest = new ArtifactResolutionRequest();
                        resolutionRequest.setArtifactDependencies(project.getDependencyArtifacts());
                        resolutionRequest.setArtifact(project.getArtifact());
                        resolutionRequest.setManagedVersionMap(project.getManagedVersionMap());
                        resolutionRequest.setLocalRepository(Maven3ServerEmbedderImpl.this.myLocalRepository);
                        resolutionRequest.setRemoteRepositories(project.getRemoteArtifactRepositories());
                        resolutionRequest.setListeners(listeners);
                        resolutionRequest.setResolveRoot(false);
                        resolutionRequest.setResolveTransitively(true);
                        ArtifactResolver resolver = Maven3ServerEmbedderImpl.this.getComponent(ArtifactResolver.class);
                        ArtifactResolutionResult result = resolver.resolve(resolutionRequest);
                        project.setArtifacts(result.getArtifacts());
                        ref.set(new MavenExecutionResult(project, exceptions));
                    } else {
                        DependencyResolutionResult dependencyResolutionResult = Maven3ServerEmbedderImpl.this.resolveDependencies(project, repositorySession);
                        List dependencies = dependencyResolutionResult.getDependencies();
                        LinkedHashSet<org.apache.maven.artifact.Artifact> artifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>(dependencies.size());
                        for (Dependency dependency : dependencies) {
                            org.apache.maven.artifact.Artifact artifact = RepositoryUtils.toArtifact((Artifact)dependency.getArtifact());
                            artifact.setScope(dependency.getScope());
                            artifact.setOptional(dependency.isOptional());
                            artifacts.add(artifact);
                            Maven3ServerEmbedderImpl.this.resolveAsModule(artifact);
                        }
                        project.setArtifacts(artifacts);
                        ref.set(new MavenExecutionResult(project, dependencyResolutionResult, exceptions));
                    }
                }
                catch (Exception e) {
                    ref.set(Maven3ServerEmbedderImpl.handleException(e));
                }
            }
        });
        MavenExecutionResult mavenExecutionResult = (MavenExecutionResult)ref.get();
        if (mavenExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "doResolveProject"));
        }
        return mavenExecutionResult;
    }

    private boolean resolveAsModule(org.apache.maven.artifact.Artifact a) {
        MavenWorkspaceMap map = this.myWorkspaceMap;
        if (map == null) {
            return false;
        }
        MavenWorkspaceMap.Data resolved = map.findFileAndOriginalId(MavenModelConverter.createMavenId(a));
        if (resolved == null) {
            return false;
        }
        a.setResolved(true);
        a.setFile(resolved.getFile(a.getType()));
        a.selectVersion(resolved.originalId.getVersion());
        return true;
    }

    private DependencyResolutionResult resolveDependencies(MavenProject project, RepositorySystemSession session) {
        DependencyResolutionResult resolutionResult;
        try {
            ProjectDependenciesResolver dependencyResolver = this.getComponent(ProjectDependenciesResolver.class);
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, session);
            resolutionResult = dependencyResolver.resolve((DependencyResolutionRequest)resolution);
        }
        catch (DependencyResolutionException e) {
            resolutionResult = e.getResult();
        }
        LinkedHashSet artifacts = new LinkedHashSet();
        if (resolutionResult.getDependencyGraph() != null) {
            RepositoryUtils.toArtifacts(artifacts, (Collection)resolutionResult.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), null);
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            for (org.apache.maven.artifact.Artifact artifact : artifacts) {
                if (artifact.isResolved()) continue;
                String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)artifact));
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
        }
        project.setResolvedArtifacts(artifacts);
        project.setArtifacts(artifacts);
        return resolutionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensions(MavenProject project, List<Exception> exceptions) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Collection<AbstractMavenLifecycleParticipant> lifecycleParticipants = this.getLifecycleParticipants(Arrays.asList(project));
        if (!lifecycleParticipants.isEmpty()) {
            LegacySupport legacySupport = this.getComponent(LegacySupport.class);
            MavenSession session = legacySupport.getSession();
            session.setCurrentProject(project);
            session.setProjects(Arrays.asList(project));
            for (AbstractMavenLifecycleParticipant listener : lifecycleParticipants) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                try {
                    listener.afterProjectsRead(session);
                }
                catch (MavenExecutionException e) {
                    exceptions.add((Exception)((Object)e));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                lifecycleListeners.addAll(this.myContainer.lookupList(AbstractMavenLifecycleParticipant.class));
            }
            catch (ComponentLookupException e) {
                Maven3ServerEmbedderImpl.warn("Failed to lookup lifecycle participants", e);
            }
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                try {
                    lifecycleListeners.addAll(this.myContainer.lookupList(AbstractMavenLifecycleParticipant.class));
                }
                catch (ComponentLookupException e) {
                    Maven3ServerEmbedderImpl.warn("Failed to lookup lifecycle participants", e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    private static void warn(String message, Throwable e) {
        try {
            Maven3ServerGlobals.getLogger().warn(new RuntimeException(message, e));
        }
        catch (RemoteException e1) {
            throw new RuntimeException(e1);
        }
    }

    public MavenExecutionRequest createRequest(File file, List<String> activeProfiles, List<String> inactiveProfiles, List<String> goals) throws RemoteException {
        DefaultMavenExecutionRequest result = new DefaultMavenExecutionRequest();
        try {
            this.getComponent(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)result, this.myMavenSettings);
            result.setGoals(goals);
            result.setPom(file);
            this.getComponent(MavenExecutionRequestPopulator.class).populateDefaults((MavenExecutionRequest)result);
            result.setSystemProperties(this.mySystemProperties);
            result.setActiveProfiles(activeProfiles);
            result.setInactiveProfiles(inactiveProfiles);
            result.setStartTime(this.myBuildStartTime);
            return result;
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new RuntimeException(e);
        }
    }

    private static MavenExecutionResult handleException(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        return new MavenExecutionResult(null, Collections.singletonList((Exception)e));
    }

    @NotNull
    public File getLocalRepositoryFile() {
        File file = new File(this.myLocalRepository.getBasedir());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "getLocalRepositoryFile"));
        }
        return file;
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(File file, MavenExecutionResult result, DependencyNode rootNode) throws RemoteException {
        Collection problems = MavenProjectProblem.createProblemsList();
        THashSet unresolvedArtifacts = new THashSet();
        this.validate(file, result.getExceptions(), problems, (Collection<MavenId>)unresolvedArtifacts);
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            MavenServerExecutionResult mavenServerExecutionResult = new MavenServerExecutionResult(null, problems, (Set)unresolvedArtifacts);
            if (mavenServerExecutionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "createExecutionResult"));
            }
            return mavenServerExecutionResult;
        }
        MavenModel model = null;
        try {
            if (USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING) {
                List dependencyNodes = rootNode == null ? Collections.emptyList() : rootNode.getChildren();
                model = MavenModelConverter.convertModel(mavenProject.getModel(), mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots(), mavenProject.getArtifacts(), dependencyNodes, mavenProject.getExtensionArtifacts(), this.getLocalRepositoryFile());
            } else {
                DependencyResolutionResult dependencyResolutionResult = result.getDependencyResolutionResult();
                org.sonatype.aether.graph.DependencyNode dependencyGraph = dependencyResolutionResult != null ? dependencyResolutionResult.getDependencyGraph() : null;
                List dependencyNodes = dependencyGraph != null ? dependencyGraph.getChildren() : Collections.emptyList();
                model = AetherModelConverter.convertModelWithAetherDependencyTree(mavenProject.getModel(), mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots(), mavenProject.getArtifacts(), dependencyNodes, mavenProject.getExtensionArtifacts(), this.getLocalRepositoryFile());
            }
        }
        catch (Exception e) {
            this.validate(mavenProject.getFile(), Collections.singleton(e), problems, null);
        }
        RemoteNativeMavenProjectHolder holder = new RemoteNativeMavenProjectHolder(mavenProject);
        try {
            UnicastRemoteObject.exportObject((Remote)((Object)holder), 0);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        Collection<String> activatedProfiles = Maven3ServerEmbedderImpl.collectActivatedProfiles(mavenProject);
        MavenServerExecutionResult.ProjectData data = new MavenServerExecutionResult.ProjectData(model, MavenModelConverter.convertToMap(mavenProject.getModel()), (NativeMavenProjectHolder)holder, activatedProfiles);
        MavenServerExecutionResult mavenServerExecutionResult = new MavenServerExecutionResult(data, problems, (Set)unresolvedArtifacts);
        if (mavenServerExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "createExecutionResult"));
        }
        return mavenServerExecutionResult;
    }

    private static Collection<String> collectActivatedProfiles(MavenProject mavenProject) throws RemoteException {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        try {
            while (mavenProject != null) {
                profiles.addAll(mavenProject.getActiveProfiles());
                mavenProject = mavenProject.getParent();
            }
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info(e);
        }
        return Maven3ServerEmbedderImpl.collectProfilesIds(profiles);
    }

    /*
     * WARNING - void declaration
     */
    private void validate(@NotNull File file, @NotNull Collection<Exception> exceptions, @NotNull Collection<MavenProjectProblem> problems, @Nullable Collection<MavenId> unresolvedArtifacts) throws RemoteException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "validate"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "validate"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "validate"));
        }
        for (Exception exception : exceptions) {
            void var6_6;
            Maven3ServerGlobals.getLogger().info(exception);
            if (exception instanceof IllegalStateException && exception.getCause() != null) {
                Throwable throwable = exception.getCause();
            }
            if (var6_6 instanceof InvalidProjectModelException) {
                ModelValidationResult modelValidationResult = ((InvalidProjectModelException)var6_6).getValidationResult();
                if (modelValidationResult != null) {
                    for (String eachValidationProblem : modelValidationResult.getMessages()) {
                        problems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)eachValidationProblem));
                    }
                    continue;
                }
                problems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)var6_6.getCause().getMessage()));
                continue;
            }
            if (var6_6 instanceof ProjectBuildingException) {
                String causeMessage = var6_6.getCause() != null ? var6_6.getCause().getMessage() : var6_6.getMessage();
                problems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)causeMessage));
                continue;
            }
            problems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)var6_6.getMessage()));
        }
        if (unresolvedArtifacts != null) {
            unresolvedArtifacts.addAll(this.retrieveUnresolvedArtifactIds());
        }
    }

    private Set<MavenId> retrieveUnresolvedArtifactIds() {
        THashSet result = new THashSet();
        return result;
    }

    @NotNull
    public MavenArtifact resolve(@NotNull MavenArtifactInfo info, @NotNull List<MavenRemoteRepository> remoteRepositories) throws RemoteException, MavenServerProcessCanceledException {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolve"));
        }
        if (remoteRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteRepositories", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolve"));
        }
        MavenArtifact mavenArtifact = this.doResolve(info, remoteRepositories);
        if (mavenArtifact == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolve"));
        }
        return mavenArtifact;
    }

    @NotNull
    public List<MavenArtifact> resolveTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories) throws RemoteException, MavenServerProcessCanceledException {
        List<MavenArtifact> list;
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolveTransitively"));
        }
        if (remoteRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteRepositories", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolveTransitively"));
        }
        try {
            LinkedHashSet<org.apache.maven.artifact.Artifact> toResolve = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
            for (MavenArtifactInfo each : artifacts) {
                toResolve.add(this.createArtifact(each));
            }
            org.apache.maven.artifact.Artifact project = this.getComponent(ArtifactFactory.class).createBuildArtifact("temp", "temp", "666", "pom");
            Set res = this.getComponent(ArtifactResolver.class).resolveTransitively(toResolve, project, Collections.EMPTY_MAP, this.myLocalRepository, this.convertRepositories(remoteRepositories), this.getComponent(ArtifactMetadataSource.class)).getArtifacts();
            list = MavenModelConverter.convertArtifacts(res, (Map<org.apache.maven.artifact.Artifact, MavenArtifact>)new THashMap(), this.getLocalRepositoryFile());
        }
        catch (ArtifactResolutionException e) {
            Maven3ServerGlobals.getLogger().info(e);
        }
        catch (ArtifactNotFoundException e) {
            Maven3ServerGlobals.getLogger().info(e);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolveTransitively"));
        }
        return list;
        List<MavenArtifact> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolveTransitively"));
        }
        return list2;
    }

    public Collection<MavenArtifact> resolvePlugin(@NotNull MavenPlugin plugin, @NotNull List<MavenRemoteRepository> repositories, int nativeMavenProjectId, boolean transitive) throws RemoteException, MavenServerProcessCanceledException {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolvePlugin"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolvePlugin"));
        }
        try {
            Plugin mavenPlugin = new Plugin();
            mavenPlugin.setGroupId(plugin.getGroupId());
            mavenPlugin.setArtifactId(plugin.getArtifactId());
            mavenPlugin.setVersion(plugin.getVersion());
            MavenProject project = RemoteNativeMavenProjectHolder.findProjectById(nativeMavenProjectId);
            Plugin pluginFromProject = (Plugin)project.getBuild().getPluginsAsMap().get(plugin.getGroupId() + ':' + plugin.getArtifactId());
            if (pluginFromProject != null) {
                mavenPlugin.setDependencies(pluginFromProject.getDependencies());
            }
            MavenExecutionRequest request = this.createRequest(null, Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList());
            DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
            RepositorySystemSession repositorySystemSession = maven.newRepositorySession(request);
            PluginDependenciesResolver pluginDependenciesResolver = this.getComponent(PluginDependenciesResolver.class);
            Artifact pluginArtifact = pluginDependenciesResolver.resolve(mavenPlugin, project.getRemotePluginRepositories(), repositorySystemSession);
            org.sonatype.aether.graph.DependencyNode node = pluginDependenciesResolver.resolve(mavenPlugin, pluginArtifact, null, project.getRemotePluginRepositories(), repositorySystemSession);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            ArrayList<MavenArtifact> res = new ArrayList<MavenArtifact>();
            for (Artifact artifact : nlg.getArtifacts(true)) {
                if (Comparing.equal((String)artifact.getArtifactId(), (String)plugin.getArtifactId()) && Comparing.equal((String)artifact.getGroupId(), (String)plugin.getGroupId())) continue;
                res.add(MavenModelConverter.convertArtifact(RepositoryUtils.toArtifact((Artifact)artifact), this.getLocalRepositoryFile()));
            }
            return res;
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info(e);
            return Collections.emptyList();
        }
    }

    private MavenArtifact doResolve(MavenArtifactInfo info, List<MavenRemoteRepository> remoteRepositories) throws RemoteException {
        org.apache.maven.artifact.Artifact resolved = this.doResolve(this.createArtifact(info), this.convertRepositories(remoteRepositories));
        return MavenModelConverter.convertArtifact(resolved, this.getLocalRepositoryFile());
    }

    private org.apache.maven.artifact.Artifact doResolve(org.apache.maven.artifact.Artifact artifact, List<ArtifactRepository> remoteRepositories) throws RemoteException {
        try {
            this.resolve(artifact, remoteRepositories);
            return artifact;
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info(e);
            return artifact;
        }
    }

    public void resolve(@NotNull org.apache.maven.artifact.Artifact artifact, @NotNull List<ArtifactRepository> repos) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolve"));
        }
        if (repos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repos", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "resolve"));
        }
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request.setRemoteRepositories(repos);
        try {
            this.getComponent(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)request, this.myMavenSettings);
            this.getComponent(MavenExecutionRequestPopulator.class).populateDefaults((MavenExecutionRequest)request);
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new RuntimeException(e);
        }
        this.getComponent(ArtifactResolver.class).resolve(artifact, request.getRemoteRepositories(), this.myLocalRepository);
    }

    private List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> repositories) throws RemoteException {
        ArrayList<ArtifactRepository> result = new ArrayList<ArtifactRepository>();
        for (MavenRemoteRepository each : repositories) {
            try {
                ArtifactRepositoryFactory factory = this.getComponent(ArtifactRepositoryFactory.class);
                result.add(ProjectUtils.buildArtifactRepository((Repository)MavenModelConverter.toNativeRepository(each), (ArtifactRepositoryFactory)factory, (PlexusContainer)this.myContainer));
            }
            catch (InvalidRepositoryException e) {
                Maven3ServerGlobals.getLogger().warn(e);
            }
        }
        return result;
    }

    private org.apache.maven.artifact.Artifact createArtifact(MavenArtifactInfo info) {
        return this.getComponent(ArtifactFactory.class).createArtifactWithClassifier(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getPackaging(), info.getClassifier());
    }

    @NotNull
    public MavenServerExecutionResult execute(@NotNull File file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles, @NotNull List<String> goals, @NotNull List<String> selectedProjects, boolean alsoMake, boolean alsoMakeDependents) throws RemoteException, MavenServerProcessCanceledException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "execute"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "execute"));
        }
        if (inactiveProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inactiveProfiles", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "execute"));
        }
        if (goals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "goals", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "execute"));
        }
        if (selectedProjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedProjects", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "execute"));
        }
        MavenExecutionResult result = this.doExecute(file, new ArrayList<String>(activeProfiles), new ArrayList<String>(inactiveProfiles), goals, selectedProjects, alsoMake, alsoMakeDependents);
        MavenServerExecutionResult mavenServerExecutionResult = this.createExecutionResult(file, result, null);
        if (mavenServerExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "execute"));
        }
        return mavenServerExecutionResult;
    }

    private MavenExecutionResult doExecute(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, @NotNull List<String> goals, @NotNull List<String> selectedProjects, boolean alsoMake, boolean alsoMakeDependents) throws RemoteException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "doExecute"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "doExecute"));
        }
        if (inactiveProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inactiveProfiles", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "doExecute"));
        }
        if (goals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "goals", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "doExecute"));
        }
        if (selectedProjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedProjects", "org/jetbrains/idea/maven/server/Maven3ServerEmbedderImpl", "doExecute"));
        }
        MavenExecutionRequest request = this.createRequest(file, activeProfiles, inactiveProfiles, goals);
        if (!selectedProjects.isEmpty()) {
            request.setRecursive(true);
            request.setSelectedProjects(selectedProjects);
            if (alsoMake && alsoMakeDependents) {
                request.setMakeBehavior("make-both");
            } else if (alsoMake) {
                request.setMakeBehavior("make");
            } else if (alsoMakeDependents) {
                request.setMakeBehavior("make-dependents");
            }
        }
        org.apache.maven.execution.MavenExecutionResult executionResult = this.safeExecute(request, this.getComponent(Maven.class));
        return new MavenExecutionResult(executionResult.getProject(), Maven3ServerEmbedderImpl.filterExceptions(executionResult.getExceptions()));
    }

    private org.apache.maven.execution.MavenExecutionResult safeExecute(MavenExecutionRequest request, Maven maven) throws RemoteException {
        MavenLeakDetector detector = new MavenLeakDetector().mark();
        org.apache.maven.execution.MavenExecutionResult result = maven.execute(request);
        detector.check();
        return result;
    }

    private static List<Exception> filterExceptions(List<Throwable> list) {
        for (Throwable throwable : list) {
            if (throwable instanceof Exception) continue;
            throw new RuntimeException(throwable);
        }
        return list;
    }

    public void reset() throws RemoteException {
        try {
            this.setConsoleAndIndicator(null, null);
            ((CustomMaven3ArtifactFactory)this.getComponent(ArtifactFactory.class)).reset();
            ((CustomMaven3ArtifactResolver)this.getComponent(ArtifactResolver.class)).reset();
            ((CustomMaven3RepositoryMetadataManager)this.getComponent(RepositoryMetadataManager.class)).reset();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    public void release() throws RemoteException {
        this.myContainer.dispose();
    }

    public void clearCaches() throws RemoteException {
    }

    public void clearCachesFor(MavenId projectId) throws RemoteException {
    }

    public static MavenModel interpolateAndAlignModel(MavenModel model, File basedir) throws RemoteException {
        Model result = MavenModelConverter.toNativeModel(model);
        result = Maven3ServerEmbedderImpl.doInterpolate(result, basedir);
        DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
        pathTranslator.alignToBaseDirectory(result, basedir);
        return MavenModelConverter.convertModel(result, null);
    }

    public static MavenModel assembleInheritance(MavenModel model, MavenModel parentModel) throws RemoteException {
        Model result = MavenModelConverter.toNativeModel(model);
        new DefaultModelInheritanceAssembler().assembleModelInheritance(result, MavenModelConverter.toNativeModel(parentModel));
        return MavenModelConverter.convertModel(result, null);
    }

    public static ProfileApplicationResult applyProfiles(MavenModel model, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) throws RemoteException {
        Model nativeModel = MavenModelConverter.toNativeModel(model);
        Collection enabledProfiles = explicitProfiles.getEnabledProfiles();
        Collection disabledProfiles = explicitProfiles.getDisabledProfiles();
        ArrayList<Profile> activatedPom = new ArrayList<Profile>();
        ArrayList<Profile> activatedExternal = new ArrayList<Profile>();
        ArrayList<Profile> activeByDefault = new ArrayList<Profile>();
        List rawProfiles = nativeModel.getProfiles();
        List expandedProfilesCache = null;
        ArrayList<Profile> deactivatedProfiles = new ArrayList<Profile>();
        for (int i = 0; i < rawProfiles.size(); ++i) {
            Profile eachRawProfile = (Profile)rawProfiles.get(i);
            if (disabledProfiles.contains(eachRawProfile.getId())) {
                deactivatedProfiles.add(eachRawProfile);
                continue;
            }
            boolean shouldAdd = enabledProfiles.contains(eachRawProfile.getId()) || alwaysOnProfiles.contains(eachRawProfile.getId());
            Activation activation = eachRawProfile.getActivation();
            if (activation != null) {
                if (activation.isActiveByDefault()) {
                    activeByDefault.add(eachRawProfile);
                }
                if (expandedProfilesCache == null) {
                    expandedProfilesCache = Maven3ServerEmbedderImpl.doInterpolate(nativeModel, basedir).getProfiles();
                }
                Profile eachExpandedProfile = (Profile)expandedProfilesCache.get(i);
                for (ProfileActivator eachActivator : Maven3ServerEmbedderImpl.getProfileActivators(basedir)) {
                    try {
                        if (!eachActivator.canDetermineActivation(eachExpandedProfile) || !eachActivator.isActive(eachExpandedProfile)) continue;
                        shouldAdd = true;
                        break;
                    }
                    catch (ProfileActivationException e) {
                        Maven3ServerGlobals.getLogger().warn(e);
                    }
                }
            }
            if (!shouldAdd) continue;
            if ("pom".equals(eachRawProfile.getSource())) {
                activatedPom.add(eachRawProfile);
                continue;
            }
            activatedExternal.add(eachRawProfile);
        }
        ArrayList<Profile> activatedProfiles = new ArrayList<Profile>(activatedPom.isEmpty() ? activeByDefault : activatedPom);
        activatedProfiles.addAll(activatedExternal);
        for (Profile each : activatedProfiles) {
            new DefaultProfileInjector().injectProfile(nativeModel, each, null, null);
        }
        return new ProfileApplicationResult(MavenModelConverter.convertModel(nativeModel, null), new MavenExplicitProfiles(Maven3ServerEmbedderImpl.collectProfilesIds(activatedProfiles), Maven3ServerEmbedderImpl.collectProfilesIds(deactivatedProfiles)));
    }

    private static Model doInterpolate(Model result, File basedir) throws RemoteException {
        try {
            CustomMaven3ModelInterpolator interpolator = new CustomMaven3ModelInterpolator(new DefaultPathTranslator());
            interpolator.initialize();
            Properties props = MavenServerUtil.collectSystemProperties();
            ProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration().setExecutionProperties(props);
            config.setBuildStartTime(new Date());
            result = interpolator.interpolate(result, basedir, config, false);
        }
        catch (ModelInterpolationException e) {
            Maven3ServerGlobals.getLogger().warn(e);
        }
        catch (InitializationException e) {
            Maven3ServerGlobals.getLogger().error(e);
        }
        return result;
    }

    private static Collection<String> collectProfilesIds(List<Profile> profiles) {
        THashSet result = new THashSet();
        for (Profile each : profiles) {
            if (each.getId() == null) continue;
            result.add(each.getId());
        }
        return result;
    }

    private static ProfileActivator[] getProfileActivators(File basedir) throws RemoteException {
        SystemPropertyProfileActivator sysPropertyActivator = new SystemPropertyProfileActivator();
        DefaultContext context = new DefaultContext();
        context.put((Object)"SystemProperties", (Object)MavenServerUtil.collectSystemProperties());
        try {
            sysPropertyActivator.contextualize((Context)context);
        }
        catch (ContextException e) {
            Maven3ServerGlobals.getLogger().error(e);
            return new ProfileActivator[0];
        }
        return new ProfileActivator[]{new MyFileProfileActivator(basedir), sysPropertyActivator, new JdkPrefixProfileActivator(), new OperatingSystemProfileActivator()};
    }

    public static interface Computable<T> {
        public T compute();
    }
}

