/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.LineSeparatorPanel;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.LineSeparator;
import java.util.List;
import java.util.Locale;
import org.editorconfig.Utils;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;

public class LineEndingsManager
extends FileDocumentManagerAdapter {
    private static final String lineEndingsKey = "end_of_line";
    private final Project myProject;
    private boolean statusBarUpdated = false;

    public LineEndingsManager(Project project) {
        this.myProject = project;
    }

    public void beforeAllDocumentsSaving() {
        this.statusBarUpdated = false;
    }

    private void updateStatusBar() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusBarWidget widget;
                IdeFrame frame = WindowManager.getInstance().getIdeFrame(LineEndingsManager.this.myProject);
                StatusBar statusBar = frame.getStatusBar();
                StatusBarWidget statusBarWidget = widget = statusBar != null ? statusBar.getWidget("LineSeparator") : null;
                if (widget instanceof LineSeparatorPanel) {
                    FileEditorManagerEvent event = new FileEditorManagerEvent(FileEditorManager.getInstance((Project)LineEndingsManager.this.myProject), null, null, null, null);
                    ((LineSeparatorPanel)widget).selectionChanged(event);
                }
            }
        });
    }

    public void beforeDocumentSaving(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/editorconfig/configmanagement/LineEndingsManager", "beforeDocumentSaving"));
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        this.applySettings(file);
    }

    private void applySettings(VirtualFile file) {
        if (file == null) {
            return;
        }
        if (!Utils.isEnabled(CodeStyleSettingsManager.getInstance((Project)this.myProject).getCurrentSettings())) {
            return;
        }
        String filePath = Utils.getFilePath(this.myProject, file);
        List<EditorConfig.OutPair> outPairs = SettingsProviderComponent.getInstance().getOutPairs(this.myProject, filePath);
        String lineEndings = Utils.configValueForKey(outPairs, lineEndingsKey);
        if (!lineEndings.isEmpty()) {
            try {
                LineSeparator separator = LineSeparator.valueOf((String)lineEndings.toUpperCase(Locale.US));
                String oldSeparator = file.getDetectedLineSeparator();
                String newSeparator = separator.getSeparatorString();
                if (!StringUtil.equals((CharSequence)oldSeparator, (CharSequence)newSeparator)) {
                    file.setDetectedLineSeparator(newSeparator);
                    if (!this.statusBarUpdated) {
                        this.statusBarUpdated = true;
                        this.updateStatusBar();
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Utils.invalidConfigMessage(this.myProject, lineEndings, lineEndingsKey, filePath);
            }
        }
    }
}

