/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.compiler;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import org.apache.tools.ant.util.ReaderInputStream;
import org.jetbrains.jps.gradle.compiler.ChainingFilterTransformer;
import org.jetbrains.jps.gradle.model.impl.GradleModuleResourceConfiguration;
import org.jetbrains.jps.gradle.model.impl.GradleProjectConfiguration;
import org.jetbrains.jps.gradle.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.gradle.model.impl.ResourceRootFilter;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.JpsProject;

public class GradleResourceFileProcessor {
    private static final int FILTERING_SIZE_LIMIT = 0xA00000;
    protected final JpsEncodingProjectConfiguration myEncodingConfig;
    protected final GradleProjectConfiguration myProjectConfig;
    protected final GradleModuleResourceConfiguration myModuleConfiguration;

    public GradleResourceFileProcessor(GradleProjectConfiguration projectConfiguration, JpsProject project, GradleModuleResourceConfiguration moduleConfiguration) {
        this.myProjectConfig = projectConfiguration;
        this.myEncodingConfig = JpsEncodingConfigurationService.getInstance().getEncodingConfiguration(project);
        this.myModuleConfiguration = moduleConfiguration;
    }

    public void copyFile(File file, Ref<File> targetFileRef, ResourceRootConfiguration rootConfiguration, CompileContext context, FileFilter filteringFilter) throws IOException {
        boolean shouldFilter;
        boolean bl = shouldFilter = rootConfiguration.isFiltered && !rootConfiguration.filters.isEmpty() && filteringFilter.accept(file);
        if (shouldFilter && file.length() > 0xA00000L) {
            context.processMessage((BuildMessage)new CompilerMessage("Gradle Resources Compiler", BuildMessage.Kind.WARNING, "File is too big to be filtered. Most likely it is a binary file and should be excluded from filtering", file.getPath()));
            shouldFilter = false;
        }
        if (shouldFilter) {
            GradleResourceFileProcessor.copyWithFiltering(file, targetFileRef, rootConfiguration.filters, context);
        } else {
            FileUtil.copyContent((File)file, (File)((File)targetFileRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyWithFiltering(File file, Ref<File> outputFileRef, List<ResourceRootFilter> filters, CompileContext context) throws IOException {
        FileInputStream originalInputStream = new FileInputStream(file);
        try {
            InputStream inputStream = GradleResourceFileProcessor.transform(filters, originalInputStream, outputFileRef, context);
            FileUtil.createIfDoesntExist((File)((File)outputFileRef.get()));
            FileOutputStream outputStream = new FileOutputStream((File)outputFileRef.get());
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                StreamUtil.closeStream((Closeable)inputStream);
                StreamUtil.closeStream((Closeable)outputStream);
            }
        }
        finally {
            StreamUtil.closeStream((Closeable)originalInputStream);
        }
    }

    private static InputStream transform(List<ResourceRootFilter> filters, FileInputStream original, Ref<File> outputFileRef, CompileContext context) {
        return new ReaderInputStream(new ChainingFilterTransformer(context, filters, outputFileRef).transform(new InputStreamReader(original)));
    }
}

