/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundlePropertiesInsertManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public class ResourceBundlePropertiesInsertManagerImpl
implements ResourceBundlePropertiesInsertManager {
    private static final Logger LOG = Logger.getInstance(ResourceBundlePropertiesInsertManagerImpl.class);
    private final ResourceBundle myResourceBundle;
    private boolean myOrdered;
    private boolean myAlphaSorted;
    private List<String> myKeysOrder;

    private ResourceBundlePropertiesInsertManagerImpl(ResourceBundle bundle) {
        this.myResourceBundle = bundle;
        this.reload();
    }

    public static ResourceBundlePropertiesInsertManager create(ResourceBundle bundle) {
        for (PropertiesFile file : bundle.getPropertiesFiles()) {
            if (file instanceof PropertiesFileImpl) continue;
            return ResourceBundlePropertiesInsertManager.Stub.INSTANCE;
        }
        return new ResourceBundlePropertiesInsertManagerImpl(bundle);
    }

    @Override
    public void insertNewProperty(String key, String value) {
        if (ApplicationManager.getApplication().isUnitTestMode() && this.myKeysOrder != null) {
            LOG.assertTrue(!this.myKeysOrder.contains(key));
        }
        PropertiesFile propertiesFile = this.myResourceBundle.getDefaultPropertiesFile();
        if (this.myAlphaSorted) {
            Pair<IProperty, Integer> propertyAndPosition = this.findExistedPrevSiblingProperty(key, propertiesFile);
            if (propertyAndPosition == null) {
                propertiesFile.addPropertyFirst(key, value);
                this.myKeysOrder.add(0, key);
            } else {
                propertiesFile.addPropertyAfter(key, value, (Property)propertyAndPosition.getFirst());
                Integer position = (Integer)propertyAndPosition.getSecond();
                this.myKeysOrder.add(position, key);
            }
        } else {
            propertiesFile.addPropertyLast(key, value);
            if (this.myOrdered) {
                this.myKeysOrder.add(key);
            }
        }
    }

    @Override
    public void insertTranslation(String key, String value, PropertiesFile propertiesFile) {
        if (this.myOrdered) {
            Pair<IProperty, Integer> propertyAndPosition = this.findExistedPrevSiblingProperty(key, propertiesFile);
            if (propertyAndPosition == null) {
                propertiesFile.addPropertyFirst(key, value);
            } else {
                propertiesFile.addPropertyAfter(key, value, (Property)propertyAndPosition.getFirst());
            }
        } else {
            propertiesFile.addPropertyLast(key, value);
        }
    }

    private Pair<IProperty, Integer> findExistedPrevSiblingProperty(String key, PropertiesFile file) {
        int rawInsertionPosition;
        if (this.myKeysOrder.isEmpty()) {
            return null;
        }
        int prevPosition = this.myAlphaSorted ? ((rawInsertionPosition = Collections.binarySearch(this.myKeysOrder, key)) < 0 ? -rawInsertionPosition - 2 : rawInsertionPosition - 1) : this.myKeysOrder.indexOf(key);
        for (int i = prevPosition; i >= 0; --i) {
            String prevKey = this.myKeysOrder.get(i);
            IProperty property = file.findPropertyByKey(prevKey);
            if (property == null) continue;
            return Pair.create((Object)property, (Object)(prevPosition + 1));
        }
        return null;
    }

    @Override
    public void reload() {
        List<String> keysOrder = ResourceBundlePropertiesInsertManagerImpl.keysOrder(this.myResourceBundle);
        boolean bl = this.myOrdered = keysOrder != null;
        if (this.myOrdered) {
            Collections.reverse(keysOrder);
            this.myAlphaSorted = ResourceBundlePropertiesInsertManagerImpl.isAlphaSorted(keysOrder);
            this.myKeysOrder = keysOrder;
        } else {
            this.myKeysOrder = null;
        }
    }

    @Nullable
    private static List<String> keysOrder(final ResourceBundle resourceBundle) {
        GraphGenerator generator = GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<String>(){

            public Collection<String> getNodes() {
                TreeSet<String> nodes = new TreeSet<String>();
                for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
                    for (IProperty property : propertiesFile.getProperties()) {
                        String key = property.getKey();
                        if (key == null) continue;
                        nodes.add(key);
                    }
                }
                return nodes;
            }

            public Iterator<String> getIn(String n) {
                HashSet<String> siblings = new HashSet<String>();
                for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
                    for (IProperty property : propertiesFile.findPropertiesByKey(n)) {
                        String key;
                        PsiElement sibling = property.getPsiElement().getNextSibling();
                        while (sibling instanceof PsiWhiteSpace || sibling instanceof PsiComment) {
                            sibling = sibling.getNextSibling();
                        }
                        if (!(sibling instanceof IProperty) || (key = ((IProperty)sibling).getKey()) == null) continue;
                        siblings.add(key);
                    }
                }
                return siblings.iterator();
            }
        }));
        DFSTBuilder dfstBuilder = new DFSTBuilder((Graph)generator);
        boolean acyclic = dfstBuilder.isAcyclic();
        return acyclic ? dfstBuilder.getSortedNodes() : null;
    }

    private static boolean isAlphaSorted(List<String> keys) {
        String prevKey = null;
        for (String key : keys) {
            if (prevKey != null && prevKey.compareTo(key) > 0) {
                return false;
            }
            prevKey = key;
        }
        return true;
    }
}

