/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesResourceBundleUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFileFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesElementFactory {
    private static final UserDataCache<PropertiesFile, Project, Void> PROPERTIES = new UserDataCache<PropertiesFile, Project, Void>("system.properties.file"){

        protected PropertiesFile compute(Project project, Void p) {
            return PropertiesElementFactory.createPropertiesFile(project, System.getProperties(), "system");
        }
    };

    @NotNull
    public static IProperty createProperty(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/psi/PropertiesElementFactory", "createProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/properties/psi/PropertiesElementFactory", "createProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/properties/psi/PropertiesElementFactory", "createProperty"));
        }
        String text = PropertiesElementFactory.getPropertyText(name, value);
        PropertiesFile dummyFile = PropertiesElementFactory.createPropertiesFile(project, text);
        IProperty iProperty = dummyFile.getProperties().get(0);
        if (iProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/PropertiesElementFactory", "createProperty"));
        }
        return iProperty;
    }

    @NotNull
    public static String getPropertyText(@NonNls @NotNull String name, @NonNls @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/properties/psi/PropertiesElementFactory", "getPropertyText"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/properties/psi/PropertiesElementFactory", "getPropertyText"));
        }
        String string = PropertiesElementFactory.escape(name) + "=" + PropertiesElementFactory.escapeValue(value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/PropertiesElementFactory", "getPropertyText"));
        }
        return string;
    }

    @NotNull
    public static PropertiesFile createPropertiesFile(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/psi/PropertiesElementFactory", "createPropertiesFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/properties/psi/PropertiesElementFactory", "createPropertiesFile"));
        }
        String filename = "dummy." + PropertiesFileType.INSTANCE.getDefaultExtension();
        PropertiesFile propertiesFile = (PropertiesFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, (FileType)PropertiesFileType.INSTANCE, (CharSequence)text);
        if (propertiesFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/PropertiesElementFactory", "createPropertiesFile"));
        }
        return propertiesFile;
    }

    @NotNull
    public static PropertiesFile createPropertiesFile(@NotNull Project project, Properties properties, String fileName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/psi/PropertiesElementFactory", "createPropertiesFile"));
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            properties.store(stream, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String filename = fileName + "." + PropertiesFileType.INSTANCE.getDefaultExtension();
        PropertiesFile propertiesFile = (PropertiesFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, (FileType)PropertiesFileType.INSTANCE, (CharSequence)stream.toString());
        if (propertiesFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/PropertiesElementFactory", "createPropertiesFile"));
        }
        return propertiesFile;
    }

    @NotNull
    public static PropertiesFile getSystemProperties(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/psi/PropertiesElementFactory", "getSystemProperties"));
        }
        PropertiesFile propertiesFile = (PropertiesFile)PROPERTIES.get((UserDataHolder)project, null);
        if (propertiesFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/PropertiesElementFactory", "getSystemProperties"));
        }
        return propertiesFile;
    }

    @NotNull
    private static String escape(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/properties/psi/PropertiesElementFactory", "escape"));
        }
        if (StringUtil.startsWithChar((CharSequence)name, (char)'#')) {
            name = PropertiesElementFactory.escapeChar(name, '#');
        }
        if (StringUtil.startsWithChar((CharSequence)name, (char)'!')) {
            name = PropertiesElementFactory.escapeChar(name, '!');
        }
        name = PropertiesElementFactory.escapeChar(name, '=');
        name = PropertiesElementFactory.escapeChar(name, ':');
        name = PropertiesElementFactory.escapeChar(name, ' ');
        String string = name = PropertiesElementFactory.escapeChar(name, '\t');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/PropertiesElementFactory", "escape"));
        }
        return string;
    }

    @NotNull
    private static String escapeChar(@NotNull String name, char c) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/properties/psi/PropertiesElementFactory", "escapeChar"));
        }
        int offset = 0;
        while (true) {
            int i;
            if ((i = name.indexOf(c, offset)) == -1) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/PropertiesElementFactory", "escapeChar"));
                }
                return string;
            }
            if (i == 0 || name.charAt(i - 1) != '\\') {
                name = name.substring(0, i) + '\\' + name.substring(i);
            }
            offset = i + 2;
        }
    }

    public static String escapeValue(String value) {
        return PropertiesResourceBundleUtil.fromValueEditorToPropertyValue(value);
    }
}

