/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class I18nUtil {
    @NotNull
    public static List<PropertiesFile> propertiesFilesByBundleName(String resourceBundleName, PsiElement context) {
        Project project;
        Module module;
        VirtualFile virtualFile;
        PsiFile containingFile = context.getContainingFile();
        PsiLanguageInjectionHost containingFileContext = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
        if (containingFileContext != null) {
            containingFile = containingFileContext.getContainingFile();
        }
        if ((virtualFile = containingFile.getVirtualFile()) == null) {
            virtualFile = containingFile.getOriginalFile().getVirtualFile();
        }
        if (virtualFile != null && (module = ProjectRootManager.getInstance((Project)(project = containingFile.getProject())).getFileIndex().getModuleForFile(virtualFile)) != null) {
            PropertiesReferenceManager refManager = PropertiesReferenceManager.getInstance(project);
            List<PropertiesFile> list = refManager.findPropertiesFiles(module, resourceBundleName);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/references/I18nUtil", "propertiesFilesByBundleName"));
            }
            return list;
        }
        List<PropertiesFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/references/I18nUtil", "propertiesFilesByBundleName"));
        }
        return list;
    }

    public static void createProperty(Project project, Collection<PropertiesFile> propertiesFiles, String key, String value) throws IncorrectOperationException {
        for (PropertiesFile file : propertiesFiles) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(documentManager.getDocument(file.getContainingFile()));
            IProperty existingProperty = file.findPropertyByKey(key);
            if (existingProperty != null) continue;
            file.addProperty(key, value);
        }
    }

    public static List<String> defaultGetPropertyFiles(Project project) {
        final ArrayList<String> paths = new ArrayList<String>();
        final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PropertiesReferenceManager.getInstance(project).processAllPropertiesFiles(new PropertiesFileProcessor(){

            @Override
            public boolean process(String baseName, PropertiesFile propertiesFile) {
                VirtualFile virtualFile = propertiesFile.getVirtualFile();
                if (projectFileIndex.isInContent(virtualFile)) {
                    String path = FileUtil.toSystemDependentName((String)virtualFile.getPath());
                    paths.add(path);
                }
                return true;
            }
        });
        return paths;
    }
}

